/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.tools.ingest;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.tools.DistCp;
import org.apache.hadoop.tools.DistCpOptions;
import org.locationtech.geomesa.tools.Command$;
import org.locationtech.geomesa.tools.ingest.AbstractIngest;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.runtime.BoxesRunTime;

public final class StorageJobUtils$
implements LazyLogging {
    public static final StorageJobUtils$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new StorageJobUtils$();
    }

    private Logger logger$lzycompute() {
        StorageJobUtils$ storageJobUtils$ = this;
        synchronized (storageJobUtils$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    /*
     * WARNING - void declaration
     */
    public boolean distCopy(Path srcRoot, Path destRoot, AbstractIngest.StatusCallback statusCallback, int stageId, int numStages) {
        statusCallback.reset();
        Command$.MODULE$.user().info("Submitting DistCp job - please wait...");
        DistCpOptions opts = new DistCpOptions(Collections.singletonList(srcRoot), destRoot);
        opts.setAppend(false);
        opts.setOverwrite(true);
        opts.setCopyStrategy("dynamic");
        Job job = new DistCp(new Configuration(), opts).execute();
        Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Tracking available at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{job.getStatus().getTrackingUrl()})));
        while (true) {
            void var7_7;
            if (job.isComplete()) {
                statusCallback.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DistCp (stage ", "/", "): "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)stageId), BoxesRunTime.boxToInteger((int)numStages)})), job.mapProgress(), (Seq)Seq$.MODULE$.empty(), true);
                boolean success = job.isSuccessful();
                if (success) {
                    Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Successfully copied data to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{destRoot})));
                } else {
                    Command$.MODULE$.user().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to copy data to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{destRoot})));
                }
                return success;
            }
            JobStatus.State state = var7_7.getStatus().getState();
            JobStatus.State state2 = JobStatus.State.PREP;
            if (state == null ? state2 != null : !state.equals(state2)) {
                statusCallback.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DistCp (stage ", "/", "): "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)stageId), BoxesRunTime.boxToInteger((int)numStages)})), var7_7.mapProgress(), (Seq)Seq$.MODULE$.empty(), false);
            }
            Thread.sleep(1000L);
        }
    }

    private StorageJobUtils$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

