/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.tools.compact;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.locationtech.geomesa.fs.storage.api.FileSystemStorage;
import org.locationtech.geomesa.fs.storage.api.StorageMetadata;
import org.locationtech.geomesa.fs.storage.common.jobs.StorageConfiguration$;
import org.locationtech.geomesa.fs.storage.common.utils.StorageUtils;
import org.locationtech.geomesa.fs.tools.compact.FileSystemCompactionJob;
import org.locationtech.geomesa.fs.tools.compact.FileSystemCompactionJob$;
import org.locationtech.geomesa.fs.tools.compact.PartitionInputFormat;
import org.locationtech.geomesa.fs.tools.ingest.StorageJobUtils$;
import org.locationtech.geomesa.jobs.mapreduce.GeoMesaOutputFormat;
import org.locationtech.geomesa.tools.Command$;
import org.locationtech.geomesa.tools.utils.StatusCallback;
import org.locationtech.geomesa.utils.text.TextTools$;
import org.opengis.feature.simple.SimpleFeature;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class FileSystemCompactionJob$class {
    /*
     * WARNING - void declaration
     */
    public static Tuple2 run(FileSystemCompactionJob $this, FileSystemStorage storage, Seq partitions, Option tempPath, Seq libjarsFiles, Iterator libjarsPaths2, StatusCallback statusCallback) {
        Job job = Job.getInstance((Configuration)new Configuration(storage.context().conf()), (String)"GeoMesa Storage Compaction");
        $this.setLibJars(job, libjarsFiles, libjarsPaths2);
        job.setJarByClass($this.getClass());
        job.setInputFormatClass(PartitionInputFormat.class);
        job.setMapperClass(FileSystemCompactionJob.CompactionMapper.class);
        job.setNumReduceTasks(0);
        job.setMapOutputKeyClass(Void.class);
        job.setMapOutputValueClass(SimpleFeature.class);
        job.setOutputKeyClass(Void.class);
        job.setOutputValueClass(SimpleFeature.class);
        FileContext fileContext = storage.context().fc();
        Option qualifiedTempPath = tempPath.map((Function1)new Serializable($this, fileContext){
            public static final long serialVersionUID = 0L;
            private final FileContext eta$0$1$1;

            public final Path apply(Path x$1) {
                return this.eta$0$1$1.makeQualified(x$1);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        });
        StorageConfiguration$.MODULE$.setRootPath(job.getConfiguration(), storage.context().root());
        StorageConfiguration$.MODULE$.setPartitions(job.getConfiguration(), (String[])((TraversableOnce)partitions.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(StorageMetadata.PartitionMetadata x$1) {
                return x$1.name();
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)));
        StorageConfiguration$.MODULE$.setFileType(job.getConfiguration(), StorageUtils.FileType$.MODULE$.Compacted());
        FileOutputFormat.setOutputPath((Job)job, (Path)((Path)qualifiedTempPath.getOrElse((Function0)new Serializable($this, storage){
            public static final long serialVersionUID = 0L;
            private final FileSystemStorage storage$1;

            public final Path apply() {
                return this.storage$1.context().root();
            }
            {
                this.storage$1 = storage$1;
            }
        })));
        job.getConfiguration().set("mapred.map.tasks.speculative.execution", "false");
        job.getConfiguration().set("mapreduce.job.user.classpath.first", "true");
        $this.configureOutput(storage.metadata().sft(), job);
        List existingDataFiles = ((TraversableOnce)partitions.map((Function1)new Serializable($this, storage){
            public static final long serialVersionUID = 0L;
            private final FileSystemStorage storage$1;

            public final Tuple2<StorageMetadata.PartitionMetadata, List<StorageMetadata.StorageFilePath>> apply(StorageMetadata.PartitionMetadata p) {
                return new Tuple2((Object)p, (Object)this.storage$1.getFilePaths(p.name()).toList());
            }
            {
                this.storage$1 = storage$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toList();
        Command$.MODULE$.user().info("Submitting job - please wait...");
        job.submit();
        Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Tracking available at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{job.getStatus().getTrackingUrl()})));
        while (true) {
            float mapProgress;
            void var7_7;
            if (job.isComplete()) {
                statusCallback.apply("Map: ", job.mapProgress(), FileSystemCompactionJob$class.mapCounters$1($this, job), true);
                statusCallback.reset();
                Tuple2.mcJJ.sp counterResult = new Tuple2.mcJJ.sp(FileSystemCompactionJob$class.written($this, job), FileSystemCompactionJob$class.failed($this, job));
                if (job.isSuccessful()) {
                    boolean copied = qualifiedTempPath.forall((Function1)new Serializable($this, storage, statusCallback){
                        public static final long serialVersionUID = 0L;
                        private final FileSystemStorage storage$1;
                        private final StatusCallback statusCallback$1;

                        public final boolean apply(Path tp) {
                            return StorageJobUtils$.MODULE$.distCopy(tp, this.storage$1.context().root(), this.statusCallback$1);
                        }
                        {
                            this.storage$1 = storage$1;
                            this.statusCallback$1 = statusCallback$1;
                        }
                    });
                    if (copied) {
                        Command$.MODULE$.user().info("Removing old files");
                        existingDataFiles.foreach((Function1)new Serializable($this, storage){
                            public static final long serialVersionUID = 0L;
                            public final FileSystemStorage storage$1;

                            public final void apply(Tuple2<StorageMetadata.PartitionMetadata, List<StorageMetadata.StorageFilePath>> x0$1) {
                                Tuple2<StorageMetadata.PartitionMetadata, List<StorageMetadata.StorageFilePath>> tuple2 = x0$1;
                                if (tuple2 != null) {
                                    StorageMetadata.PartitionMetadata partition = (StorageMetadata.PartitionMetadata)tuple2._1();
                                    List files = (List)tuple2._2();
                                    files.foreach((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ FileSystemCompactionJob$.anonfun.run.3 $outer;

                                        public final boolean apply(StorageMetadata.StorageFilePath f) {
                                            return this.$outer.storage$1.context().fc().delete(f.path(), false);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                    this.storage$1.metadata().removePartition(partition);
                                    Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removed ", " in partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TextTools$.MODULE$.getPlural((long)files.size(), "file"), partition.name()})));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                this.storage$1 = storage$1;
                            }
                        });
                        Command$.MODULE$.user().info("Compacting metadata");
                        storage.metadata().compact((Option)None$.MODULE$, 4);
                    }
                } else {
                    Command$.MODULE$.user().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Job failed with state ", " due to: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{job.getStatus().getState(), job.getStatus().getFailureInfo()})));
                }
                return counterResult;
            }
            Thread.sleep(1000L);
            JobStatus.State state = var7_7.getStatus().getState();
            JobStatus.State state2 = JobStatus.State.PREP;
            if (!(state == null ? state2 != null : !state.equals(state2)) || !((mapProgress = var7_7.mapProgress()) < 1.0f)) continue;
            statusCallback.apply("Map: ", mapProgress, FileSystemCompactionJob$class.mapCounters$1($this, (Job)var7_7), false);
        }
    }

    private static long written(FileSystemCompactionJob $this, Job job) {
        return job.getCounters().findCounter(GeoMesaOutputFormat.Counters$.MODULE$.Group(), GeoMesaOutputFormat.Counters$.MODULE$.Written()).getValue();
    }

    private static long failed(FileSystemCompactionJob $this, Job job) {
        return job.getCounters().findCounter(GeoMesaOutputFormat.Counters$.MODULE$.Group(), GeoMesaOutputFormat.Counters$.MODULE$.Failed()).getValue();
    }

    private static final Seq mapCounters$1(FileSystemCompactionJob $this, Job job$1) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"mapped", (Object)BoxesRunTime.boxToLong((long)FileSystemCompactionJob$class.written($this, job$1))), new Tuple2((Object)"failed", (Object)BoxesRunTime.boxToLong((long)FileSystemCompactionJob$class.failed($this, job$1)))}));
    }

    public static void $init$(FileSystemCompactionJob $this) {
    }
}

