/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.tools.compact;

import com.beust.jcommander.ParameterException;
import java.io.File;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.fs.Path;
import org.locationtech.geomesa.fs.data.FileSystemDataStore;
import org.locationtech.geomesa.fs.storage.api.FileSystemStorage;
import org.locationtech.geomesa.fs.storage.api.StorageMetadata;
import org.locationtech.geomesa.fs.storage.orc.OrcFileSystemStorage$;
import org.locationtech.geomesa.fs.tools.compact.FileSystemCompactionJob;
import org.locationtech.geomesa.fs.tools.compact.FsCompactCommand;
import org.locationtech.geomesa.fs.tools.compact.FsCompactCommand$CompactCommand$;
import org.locationtech.geomesa.parquet.ParquetFileSystemStorage$;
import org.locationtech.geomesa.tools.Command$;
import org.locationtech.geomesa.tools.DistributedRunParam;
import org.locationtech.geomesa.tools.ingest.IngestCommand$;
import org.locationtech.geomesa.tools.utils.StatusCallback;
import org.locationtech.geomesa.utils.io.PathUtils$;
import org.locationtech.geomesa.utils.text.TextTools$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public abstract class FsCompactCommand$CompactCommand$class {
    public static Seq libjarsFiles(FsCompactCommand.CompactCommand $this) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"org/locationtech/geomesa/tools/ingest-libjars.list"}));
    }

    public static void execute(FsCompactCommand.CompactCommand $this) {
        $this.withDataStore((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FsCompactCommand.CompactCommand $outer;

            public final void apply(FileSystemDataStore ds) {
                this.$outer.compact(ds);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static void compact(FsCompactCommand.CompactCommand $this, FileSystemDataStore ds) {
        Enumeration.Value value;
        block11: {
            void var19_18;
            block14: {
                Tuple2<Object, Object> tuple2;
                block15: {
                    block10: {
                        Tuple2.mcJJ.sp sp2;
                        FileSystemCompactionJob fileSystemCompactionJob;
                        StatusCallback.PrintProgress status;
                        long start;
                        Seq toCompact;
                        FileSystemStorage storage;
                        block13: {
                            String encoding;
                            block12: {
                                block9: {
                                    Seq seq;
                                    Command$.MODULE$.user().info("Beginning compaction process...");
                                    storage = ds.storage($this.params().featureName());
                                    if ($this.params().partitions().isEmpty()) {
                                        seq = storage.getPartitions();
                                    } else {
                                        StorageMetadata storageMetadata = storage.metadata();
                                        Buffer filtered = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.params().partitions()).asScala()).flatMap((Function1)new Serializable($this, storageMetadata){
                                            public static final long serialVersionUID = 0L;
                                            private final StorageMetadata eta$0$1$1;

                                            public final Iterable<StorageMetadata.PartitionMetadata> apply(String name) {
                                                return Option$.MODULE$.option2Iterable(this.eta$0$1$1.getPartition(name));
                                            }
                                            {
                                                this.eta$0$1$1 = eta$0$1$1;
                                            }
                                        }, Buffer$.MODULE$.canBuildFrom());
                                        if (filtered.lengthCompare($this.params().partitions().size()) != 0) {
                                            Buffer unmatched = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.params().partitions()).asScala()).filterNot((Function1)new Serializable($this, filtered){
                                                public static final long serialVersionUID = 0L;
                                                private final Buffer filtered$1;

                                                public final boolean apply(String name) {
                                                    return this.filtered$1.exists((Function1)new Serializable(this, name){
                                                        public static final long serialVersionUID = 0L;
                                                        private final String name$1;

                                                        public final boolean apply(StorageMetadata.PartitionMetadata x$1) {
                                                            String string = x$1.name();
                                                            String string2 = this.name$1;
                                                            return !(string != null ? !string.equals(string2) : string2 != null);
                                                        }
                                                        {
                                                            this.name$1 = name$1;
                                                        }
                                                    });
                                                }
                                                {
                                                    this.filtered$1 = filtered$1;
                                                }
                                            });
                                            throw new ParameterException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition(s) ", " cannot be found in metadata"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{unmatched.mkString(", ")})));
                                        }
                                        seq = filtered;
                                    }
                                    toCompact = seq;
                                    Enumeration.Value mode = (Enumeration.Value)$this.params().mode().getOrElse((Function0)new Serializable($this, storage){
                                        public static final long serialVersionUID = 0L;
                                        private final FileSystemStorage storage$1;

                                        public final Enumeration.Value apply() {
                                            return PathUtils$.MODULE$.isRemote(this.storage$1.context().root().toString()) ? DistributedRunParam.RunModes$.MODULE$.Distributed() : DistributedRunParam.RunModes$.MODULE$.Local();
                                        }
                                        {
                                            this.storage$1 = storage$1;
                                        }
                                    });
                                    Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compacting ", " partitions in ", " mode"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)toCompact.size()), mode.toString().toLowerCase(Locale.US)})));
                                    start = System.currentTimeMillis();
                                    status = new StatusCallback.PrintProgress(System.err, TextTools$.MODULE$.buildString(' ', 60), '=', '>', '>');
                                    value = mode;
                                    Enumeration.Value value2 = DistributedRunParam.RunModes$.MODULE$.Local();
                                    Enumeration.Value value3 = value;
                                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block9;
                                    int total = toCompact.length();
                                    CountDownLatch latch = new CountDownLatch(total);
                                    ExecutorService executor = Executors.newFixedThreadPool(package$.MODULE$.max(1, package$.MODULE$.min(Predef$.MODULE$.Integer2int($this.params().threads()), total)));
                                    try {
                                        toCompact.foreach((Function1)new Serializable($this, storage, latch, executor){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ FsCompactCommand.CompactCommand $outer;
                                            public final FileSystemStorage storage$1;
                                            public final CountDownLatch latch$1;
                                            private final ExecutorService executor$1;

                                            public final Future<?> apply(StorageMetadata.PartitionMetadata p) {
                                                return this.executor$1.submit(new Runnable(this, p){
                                                    private final /* synthetic */ FsCompactCommand$CompactCommand$.anonfun.compact.1 $outer;
                                                    private final StorageMetadata.PartitionMetadata p$1;

                                                    public void run() {
                                                        try {
                                                            try {
                                                                BoxedUnit boxedUnit;
                                                                if (this.$outer.org$locationtech$geomesa$fs$tools$compact$FsCompactCommand$CompactCommand$$anonfun$$$outer().logger().underlying().isInfoEnabled()) {
                                                                    this.$outer.org$locationtech$geomesa$fs$tools$compact$FsCompactCommand$CompactCommand$$anonfun$$$outer().logger().underlying().info("Compacting {}", new Object[]{this.p$1.name()});
                                                                    boxedUnit = BoxedUnit.UNIT;
                                                                } else {
                                                                    boxedUnit = BoxedUnit.UNIT;
                                                                }
                                                                this.$outer.storage$1.compact((Option)new Some((Object)this.p$1.name()), this.$outer.storage$1.compact$default$2());
                                                            }
                                                            catch (Throwable throwable) {
                                                                BoxedUnit boxedUnit;
                                                                Throwable throwable2 = throwable;
                                                                Option option = NonFatal$.MODULE$.unapply(throwable2);
                                                                if (option.isEmpty()) {
                                                                    throw throwable;
                                                                }
                                                                Throwable e = (Throwable)option.get();
                                                                if (this.$outer.org$locationtech$geomesa$fs$tools$compact$FsCompactCommand$CompactCommand$$anonfun$$$outer().logger().underlying().isErrorEnabled()) {
                                                                    this.$outer.org$locationtech$geomesa$fs$tools$compact$FsCompactCommand$CompactCommand$$anonfun$$$outer().logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error processing partition '", "':"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.p$1.name()})), e);
                                                                    boxedUnit = BoxedUnit.UNIT;
                                                                } else {
                                                                    boxedUnit = BoxedUnit.UNIT;
                                                                }
                                                                BoxedUnit boxedUnit2 = boxedUnit;
                                                            }
                                                        }
                                                        finally {
                                                            this.$outer.latch$1.countDown();
                                                        }
                                                    }
                                                    {
                                                        if ($outer == null) {
                                                            throw null;
                                                        }
                                                        this.$outer = $outer;
                                                        this.p$1 = p$1;
                                                    }
                                                });
                                            }

                                            public /* synthetic */ FsCompactCommand.CompactCommand org$locationtech$geomesa$fs$tools$compact$FsCompactCommand$CompactCommand$$anonfun$$$outer() {
                                                return this.$outer;
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                                this.storage$1 = storage$1;
                                                this.latch$1 = latch$1;
                                                this.executor$1 = executor$1;
                                            }
                                        });
                                        executor.shutdown();
                                    }
                                    catch (Throwable throwable) {
                                        void var16_14;
                                        var16_14.shutdown();
                                        throw throwable;
                                    }
                                    while (latch.getCount() > 0L) {
                                        Thread.sleep(1000L);
                                        status.apply("", 1.0f - (float)latch.getCount() / (float)total, (Seq)Seq$.MODULE$.empty(), false);
                                    }
                                    status.apply("", 1.0f, (Seq)Seq$.MODULE$.empty(), true);
                                    Command$.MODULE$.user().info("Compacting metadata");
                                    storage.metadata().compact((Option)None$.MODULE$, package$.MODULE$.max(1, Predef$.MODULE$.Integer2int($this.params().threads())));
                                    Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Local compaction complete in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TextTools$.MODULE$.getTime(start)})));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block10;
                                }
                                Enumeration.Value value4 = DistributedRunParam.RunModes$.MODULE$.Distributed();
                                Enumeration.Value value5 = value;
                                if (value4 != null ? !value4.equals(value5) : value5 != null) break block11;
                                encoding = storage.metadata().encoding();
                                if (!ParquetFileSystemStorage$.MODULE$.Encoding().equalsIgnoreCase(encoding)) break block12;
                                fileSystemCompactionJob = new FileSystemCompactionJob.ParquetCompactionJob();
                                break block13;
                            }
                            if (!OrcFileSystemStorage$.MODULE$.Encoding().equalsIgnoreCase(encoding)) break block14;
                            fileSystemCompactionJob = new FileSystemCompactionJob.OrcCompactionJob();
                        }
                        FileSystemCompactionJob.ParquetCompactionJob job = fileSystemCompactionJob;
                        Option tempDir = Option$.MODULE$.apply((Object)$this.params().tempDir()).map((Function1)new Serializable($this){
                            public static final long serialVersionUID = 0L;

                            public final Path apply(String t) {
                                return new Path(t);
                            }
                        });
                        tuple2 = job.run(storage, (Seq<StorageMetadata.PartitionMetadata>)toCompact, (Option<Path>)tempDir, $this.libjarsFiles(), (Iterator<Function0<Seq<File>>>)$this.libjarsPaths(), (StatusCallback)status);
                        if (tuple2 == null) break block15;
                        long success = tuple2._1$mcJ$sp();
                        long failed = tuple2._2$mcJ$sp();
                        Tuple2.mcJJ.sp sp3 = sp2 = new Tuple2.mcJJ.sp(success, failed);
                        long success2 = sp3._1$mcJ$sp();
                        long failed2 = sp3._2$mcJ$sp();
                        Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Distributed compaction complete in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TextTools$.MODULE$.getTime(start)})));
                        Command$.MODULE$.user().info(IngestCommand$.MODULE$.getStatInfo(success2, failed2, "Compacted", IngestCommand$.MODULE$.getStatInfo$default$4()));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw new MatchError(tuple2);
            }
            throw new ParameterException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compaction is not supported for encoding '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var19_18})));
        }
        throw new MatchError((Object)value);
    }

    public static void $init$(FsCompactCommand.CompactCommand $this) {
        $this.org$locationtech$geomesa$fs$tools$compact$FsCompactCommand$CompactCommand$_setter_$name_$eq("compact");
        $this.org$locationtech$geomesa$fs$tools$compact$FsCompactCommand$CompactCommand$_setter_$params_$eq(new FsCompactCommand.CompactParams());
    }
}

