/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.tools.ingest;

import com.typesafe.config.Config;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.net.URI;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.geotools.data.DataUtilities;
import org.locationtech.geomesa.features.SerializationOption;
import org.locationtech.geomesa.features.kryo.KryoFeatureSerializer;
import org.locationtech.geomesa.features.kryo.KryoFeatureSerializer$;
import org.locationtech.geomesa.fs.data.FileSystemDataStoreFactory;
import org.locationtech.geomesa.fs.data.FileSystemStorageManager;
import org.locationtech.geomesa.fs.data.FileSystemStorageManager$;
import org.locationtech.geomesa.fs.storage.api.FileSystemStorage;
import org.locationtech.geomesa.fs.storage.api.PartitionScheme;
import org.locationtech.geomesa.fs.storage.api.StorageMetadata;
import org.locationtech.geomesa.fs.storage.api.StorageMetadataFactory$;
import org.locationtech.geomesa.fs.storage.api.package;
import org.locationtech.geomesa.fs.storage.common.jobs.StorageConfiguration;
import org.locationtech.geomesa.fs.storage.common.jobs.StorageConfiguration$;
import org.locationtech.geomesa.fs.storage.common.utils.StorageUtils;
import org.locationtech.geomesa.fs.storage.orc.jobs.OrcStorageConfiguration;
import org.locationtech.geomesa.fs.tools.ingest.StorageJobUtils$;
import org.locationtech.geomesa.jobs.mapreduce.GeoMesaOutputFormat;
import org.locationtech.geomesa.parquet.jobs.ParquetStorageConfiguration;
import org.locationtech.geomesa.tools.Command$;
import org.locationtech.geomesa.tools.ingest.DistributedConverterIngest;
import org.locationtech.geomesa.tools.utils.StatusCallback;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\r=e!B\u0001\u0003\u0003\u0003y!A\u0006$jY\u0016\u001c\u0016p\u001d;f[\u000e{gN^3si\u0016\u0014(j\u001c2\u000b\u0005\r!\u0011AB5oO\u0016\u001cHO\u0003\u0002\u0006\r\u0005)Ao\\8mg*\u0011q\u0001C\u0001\u0003MNT!!\u0003\u0006\u0002\u000f\u001d,w.\\3tC*\u00111\u0002D\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0005\u00141!\t\t2E\u0004\u0002\u0013A9\u00111C\b\b\u0003)uq!!\u0006\u000f\u000f\u0005YYbBA\f\u001b\u001b\u0005A\"BA\r\u000f\u0003\u0019a$o\\8u}%\tQ\"\u0003\u0002\f\u0019%\u0011\u0011BC\u0005\u0003\u000b!I!aA\u0010\u000b\u0005\u0015A\u0011BA\u0011#\u0003i!\u0015n\u001d;sS\n,H/\u001a3D_:4XM\u001d;fe&sw-Z:u\u0015\t\u0019q$\u0003\u0002%K\t\u00112i\u001c8wKJ$XM]%oO\u0016\u001cHOS8c\u0015\t\t#\u0005\u0005\u0002(]5\t\u0001F\u0003\u0002*U\u0005!!n\u001c2t\u0015\tYC&\u0001\u0004d_6lwN\u001c\u0006\u0003[\u0019\tqa\u001d;pe\u0006<W-\u0003\u00020Q\t!2\u000b^8sC\u001e,7i\u001c8gS\u001e,(/\u0019;j_:\u0004\"!\r\u001d\u000e\u0003IR!a\r\u001b\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005U2\u0014\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003]\n1aY8n\u0013\tI$GA\u0006MCjLHj\\4hS:<\u0007\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001f\u0002\u0011\u0011\u001c\b+\u0019:b[N\u0004B!P\"G\r:\u0011a(Q\u0007\u0002\u007f)\t\u0001)A\u0003tG\u0006d\u0017-\u0003\u0002C\u007f\u00051\u0001K]3eK\u001aL!\u0001R#\u0003\u00075\u000b\u0007O\u0003\u0002C\u007fA\u0011QhR\u0005\u0003\u0011\u0016\u0013aa\u0015;sS:<\u0007\u0002\u0003&\u0001\u0005\u0003\u0005\u000b\u0011B&\u0002\u0007M4G\u000f\u0005\u0002M'6\tQJ\u0003\u0002O\u001f\u000611/[7qY\u0016T!\u0001U)\u0002\u000f\u0019,\u0017\r^;sK*\u0011!\u000bD\u0001\b_B,gnZ5t\u0013\t!VJA\tTS6\u0004H.\u001a$fCR,(/\u001a+za\u0016D\u0001B\u0016\u0001\u0003\u0002\u0003\u0006IaV\u0001\u0010G>tg/\u001a:uKJ\u001cuN\u001c4jOB\u0011\u0001lW\u0007\u00023*\u0011!\fN\u0001\u0007G>tg-[4\n\u0005qK&AB\"p]\u001aLw\r\u0003\u0005_\u0001\t\u0005\t\u0015!\u0003`\u0003\u0015\u0001\u0018\r\u001e5t!\r\u0001WM\u0012\b\u0003C\u000et!a\u00062\n\u0003\u0001K!\u0001Z \u0002\u000fA\f7m[1hK&\u0011am\u001a\u0002\u0004'\u0016\f(B\u00013@\u0011!I\u0007A!A!\u0002\u0013y\u0016\u0001\u00047jE*\f'o\u001d$jY\u0016\u001c\b\u0002C6\u0001\u0005\u0003\u0005\u000b\u0011\u00027\u0002\u00191L'M[1sgB\u000bG\u000f[:\u0011\u0007\u0001lw.\u0003\u0002oO\nA\u0011\n^3sCR|'\u000fE\u0002?aJL!!] \u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004c\u00011fgB\u0011A/_\u0007\u0002k*\u0011ao^\u0001\u0003S>T\u0011\u0001_\u0001\u0005U\u00064\u0018-\u0003\u0002{k\n!a)\u001b7f\u0011!a\bA!A!\u0002\u0013i\u0018\u0001\u0003:fIV\u001cWM]:\u0011\u0005yr\u0018BA@@\u0005\rIe\u000e\u001e\u0005\u000b\u0003\u0007\u0001!\u0011!Q\u0001\n\u0005\u0015\u0011a\u0002;naB\u000bG\u000f\u001b\t\u0006}\u0005\u001d\u00111B\u0005\u0004\u0003\u0013y$AB(qi&|g\u000e\u0005\u0003\u0002\u000e\u0005eQBAA\b\u0015\r9\u0011\u0011\u0003\u0006\u0005\u0003'\t)\"\u0001\u0004iC\u0012|w\u000e\u001d\u0006\u0004\u0003/a\u0011AB1qC\u000eDW-\u0003\u0003\u0002\u001c\u0005=!\u0001\u0002)bi\"Dq!a\b\u0001\t\u0003\t\t#\u0001\u0004=S:LGO\u0010\u000b\u0013\u0003G\t9#!\u000b\u0002,\u00055\u0012qFA\u0019\u0003g\t)\u0004E\u0002\u0002&\u0001i\u0011A\u0001\u0005\u0007w\u0005u\u0001\u0019\u0001\u001f\t\r)\u000bi\u00021\u0001L\u0011\u00191\u0016Q\u0004a\u0001/\"1a,!\bA\u0002}Ca![A\u000f\u0001\u0004y\u0006BB6\u0002\u001e\u0001\u0007A\u000e\u0003\u0004}\u0003;\u0001\r! \u0005\t\u0003\u0007\ti\u00021\u0001\u0002\u0006!Y\u0011\u0011\b\u0001A\u0002\u0003\u0007I\u0011BA\u001e\u0003\rQwNY\u000b\u0003\u0003{\u0001B!a\u0010\u0002F5\u0011\u0011\u0011\t\u0006\u0005\u0003\u0007\n\t\"A\u0005nCB\u0014X\rZ;dK&!\u0011qIA!\u0005\rQuN\u0019\u0005\f\u0003\u0017\u0002\u0001\u0019!a\u0001\n\u0013\ti%A\u0004k_\n|F%Z9\u0015\t\u0005=\u0013Q\u000b\t\u0004}\u0005E\u0013bAA*\u007f\t!QK\\5u\u0011)\t9&!\u0013\u0002\u0002\u0003\u0007\u0011QH\u0001\u0004q\u0012\n\u0004\u0002CA.\u0001\u0001\u0006K!!\u0010\u0002\t)|'\r\t\u0005\f\u0003?\u0002\u0001\u0019!a\u0001\n\u0013\t\t'\u0001\u0003s_>$XCAA\u0006\u0011-\t)\u0007\u0001a\u0001\u0002\u0004%I!a\u001a\u0002\u0011I|w\u000e^0%KF$B!a\u0014\u0002j!Q\u0011qKA2\u0003\u0003\u0005\r!a\u0003\t\u0011\u00055\u0004\u0001)Q\u0005\u0003\u0017\tQA]8pi\u0002B\u0011\"!\u001d\u0001\u0001\u0004%I!a\u001d\u0002#E,\u0018\r\\5gS\u0016$G+Z7q!\u0006$\b.\u0006\u0002\u0002\u0006!I\u0011q\u000f\u0001A\u0002\u0013%\u0011\u0011P\u0001\u0016cV\fG.\u001b4jK\u0012$V-\u001c9QCRDw\fJ3r)\u0011\ty%a\u001f\t\u0015\u0005]\u0013QOA\u0001\u0002\u0004\t)\u0001\u0003\u0005\u0002\u0000\u0001\u0001\u000b\u0015BA\u0003\u0003I\tX/\u00197jM&,G\rV3naB\u000bG\u000f\u001b\u0011\t\u000f\u0005\r\u0005\u0001\"\u0011\u0002\u0006\u00069!/\u001a3vG\u0016$G\u0003BAD\u0003\u001b\u00032APAE\u0013\r\tYi\u0010\u0002\u0005\u0019>tw\r\u0003\u0005\u0002:\u0005\u0005\u0005\u0019AA\u001f\u0011\u001d\t\t\n\u0001C!\u0003'\u000bAbY8oM&<WO]3K_\n$B!a\u0014\u0002\u0016\"A\u0011\u0011HAH\u0001\u0004\ti\u0004C\u0004\u0002\u001a\u0002!\t%a'\u0002\u0007I,h\u000e\u0006\u0004\u0002\u001e\u0006\u0015\u0016Q\u0017\t\u0006}\u0005\u001d\u0011q\u0014\t\b}\u0005\u0005\u0016qQAD\u0013\r\t\u0019k\u0010\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u0005\u001d\u0016q\u0013a\u0001\u0003S\u000bab\u001d;biV\u001c8)\u00197mE\u0006\u001c7\u000e\u0005\u0003\u0002,\u0006EVBAAW\u0015\r\tykH\u0001\u0006kRLGn]\u0005\u0005\u0003g\u000biK\u0001\bTi\u0006$Xo]\"bY2\u0014\u0017mY6\t\u0015\u0005]\u0016q\u0013I\u0001\u0002\u0004\tI,A\txC&$hi\u001c:D_6\u0004H.\u001a;j_:\u00042APA^\u0013\r\til\u0010\u0002\b\u0005>|G.Z1o\u000f\u001d\t\tM\u0001E\u0001\u0003\u0007\faCR5mKNK8\u000f^3n\u0007>tg/\u001a:uKJTuN\u0019\t\u0005\u0003K\t)M\u0002\u0004\u0002\u0005!\u0005\u0011qY\n\u0005\u0003\u000b\fI\rE\u0002?\u0003\u0017L1!!4@\u0005\u0019\te.\u001f*fM\"A\u0011qDAc\t\u0003\t\t\u000e\u0006\u0002\u0002D\u001a9\u0011Q[Ac\u0001\u0005]'a\u0005)beF,X\r^\"p]Z,'\u000f^3s\u0015>\u00147CBAj\u0003G\tI\u000e\u0005\u0003\u0002\\\u0006\rXBAAo\u0015\rI\u0013q\u001c\u0006\u0004\u0003CD\u0011a\u00029beF,X\r^\u0005\u0005\u0003K\fiNA\u000eQCJ\fX/\u001a;Ti>\u0014\u0018mZ3D_:4\u0017nZ;sCRLwN\u001c\u0005\nw\u0005M'\u0011!Q\u0001\nqB\u0011BSAj\u0005\u0003\u0005\u000b\u0011B&\t\u0013Y\u000b\u0019N!A!\u0002\u00139\u0006\"\u00030\u0002T\n\u0005\t\u0015!\u0003`\u0011%I\u00171\u001bB\u0001B\u0003%q\fC\u0005l\u0003'\u0014\t\u0011)A\u0005Y\"IA0a5\u0003\u0002\u0003\u0006I! \u0005\f\u0003\u0007\t\u0019N!A!\u0002\u0013\t)\u0001\u0003\u0005\u0002 \u0005MG\u0011AA})I\tY0a@\u0003\u0002\t\r!Q\u0001B\u0004\u0005\u0013\u0011YA!\u0004\u0011\t\u0005u\u00181[\u0007\u0003\u0003\u000bDaaOA|\u0001\u0004a\u0004B\u0002&\u0002x\u0002\u00071\n\u0003\u0004W\u0003o\u0004\ra\u0016\u0005\u0007=\u0006]\b\u0019A0\t\r%\f9\u00101\u0001`\u0011\u0019Y\u0017q\u001fa\u0001Y\"1A0a>A\u0002uD\u0001\"a\u0001\u0002x\u0002\u0007\u0011Q\u0001\u0004\b\u0005#\t)\r\u0001B\n\u0005=y%oY\"p]Z,'\u000f^3s\u0015>\u00147C\u0002B\b\u0003G\u0011)\u0002\u0005\u0003\u0003\u0018\t}QB\u0001B\r\u0015\rI#1\u0004\u0006\u0004\u0005;a\u0013aA8sG&!!\u0011\u0005B\r\u0005]y%oY*u_J\fw-Z\"p]\u001aLw-\u001e:bi&|g\u000eC\u0005<\u0005\u001f\u0011\t\u0011)A\u0005y!I!Ja\u0004\u0003\u0002\u0003\u0006Ia\u0013\u0005\n-\n=!\u0011!Q\u0001\n]C\u0011B\u0018B\b\u0005\u0003\u0005\u000b\u0011B0\t\u0013%\u0014yA!A!\u0002\u0013y\u0006\"C6\u0003\u0010\t\u0005\t\u0015!\u0003m\u0011%a(q\u0002B\u0001B\u0003%Q\u0010C\u0006\u0002\u0004\t=!\u0011!Q\u0001\n\u0005\u0015\u0001\u0002CA\u0010\u0005\u001f!\tA!\u000e\u0015%\t]\"\u0011\bB\u001e\u0005{\u0011yD!\u0011\u0003D\t\u0015#q\t\t\u0005\u0003{\u0014y\u0001\u0003\u0004<\u0005g\u0001\r\u0001\u0010\u0005\u0007\u0015\nM\u0002\u0019A&\t\rY\u0013\u0019\u00041\u0001X\u0011\u0019q&1\u0007a\u0001?\"1\u0011Na\rA\u0002}Caa\u001bB\u001a\u0001\u0004a\u0007B\u0002?\u00034\u0001\u0007Q\u0010\u0003\u0005\u0002\u0004\tM\u0002\u0019AA\u0003\r\u001d\u0011Y%!2\u0001\u0005\u001b\u0012aBR:J]\u001e,7\u000f^'baB,'oE\u0003\u0003J\t=\u0003\u0007\u0005\u0007\u0002@\tE#Q\u000bB0\u0005K\u0012Y'\u0003\u0003\u0003T\u0005\u0005#AB'baB,'\u000f\u0005\u0003\u0003X\tmSB\u0001B-\u0015\r1\u0018\u0011C\u0005\u0005\u0005;\u0012IF\u0001\u0007M_:<wK]5uC\ndW\rE\u0002M\u0005CJ1Aa\u0019N\u00055\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKB!!q\u000bB4\u0013\u0011\u0011IG!\u0017\u0003\tQ+\u0007\u0010\u001e\t\u0005\u0005/\u0012i'\u0003\u0003\u0003p\te#!\u0004\"zi\u0016\u001cxK]5uC\ndW\r\u0003\u0005\u0002 \t%C\u0011\u0001B:)\t\u0011)\b\u0005\u0003\u0002~\n%Sa\u0002B=\u0005\u0013\u0002!1\u0010\u0002\b\u0007>tG/\u001a=u!\u0011\u0011yE! \n\t\te$\u0011\u000b\u0005\r\u0005\u0003\u0013I\u00051AA\u0002\u0013%!1Q\u0001\u000bg\u0016\u0014\u0018.\u00197ju\u0016\u0014XC\u0001BC!\u0011\u00119I!%\u000e\u0005\t%%\u0002\u0002BF\u0005\u001b\u000bAa\u001b:z_*\u0019!q\u0012\u0005\u0002\u0011\u0019,\u0017\r^;sKNLAAa%\u0003\n\n)2J]=p\r\u0016\fG/\u001e:f'\u0016\u0014\u0018.\u00197ju\u0016\u0014\b\u0002\u0004BL\u0005\u0013\u0002\r\u00111A\u0005\n\te\u0015AD:fe&\fG.\u001b>fe~#S-\u001d\u000b\u0005\u0003\u001f\u0012Y\n\u0003\u0006\u0002X\tU\u0015\u0011!a\u0001\u0005\u000bC\u0011Ba(\u0003J\u0001\u0006KA!\"\u0002\u0017M,'/[1mSj,'\u000f\t\u0005\r\u0005G\u0013I\u00051AA\u0002\u0013%!QU\u0001\t[\u0016$\u0018\rZ1uCV\u0011!q\u0015\t\u0005\u0005S\u0013y+\u0004\u0002\u0003,*\u0019!Q\u0016\u0017\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u00032\n-&aD*u_J\fw-Z'fi\u0006$\u0017\r^1\t\u0019\tU&\u0011\na\u0001\u0002\u0004%IAa.\u0002\u00195,G/\u00193bi\u0006|F%Z9\u0015\t\u0005=#\u0011\u0018\u0005\u000b\u0003/\u0012\u0019,!AA\u0002\t\u001d\u0006\"\u0003B_\u0005\u0013\u0002\u000b\u0015\u0002BT\u0003%iW\r^1eCR\f\u0007\u0005\u0003\u0007\u0003B\n%\u0003\u0019!a\u0001\n\u0013\u0011\u0019-\u0001\u0004tG\",W.Z\u000b\u0003\u0005\u000b\u0004BA!+\u0003H&!!\u0011\u001aBV\u0005=\u0001\u0016M\u001d;ji&|gnU2iK6,\u0007\u0002\u0004Bg\u0005\u0013\u0002\r\u00111A\u0005\n\t=\u0017AC:dQ\u0016lWm\u0018\u0013fcR!\u0011q\nBi\u0011)\t9Fa3\u0002\u0002\u0003\u0007!Q\u0019\u0005\n\u0005+\u0014I\u0005)Q\u0005\u0005\u000b\fqa]2iK6,\u0007\u0005\u0003\u0007\u0003Z\n%\u0003\u0019!a\u0001\n\u0003\u0011Y.\u0001\u0004nCB\u0004X\rZ\u000b\u0003\u0005;\u0004B!a\u0010\u0003`&!!\u0011]A!\u0005\u001d\u0019u.\u001e8uKJDAB!:\u0003J\u0001\u0007\t\u0019!C\u0001\u0005O\f!\"\\1qa\u0016$w\fJ3r)\u0011\tyE!;\t\u0015\u0005]#1]A\u0001\u0002\u0004\u0011i\u000eC\u0005\u0003n\n%\u0003\u0015)\u0003\u0003^\u00069Q.\u00199qK\u0012\u0004\u0003\u0002\u0004By\u0005\u0013\u0002\r\u00111A\u0005\u0002\tm\u0017aB<sSR$XM\u001c\u0005\r\u0005k\u0014I\u00051AA\u0002\u0013\u0005!q_\u0001\foJLG\u000f^3o?\u0012*\u0017\u000f\u0006\u0003\u0002P\te\bBCA,\u0005g\f\t\u00111\u0001\u0003^\"I!Q B%A\u0003&!Q\\\u0001\toJLG\u000f^3oA!a1\u0011\u0001B%\u0001\u0004\u0005\r\u0011\"\u0001\u0003\\\u00061a-Y5mK\u0012DAb!\u0002\u0003J\u0001\u0007\t\u0019!C\u0001\u0007\u000f\t!BZ1jY\u0016$w\fJ3r)\u0011\tye!\u0003\t\u0015\u0005]31AA\u0001\u0002\u0004\u0011i\u000eC\u0005\u0004\u000e\t%\u0003\u0015)\u0003\u0003^\u00069a-Y5mK\u0012\u0004\u0003\u0002CB\t\u0005\u0013\"\tea\u0005\u0002\u000bM,G/\u001e9\u0015\t\u0005=3Q\u0003\u0005\t\u0007/\u0019y\u00011\u0001\u0004\u001a\u000591m\u001c8uKb$\b\u0003BB\u000e\u0005oj!A!\u0013\t\u0011\r}!\u0011\nC!\u0007C\t1!\\1q)!\tyea\t\u0004(\r-\u0002\u0002CB\u0013\u0007;\u0001\rA!\u0016\u0002\u0007-,\u0017\u0010\u0003\u0005\u0004*\ru\u0001\u0019\u0001B0\u0003\t\u0019h\r\u0003\u0005\u0004\u0018\ru\u0001\u0019AB\r\u0011!\u0019yC!\u0013\u0005B\rE\u0012aB2mK\u0006tW\u000f\u001d\u000b\u0005\u0003\u001f\u001a\u0019\u0004\u0003\u0005\u0004\u0018\r5\u0002\u0019AB\r\r\u001d\u00199$!2\u0001\u0007s\u0011A\u0002R;n[f\u0014V\rZ;dKJ\u001cBa!\u000e\u0004<Aa\u0011qHB\u001f\u0005K\u0012Yg!\u0011\u0003`%!1qHA!\u0005\u001d\u0011V\rZ;dKJ\u0004Baa\u0011\u0004J5\u00111Q\t\u0006\u0004\u0007\u000f:\u0018\u0001\u00027b]\u001eLAaa\u0013\u0004F\t!ak\\5e\u0011!\tyb!\u000e\u0005\u0002\r=CCAB)!\u0011\tip!\u000e\u0006\u000f\te4Q\u0007\u0001\u0004VA!11HB,\u0013\u0011\u0011Ih!\u0010\t\u0019\t\u00055Q\u0007a\u0001\u0002\u0004%IAa!\t\u0019\t]5Q\u0007a\u0001\u0002\u0004%Ia!\u0018\u0015\t\u0005=3q\f\u0005\u000b\u0003/\u001aY&!AA\u0002\t\u0015\u0005\"\u0003BP\u0007k\u0001\u000b\u0015\u0002BC\u00111\t\u0019i!\u000eA\u0002\u0003\u0007I\u0011\u0002Bn\u00111\u00199g!\u000eA\u0002\u0003\u0007I\u0011BB5\u0003-\u0011X\rZ;dK\u0012|F%Z9\u0015\t\u0005=31\u000e\u0005\u000b\u0003/\u001a)'!AA\u0002\tu\u0007\"CB8\u0007k\u0001\u000b\u0015\u0002Bo\u0003!\u0011X\rZ;dK\u0012\u0004\u0003\u0002CB\t\u0007k!\tea\u001d\u0015\t\u0005=3Q\u000f\u0005\t\u0007/\u0019\t\b1\u0001\u0004xA!1\u0011PB*\u001b\t\u0019)\u0004\u0003\u0005\u0004~\rUB\u0011IB@\u0003\u0019\u0011X\rZ;dKRA\u0011qJBA\u0007\u0007\u001bi\t\u0003\u0005\u0004&\rm\u0004\u0019\u0001B3\u0011!\u0019)ia\u001fA\u0002\r\u001d\u0015A\u0002<bYV,7\u000f\u0005\u0004\u0004D\r%%1N\u0005\u0005\u0007\u0017\u001b)E\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0011!\u00199ba\u001fA\u0002\r]\u0004")
public abstract class FileSystemConverterJob
extends DistributedConverterIngest.ConverterIngestJob
implements StorageConfiguration,
LazyLogging {
    public final scala.collection.immutable.Map<String, String> org$locationtech$geomesa$fs$tools$ingest$FileSystemConverterJob$$dsParams;
    public final SimpleFeatureType org$locationtech$geomesa$fs$tools$ingest$FileSystemConverterJob$$sft;
    private final int reducers;
    private final Option<Path> tmpPath;
    private Job job;
    private Path org$locationtech$geomesa$fs$tools$ingest$FileSystemConverterJob$$root;
    private Option<Path> qualifiedTempPath;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        FileSystemConverterJob fileSystemConverterJob = this;
        synchronized (fileSystemConverterJob) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    private Job job() {
        return this.job;
    }

    private void job_$eq(Job x$1) {
        this.job = x$1;
    }

    public Path org$locationtech$geomesa$fs$tools$ingest$FileSystemConverterJob$$root() {
        return this.org$locationtech$geomesa$fs$tools$ingest$FileSystemConverterJob$$root;
    }

    private void org$locationtech$geomesa$fs$tools$ingest$FileSystemConverterJob$$root_$eq(Path x$1) {
        this.org$locationtech$geomesa$fs$tools$ingest$FileSystemConverterJob$$root = x$1;
    }

    private Option<Path> qualifiedTempPath() {
        return this.qualifiedTempPath;
    }

    private void qualifiedTempPath_$eq(Option<Path> x$1) {
        this.qualifiedTempPath = x$1;
    }

    public long reduced(Job job) {
        return job.getCounters().findCounter(GeoMesaOutputFormat.Counters$.MODULE$.Group(), "reduced").getValue();
    }

    public void configureJob(Job job) {
        super.configureJob(job);
        job.setMapperClass(FsIngestMapper.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(BytesWritable.class);
        job.setOutputKeyClass(Void.class);
        job.setOutputValueClass(SimpleFeature.class);
        job.setReducerClass(DummyReducer.class);
        job.setNumReduceTasks(this.reducers);
        job.getConfiguration().set("mapreduce.job.reduce.slowstart.completedmaps", ".90");
        FileContext fc = FileContext.getFileContext((Configuration)job.getConfiguration());
        FileSystemStorageManager manager = FileSystemStorageManager$.MODULE$.apply(fc, job.getConfiguration(), new Path((String)FileSystemDataStoreFactory.FileSystemDataStoreParams$.MODULE$.PathParam().lookup((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.org$locationtech$geomesa$fs$tools$ingest$FileSystemConverterJob$$dsParams).asJava())), (Option)None$.MODULE$);
        FileSystemStorage storage = (FileSystemStorage)manager.storage(this.org$locationtech$geomesa$fs$tools$ingest$FileSystemConverterJob$$sft.getTypeName()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileSystemConverterJob $outer;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not load metadata for ", " at "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$locationtech$geomesa$fs$tools$ingest$FileSystemConverterJob$$sft.getTypeName()}))).append(FileSystemDataStoreFactory.FileSystemDataStoreParams$.MODULE$.PathParam().lookup((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.$outer.org$locationtech$geomesa$fs$tools$ingest$FileSystemConverterJob$$dsParams).asJava())).toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.org$locationtech$geomesa$fs$tools$ingest$FileSystemConverterJob$$root_$eq(storage.context().root());
        this.qualifiedTempPath_$eq((Option<Path>)this.tmpPath.map((Function1)new Serializable(this, fc){
            public static final long serialVersionUID = 0L;
            private final FileContext fc$1;

            public final Path apply(Path x$1) {
                return this.fc$1.makeQualified(x$1);
            }
            {
                this.fc$1 = fc$1;
            }
        }));
        this.qualifiedTempPath().foreach((Function1)new Serializable(this, fc){
            public static final long serialVersionUID = 0L;
            private final FileContext fc$1;

            public final Object apply(Path tp) {
                Object object;
                if (this.fc$1.util().exists(tp)) {
                    Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting temp path ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tp})));
                    object = BoxesRunTime.boxToBoolean((boolean)this.fc$1.delete(tp, true));
                } else {
                    object = BoxedUnit.UNIT;
                }
                return object;
            }
            {
                this.fc$1 = fc$1;
            }
        });
        StorageConfiguration$.MODULE$.setRootPath(job.getConfiguration(), this.org$locationtech$geomesa$fs$tools$ingest$FileSystemConverterJob$$root());
        StorageConfiguration$.MODULE$.setFileType(job.getConfiguration(), StorageUtils.FileType$.MODULE$.Written());
        FileOutputFormat.setOutputPath((Job)job, (Path)((Path)this.qualifiedTempPath().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileSystemConverterJob $outer;

            public final Path apply() {
                return this.$outer.org$locationtech$geomesa$fs$tools$ingest$FileSystemConverterJob$$root();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        })));
        this.configureOutput(this.org$locationtech$geomesa$fs$tools$ingest$FileSystemConverterJob$$sft, job);
        this.job_$eq(job);
    }

    /*
     * WARNING - void declaration
     */
    public Option<Tuple2<Object, Object>> run(StatusCallback statusCallback, boolean waitForCompletion) {
        void var3_3;
        Option result = super.run(statusCallback, waitForCompletion);
        if (waitForCompletion && this.job().isSuccessful()) {
            this.qualifiedTempPath().foreach((Function1)new Serializable(this, statusCallback){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FileSystemConverterJob $outer;
                private final StatusCallback statusCallback$1;

                public final boolean apply(Path x$1) {
                    return StorageJobUtils$.MODULE$.distCopy(x$1, this.$outer.org$locationtech$geomesa$fs$tools$ingest$FileSystemConverterJob$$root(), this.statusCallback$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.statusCallback$1 = statusCallback$1;
                }
            });
        }
        return var3_3;
    }

    public FileSystemConverterJob(scala.collection.immutable.Map<String, String> dsParams, SimpleFeatureType sft, Config converterConfig, Seq<String> paths, Seq<String> libjarsFiles, Iterator<Function0<Seq<File>>> libjarsPaths2, int reducers, Option<Path> tmpPath) {
        this.org$locationtech$geomesa$fs$tools$ingest$FileSystemConverterJob$$dsParams = dsParams;
        this.org$locationtech$geomesa$fs$tools$ingest$FileSystemConverterJob$$sft = sft;
        this.reducers = reducers;
        this.tmpPath = tmpPath;
        super(dsParams, sft, converterConfig, paths, libjarsFiles, libjarsPaths2);
        LazyLogging.class.$init$((LazyLogging)this);
        this.qualifiedTempPath = None$.MODULE$;
    }

    public static class DummyReducer
    extends Reducer<Text, BytesWritable, Void, SimpleFeature> {
        private KryoFeatureSerializer org$locationtech$geomesa$fs$tools$ingest$FileSystemConverterJob$DummyReducer$$serializer;
        private Counter org$locationtech$geomesa$fs$tools$ingest$FileSystemConverterJob$DummyReducer$$reduced;

        public KryoFeatureSerializer org$locationtech$geomesa$fs$tools$ingest$FileSystemConverterJob$DummyReducer$$serializer() {
            return this.org$locationtech$geomesa$fs$tools$ingest$FileSystemConverterJob$DummyReducer$$serializer;
        }

        private void org$locationtech$geomesa$fs$tools$ingest$FileSystemConverterJob$DummyReducer$$serializer_$eq(KryoFeatureSerializer x$1) {
            this.org$locationtech$geomesa$fs$tools$ingest$FileSystemConverterJob$DummyReducer$$serializer = x$1;
        }

        public Counter org$locationtech$geomesa$fs$tools$ingest$FileSystemConverterJob$DummyReducer$$reduced() {
            return this.org$locationtech$geomesa$fs$tools$ingest$FileSystemConverterJob$DummyReducer$$reduced;
        }

        private void org$locationtech$geomesa$fs$tools$ingest$FileSystemConverterJob$DummyReducer$$reduced_$eq(Counter x$1) {
            this.org$locationtech$geomesa$fs$tools$ingest$FileSystemConverterJob$DummyReducer$$reduced = x$1;
        }

        public void setup(Reducer.Context context) {
            Path root = StorageConfiguration$.MODULE$.getRootPath(context.getConfiguration());
            FileContext fc = FileContext.getFileContext((URI)root.toUri(), (Configuration)context.getConfiguration());
            StorageMetadata metadata = (StorageMetadata)StorageMetadataFactory$.MODULE$.load(new package.FileSystemContext(fc, context.getConfiguration(), root, package.FileSystemContext$.MODULE$.apply$default$4())).getOrElse((Function0)new Serializable(this, root){
                public static final long serialVersionUID = 0L;
                private final Path root$2;

                public final Nothing$ apply() {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not load storage instance at path ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.root$2})));
                }
                {
                    this.root$2 = root$2;
                }
            });
            this.org$locationtech$geomesa$fs$tools$ingest$FileSystemConverterJob$DummyReducer$$serializer_$eq(KryoFeatureSerializer$.MODULE$.apply(metadata.sft(), SerializationOption.SerializationOptions$.MODULE$.none()));
            this.org$locationtech$geomesa$fs$tools$ingest$FileSystemConverterJob$DummyReducer$$reduced_$eq(context.getCounter(GeoMesaOutputFormat.Counters$.MODULE$.Group(), "reduced"));
            metadata.close();
        }

        public void reduce(Text key, Iterable<BytesWritable> values, Reducer.Context context) {
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(values).asScala()).foreach((Function1)new Serializable(this, context){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DummyReducer $outer;
                private final Reducer.Context context$1;

                public final void apply(BytesWritable bw) {
                    this.context$1.write(null, (Object)this.$outer.org$locationtech$geomesa$fs$tools$ingest$FileSystemConverterJob$DummyReducer$$serializer().deserialize(bw.getBytes()));
                    this.$outer.org$locationtech$geomesa$fs$tools$ingest$FileSystemConverterJob$DummyReducer$$reduced().increment(1L);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.context$1 = context$1;
                }
            });
        }
    }

    public static class FsIngestMapper
    extends Mapper<LongWritable, SimpleFeature, Text, BytesWritable>
    implements LazyLogging {
        private KryoFeatureSerializer serializer;
        private StorageMetadata metadata;
        private PartitionScheme scheme;
        private Counter mapped;
        private Counter written;
        private Counter failed;
        private final Logger logger;
        private volatile boolean bitmap$0;

        private Logger logger$lzycompute() {
            FsIngestMapper fsIngestMapper = this;
            synchronized (fsIngestMapper) {
                if (!this.bitmap$0) {
                    this.logger = LazyLogging.class.logger((LazyLogging)this);
                    this.bitmap$0 = true;
                }
                return this.logger;
            }
        }

        public Logger logger() {
            return this.bitmap$0 ? this.logger : this.logger$lzycompute();
        }

        private KryoFeatureSerializer serializer() {
            return this.serializer;
        }

        private void serializer_$eq(KryoFeatureSerializer x$1) {
            this.serializer = x$1;
        }

        private StorageMetadata metadata() {
            return this.metadata;
        }

        private void metadata_$eq(StorageMetadata x$1) {
            this.metadata = x$1;
        }

        private PartitionScheme scheme() {
            return this.scheme;
        }

        private void scheme_$eq(PartitionScheme x$1) {
            this.scheme = x$1;
        }

        public Counter mapped() {
            return this.mapped;
        }

        public void mapped_$eq(Counter x$1) {
            this.mapped = x$1;
        }

        public Counter written() {
            return this.written;
        }

        public void written_$eq(Counter x$1) {
            this.written = x$1;
        }

        public Counter failed() {
            return this.failed;
        }

        public void failed_$eq(Counter x$1) {
            this.failed = x$1;
        }

        public void setup(Mapper.Context context) {
            Path root = StorageConfiguration$.MODULE$.getRootPath(context.getConfiguration());
            FileContext fc = FileContext.getFileContext((URI)root.toUri(), (Configuration)context.getConfiguration());
            this.metadata_$eq((StorageMetadata)StorageMetadataFactory$.MODULE$.load(new package.FileSystemContext(fc, context.getConfiguration(), root, package.FileSystemContext$.MODULE$.apply$default$4())).getOrElse((Function0)new Serializable(this, root){
                public static final long serialVersionUID = 0L;
                private final Path root$1;

                public final Nothing$ apply() {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not load storage instance at path ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.root$1})));
                }
                {
                    this.root$1 = root$1;
                }
            }));
            this.serializer_$eq(KryoFeatureSerializer$.MODULE$.apply(this.metadata().sft(), SerializationOption.SerializationOptions$.MODULE$.none()));
            this.scheme_$eq(this.metadata().scheme());
            this.mapped_$eq(context.getCounter(GeoMesaOutputFormat.Counters$.MODULE$.Group(), "mapped"));
            this.written_$eq(context.getCounter(GeoMesaOutputFormat.Counters$.MODULE$.Group(), GeoMesaOutputFormat.Counters$.MODULE$.Written()));
            this.failed_$eq(context.getCounter(GeoMesaOutputFormat.Counters$.MODULE$.Group(), GeoMesaOutputFormat.Counters$.MODULE$.Failed()));
        }

        public void map(LongWritable key, SimpleFeature sf, Mapper.Context context) {
            try {
                this.mapped().increment(1L);
                Text partitionKey = new Text(this.scheme().getPartitionName(sf));
                context.write((Object)partitionKey, (Object)new BytesWritable(this.serializer().serialize(sf)));
                this.written().increment(1L);
            }
            catch (Throwable throwable) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to write '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DataUtilities.encodeFeature((SimpleFeature)sf)})), throwable);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                this.failed().increment(1L);
            }
        }

        public void cleanup(Mapper.Context context) {
            this.metadata().close();
        }

        public FsIngestMapper() {
            LazyLogging.class.$init$((LazyLogging)this);
        }
    }

    public static class OrcConverterJob
    extends FileSystemConverterJob
    implements OrcStorageConfiguration {
        public void configureOutput(SimpleFeatureType sft, Job job) {
            OrcStorageConfiguration.class.configureOutput((OrcStorageConfiguration)this, (SimpleFeatureType)sft, (Job)job);
        }

        public OrcConverterJob(scala.collection.immutable.Map<String, String> dsParams, SimpleFeatureType sft, Config converterConfig, Seq<String> paths, Seq<String> libjarsFiles, Iterator<Function0<Seq<File>>> libjarsPaths2, int reducers, Option<Path> tmpPath) {
            super(dsParams, sft, converterConfig, paths, libjarsFiles, libjarsPaths2, reducers, tmpPath);
            OrcStorageConfiguration.class.$init$((OrcStorageConfiguration)this);
        }
    }

    public static class ParquetConverterJob
    extends FileSystemConverterJob
    implements ParquetStorageConfiguration {
        public void configureOutput(SimpleFeatureType sft, Job job) {
            ParquetStorageConfiguration.class.configureOutput((ParquetStorageConfiguration)this, (SimpleFeatureType)sft, (Job)job);
        }

        public ParquetConverterJob(scala.collection.immutable.Map<String, String> dsParams, SimpleFeatureType sft, Config converterConfig, Seq<String> paths, Seq<String> libjarsFiles, Iterator<Function0<Seq<File>>> libjarsPaths2, int reducers, Option<Path> tmpPath) {
            super(dsParams, sft, converterConfig, paths, libjarsFiles, libjarsPaths2, reducers, tmpPath);
            ParquetStorageConfiguration.class.$init$((ParquetStorageConfiguration)this);
        }
    }
}

