/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.tools.ingest;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.converters.BaseConverter;
import java.util.ArrayList;
import java.util.List;
import org.geotools.data.DataStore;
import org.locationtech.geomesa.fs.data.FileSystemDataStore;
import org.locationtech.geomesa.fs.storage.api.StorageMetadata;
import org.locationtech.geomesa.fs.tools.FsDataStoreCommand;
import org.locationtech.geomesa.fs.tools.FsDataStoreCommand$FsParams$class;
import org.locationtech.geomesa.fs.tools.FsDataStoreCommand$class;
import org.locationtech.geomesa.tools.Command;
import org.locationtech.geomesa.tools.Command$;
import org.locationtech.geomesa.tools.CommandWithSubCommands;
import org.locationtech.geomesa.tools.DataStoreCommand;
import org.locationtech.geomesa.tools.RequiredTypeNameParam;
import org.locationtech.geomesa.tools.Runner;
import org.locationtech.jts.geom.Envelope;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple4;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t\rh\u0001B\u0001\u0003\u0001=\u0011Q#T1oC\u001e,W*\u001a;bI\u0006$\u0018mQ8n[\u0006tGM\u0003\u0002\u0004\t\u00051\u0011N\\4fgRT!!\u0002\u0004\u0002\u000bQ|w\u000e\\:\u000b\u0005\u001dA\u0011A\u00014t\u0015\tI!\"A\u0004hK>lWm]1\u000b\u0005-a\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0001b\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\t\u0003/ei\u0011\u0001\u0007\u0006\u0003\u000b!I!A\u0007\r\u0003-\r{W.\\1oI^KG\u000f[*vE\u000e{W.\\1oIND\u0001\u0002\b\u0001\u0003\u0006\u0004%\t!H\u0001\u0007eVtg.\u001a:\u0016\u0003y\u0001\"aF\u0010\n\u0005\u0001B\"A\u0002*v]:,'\u000f\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003\u001f\u0003\u001d\u0011XO\u001c8fe\u0002B\u0001\u0002\n\u0001\u0003\u0006\u0004%\t!J\u0001\u0003U\u000e,\u0012A\n\t\u0003O9j\u0011\u0001\u000b\u0006\u0003S)\n!B[2p[6\fg\u000eZ3s\u0015\tYC&A\u0003cKV\u001cHOC\u0001.\u0003\r\u0019w.\\\u0005\u0003_!\u0012!BS\"p[6\fg\u000eZ3s\u0011!\t\u0004A!A!\u0002\u00131\u0013a\u00016dA!)1\u0007\u0001C\u0001i\u00051A(\u001b8jiz\"2!N\u001c9!\t1\u0004!D\u0001\u0003\u0011\u0015a\"\u00071\u0001\u001f\u0011\u0015!#\u00071\u0001'\u0011\u001dQ\u0004A1A\u0005Bm\nAA\\1nKV\tA\b\u0005\u0002>\u0001:\u0011\u0011CP\u0005\u0003\u007fI\ta\u0001\u0015:fI\u00164\u0017BA!C\u0005\u0019\u0019FO]5oO*\u0011qH\u0005\u0005\u0007\t\u0002\u0001\u000b\u0011\u0002\u001f\u0002\u000b9\fW.\u001a\u0011\t\u000f\u0019\u0003!\u0019!C!\u000f\u00061\u0001/\u0019:b[N,\u0012\u0001\u0013\t\u0004\u0013\n5fB\u0001&Z\u001d\tY\u0005L\u0004\u0002M/:\u0011QJ\u0016\b\u0003\u001dVs!a\u0014+\u000f\u0005A\u001bV\"A)\u000b\u0005Is\u0011A\u0002\u001fs_>$h(C\u0001\u000e\u0013\tYA\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003\u000b\u0019I!a\u0001\u0003\b\u000bi\u0013\u0001\u0012A.\u0002+5\u000bg.Y4f\u001b\u0016$\u0018\rZ1uC\u000e{W.\\1oIB\u0011a\u0007\u0018\u0004\u0006\u0003\tA\t!X\n\u00039BAQa\r/\u0005\u0002}#\u0012a\u0017\u0004\u0005Cr\u0003!M\u0001\bD_6\u0004\u0018m\u0019;D_6l\u0017M\u001c3\u0014\u0007\u0001\u00042\r\u0005\u0002eK6\tA!\u0003\u0002g\t\t\u0011bi\u001d#bi\u0006\u001cFo\u001c:f\u0007>lW.\u00198e\u0011\u0015\u0019\u0004\r\"\u0001i)\u0005I\u0007C\u00016a\u001b\u0005a\u0006b\u0002\u001ea\u0005\u0004%\t\u0005\\\u000b\u0002[B\u0011an]\u0007\u0002_*\u0011\u0001/]\u0001\u0005Y\u0006twMC\u0001s\u0003\u0011Q\u0017M^1\n\u0005\u0005{\u0007B\u0002#aA\u0003%Q\u000eC\u0004GA\n\u0007I\u0011\t<\u0016\u0003]\u0004\"A\u001b=\u0007\ted\u0006A\u001f\u0002\u000e\u0007>l\u0007/Y2u!\u0006\u0014\u0018-\\:\u0014\u000ba\u000420!\u0002\u0011\u0005q|hBA&~\u0013\tqH!\u0001\nGg\u0012\u000bG/Y*u_J,7i\\7nC:$\u0017\u0002BA\u0001\u0003\u0007\u0011\u0001BR:QCJ\fWn\u001d\u0006\u0003}\u0012\u00012aFA\u0004\u0013\r\tI\u0001\u0007\u0002\u0016%\u0016\fX/\u001b:fIRK\b/\u001a(b[\u0016\u0004\u0016M]1n\u0011\u0019\u0019\u0004\u0010\"\u0001\u0002\u000eQ\tq\u000fC\u0005\u0002\u0012a\u0004\r\u0011\"\u0001\u0002\u0014\u00059A\u000f\u001b:fC\u0012\u001cXCAA\u000b!\rq\u0017qC\u0005\u0004\u00033y'aB%oi\u0016<WM\u001d\u0005\n\u0003;A\b\u0019!C\u0001\u0003?\t1\u0002\u001e5sK\u0006$7o\u0018\u0013fcR!\u0011\u0011EA\u0014!\r\t\u00121E\u0005\u0004\u0003K\u0011\"\u0001B+oSRD!\"!\u000b\u0002\u001c\u0005\u0005\t\u0019AA\u000b\u0003\rAH%\r\u0005\t\u0003[A\b\u0015)\u0003\u0002\u0016\u0005AA\u000f\u001b:fC\u0012\u001c\b\u0005\u000b\u0007\u0002,\u0005E\u0012qGA\u001d\u0003\u0007\n)\u0005E\u0002(\u0003gI1!!\u000e)\u0005%\u0001\u0016M]1nKR,'/A\u0003oC6,7\u000f\f\u0003\u0002<\u0005}\u0012EAA\u001f\u0003\tiC/\t\u0002\u0002B\u0005IQ&\f;ie\u0016\fGm]\u0001\fI\u0016\u001c8M]5qi&|g.\t\u0002\u0002H\u00059c*^7cKJ\u0004sN\u001a\u0011uQJ,\u0017\rZ:!i>\u0004So]3!M>\u0014\beY8na\u0006\u001cG/[8oQ\u001dA\u00181JA)\u0003'\u00022aJA'\u0013\r\ty\u0005\u000b\u0002\u000b!\u0006\u0014\u0018-\\3uKJ\u001c\u0018AE2p[6\fg\u000e\u001a#fg\u000e\u0014\u0018\u000e\u001d;j_:\f#!!\u0016\u0002W\r{W\u000e]1di\u0002\"\b.\u001a\u0011nKR\fG-\u0019;bA\u0019|'\u000fI1!gR|'/Y4fA%t7\u000f^1oG\u0016Dq!!\u0017aA\u0003%q/A\u0004qCJ\fWn\u001d\u0011\t\u000f\u0005u\u0003\r\"\u0011\u0002`\u00059Q\r_3dkR,GCAA\u0011\r\u0019\t\u0019\u0007\u0018\u0001\u0002f\ty!+Z4jgR,'oQ8n[\u0006tGm\u0005\u0003\u0002bA\u0019\u0007bB\u001a\u0002b\u0011\u0005\u0011\u0011\u000e\u000b\u0003\u0003W\u00022A[A1\u0011!Q\u0014\u0011\rb\u0001\n\u0003b\u0007b\u0002#\u0002b\u0001\u0006I!\u001c\u0005\n\r\u0006\u0005$\u0019!C!\u0003g*\"!!\u001e\u0011\u0007)\f9H\u0002\u0004\u0002zq\u0003\u00111\u0010\u0002\u000f%\u0016<\u0017n\u001d;feB\u000b'/Y7t'\u0019\t9\bE>\u0002\u0006!91'a\u001e\u0005\u0002\u0005}DCAA;\u0011-\t\u0019)a\u001eA\u0002\u0003\u0007I\u0011A\u001e\u0002\u0013A\f'\u000f^5uS>t\u0007\u0002DAD\u0003o\u0002\r\u00111A\u0005\u0002\u0005%\u0015!\u00049beRLG/[8o?\u0012*\u0017\u000f\u0006\u0003\u0002\"\u0005-\u0005\"CA\u0015\u0003\u000b\u000b\t\u00111\u0001=\u0011!\ty)a\u001e!B\u0013a\u0014A\u00039beRLG/[8oA!\u0002\u0012QRA\u0019\u0003o\t\u0019*a\u0011\u0002\u001a\u0006u\u0015q\u0014\u0017\u0003\u0003+\u000b#!a&\u0002\u00175j\u0003/\u0019:uSRLwN\\\u0011\u0003\u00037\u000b1\u0003U1si&$\u0018n\u001c8!i>\u0004S\u000f\u001d3bi\u0016\f\u0001B]3rk&\u0014X\rZ\r\u0002\u0003!Q\u00111UA<\u0001\u0004%\t!!*\u0002\u000b\u0019LG.Z:\u0016\u0005\u0005\u001d\u0006#BAU\u0003_cTBAAV\u0015\r\ti+]\u0001\u0005kRLG.\u0003\u0003\u00022\u0006-&\u0001\u0002'jgRD!\"!.\u0002x\u0001\u0007I\u0011AA\\\u0003%1\u0017\u000e\\3t?\u0012*\u0017\u000f\u0006\u0003\u0002\"\u0005e\u0006BCA\u0015\u0003g\u000b\t\u00111\u0001\u0002(\"I\u0011QXA<A\u0003&\u0011qU\u0001\u0007M&dWm\u001d\u0011))\u0005m\u0016\u0011GA\u001c\u0003\u0003\f\u0019%a2\u0002\u001e\u0006}\u00151ZAPY\t\t\u0019-\t\u0002\u0002F\u00069Q&\f4jY\u0016\u001c\u0018EAAe\u0003Ys\u0015-\\3tA=4\u0007\u0005\u001e5fA\u0019LG.Z:!i>\u0004#/Z4jgR,'\u000f\f\u0011nkN$\b%\u00197sK\u0006$\u0017\u0010I3ySN$\b%\u001b8!i\",\u0007%\u00199qe>\u0004(/[1uK\u0002\u0002\u0018M\u001d;ji&|g\u000e\t4pY\u0012,'/A\u0007wCJL\u0017M\u00197f\u0003JLG/\u001f\u0005\r\u0003\u001f\f9\b1AA\u0002\u0013\u0005\u0011\u0011[\u0001\u0007E>,h\u000eZ:\u0016\u0005\u0005M\u0007cC\t\u0002V\u0006e\u0017\u0011\\Am\u00033L1!a6\u0013\u0005\u0019!V\u000f\u001d7fiA\u0019\u0011#a7\n\u0007\u0005u'C\u0001\u0004E_V\u0014G.\u001a\u0005\r\u0003C\f9\b1AA\u0002\u0013\u0005\u00111]\u0001\u000bE>,h\u000eZ:`I\u0015\fH\u0003BA\u0011\u0003KD!\"!\u000b\u0002`\u0006\u0005\t\u0019AAj\u0011%\tI/a\u001e!B\u0013\t\u0019.A\u0004c_VtGm\u001d\u0011))\u0005\u001d\u0018\u0011GA\u001c\u0003[\f\u0019%a=\u0002\u001e\u0006]\u0018\u0011`A~Y\t\ty/\t\u0002\u0002r\u0006AQ&\f2pk:$7/\t\u0002\u0002v\u0006)v)Z8he\u0006\u0004\b.[2!E>,h\u000eZ:!_\u001a\u0004C\u000f[3!I\u0006$\u0018\r\t4jY\u0016\u001c\bEY3j]\u001e\u0004#/Z4jgR,'/\u001a3-A%t\u0007\u0005\u001e5fA\u0019|'/\u001c\u0011y[&tG&_7j]2BX.\u0019=-s6\f\u00070G\u0001\u0001\u0003%\u0019wN\u001c<feR,'o\t\u0002\u0002~B\u0019!.a@\u0007\r\t\u0005A\f\u0001B\u0002\u0005=\u0011u.\u001e8eg\u000e{gN^3si\u0016\u00148\u0003BA\u0000\u0005\u000b\u0001bAa\u0002\u0003\u000e\u0005MWB\u0001B\u0005\u0015\r\u0011Y\u0001K\u0001\u000bG>tg/\u001a:uKJ\u001c\u0018\u0002\u0002B\b\u0005\u0013\u0011QBQ1tK\u000e{gN^3si\u0016\u0014\b\"\u0003\u001e\u0002\u0000\n\u0005\t\u0015!\u0003=\u0011\u001d\u0019\u0014q C\u0001\u0005+!B!!@\u0003\u0018!1!Ha\u0005A\u0002qB\u0001Ba\u0007\u0002\u0000\u0012\u0005#QD\u0001\bG>tg/\u001a:u)\u0011\t\u0019Na\b\t\u000f\t\u0005\"\u0011\u0004a\u0001y\u0005)a/\u00197vK\"a!QEA<\u0001\u0004\u0005\r\u0011\"\u0001\u0003(\u0005)1m\\;oiV\u0011!\u0011\u0006\t\u0004]\n-\u0012b\u0001B\u0017_\n!Aj\u001c8h\u00111\u0011\t$a\u001eA\u0002\u0003\u0007I\u0011\u0001B\u001a\u0003%\u0019w.\u001e8u?\u0012*\u0017\u000f\u0006\u0003\u0002\"\tU\u0002BCA\u0015\u0005_\t\t\u00111\u0001\u0003*!I!\u0011HA<A\u0003&!\u0011F\u0001\u0007G>,h\u000e\u001e\u0011)!\t]\u0012\u0011GA\u001c\u0005{\t\u0019Ea\u0011\u0002\u001e\u0006]HF\u0001B C\t\u0011\t%A\u0004.[\r|WO\u001c;\"\u0005\t\u0015\u0013!\u000e(v[\n,'\u000fI8gA\u0019,\u0017\r^;sKN\u0004\u0013N\u001c\u0011uQ\u0016\u0004C-\u0019;bA\u0019LG.Z:!E\u0016Lgn\u001a\u0011sK\u001eL7\u000f^3sK\u0012D\u0003\"a\u001e\u0002L\u0005E#\u0011J\u0011\u0003\u0005\u0017\nqFU3hSN$XM\u001d\u0011oK^\u0004C-\u0019;bA\u0019LG.Z:!o&$\b\u000eI1!gR|'/Y4fA%t7\u000f^1oG\u0016D\u0011\"!\u0017\u0002b\u0001\u0006I!!\u001e\t\u0011\u0005u\u0013\u0011\rC!\u0003?2aAa\u0015]\u0001\tU#!E+oe\u0016<\u0017n\u001d;fe\u000e{W.\\1oIN!!\u0011\u000b\td\u0011\u001d\u0019$\u0011\u000bC\u0001\u00053\"\"Aa\u0017\u0011\u0007)\u0014\t\u0006\u0003\u0005;\u0005#\u0012\r\u0011\"\u0011m\u0011\u001d!%\u0011\u000bQ\u0001\n5D\u0011B\u0012B)\u0005\u0004%\tEa\u0019\u0016\u0005\t\u0015\u0004c\u00016\u0003h\u00191!\u0011\u000e/\u0001\u0005W\u0012\u0001#\u00168sK\u001eL7\u000f^3s!\u0006\u0014\u0018-\\:\u0014\r\t\u001d\u0004c_A\u0003\u0011\u001d\u0019$q\rC\u0001\u0005_\"\"A!\u001a\t\u0017\u0005\r%q\ra\u0001\u0002\u0004%\ta\u000f\u0005\r\u0003\u000f\u00139\u00071AA\u0002\u0013\u0005!Q\u000f\u000b\u0005\u0003C\u00119\bC\u0005\u0002*\tM\u0014\u0011!a\u0001y!A\u0011q\u0012B4A\u0003&A\b\u000b\t\u0003z\u0005E\u0012q\u0007B?\u0003\u0007\nI*!(\u0002 2\u0012\u0011Q\u0013\u0005\u000b\u0003G\u00139\u00071A\u0005\u0002\u0005\u0015\u0006BCA[\u0005O\u0002\r\u0011\"\u0001\u0003\u0004R!\u0011\u0011\u0005BC\u0011)\tIC!!\u0002\u0002\u0003\u0007\u0011q\u0015\u0005\n\u0003{\u00139\u0007)Q\u0005\u0003OCCCa\"\u00022\u0005]\"1RA\"\u0005\u001b\u000bi*a(\u0002L\u0006}EFAAbC\t\u0011y)\u0001-OC6,7\u000fI8gAQDW\r\t4jY\u0016\u001c\b\u0005^8!k:\u0014XmZ5ti\u0016\u0014H\u0006I7vgR\u0004\u0013\r\u001c:fC\u0012L\b%\u001a=jgR\u0004\u0013N\u001c\u0011uQ\u0016\u0004\u0013\r\u001d9s_B\u0014\u0018.\u0019;fAA\f'\u000f^5uS>t\u0007EZ8mI\u0016\u0014\b\u0002\u0004B\u0013\u0005O\u0002\r\u00111A\u0005\u0002\t\u001d\u0002\u0002\u0004B\u0019\u0005O\u0002\r\u00111A\u0005\u0002\tUE\u0003BA\u0011\u0005/C!\"!\u000b\u0003\u0014\u0006\u0005\t\u0019\u0001B\u0015\u0011%\u0011IDa\u001a!B\u0013\u0011I\u0003\u000b\t\u0003\u001a\u0006E\u0012q\u0007BO\u0003\u0007\u0012y*!(\u0002x2\u0012!qH\u0011\u0003\u0005C\u000bqGT;nE\u0016\u0014\be\u001c4!M\u0016\fG/\u001e:fg\u0002Jg\u000e\t;iK\u0002\"\u0017\r^1!M&dWm\u001d\u0011cK&tw\rI;oe\u0016<\u0017n\u001d;fe\u0016$\u0007\u0006\u0003B4\u0003\u0017\n\tF!*\"\u0005\t\u001d\u0016!L+oe\u0016<\u0017n\u001d;fe\u0002\"\u0017\r^1!M&dWm\u001d\u0011ge>l\u0007%\u0019\u0011ti>\u0014\u0018mZ3!S:\u001cH/\u00198dK\"I\u0011\u0011\fB)A\u0003%!Q\r\u0005\t\u0003;\u0012\t\u0006\"\u0011\u0002`\u00191!q\u0016/\u0001\u0005c\u0013A#T1oC\u001e,W*\u001a;bI\u0006$\u0018\rU1sC6\u001c8c\u0001BW!!91G!,\u0005\u0002\tUFC\u0001B\\!\rQ'Q\u0016\u0015\t\u0005[\u000bY%!\u0015\u0003<\u0006\u0012!QX\u0001+\u001b\u0006t\u0017mZ3!i\",\u0007%\\3uC\u0012\fG/\u0019\u0011g_J\u0004\u0013\rI:u_J\fw-\u001a\u0011j]N$\u0018M\\2f\u0011\u001d\tI\u0006\u0001Q\u0001\n!C\u0011Ba1\u0001\u0005\u0004%\tE!2\u0002\u0017M,(mQ8n[\u0006tGm]\u000b\u0003\u0005\u000f\u0004bA!3\u0003T\neg\u0002\u0002Bf\u0005\u001ft1\u0001\u0015Bg\u0013\u0005\u0019\u0012b\u0001Bi%\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002Bk\u0005/\u00141aU3r\u0015\r\u0011\tN\u0005\t\u0004/\tm\u0017b\u0001Bo1\t91i\\7nC:$\u0007\u0002\u0003Bq\u0001\u0001\u0006IAa2\u0002\u0019M,(mQ8n[\u0006tGm\u001d\u0011")
public class ManageMetadataCommand
implements CommandWithSubCommands {
    private final Runner runner;
    private final JCommander jc;
    private final String name;
    private final ManageMetadataParams params;
    private final Seq<Command> subCommands;

    public void execute() {
        CommandWithSubCommands.class.execute((CommandWithSubCommands)this);
    }

    public Runner runner() {
        return this.runner;
    }

    public JCommander jc() {
        return this.jc;
    }

    public String name() {
        return this.name;
    }

    public ManageMetadataParams params() {
        return this.params;
    }

    public Seq<Command> subCommands() {
        return this.subCommands;
    }

    public ManageMetadataCommand(Runner runner, JCommander jc) {
        this.runner = runner;
        this.jc = jc;
        CommandWithSubCommands.class.$init$((CommandWithSubCommands)this);
        this.name = "manage-metadata";
        this.params = new ManageMetadataParams();
        this.subCommands = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FsDataStoreCommand[]{new CompactCommand(), new RegisterCommand(), new UnregisterCommand()}));
    }

    @Parameters(commandDescription="Compact the metadata for a storage instance")
    public static class CompactParams
    implements FsDataStoreCommand.FsParams,
    RequiredTypeNameParam {
        @Parameter(names={"-t", "--threads"}, description="Number of threads to use for compaction")
        private Integer threads;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate", required=true)
        private String featureName;
        @Parameter(names={"--path", "-p"}, description="Path to root of filesystem datastore", required=true)
        private String path;
        @Parameter(names={"--config"}, description="Configuration properties, in the form k=v", variableArity=true)
        private List<String> configuration;

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        @Override
        public String path() {
            return this.path;
        }

        @Override
        @TraitSetter
        public void path_$eq(String x$1) {
            this.path = x$1;
        }

        @Override
        public List<String> configuration() {
            return this.configuration;
        }

        @Override
        @TraitSetter
        public void configuration_$eq(List<String> x$1) {
            this.configuration = x$1;
        }

        public Integer threads() {
            return this.threads;
        }

        public void threads_$eq(Integer x$1) {
            this.threads = x$1;
        }

        public CompactParams() {
            FsDataStoreCommand$FsParams$class.$init$(this);
            RequiredTypeNameParam.class.$init$((RequiredTypeNameParam)this);
            this.threads = Predef$.MODULE$.int2Integer(4);
        }
    }

    public static class CompactCommand
    implements FsDataStoreCommand {
        private final String name;
        private final CompactParams params;

        @Override
        public Map<String, String> connection() {
            return FsDataStoreCommand$class.connection(this);
        }

        public <T> T withDataStore(Function1<FileSystemDataStore, T> method) throws ParameterException {
            return (T)DataStoreCommand.class.withDataStore((DataStoreCommand)this, method);
        }

        public DataStore loadDataStore() throws ParameterException {
            return DataStoreCommand.class.loadDataStore((DataStoreCommand)this);
        }

        public String name() {
            return this.name;
        }

        @Override
        public CompactParams params() {
            return this.params;
        }

        public void execute() {
            this.withDataStore((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CompactCommand $outer;

                public final void apply(FileSystemDataStore ds) {
                    StorageMetadata metadata = ds.storage(this.$outer.params().featureName()).metadata();
                    metadata.compact((Option)None$.MODULE$, Predef$.MODULE$.Integer2int(this.$outer.params().threads()));
                    Seq partitions = metadata.getPartitions(metadata.getPartitions$default$1());
                    Command$.MODULE$.user().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compacted metadata into ", " partitions consisting of "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partitions.length())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " files"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)partitions.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(StorageMetadata.PartitionMetadata x$1) {
                            return x$1.files().size();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)}))).toString());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }

        public CompactCommand() {
            DataStoreCommand.class.$init$((DataStoreCommand)this);
            FsDataStoreCommand$class.$init$(this);
            this.name = "compact";
            this.params = new CompactParams();
        }
    }

    @Parameters(commandDescription="Register new data files with a storage instance")
    public static class RegisterParams
    implements FsDataStoreCommand.FsParams,
    RequiredTypeNameParam {
        @Parameter(names={"--partition"}, description="Partition to update", required=true)
        private String partition;
        @Parameter(names={"--files"}, description="Names of the files to register, must already exist in the appropriate partition folder", required=true, variableArity=true)
        private List<String> files;
        @Parameter(names={"--bounds"}, description="Geographic bounds of the data files being registered, in the form xmin,ymin,xmax,ymax", required=false, converter=BoundsConverter.class)
        private Tuple4<Object, Object, Object, Object> bounds;
        @Parameter(names={"--count"}, description="Number of features in the data files being registered", required=false)
        private Long count;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate", required=true)
        private String featureName;
        @Parameter(names={"--path", "-p"}, description="Path to root of filesystem datastore", required=true)
        private String path;
        @Parameter(names={"--config"}, description="Configuration properties, in the form k=v", variableArity=true)
        private List<String> configuration;

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        @Override
        public String path() {
            return this.path;
        }

        @Override
        @TraitSetter
        public void path_$eq(String x$1) {
            this.path = x$1;
        }

        @Override
        public List<String> configuration() {
            return this.configuration;
        }

        @Override
        @TraitSetter
        public void configuration_$eq(List<String> x$1) {
            this.configuration = x$1;
        }

        public String partition() {
            return this.partition;
        }

        public void partition_$eq(String x$1) {
            this.partition = x$1;
        }

        public List<String> files() {
            return this.files;
        }

        public void files_$eq(List<String> x$1) {
            this.files = x$1;
        }

        public Tuple4<Object, Object, Object, Object> bounds() {
            return this.bounds;
        }

        public void bounds_$eq(Tuple4<Object, Object, Object, Object> x$1) {
            this.bounds = x$1;
        }

        public Long count() {
            return this.count;
        }

        public void count_$eq(Long x$1) {
            this.count = x$1;
        }

        public RegisterParams() {
            FsDataStoreCommand$FsParams$class.$init$(this);
            RequiredTypeNameParam.class.$init$((RequiredTypeNameParam)this);
            this.files = new ArrayList<String>();
        }
    }

    public static class RegisterCommand
    implements FsDataStoreCommand {
        private final String name;
        private final RegisterParams params;

        @Override
        public Map<String, String> connection() {
            return FsDataStoreCommand$class.connection(this);
        }

        public <T> T withDataStore(Function1<FileSystemDataStore, T> method) throws ParameterException {
            return (T)DataStoreCommand.class.withDataStore((DataStoreCommand)this, method);
        }

        public DataStore loadDataStore() throws ParameterException {
            return DataStoreCommand.class.loadDataStore((DataStoreCommand)this);
        }

        public String name() {
            return this.name;
        }

        @Override
        public RegisterParams params() {
            return this.params;
        }

        public void execute() {
            this.withDataStore((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ RegisterCommand $outer;

                public final void apply(FileSystemDataStore ds) {
                    StorageMetadata metadata = ds.storage(this.$outer.params().featureName()).metadata();
                    Buffer files = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.$outer.params().files()).asScala()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final StorageMetadata.StorageFile apply(String x$2) {
                            return new StorageMetadata.StorageFile(x$2, System.currentTimeMillis(), StorageMetadata.StorageFile$.MODULE$.apply$default$3());
                        }
                    }, Buffer$.MODULE$.canBuildFrom());
                    long count = BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)this.$outer.params().count()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(Long x$3) {
                            return x$3;
                        }
                    }).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply() {
                            return this.apply$mcJ$sp();
                        }

                        public long apply$mcJ$sp() {
                            return 0L;
                        }
                    }));
                    Envelope bounds = new Envelope();
                    Option$.MODULE$.apply(this.$outer.params().bounds()).foreach((Function1)new Serializable(this, bounds){
                        public static final long serialVersionUID = 0L;
                        private final Envelope bounds$1;

                        public final void apply(Tuple4<Object, Object, Object, Object> x0$1) {
                            Tuple4<Object, Object, Object, Object> tuple4 = x0$1;
                            if (tuple4 != null) {
                                double xmin = BoxesRunTime.unboxToDouble((Object)tuple4._1());
                                double ymin = BoxesRunTime.unboxToDouble((Object)tuple4._2());
                                double xmax = BoxesRunTime.unboxToDouble((Object)tuple4._3());
                                double ymax = BoxesRunTime.unboxToDouble((Object)tuple4._4());
                                this.bounds$1.expandToInclude(xmin, ymin);
                                this.bounds$1.expandToInclude(xmax, ymax);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError(tuple4);
                        }
                        {
                            this.bounds$1 = bounds$1;
                        }
                    });
                    metadata.addPartition(new StorageMetadata.PartitionMetadata(this.$outer.params().partition(), (Seq)files, StorageMetadata.PartitionBounds$.MODULE$.apply(bounds), count));
                    StorageMetadata.PartitionMetadata partition = (StorageMetadata.PartitionMetadata)metadata.getPartition(this.$outer.params().partition()).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final StorageMetadata.PartitionMetadata apply() {
                            return new StorageMetadata.PartitionMetadata("", (Seq)Seq$.MODULE$.empty(), (Option)None$.MODULE$, 0L);
                        }
                    });
                    Command$.MODULE$.user().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Registered ", " new files. Updated partition: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.params().files().size()), BoxesRunTime.boxToInteger((int)partition.files().size())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"files containing ", " known features"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)partition.count())}))).toString());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }

        public RegisterCommand() {
            DataStoreCommand.class.$init$((DataStoreCommand)this);
            FsDataStoreCommand$class.$init$(this);
            this.name = "register";
            this.params = new RegisterParams();
        }
    }

    public static class BoundsConverter
    extends BaseConverter<Tuple4<Object, Object, Object, Object>> {
        public Tuple4<Object, Object, Object, Object> convert(String value) {
            try {
                double[] dArray = (double[])Predef$.MODULE$.refArrayOps((Object[])value.split(",")).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(String x$6) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$6.trim())).toDouble();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                Option option = Array$.MODULE$.unapplySeq((Object)dArray);
                if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(4) == 0) {
                    Tuple4 tuple4;
                    double xmin = BoxesRunTime.unboxToDouble((Object)((SeqLike)option.get()).apply(0));
                    double ymin = BoxesRunTime.unboxToDouble((Object)((SeqLike)option.get()).apply(1));
                    double xmax = BoxesRunTime.unboxToDouble((Object)((SeqLike)option.get()).apply(2));
                    double ymax = BoxesRunTime.unboxToDouble((Object)((SeqLike)option.get()).apply(3));
                    Tuple4 tuple42 = tuple4 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)xmin), (Object)BoxesRunTime.boxToDouble((double)ymin), (Object)BoxesRunTime.boxToDouble((double)xmax), (Object)BoxesRunTime.boxToDouble((double)ymax));
                    double xmin2 = BoxesRunTime.unboxToDouble((Object)tuple42._1());
                    double ymin2 = BoxesRunTime.unboxToDouble((Object)tuple42._2());
                    double xmax2 = BoxesRunTime.unboxToDouble((Object)tuple42._3());
                    double ymax2 = BoxesRunTime.unboxToDouble((Object)tuple42._4());
                    return new Tuple4((Object)BoxesRunTime.boxToDouble((double)xmin2), (Object)BoxesRunTime.boxToDouble((double)ymin2), (Object)BoxesRunTime.boxToDouble((double)xmax2), (Object)BoxesRunTime.boxToDouble((double)ymax2));
                }
                throw new MatchError((Object)dArray);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                throw new ParameterException(this.getErrorString(value, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"format: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e}))));
            }
        }

        public BoundsConverter(String name) {
            super(name);
        }
    }

    @Parameters(commandDescription="Unregister data files from a storage instance")
    public static class UnregisterParams
    implements FsDataStoreCommand.FsParams,
    RequiredTypeNameParam {
        @Parameter(names={"--partition"}, description="Partition to update", required=true)
        private String partition;
        @Parameter(names={"--files"}, description="Names of the files to unregister, must already exist in the appropriate partition folder", required=true, variableArity=true)
        private List<String> files;
        @Parameter(names={"--count"}, description="Number of features in the data files being unregistered", required=false)
        private Long count;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate", required=true)
        private String featureName;
        @Parameter(names={"--path", "-p"}, description="Path to root of filesystem datastore", required=true)
        private String path;
        @Parameter(names={"--config"}, description="Configuration properties, in the form k=v", variableArity=true)
        private List<String> configuration;

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        @Override
        public String path() {
            return this.path;
        }

        @Override
        @TraitSetter
        public void path_$eq(String x$1) {
            this.path = x$1;
        }

        @Override
        public List<String> configuration() {
            return this.configuration;
        }

        @Override
        @TraitSetter
        public void configuration_$eq(List<String> x$1) {
            this.configuration = x$1;
        }

        public String partition() {
            return this.partition;
        }

        public void partition_$eq(String x$1) {
            this.partition = x$1;
        }

        public List<String> files() {
            return this.files;
        }

        public void files_$eq(List<String> x$1) {
            this.files = x$1;
        }

        public Long count() {
            return this.count;
        }

        public void count_$eq(Long x$1) {
            this.count = x$1;
        }

        public UnregisterParams() {
            FsDataStoreCommand$FsParams$class.$init$(this);
            RequiredTypeNameParam.class.$init$((RequiredTypeNameParam)this);
            this.files = new ArrayList<String>();
        }
    }

    public static class UnregisterCommand
    implements FsDataStoreCommand {
        private final String name;
        private final UnregisterParams params;

        @Override
        public Map<String, String> connection() {
            return FsDataStoreCommand$class.connection(this);
        }

        public <T> T withDataStore(Function1<FileSystemDataStore, T> method) throws ParameterException {
            return (T)DataStoreCommand.class.withDataStore((DataStoreCommand)this, method);
        }

        public DataStore loadDataStore() throws ParameterException {
            return DataStoreCommand.class.loadDataStore((DataStoreCommand)this);
        }

        public String name() {
            return this.name;
        }

        @Override
        public UnregisterParams params() {
            return this.params;
        }

        public void execute() {
            this.withDataStore((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ UnregisterCommand $outer;

                public final void apply(FileSystemDataStore ds) {
                    StorageMetadata metadata = ds.storage(this.$outer.params().featureName()).metadata();
                    Buffer files = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.$outer.params().files()).asScala()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final StorageMetadata.StorageFile apply(String x$4) {
                            return new StorageMetadata.StorageFile(x$4, 0L, StorageMetadata.StorageFile$.MODULE$.apply$default$3());
                        }
                    }, Buffer$.MODULE$.canBuildFrom());
                    long count = BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)this.$outer.params().count()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(Long x$5) {
                            return x$5;
                        }
                    }).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply() {
                            return this.apply$mcJ$sp();
                        }

                        public long apply$mcJ$sp() {
                            return 0L;
                        }
                    }));
                    metadata.removePartition(new StorageMetadata.PartitionMetadata(this.$outer.params().partition(), (Seq)files, (Option)None$.MODULE$, count));
                    StorageMetadata.PartitionMetadata partition = (StorageMetadata.PartitionMetadata)metadata.getPartition(this.$outer.params().partition()).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final StorageMetadata.PartitionMetadata apply() {
                            return new StorageMetadata.PartitionMetadata("", (Seq)Seq$.MODULE$.empty(), (Option)None$.MODULE$, 0L);
                        }
                    });
                    Command$.MODULE$.user().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unregistered ", " files. Updated partition: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.params().files().size()), BoxesRunTime.boxToInteger((int)partition.files().size())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"files containing ", " known features"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)partition.count())}))).toString());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }

        public UnregisterCommand() {
            DataStoreCommand.class.$init$((DataStoreCommand)this);
            FsDataStoreCommand$class.$init$(this);
            this.name = "unregister";
            this.params = new UnregisterParams();
        }
    }

    @Parameters(commandDescription="Manage the metadata for a storage instance")
    public static class ManageMetadataParams {
    }
}

