/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.tools.ingest;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.tools.DistCp;
import org.apache.hadoop.tools.DistCpOptions;
import org.locationtech.geomesa.tools.Command$;
import org.locationtech.geomesa.tools.utils.StatusCallback;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;

public final class StorageJobUtils$
implements LazyLogging {
    public static final StorageJobUtils$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new StorageJobUtils$();
    }

    private Logger logger$lzycompute() {
        StorageJobUtils$ storageJobUtils$ = this;
        synchronized (storageJobUtils$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    /*
     * WARNING - void declaration
     */
    public boolean distCopy(Path srcRoot, Path destRoot, StatusCallback statusCallback) {
        statusCallback.reset();
        Command$.MODULE$.user().info("Submitting DistCp job - please wait...");
        DistCpOptions opts = this.distCpOptions(srcRoot, destRoot);
        Job job = new DistCp(new Configuration(), opts).execute();
        Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Tracking available at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{job.getStatus().getTrackingUrl()})));
        while (true) {
            void var5_5;
            if (job.isComplete()) {
                statusCallback.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DistCp: "})).s((Seq)Nil$.MODULE$), job.mapProgress(), (Seq)Seq$.MODULE$.empty(), true);
                boolean success = job.isSuccessful();
                if (success) {
                    Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Successfully copied data to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{destRoot})));
                } else {
                    Command$.MODULE$.user().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to copy data to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{destRoot})));
                }
                return success;
            }
            JobStatus.State state = var5_5.getStatus().getState();
            JobStatus.State state2 = JobStatus.State.PREP;
            if (state == null ? state2 != null : !state.equals(state2)) {
                statusCallback.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DistCp: "})).s((Seq)Nil$.MODULE$), var5_5.mapProgress(), (Seq)Seq$.MODULE$.empty(), false);
            }
            Thread.sleep(1000L);
        }
    }

    private DistCpOptions distCpOptions(Path src, Path dest) {
        DistCpOptions distCpOptions;
        try {
            distCpOptions = this.distCpOptions3(src, dest);
        }
        catch (ClassNotFoundException classNotFoundException) {
            distCpOptions = this.distCpOptions2(src, dest);
        }
        return distCpOptions;
    }

    private DistCpOptions distCpOptions3(Path src, Path dest) {
        Class<?> clas = Class.forName("org.apache.hadoop.tools.DistCpOptions.Builder");
        Constructor<?> constructor = clas.getConstructor(List.class, Path.class);
        Object builder = constructor.newInstance(Collections.singletonList(src), dest);
        clas.getMethod("withAppend", Boolean.TYPE).invoke(builder, Boolean.FALSE);
        clas.getMethod("withOverwrite", Boolean.TYPE).invoke(builder, Boolean.TRUE);
        clas.getMethod("withCopyStrategy", String.class).invoke(builder, "dynamic");
        return (DistCpOptions)clas.getMethod("build", new Class[0]).invoke(builder, new Object[0]);
    }

    private DistCpOptions distCpOptions2(Path src, Path dest) {
        Constructor constructor = DistCpOptions.class.getConstructor(List.class, Path.class);
        DistCpOptions opts = (DistCpOptions)constructor.newInstance(Collections.singletonList(src), dest);
        DistCpOptions.class.getMethod("setAppend", Boolean.TYPE).invoke((Object)opts, Boolean.FALSE);
        DistCpOptions.class.getMethod("setOverwrite", Boolean.TYPE).invoke((Object)opts, Boolean.TRUE);
        DistCpOptions.class.getMethod("setCopyStrategy", String.class).invoke((Object)opts, "dynamic");
        return opts;
    }

    private StorageJobUtils$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

