/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.tools.compact;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.fs.storage.api.FileSystemStorage;
import org.locationtech.geomesa.fs.storage.api.StorageMetadata;
import org.locationtech.geomesa.fs.storage.common.jobs.StorageConfiguration;
import org.locationtech.geomesa.fs.storage.orc.jobs.OrcStorageConfiguration;
import org.locationtech.geomesa.fs.tools.compact.FileSystemCompactionJob$class;
import org.locationtech.geomesa.jobs.mapreduce.GeoMesaOutputFormat;
import org.locationtech.geomesa.jobs.mapreduce.JobWithLibJars;
import org.locationtech.geomesa.parquet.jobs.ParquetStorageConfiguration;
import org.locationtech.geomesa.tools.utils.StatusCallback;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Option;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\tmaaB\u0001\u0003!\u0003\r\ta\u0004\u0002\u0018\r&dWmU=ti\u0016l7i\\7qC\u000e$\u0018n\u001c8K_\nT!a\u0001\u0003\u0002\u000f\r|W\u000e]1di*\u0011QAB\u0001\u0006i>|Gn\u001d\u0006\u0003\u000f!\t!AZ:\u000b\u0005%Q\u0011aB4f_6,7/\u0019\u0006\u0003\u00171\tA\u0002\\8dCRLwN\u001c;fG\"T\u0011!D\u0001\u0004_J<7\u0001A\n\u0005\u0001A1\u0002\u0005\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\t\u0003/yi\u0011\u0001\u0007\u0006\u00033i\tAA[8cg*\u00111\u0004H\u0001\u0007G>lWn\u001c8\u000b\u0005u1\u0011aB:u_J\fw-Z\u0005\u0003?a\u0011Ac\u0015;pe\u0006<WmQ8oM&<WO]1uS>t\u0007CA\u0011&\u001b\u0005\u0011#BA\u0012%\u0003%i\u0017\r\u001d:fIV\u001cWM\u0003\u0002\u001a\u0011%\u0011aE\t\u0002\u000f\u0015>\u0014w+\u001b;i\u0019&\u0014'*\u0019:t\u0011\u0015A\u0003\u0001\"\u0001*\u0003\u0019!\u0013N\\5uIQ\t!\u0006\u0005\u0002\u0012W%\u0011AF\u0005\u0002\u0005+:LG\u000fC\u0003/\u0001\u0011\u0005q&A\u0002sk:$\u0002\u0002\r\u001c>=24\u0018q\u0002\t\u0005#E\u001a4'\u0003\u00023%\t1A+\u001e9mKJ\u0002\"!\u0005\u001b\n\u0005U\u0012\"\u0001\u0002'p]\u001eDQ!H\u0017A\u0002]\u0002\"\u0001O\u001e\u000e\u0003eR!A\u000f\u000f\u0002\u0007\u0005\u0004\u0018.\u0003\u0002=s\t\tb)\u001b7f'f\u001cH/Z7Ti>\u0014\u0018mZ3\t\u000byj\u0003\u0019A \u0002\u0015A\f'\u000f^5uS>t7\u000fE\u0002A\u0011.s!!\u0011$\u000f\u0005\t+U\"A\"\u000b\u0005\u0011s\u0011A\u0002\u001fs_>$h(C\u0001\u0014\u0013\t9%#A\u0004qC\u000e\\\u0017mZ3\n\u0005%S%aA*fc*\u0011qI\u0005\t\u0003\u0019ns!!T-\u000f\u00059CfBA(X\u001d\t\u0001fK\u0004\u0002R+:\u0011!\u000b\u0016\b\u0003\u0005NK\u0011!D\u0005\u0003\u00171I!!\u0003\u0006\n\u0005\u001dA\u0011BA\u000f\u0007\u0013\tQD$\u0003\u0002[s\u0005y1\u000b^8sC\u001e,W*\u001a;bI\u0006$\u0018-\u0003\u0002];\n\t\u0002+\u0019:uSRLwN\\'fi\u0006$\u0017\r^1\u000b\u0005iK\u0004\"B0.\u0001\u0004\u0001\u0017\u0001\u0003;f[B\u0004\u0016\r\u001e5\u0011\u0007E\t7-\u0003\u0002c%\t1q\n\u001d;j_:\u0004\"\u0001\u001a6\u000e\u0003\u0015T!a\u00024\u000b\u0005\u001dD\u0017A\u00025bI>|\u0007O\u0003\u0002j\u0019\u00051\u0011\r]1dQ\u0016L!a[3\u0003\tA\u000bG\u000f\u001b\u0005\u0006[6\u0002\rA\\\u0001\rY&\u0014'.\u0019:t\r&dWm\u001d\t\u0004\u0001\"{\u0007C\u00019t\u001d\t\t\u0012/\u0003\u0002s%\u00051\u0001K]3eK\u001aL!\u0001^;\u0003\rM#(/\u001b8h\u0015\t\u0011(\u0003C\u0003x[\u0001\u0007\u00010\u0001\u0007mS\nT\u0017M]:QCRD7\u000fE\u0002AsnL!A\u001f&\u0003\u0011%#XM]1u_J\u00042!\u0005?\u007f\u0013\ti(CA\u0005Gk:\u001cG/[8oaA\u0019\u0001\tS@\u0011\t\u0005\u0005\u00111B\u0007\u0003\u0003\u0007QA!!\u0002\u0002\b\u0005\u0011\u0011n\u001c\u0006\u0003\u0003\u0013\tAA[1wC&!\u0011QBA\u0002\u0005\u00111\u0015\u000e\\3\t\u000f\u0005EQ\u00061\u0001\u0002\u0014\u0005q1\u000f^1ukN\u001c\u0015\r\u001c7cC\u000e\\\u0007\u0003BA\u000b\u0003;i!!a\u0006\u000b\t\u0005e\u00111D\u0001\u0006kRLGn\u001d\u0006\u0003\u000b!IA!a\b\u0002\u0018\tq1\u000b^1ukN\u001c\u0015\r\u001c7cC\u000e\\\u0007bBA\u0012\u0001\u0011%\u0011QE\u0001\boJLG\u000f^3o)\r\u0019\u0014q\u0005\u0005\t\u0003S\t\t\u00031\u0001\u0002,\u0005\u0019!n\u001c2\u0011\t\u00055\u0012\u0011G\u0007\u0003\u0003_Q!a\t4\n\t\u0005M\u0012q\u0006\u0002\u0004\u0015>\u0014\u0007bBA\u001c\u0001\u0011%\u0011\u0011H\u0001\u0007M\u0006LG.\u001a3\u0015\u0007M\nY\u0004\u0003\u0005\u0002*\u0005U\u0002\u0019AA\u0016\u000f\u001d\tyD\u0001E\u0001\u0003\u0003\nqCR5mKNK8\u000f^3n\u0007>l\u0007/Y2uS>t'j\u001c2\u0011\t\u0005\r\u0013QI\u0007\u0002\u0005\u00191\u0011A\u0001E\u0001\u0003\u000f\u001a2!!\u0012\u0011\u0011!\tY%!\u0012\u0005\u0002\u00055\u0013A\u0002\u001fj]&$h\b\u0006\u0002\u0002B\u00199\u0011\u0011KA#\u0001\u0005M#\u0001\u0006)beF,X\r^\"p[B\f7\r^5p]*{'mE\u0004\u0002PA\t)&a\u0016\u0011\u0007\u0005\r\u0003\u0001\u0005\u0003\u0002Z\u0005\u0005TBAA.\u0015\rI\u0012Q\f\u0006\u0004\u0003?B\u0011a\u00029beF,X\r^\u0005\u0005\u0003G\nYFA\u000eQCJ\fX/\u001a;Ti>\u0014\u0018mZ3D_:4\u0017nZ;sCRLwN\u001c\u0005\t\u0003\u0017\ny\u0005\"\u0001\u0002hQ\u0011\u0011\u0011\u000e\t\u0005\u0003W\ny%\u0004\u0002\u0002F\u00199\u0011qNA#\u0001\u0005E$\u0001E(sG\u000e{W\u000e]1di&|gNS8c'\u001d\ti\u0007EA+\u0003g\u0002B!!\u001e\u0002~5\u0011\u0011q\u000f\u0006\u00043\u0005e$bAA>9\u0005\u0019qN]2\n\t\u0005}\u0014q\u000f\u0002\u0018\u001fJ\u001c7\u000b^8sC\u001e,7i\u001c8gS\u001e,(/\u0019;j_:D\u0001\"a\u0013\u0002n\u0011\u0005\u00111\u0011\u000b\u0003\u0003\u000b\u0003B!a\u001b\u0002n\u00199\u0011\u0011RA#\u0001\u0005-%\u0001E\"p[B\f7\r^5p]6\u000b\u0007\u000f]3s'\u0019\t9)!$\u00024Ba\u0011QFAH\u0003'\u000by*a%\u0002 &!\u0011\u0011SA\u0018\u0005\u0019i\u0015\r\u001d9feB!\u0011QSAN\u001b\t\t9J\u0003\u0003\u0002\u001a\u0006\u001d\u0011\u0001\u00027b]\u001eLA!!(\u0002\u0018\n!ak\\5e!\u0011\t\t+a,\u000e\u0005\u0005\r&\u0002BAS\u0003O\u000baa]5na2,'\u0002BAU\u0003W\u000bqAZ3biV\u0014XMC\u0002\u0002.2\tqa\u001c9f]\u001eL7/\u0003\u0003\u00022\u0006\r&!D*j[BdWMR3biV\u0014X\r\u0005\u0003\u00026\u0006\rWBAA\\\u0015\u0011\tI,a/\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\t\u0005u\u0016qX\u0001\tif\u0004Xm]1gK*\u0011\u0011\u0011Y\u0001\u0004G>l\u0017\u0002BAc\u0003o\u00131\u0002T1{s2{wmZ5oO\"A\u00111JAD\t\u0003\tI\r\u0006\u0002\u0002LB!\u00111NAD\u000b\u001d\ty-a\"\u0001\u0003#\u0014qaQ8oi\u0016DH\u000f\u0005\u0003\u0002\u000e\u0006M\u0017\u0002BAh\u0003\u001fCA\"a\t\u0002\b\u0002\u0007\t\u0019!C\u0005\u0003/,\"!!7\u0011\t\u00055\u00121\\\u0005\u0005\u0003;\fyCA\u0004D_VtG/\u001a:\t\u0019\u0005\u0005\u0018q\u0011a\u0001\u0002\u0004%I!a9\u0002\u0017]\u0014\u0018\u000e\u001e;f]~#S-\u001d\u000b\u0004U\u0005\u0015\bBCAt\u0003?\f\t\u00111\u0001\u0002Z\u0006\u0019\u0001\u0010J\u0019\t\u0013\u0005-\u0018q\u0011Q!\n\u0005e\u0017\u0001C<sSR$XM\u001c\u0011\t\u0019\u0005=\u0018q\u0011a\u0001\u0002\u0004%I!a6\u0002\r5\f\u0007\u000f]3e\u00111\t\u00190a\"A\u0002\u0003\u0007I\u0011BA{\u0003)i\u0017\r\u001d9fI~#S-\u001d\u000b\u0004U\u0005]\bBCAt\u0003c\f\t\u00111\u0001\u0002Z\"I\u00111`ADA\u0003&\u0011\u0011\\\u0001\b[\u0006\u0004\b/\u001a3!\u0011!\ty0a\"\u0005B\t\u0005\u0011!B:fiV\u0004Hc\u0001\u0016\u0003\u0004!A!QAA\u007f\u0001\u0004\u00119!A\u0004d_:$X\r\u001f;\u0011\t\t%\u0011QZ\u0007\u0003\u0003\u000fC\u0001B!\u0004\u0002\b\u0012\u0005#qB\u0001\u0004[\u0006\u0004Hc\u0002\u0016\u0003\u0012\tU!\u0011\u0004\u0005\t\u0005'\u0011Y\u00011\u0001\u0002\u0014\u0006\u00191.Z=\t\u0011\t]!1\u0002a\u0001\u0003?\u000b!a\u001d4\t\u0011\t\u0015!1\u0002a\u0001\u0005\u000f\u0001")
public interface FileSystemCompactionJob
extends StorageConfiguration,
JobWithLibJars {
    public Tuple2<Object, Object> run(FileSystemStorage var1, Seq<StorageMetadata.PartitionMetadata> var2, Option<Path> var3, Seq<String> var4, Iterator<Function0<Seq<File>>> var5, StatusCallback var6);

    public static class OrcCompactionJob
    implements FileSystemCompactionJob,
    OrcStorageConfiguration {
        public void configureOutput(SimpleFeatureType sft, Job job) {
            OrcStorageConfiguration.class.configureOutput((OrcStorageConfiguration)this, (SimpleFeatureType)sft, (Job)job);
        }

        @Override
        public Tuple2<Object, Object> run(FileSystemStorage storage, Seq<StorageMetadata.PartitionMetadata> partitions, Option<Path> tempPath, Seq<String> libjarsFiles, Iterator<Function0<Seq<File>>> libjarsPaths2, StatusCallback statusCallback) {
            return FileSystemCompactionJob$class.run(this, storage, partitions, tempPath, libjarsFiles, libjarsPaths2, statusCallback);
        }

        public void setLibJars(Job job, Seq<String> fileNames, Iterator<Function0<Seq<File>>> searchPath) {
            JobWithLibJars.class.setLibJars((JobWithLibJars)this, (Job)job, fileNames, searchPath);
        }

        public OrcCompactionJob() {
            JobWithLibJars.class.$init$((JobWithLibJars)this);
            FileSystemCompactionJob$class.$init$(this);
            OrcStorageConfiguration.class.$init$((OrcStorageConfiguration)this);
        }
    }

    public static class CompactionMapper
    extends Mapper<Void, SimpleFeature, Void, SimpleFeature>
    implements LazyLogging {
        private Counter written;
        private Counter mapped;
        private final Logger logger;
        private volatile boolean bitmap$0;

        private Logger logger$lzycompute() {
            CompactionMapper compactionMapper = this;
            synchronized (compactionMapper) {
                if (!this.bitmap$0) {
                    this.logger = LazyLogging.class.logger((LazyLogging)this);
                    this.bitmap$0 = true;
                }
                return this.logger;
            }
        }

        public Logger logger() {
            return this.bitmap$0 ? this.logger : this.logger$lzycompute();
        }

        private Counter written() {
            return this.written;
        }

        private void written_$eq(Counter x$1) {
            this.written = x$1;
        }

        private Counter mapped() {
            return this.mapped;
        }

        private void mapped_$eq(Counter x$1) {
            this.mapped = x$1;
        }

        public void setup(Mapper.Context context) {
            super.setup(context);
            this.written_$eq(context.getCounter(GeoMesaOutputFormat.Counters$.MODULE$.Group(), GeoMesaOutputFormat.Counters$.MODULE$.Written()));
            this.mapped_$eq(context.getCounter("org.locationtech.geomesa.fs.compaction", "mapped"));
        }

        public void map(Void key, SimpleFeature sf, Mapper.Context context) {
            sf.getUserData().put(Hints.USE_PROVIDED_FID, Boolean.TRUE);
            this.mapped().increment(1L);
            context.write(null, (Object)sf);
            this.written().increment(1L);
        }

        public CompactionMapper() {
            LazyLogging.class.$init$((LazyLogging)this);
        }
    }

    public static class ParquetCompactionJob
    implements FileSystemCompactionJob,
    ParquetStorageConfiguration {
        private final Logger logger;
        private volatile boolean bitmap$0;

        public void configureOutput(SimpleFeatureType sft, Job job) {
            ParquetStorageConfiguration.class.configureOutput((ParquetStorageConfiguration)this, (SimpleFeatureType)sft, (Job)job);
        }

        private Logger logger$lzycompute() {
            ParquetCompactionJob parquetCompactionJob = this;
            synchronized (parquetCompactionJob) {
                if (!this.bitmap$0) {
                    this.logger = LazyLogging.class.logger((LazyLogging)this);
                    this.bitmap$0 = true;
                }
                return this.logger;
            }
        }

        public Logger logger() {
            return this.bitmap$0 ? this.logger : this.logger$lzycompute();
        }

        @Override
        public Tuple2<Object, Object> run(FileSystemStorage storage, Seq<StorageMetadata.PartitionMetadata> partitions, Option<Path> tempPath, Seq<String> libjarsFiles, Iterator<Function0<Seq<File>>> libjarsPaths2, StatusCallback statusCallback) {
            return FileSystemCompactionJob$class.run(this, storage, partitions, tempPath, libjarsFiles, libjarsPaths2, statusCallback);
        }

        public void setLibJars(Job job, Seq<String> fileNames, Iterator<Function0<Seq<File>>> searchPath) {
            JobWithLibJars.class.setLibJars((JobWithLibJars)this, (Job)job, fileNames, searchPath);
        }

        public ParquetCompactionJob() {
            JobWithLibJars.class.$init$((JobWithLibJars)this);
            FileSystemCompactionJob$class.$init$(this);
            LazyLogging.class.$init$((LazyLogging)this);
            ParquetStorageConfiguration.class.$init$((ParquetStorageConfiguration)this);
        }
    }
}

