/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.tools.status;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.time.Instant;
import java.util.List;
import java.util.Locale;
import org.geotools.data.DataStore;
import org.locationtech.geomesa.fs.data.FileSystemDataStore;
import org.locationtech.geomesa.fs.storage.api.StorageMetadata;
import org.locationtech.geomesa.fs.storage.api.StorageMetadata$;
import org.locationtech.geomesa.fs.tools.FsDataStoreCommand;
import org.locationtech.geomesa.fs.tools.FsDataStoreCommand$FsParams$class;
import org.locationtech.geomesa.fs.tools.FsDataStoreCommand$PartitionParam$class;
import org.locationtech.geomesa.fs.tools.FsDataStoreCommand$class;
import org.locationtech.geomesa.tools.Command$;
import org.locationtech.geomesa.tools.DataStoreCommand;
import org.locationtech.geomesa.tools.RequiredTypeNameParam;
import org.locationtech.geomesa.utils.geotools.package$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001I4A!\u0001\u0002\u0001\u001f\t\tbi]$fi\u001aKG.Z:D_6l\u0017M\u001c3\u000b\u0005\r!\u0011AB:uCR,8O\u0003\u0002\u0006\r\u0005)Ao\\8mg*\u0011q\u0001C\u0001\u0003MNT!!\u0003\u0006\u0002\u000f\u001d,w.\\3tC*\u00111\u0002D\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0005\f\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g!\t9\u0002$D\u0001\u0005\u0013\tIBA\u0001\nGg\u0012\u000bG/Y*u_J,7i\\7nC:$\u0007\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\u001e!\tq\u0002!D\u0001\u0003\u0011\u001d\u0001\u0003A1A\u0005B\u0005\na\u0001]1sC6\u001cX#\u0001\u0012\u0011\u0005\rRdB\u0001\u00134\u001d\t)#G\u0004\u0002'c9\u0011q\u0005\r\b\u0003Q=r!!\u000b\u0018\u000f\u0005)jS\"A\u0016\u000b\u00051r\u0011A\u0002\u001fs_>$h(C\u0001\u000e\u0013\tYA\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003\u000b\u0019I!a\u0001\u0003\b\u000bQ\u0012\u0001\u0012A\u001b\u0002#\u0019\u001bx)\u001a;GS2,7oQ8n[\u0006tG\r\u0005\u0002\u001fm\u0019)\u0011A\u0001E\u0001oM\u0011a\u0007\u0005\u0005\u00067Y\"\t!\u000f\u000b\u0002k\u0019!1H\u000e\u0001=\u0005A15kR3u\r&dWm\u001d)be\u0006l7oE\u0003;!u\"\u0015\n\u0005\u0002?\u0003:\u0011QeP\u0005\u0003\u0001\u0012\t!CR:ECR\f7\u000b^8sK\u000e{W.\\1oI&\u0011!i\u0011\u0002\t\rN\u0004\u0016M]1ng*\u0011\u0001\t\u0002\t\u0003\u000b\u001ek\u0011A\u0012\u0006\u0003\u000b!I!\u0001\u0013$\u0003+I+\u0017/^5sK\u0012$\u0016\u0010]3OC6,\u0007+\u0019:b[B\u0011aHS\u0005\u0003\u0017\u000e\u0013a\u0002U1si&$\u0018n\u001c8QCJ\fW\u000eC\u0003\u001cu\u0011\u0005Q\nF\u0001O!\ty%(D\u00017Q\u0011Q\u0014k\u0017/\u0011\u0005IKV\"A*\u000b\u0005Q+\u0016A\u00036d_6l\u0017M\u001c3fe*\u0011akV\u0001\u0006E\u0016,8\u000f\u001e\u0006\u00021\u0006\u00191m\\7\n\u0005i\u001b&A\u0003)be\u0006lW\r^3sg\u0006\u00112m\\7nC:$G)Z:de&\u0004H/[8oC\u0005i\u0016!\u0007'jgR\u0004c-\u001b7fg\u00022wN\u001d\u0011qCJ$\u0018\u000e^5p]NDaa\u0018\u0001!\u0002\u0013\u0011\u0013a\u00029be\u0006l7\u000f\t\u0005\bC\u0002\u0011\r\u0011\"\u0011c\u0003\u0011q\u0017-\\3\u0016\u0003\r\u0004\"\u0001Z4\u000f\u0005E)\u0017B\u00014\u0013\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001.\u001b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0019\u0014\u0002BB6\u0001A\u0003%1-A\u0003oC6,\u0007\u0005C\u0003n\u0001\u0011\u0005c.A\u0004fq\u0016\u001cW\u000f^3\u0015\u0003=\u0004\"!\u00059\n\u0005E\u0014\"\u0001B+oSR\u0004")
public class FsGetFilesCommand
implements FsDataStoreCommand {
    private final FSGetFilesParams params;
    private final String name;

    @Override
    public Map<String, String> connection() {
        return FsDataStoreCommand$class.connection(this);
    }

    public <T> T withDataStore(Function1<FileSystemDataStore, T> method) throws ParameterException {
        return (T)DataStoreCommand.class.withDataStore((DataStoreCommand)this, method);
    }

    public DataStore loadDataStore() throws ParameterException {
        return DataStoreCommand.class.loadDataStore((DataStoreCommand)this);
    }

    @Override
    public FSGetFilesParams params() {
        return this.params;
    }

    public String name() {
        return this.name;
    }

    public void execute() {
        this.withDataStore((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FsGetFilesCommand $outer;

            public final void apply(FileSystemDataStore ds) {
                StorageMetadata metadata = ds.storage(this.$outer.params().featureName()).metadata();
                Seq partitions = this.$outer.params().partitions().isEmpty() ? metadata.getPartitions(metadata.getPartitions$default$1()) : (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.$outer.params().partitions()).asScala()).map((Function1)new Serializable(this, metadata){
                    public static final long serialVersionUID = 0L;
                    private final StorageMetadata metadata$1;

                    public final StorageMetadata.PartitionMetadata apply(String name) {
                        return (StorageMetadata.PartitionMetadata)this.metadata$1.getPartition(name).getOrElse((Function0)new Serializable(this, name){
                            public static final long serialVersionUID = 0L;
                            private final String name$1;

                            public final Nothing$ apply() {
                                throw new ParameterException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition ", " cannot be found in metadata"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1})));
                            }
                            {
                                this.name$1 = name$1;
                            }
                        });
                    }
                    {
                        this.metadata$1 = metadata$1;
                    }
                }, Buffer$.MODULE$.canBuildFrom());
                Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Listing files for ", " partitions"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partitions.length())})));
                ((IterableLike)partitions.sortBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(StorageMetadata.PartitionMetadata x$1) {
                        return x$1.name();
                    }
                }, (Ordering)Ordering.String$.MODULE$)).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(StorageMetadata.PartitionMetadata partition) {
                        Command$.MODULE$.output().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition.name()})));
                        ((IterableLike)partition.files().sorted(StorageMetadata$.MODULE$.StorageFileOrdering().reverse())).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(StorageMetadata.StorageFile f) {
                                Command$.MODULE$.output().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{f.action().toString().toUpperCase(Locale.US)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.GeoToolsDateFormat().format(Instant.ofEpochMilli(f.timestamp())), f.name()}))).toString());
                            }
                        });
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public FsGetFilesCommand() {
        DataStoreCommand.class.$init$((DataStoreCommand)this);
        FsDataStoreCommand$class.$init$(this);
        this.params = new FSGetFilesParams();
        this.name = "get-files";
    }

    @Parameters(commandDescription="List files for partitions")
    public static class FSGetFilesParams
    implements FsDataStoreCommand.FsParams,
    RequiredTypeNameParam,
    FsDataStoreCommand.PartitionParam {
        @Parameter(names={"--partitions"}, description="Partitions to operate on (if empty all partitions will be used)", variableArity=true)
        private List<String> partitions;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate", required=true)
        private String featureName;
        @Parameter(names={"--path", "-p"}, description="Path to root of filesystem datastore", required=true)
        private String path;
        @Parameter(names={"--config"}, description="Configuration properties, in the form k=v", variableArity=true)
        private List<String> configuration;

        @Override
        public List<String> partitions() {
            return this.partitions;
        }

        @Override
        @TraitSetter
        public void partitions_$eq(List<String> x$1) {
            this.partitions = x$1;
        }

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        @Override
        public String path() {
            return this.path;
        }

        @Override
        @TraitSetter
        public void path_$eq(String x$1) {
            this.path = x$1;
        }

        @Override
        public List<String> configuration() {
            return this.configuration;
        }

        @Override
        @TraitSetter
        public void configuration_$eq(List<String> x$1) {
            this.configuration = x$1;
        }

        public FSGetFilesParams() {
            FsDataStoreCommand$FsParams$class.$init$(this);
            RequiredTypeNameParam.class.$init$((RequiredTypeNameParam)this);
            FsDataStoreCommand$PartitionParam$class.$init$(this);
        }
    }
}

