/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.geotools.tools.data;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.List;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.postgis.PostGISPSDialect;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.SQLDialect;
import org.locationtech.geomesa.geotools.tools.GeoToolsDataStoreCommand;
import org.locationtech.geomesa.gt.partition.postgis.dialect.PartitionedPostgisDialect;
import org.locationtech.geomesa.tools.RequiredTypeNameParam;
import org.locationtech.geomesa.tools.package;
import org.locationtech.geomesa.tools.utils.ParameterConverters;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001a4A\u0001D\u0007\u00015!)q\u0005\u0001C\u0001Q!91\u0006\u0001b\u0001\n\u0003b\u0003BB4\u0001A\u0003%Q\u0006C\u0004i\u0001\t\u0007I\u0011I5\t\rI\u0004\u0001\u0015!\u0003k\u0011\u0015\u0019\b\u0001\"\u0011u\u000f\u0015qT\u0002#\u0001@\r\u0015aQ\u0002#\u0001A\u0011\u00159\u0003\u0002\"\u0001H\r\u0011A\u0005\u0002A%\t\u000b\u001dRA\u0011\u0001,\u00037A{7\u000f^4jgV\u0003xM]1eKN\u001b\u0007.Z7b\u0007>lW.\u00198e\u0015\tqq\"\u0001\u0003eCR\f'B\u0001\t\u0012\u0003\u0015!xn\u001c7t\u0015\t\u00112#\u0001\u0005hK>$xn\u001c7t\u0015\t!R#A\u0004hK>lWm]1\u000b\u0005Y9\u0012\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"\u0001\r\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001Y2\u0005\u0005\u0002\u001dC5\tQD\u0003\u0002\u001f?\u0005!A.\u00198h\u0015\u0005\u0001\u0013\u0001\u00026bm\u0006L!AI\u000f\u0003\r=\u0013'.Z2u!\t!S%D\u0001\u0010\u0013\t1sB\u0001\rHK>$vn\u001c7t\t\u0006$\u0018m\u0015;pe\u0016\u001cu.\\7b]\u0012\fa\u0001P5oSRtD#A\u0015\u0011\u0005)\u0002Q\"A\u0007\u0002\rA\f'/Y7t+\u0005i\u0003C\u0001\u0018\u000b\u001d\tysA\u0004\u00021{9\u0011\u0011\u0007\u0010\b\u0003emr!a\r\u001e\u000f\u0005QJdBA\u001b9\u001b\u00051$BA\u001c\u001a\u0003\u0019a$o\\8u}%\t\u0001$\u0003\u0002\u0017/%\u0011A#F\u0005\u0003%MI!\u0001E\t\n\u00059y\u0011a\u0007)pgR<\u0017n]+qOJ\fG-Z*dQ\u0016l\u0017mQ8n[\u0006tG\r\u0005\u0002+\u0011M\u0011\u0001\"\u0011\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0002\t\u0006)1oY1mC&\u0011ai\u0011\u0002\u0007\u0003:L(+\u001a4\u0015\u0003}\u0012!\u0004U8ti\u001eL7/\u00169he\u0006$WmU2iK6\f\u0007+\u0019:b[N\u001cBAC!K#B\u00111J\u0014\b\u0003a1K!!T\b\u00021\u001d+w\u000eV8pYN$\u0015\r^1Ti>\u0014XmQ8n[\u0006tG-\u0003\u0002P!\n9r)Z8U_>d7\u000fR1uCN#xN]3QCJ\fWn\u001d\u0006\u0003\u001b>\u0001\"A\u0015+\u000e\u0003MS!\u0001E\n\n\u0005U\u001b&!\u0006*fcVL'/\u001a3UsB,g*Y7f!\u0006\u0014\u0018-\u001c\u000b\u0002/B\u0011\u0001LC\u0007\u0002\u0011!\"!B\u00173f!\tY&-D\u0001]\u0015\tif,\u0001\u0006kG>lW.\u00198eKJT!a\u00181\u0002\u000b\t,Wo\u001d;\u000b\u0003\u0005\f1aY8n\u0013\t\u0019GL\u0001\u0006QCJ\fW.\u001a;feN\f!cY8n[\u0006tG\rR3tGJL\u0007\u000f^5p]\u0006\na-A Va\u0012\fG/\u001a\u0011uQ\u0016\u0004s)Z8NKN\f\u0007\u0005]1si&$\u0018n\u001c8j]\u001e\u0004c-\u001e8di&|gn\u001d\u0011u_\u0002\"\b.\u001a\u0011mCR,7\u000f\u001e\u0011wKJ\u001c\u0018n\u001c8\u0002\u000fA\f'/Y7tA\u0005!a.Y7f+\u0005Q\u0007CA6p\u001d\taW\u000e\u0005\u00026\u0007&\u0011anQ\u0001\u0007!J,G-\u001a4\n\u0005A\f(AB*ue&twM\u0003\u0002o\u0007\u0006)a.Y7fA\u00059Q\r_3dkR,G#A;\u0011\u0005\t3\u0018BA<D\u0005\u0011)f.\u001b;")
public class PostgisUpgradeSchemaCommand
implements GeoToolsDataStoreCommand {
    private final PostgisUpgradeSchemaParams params;
    private final String name;
    private Map<String, String> connection;
    private volatile boolean bitmap$0;

    public <T> T withDataStore(Function1<DataStore, T> method) throws ParameterException {
        return (T)package.DataStoreCommand.withDataStore$((package.DataStoreCommand)this, method);
    }

    public DataStore loadDataStore() throws ParameterException {
        return package.DataStoreCommand.loadDataStore$((package.DataStoreCommand)this);
    }

    public Seq<package.Command> subCommands() {
        return package.Command.subCommands$((package.Command)this);
    }

    public Option<ParameterException> validate() {
        return package.Command.validate$((package.Command)this);
    }

    public void run() {
        package.Command.run$((package.Command)this);
    }

    private Map<String, String> connection$lzycompute() {
        PostgisUpgradeSchemaCommand postgisUpgradeSchemaCommand = this;
        synchronized (postgisUpgradeSchemaCommand) {
            if (!this.bitmap$0) {
                this.connection = GeoToolsDataStoreCommand.connection$(this);
                this.bitmap$0 = true;
            }
        }
        return this.connection;
    }

    @Override
    public Map<String, String> connection() {
        if (!this.bitmap$0) {
            return this.connection$lzycompute();
        }
        return this.connection;
    }

    @Override
    public PostgisUpgradeSchemaParams params() {
        return this.params;
    }

    public String name() {
        return this.name;
    }

    public void execute() {
        this.withDataStore((Function1 & Serializable & scala.Serializable)x0$1 -> {
            PostgisUpgradeSchemaCommand.$anonfun$execute$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private final Class unwrap$1(Class c) {
        while (true) {
            Class clazz = c;
            Class<PostGISPSDialect> clazz2 = PostGISPSDialect.class;
            if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
                return c;
            }
            c = c.getSuperclass();
        }
    }

    public static final /* synthetic */ void $anonfun$execute$2(PostgisUpgradeSchemaCommand $this, JDBCDataStore x2$1, SimpleFeatureType sft$1, Connection cx) {
        PartitionedPostgisDialect partitionedPostgisDialect;
        SQLDialect sQLDialect = x2$1.dialect;
        if (sQLDialect instanceof PartitionedPostgisDialect) {
            PartitionedPostgisDialect partitionedPostgisDialect2;
            partitionedPostgisDialect = partitionedPostgisDialect2 = (PartitionedPostgisDialect)sQLDialect;
        } else if (sQLDialect instanceof PostGISPSDialect) {
            PostGISPSDialect postGISPSDialect = (PostGISPSDialect)sQLDialect;
            Method m = $this.unwrap$1(postGISPSDialect.getClass()).getDeclaredMethod("getDelegate", new Class[0]);
            m.setAccessible(true);
            partitionedPostgisDialect = (PartitionedPostgisDialect)m.invoke((Object)postGISPSDialect, new Object[0]);
        } else {
            throw new MatchError((Object)sQLDialect);
        }
        PartitionedPostgisDialect dialect = partitionedPostgisDialect;
        String schema = (String)$this.connection().getOrElse((Object)JDBCDataStoreFactory.SCHEMA.key, (Function0 & Serializable & scala.Serializable)() -> "public");
        dialect.upgrade(schema, sft$1, cx);
    }

    public static final /* synthetic */ void $anonfun$execute$1(PostgisUpgradeSchemaCommand $this, DataStore x0$1) {
        DataStore dataStore = x0$1;
        if (dataStore instanceof JDBCDataStore) {
            JDBCDataStore jDBCDataStore = (JDBCDataStore)dataStore;
            package.Command$.MODULE$.user().info(new StringBuilder(27).append("Running upgrade on schema: ").append($this.params().featureName()).toString());
            SimpleFeatureType sft = jDBCDataStore.getSchema($this.params().featureName());
            package.WithClose$.MODULE$.apply((Object)jDBCDataStore.getConnection(Transaction.AUTO_COMMIT), (Function1 & Serializable & scala.Serializable)cx -> {
                PostgisUpgradeSchemaCommand.$anonfun$execute$2($this, jDBCDataStore, sft, cx);
                return BoxedUnit.UNIT;
            }, IsCloseable$.MODULE$.closeableIsCloseable());
            package.Command$.MODULE$.user().info("Upgrade complete");
            return;
        }
        throw new MatchError((Object)dataStore);
    }

    public PostgisUpgradeSchemaCommand() {
        package.Command.$init$((package.Command)this);
        package.DataStoreCommand.$init$((package.DataStoreCommand)this);
        GeoToolsDataStoreCommand.$init$(this);
        this.params = new PostgisUpgradeSchemaParams();
        this.name = "partition-upgrade";
    }

    @Parameters(commandDescription="Update the GeoMesa partitioning functions to the latest version")
    public static class PostgisUpgradeSchemaParams
    implements GeoToolsDataStoreCommand.GeoToolsDataStoreParams,
    RequiredTypeNameParam {
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate", required=true)
        private String featureName;
        @Parameter(names={"--param"}, description="Parameter for DataStoreFinder to load the data store, in the form key=value", variableArity=true, converter=ParameterConverters.KeyValueConverter.class)
        private List<Tuple2<String, String>> params;
        @Parameter(names={"--params"}, description="Java properties file containing parameters for DataStoreFinder to load the data store")
        private File paramFile;

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        @Override
        public List<Tuple2<String, String>> params() {
            return this.params;
        }

        @Override
        public void params_$eq(List<Tuple2<String, String>> x$1) {
            this.params = x$1;
        }

        @Override
        public File paramFile() {
            return this.paramFile;
        }

        @Override
        public void paramFile_$eq(File x$1) {
            this.paramFile = x$1;
        }

        public PostgisUpgradeSchemaParams() {
            GeoToolsDataStoreCommand.GeoToolsDataStoreParams.$init$(this);
            RequiredTypeNameParam.$init$((RequiredTypeNameParam)this);
        }
    }
}

