/***********************************************************************
 * Copyright (c) 2013-2025 Commonwealth Computer Research, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at
 * http://www.opensource.org/licenses/apache2.0.php.
 ***********************************************************************/

package org.locationtech.geomesa.geotools.tools.data


import com.beust.jcommander.Parameters
import org.geotools.api.data.DataStore
import org.locationtech.geomesa.geotools.tools.GeoToolsDataStoreCommand
import org.locationtech.geomesa.geotools.tools.GeoToolsDataStoreCommand.GeoToolsDataStoreParams
import org.locationtech.geomesa.geotools.tools.data.GeoToolsGetSftConfigCommand.GeoToolsGetSftConfigParams
import org.locationtech.geomesa.tools.RequiredTypeNameParam
import org.locationtech.geomesa.tools.status.{GetSftConfigCommand, GetSftConfigParams}

class GeoToolsGetSftConfigCommand extends GetSftConfigCommand[DataStore] with GeoToolsDataStoreCommand {
  override val params: GeoToolsGetSftConfigParams = new GeoToolsGetSftConfigParams
}

object GeoToolsGetSftConfigCommand {
  @Parameters(commandDescription = "Get the SimpleFeatureType definition of a schema")
  class GeoToolsGetSftConfigParams extends GetSftConfigParams with GeoToolsDataStoreParams with RequiredTypeNameParam
}
