/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.geotools.tools.data;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.DefaultTransaction;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.SQLDialect;
import org.locationtech.geomesa.geotools.tools.GeoToolsDataStoreCommand;
import org.locationtech.geomesa.gt.partition.postgis.dialect.PartitionedPostgisDialect;
import org.locationtech.geomesa.gt.partition.postgis.dialect.PartitionedPostgisPsDialect;
import org.locationtech.geomesa.tools.OptionalForceParam;
import org.locationtech.geomesa.tools.RequiredTypeNameParam;
import org.locationtech.geomesa.tools.package;
import org.locationtech.geomesa.tools.utils.NoopParameterSplitter;
import org.locationtech.geomesa.tools.utils.ParameterConverters;
import org.locationtech.geomesa.tools.utils.Prompt$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0005\u0005}d\u0001B\t\u0013\u0001}AQa\u0012\u0001\u0005\u0002!Cqa\u0013\u0001C\u0002\u0013\u0005C\n\u0003\u0004Q\u0001\u0001\u0006I!\u0014\u0005\b#\u0002\u0011\r\u0011\"\u0011S\u0011\u001d\t\t\b\u0001Q\u0001\nMCq!a\u001d\u0001\t\u0003\n)\bC\u0004\u0002x\u0001!\t\"!\u001f\b\u000bm\u0013\u0002\u0012\u0001/\u0007\u000bE\u0011\u0002\u0012A/\t\u000b\u001dKA\u0011\u00013\u0007\t\u0015L\u0001A\u001a\u0005\u0006\u000f.!\t!\u001e\u0005\bq.\u0001\r\u0011\"\u0001z\u0011%\tya\u0003a\u0001\n\u0003\t\t\u0002C\u0004\u0002\u001e-\u0001\u000b\u0015\u0002>\t\u000f\u0005M3\u0002\"\u0001\u0002V\tYr)Z8U_>d7/\u00169eCR,7k\u00195f[\u0006\u001cu.\\7b]\u0012T!a\u0005\u000b\u0002\t\u0011\fG/\u0019\u0006\u0003+Y\tQ\u0001^8pYNT!a\u0006\r\u0002\u0011\u001d,w\u000e^8pYNT!!\u0007\u000e\u0002\u000f\u001d,w.\\3tC*\u00111\u0004H\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002;\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\t\u0015D!\t\tc%D\u0001#\u0015\t\u0019C%\u0001\u0003mC:<'\"A\u0013\u0002\t)\fg/Y\u0005\u0003O\t\u0012aa\u00142kK\u000e$\bcA\u00159w9\u0011!&\u000e\b\u0003WQr!\u0001L\u001a\u000f\u00055\u0012dB\u0001\u00182\u001b\u0005y#B\u0001\u0019\u001f\u0003\u0019a$o\\8u}%\tQ$\u0003\u0002\u001c9%\u0011\u0011DG\u0005\u0003+aI!AN\u001c\u0002\u000fA\f7m[1hK*\u0011Q\u0003G\u0005\u0003si\u0012\u0001\u0003R1uCN#xN]3D_6l\u0017M\u001c3\u000b\u0005Y:\u0004C\u0001\u001fB\u001b\u0005i$BA\n?\u0015\ty\u0004)A\u0002ba&T!a\u0006\u000f\n\u0005\tk$!\u0003#bi\u0006\u001cFo\u001c:f!\t!U)D\u0001\u0015\u0013\t1EC\u0001\rHK>$vn\u001c7t\t\u0006$\u0018m\u0015;pe\u0016\u001cu.\\7b]\u0012\fa\u0001P5oSRtD#A%\u0011\u0005)\u0003Q\"\u0001\n\u0002\t9\fW.Z\u000b\u0002\u001bB\u0011\u0011ET\u0005\u0003\u001f\n\u0012aa\u0015;sS:<\u0017!\u00028b[\u0016\u0004\u0013A\u00029be\u0006l7/F\u0001T!\t!6B\u0004\u0002V\u00119\u0011aK\u0017\b\u0003/fs!a\u000b-\n\u0005]A\u0012BA\u000b\u0017\u0013\t\u0019B#A\u000eHK>$vn\u001c7t+B$\u0017\r^3TG\",W.Y\"p[6\fg\u000e\u001a\t\u0003\u0015&\u0019\"!\u00030\u0011\u0005}\u0013W\"\u00011\u000b\u0003\u0005\fQa]2bY\u0006L!a\u00191\u0003\r\u0005s\u0017PU3g)\u0005a&AG$f_R{w\u000e\\:Va\u0012\fG/Z*dQ\u0016l\u0017\rU1sC6\u001c8#B\u0006_O.t\u0007C\u00015j\u001b\u00059\u0014B\u000168\u0005U\u0011V-];je\u0016$G+\u001f9f\u001d\u0006lW\rU1sC6\u0004\"\u0001\u001b7\n\u00055<$AE(qi&|g.\u00197G_J\u001cW\rU1sC6\u0004\"a\u001c:\u000f\u0005Y\u0003\u0018BA9\u0015\u0003a9Um\u001c+p_2\u001cH)\u0019;b'R|'/Z\"p[6\fg\u000eZ\u0005\u0003gR\u0014qcR3p)>|Gn\u001d#bi\u0006\u001cFo\u001c:f!\u0006\u0014\u0018-\\:\u000b\u0005E$B#\u0001<\u0011\u0005]\\Q\"A\u0005\u0002\u0011U\u001cXM\u001d#bi\u0006,\u0012A\u001f\t\u0005wz\f\t!D\u0001}\u0015\tiH%\u0001\u0003vi&d\u0017BA@}\u0005\u0011a\u0015n\u001d;\u0011\t\u0005\r\u00111\u0002\b\u0005\u0003\u000b\t9\u0001\u0005\u0002/A&\u0019\u0011\u0011\u00021\u0002\rA\u0013X\rZ3g\u0013\ry\u0015Q\u0002\u0006\u0004\u0003\u0013\u0001\u0017\u0001D;tKJ$\u0015\r^1`I\u0015\fH\u0003BA\n\u00033\u00012aXA\u000b\u0013\r\t9\u0002\u0019\u0002\u0005+:LG\u000f\u0003\u0005\u0002\u001c9\t\t\u00111\u0001{\u0003\rAH%M\u0001\nkN,'\u000fR1uC\u0002BsbDA\u0011\u0003k\t9$!\u0010\u0002@\u0005\r\u0013Q\t\t\u0005\u0003G\t\t$\u0004\u0002\u0002&)!\u0011qEA\u0015\u0003)Q7m\\7nC:$WM\u001d\u0006\u0005\u0003W\ti#A\u0003cKV\u001cHO\u0003\u0002\u00020\u0005\u00191m\\7\n\t\u0005M\u0012Q\u0005\u0002\n!\u0006\u0014\u0018-\\3uKJ\fQA\\1nKNd#!!\u000f\"\u0005\u0005m\u0012aD\u0017.C\u0012$W&^:fe6\"\u0017\r^1\u0002\u0017\u0011,7o\u0019:jaRLwN\\\u0011\u0003\u0003\u0003\na-\u00113eA\u0005\u0004c.Z<!K:$(/\u001f\u0011pe\u0002*\b\u000fZ1uK\u0002\ng\u000eI3ySN$\u0018N\\4!K:$(/\u001f\u0011j]\u0002\"\b.\u001a\u0011gK\u0006$XO]3!if\u0004X\rI;tKJ\u0004C-\u0019;bY\u0001\"W\r\\5oK\u0006$X\r\u001a\u0011xSRD\u0007%\u0019\u0011d_2|g\u000e\t\u0015;S\u0005A1\u000f\u001d7jiR,'o\t\u0002\u0002HA!\u0011\u0011JA(\u001b\t\tYEC\u0002\u0002N]\nQ!\u001e;jYNLA!!\u0015\u0002L\t)bj\\8q!\u0006\u0014\u0018-\\3uKJ\u001c\u0006\u000f\\5ui\u0016\u0014\u0018\u0001\u0003<bY&$\u0017\r^3\u0015\u0005\u0005]\u0003#B0\u0002Z\u0005u\u0013bAA.A\n1q\n\u001d;j_:\u0004B!a\t\u0002`%!\u0011\u0011MA\u0013\u0005I\u0001\u0016M]1nKR,'/\u0012=dKB$\u0018n\u001c8)\u000f-\t)'a\u001b\u0002nA!\u00111EA4\u0013\u0011\tI'!\n\u0003\u0015A\u000b'/Y7fi\u0016\u00148/\u0001\nd_6l\u0017M\u001c3EKN\u001c'/\u001b9uS>t\u0017EAA8\u0003U)\u0006\u000fZ1uK\u0002\n\u0007EZ3biV\u0014X\r\t;za\u0016\fq\u0001]1sC6\u001c\b%A\u0004fq\u0016\u001cW\u000f^3\u0015\u0005\u0005M\u0011AB;qI\u0006$X\r\u0006\u0003\u0002\u0014\u0005m\u0004BBA?\u000f\u0001\u00071(\u0001\u0002eg\u0002")
public class GeoToolsUpdateSchemaCommand
implements GeoToolsDataStoreCommand {
    private final String name;
    private final GeoToolsUpdateSchemaParams params;
    private Map<String, String> connection;
    private volatile boolean bitmap$0;

    public <T> T withDataStore(Function1<DataStore, T> method) throws ParameterException {
        return (T)package.DataStoreCommand.withDataStore$((package.DataStoreCommand)this, method);
    }

    public DataStore loadDataStore() throws ParameterException {
        return package.DataStoreCommand.loadDataStore$((package.DataStoreCommand)this);
    }

    public Seq<package.Command> subCommands() {
        return package.Command.subCommands$((package.Command)this);
    }

    public Option<ParameterException> validate() {
        return package.Command.validate$((package.Command)this);
    }

    public void run() {
        package.Command.run$((package.Command)this);
    }

    private Map<String, String> connection$lzycompute() {
        GeoToolsUpdateSchemaCommand geoToolsUpdateSchemaCommand = this;
        synchronized (geoToolsUpdateSchemaCommand) {
            if (!this.bitmap$0) {
                this.connection = GeoToolsDataStoreCommand.connection$(this);
                this.bitmap$0 = true;
            }
        }
        return this.connection;
    }

    @Override
    public Map<String, String> connection() {
        if (!this.bitmap$0) {
            return this.connection$lzycompute();
        }
        return this.connection;
    }

    public String name() {
        return this.name;
    }

    @Override
    public GeoToolsUpdateSchemaParams params() {
        return this.params;
    }

    public void execute() {
        this.withDataStore((Function1 & Serializable)ds -> {
            this.update(ds);
            return BoxedUnit.UNIT;
        });
    }

    public void update(DataStore ds) {
        block17: {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            SimpleFeatureType updated;
            SimpleFeatureType sft;
            block16: {
                Object x$4;
                String x$3;
                BoxedUnit boxedUnit3;
                SimpleFeatureType simpleFeatureType;
                this.params().validate().foreach((Function1 & Serializable)e -> {
                    throw e;
                });
                try {
                    simpleFeatureType = ds.getSchema(this.params().featureName());
                }
                catch (IOException iOException) {
                    simpleFeatureType = sft = null;
                }
                if (sft == null) {
                    throw new ParameterException(new java.lang.StringBuilder(42).append("Schema '").append(this.params().featureName()).append("' does not exist in the data store").toString());
                }
                IntRef n = IntRef.create((int)0);
                StringBuilder prompts = new StringBuilder();
                SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
                builder.init(sft);
                updated = builder.buildFeatureType();
                updated.getUserData().putAll(sft.getUserData());
                if (!this.params().userData().isEmpty()) {
                    ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(this.params().userData()).asScala()).foreach((Function1 & Serializable)ud -> {
                        Object object;
                        String[] stringArray = ud.split(":", 2);
                        if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) == 0) {
                            String k = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                            String v = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
                            String string = updated.getUserData().put(k, v);
                            if (string == null) {
                                return prompts.append(new java.lang.StringBuilder(26).append("\n  ").append(GeoToolsUpdateSchemaCommand.number$1(n)).append(": Adding user data: '").append(k).append("=").append(v).append("'").toString());
                            }
                            return prompts.append(new java.lang.StringBuilder(37).append("\n  ").append(GeoToolsUpdateSchemaCommand.number$1(n)).append(": Updating user data: '").append(k).append("=").append(v).append("' (was '").append((Object)string).append("')").toString());
                        }
                        throw new ParameterException(new java.lang.StringBuilder(48).append("Invalid user data entry - expected 'key:value': ").append((String)ud).toString());
                    });
                }
                if (package.Command$.MODULE$.user().underlying().isInfoEnabled()) {
                    package.Command$.MODULE$.user().underlying().info("Preparing to update schema '{}':{}", new Object[]{sft.getTypeName(), prompts});
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                if (this.params().force()) break block16;
                String x$1 = "Continue (y/n)? ";
                List x$2 = Prompt$.MODULE$.confirm$default$2();
                if (!Prompt$.MODULE$.confirm("Continue (y/n)? ", x$2, x$3 = Prompt$.MODULE$.confirm$default$3(), x$4 = Prompt$.MODULE$.confirm$default$4("Continue (y/n)? ", x$2, x$3))) break block17;
            }
            if (package.Command$.MODULE$.user().underlying().isInfoEnabled()) {
                package.Command$.MODULE$.user().underlying().info("Updating, please wait...");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            DataStore dataStore = ds;
            if (dataStore instanceof JDBCDataStore) {
                JDBCDataStore jDBCDataStore = (JDBCDataStore)dataStore;
                Option partitioning = Option$.MODULE$.apply((Object)jDBCDataStore.dialect).collect((PartialFunction)new Serializable(null){
                    private static final long serialVersionUID = 0L;

                    public final <A1 extends SQLDialect, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        if (A1 instanceof PartitionedPostgisDialect) {
                            PartitionedPostgisDialect partitionedPostgisDialect = (PartitionedPostgisDialect)A1;
                            return (B1)partitionedPostgisDialect;
                        }
                        if (A1 instanceof PartitionedPostgisPsDialect) {
                            PartitionedPostgisPsDialect partitionedPostgisPsDialect = (PartitionedPostgisPsDialect)A1;
                            return (B1)partitionedPostgisPsDialect;
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(SQLDialect x1) {
                        SQLDialect sQLDialect = x1;
                        if (sQLDialect instanceof PartitionedPostgisDialect) {
                            return true;
                        }
                        return sQLDialect instanceof PartitionedPostgisPsDialect;
                    }
                });
                SQLDialect dialect = (SQLDialect)partitioning.getOrElse((Function0 & Serializable)() -> {
                    throw new RuntimeException("JDBCDataStore does not support schema updates unless using 'dbtype=postgis-partitioned'");
                });
                BoxedUnit cfr_ignored_0 = (BoxedUnit)package.WithClose$.MODULE$.apply((Object)new DefaultTransaction(), (Function1 & Serializable)tx -> {
                    package.WithClose$.MODULE$.apply((Object)jDBCDataStore.getConnection((Transaction)tx), (Function1 & Serializable)cx -> {
                        dialect$1.postCreateTable(x2$1.getDatabaseSchema(), updated$1, cx);
                        return BoxedUnit.UNIT;
                    }, IsCloseable$.MODULE$.closeableIsCloseable());
                    return BoxedUnit.UNIT;
                }, IsCloseable$.MODULE$.closeableIsCloseable());
            } else {
                try {
                    ds.updateSchema(sft.getTypeName(), updated);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    throw new RuntimeException(new java.lang.StringBuilder(32).append(ds.getClass().getSimpleName()).append(" does not support schema updates").toString());
                }
            }
            if (package.Command$.MODULE$.user().underlying().isInfoEnabled()) {
                package.Command$.MODULE$.user().underlying().info("Update complete");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    private static final int number$1(IntRef n$1) {
        ++n$1.elem;
        return n$1.elem;
    }

    public GeoToolsUpdateSchemaCommand() {
        package.Command.$init$((package.Command)this);
        package.DataStoreCommand.$init$((package.DataStoreCommand)this);
        GeoToolsDataStoreCommand.$init$(this);
        this.name = "update-schema";
        this.params = new GeoToolsUpdateSchemaParams();
    }

    @Parameters(commandDescription="Update a feature type")
    public static class GeoToolsUpdateSchemaParams
    implements RequiredTypeNameParam,
    OptionalForceParam,
    GeoToolsDataStoreCommand.GeoToolsDataStoreParams {
        @Parameter(names={"--add-user-data"}, description="Add a new entry or update an existing entry in the feature type user data, delineated with a colon (:)", splitter=NoopParameterSplitter.class)
        private java.util.List<String> userData;
        @Parameter(names={"--param"}, description="Parameter for DataStoreFinder to load the data store, in the form key=value", variableArity=true, converter=ParameterConverters.KeyValueConverter.class)
        private java.util.List<Tuple2<String, String>> params;
        @Parameter(names={"--params"}, description="Java properties file containing parameters for DataStoreFinder to load the data store")
        private File paramFile;
        @Parameter(names={"--force"}, description="Force execution without prompt")
        private boolean force;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate", required=true)
        private String featureName;

        @Override
        public java.util.List<Tuple2<String, String>> params() {
            return this.params;
        }

        @Override
        public void params_$eq(java.util.List<Tuple2<String, String>> x$1) {
            this.params = x$1;
        }

        @Override
        public File paramFile() {
            return this.paramFile;
        }

        @Override
        public void paramFile_$eq(File x$1) {
            this.paramFile = x$1;
        }

        public boolean force() {
            return this.force;
        }

        public void force_$eq(boolean x$1) {
            this.force = x$1;
        }

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        public java.util.List<String> userData() {
            return this.userData;
        }

        public void userData_$eq(java.util.List<String> x$1) {
            this.userData = x$1;
        }

        public Option<ParameterException> validate() {
            if (this.userData().isEmpty()) {
                return new Some((Object)new ParameterException("Please specify an update operation"));
            }
            return None$.MODULE$;
        }

        public GeoToolsUpdateSchemaParams() {
            RequiredTypeNameParam.$init$((RequiredTypeNameParam)this);
            OptionalForceParam.$init$((OptionalForceParam)this);
            GeoToolsDataStoreCommand.GeoToolsDataStoreParams.$init$(this);
            this.userData = Collections.emptyList();
        }
    }
}

