/*
 * Decompiled with CFR 0.152.
 */
package net.opengis.wfs20;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ResultTypeType implements Enumerator
{
    RESULTS(0, "results", "results"),
    HITS(1, "hits", "hits");

    public static final int RESULTS_VALUE = 0;
    public static final int HITS_VALUE = 1;
    private static final ResultTypeType[] VALUES_ARRAY;
    public static final List<ResultTypeType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static ResultTypeType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ResultTypeType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static ResultTypeType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ResultTypeType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static ResultTypeType get(int value) {
        switch (value) {
            case 0: {
                return RESULTS;
            }
            case 1: {
                return HITS;
            }
        }
        return null;
    }

    private ResultTypeType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new ResultTypeType[]{RESULTS, HITS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

