/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.tools.export;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.tools.CatalogParam;
import org.locationtech.geomesa.tools.OptionalCqlFilterParam;
import org.locationtech.geomesa.tools.OptionalIndexParam;
import org.locationtech.geomesa.tools.RequiredTypeNameParam;
import org.locationtech.geomesa.tools.export.BinExportCommand;
import org.locationtech.geomesa.tools.export.ExportParams;
import org.locationtech.geomesa.tools.export.FileExportParams;
import org.locationtech.geomesa.tools.utils.ParameterConverters;
import org.locationtech.geomesa.utils.index.IndexMode;
import scala.Option;
import scala.reflect.ScalaSignature;

@Parameters(commandDescription="Export features from a GeoMesa data store in a binary format")
@ScalaSignature(bytes="\u0006\u0001\u00193A!\u0001\u0002\u0001\u001f\t!\u0002JQ1tK\nKg.\u0012=q_J$\b+\u0019:b[NT!a\u0001\u0003\u0002\r\u0015D\bo\u001c:u\u0015\t)a!A\u0003u_>d7O\u0003\u0002\b\u0011\u0005)\u0001NY1tK*\u0011\u0011BC\u0001\bO\u0016|W.Z:b\u0015\tYA\"\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\u0015\u0001\u0001C\u0006\u00171!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0011q#\u000b\b\u00031\u0019r!!\u0007\u0013\u000f\u0005i\u0019cBA\u000e#\u001d\ta\u0012E\u0004\u0002\u001eA5\taD\u0003\u0002 \u001d\u00051AH]8pizJ\u0011!D\u0005\u0003\u00171I!!\u0003\u0006\n\u0005\u0015A\u0011BA\u0002&\u0015\t)\u0001\"\u0003\u0002(Q\u0005\u0001\")\u001b8FqB|'\u000f^\"p[6\fg\u000e\u001a\u0006\u0003\u0007\u0015J!AK\u0016\u0003\u001f\tKg.\u0012=q_J$\b+\u0019:b[NT!a\n\u0015\u0011\u00055rS\"A\u0013\n\u0005=*#\u0001D\"bi\u0006dwn\u001a)be\u0006l\u0007CA\u00172\u0013\t\u0011TEA\u000bSKF,\u0018N]3e)f\u0004XMT1nKB\u000b'/Y7\t\u000bQ\u0002A\u0011A\u001b\u0002\rqJg.\u001b;?)\u00051\u0004CA\u001c\u0001\u001b\u0005\u0011\u0001\u0006\u0002\u0001:\u0007\u0012\u0003\"AO!\u000e\u0003mR!\u0001P\u001f\u0002\u0015)\u001cw.\\7b]\u0012,'O\u0003\u0002?\u007f\u0005)!-Z;ti*\t\u0001)A\u0002d_6L!AQ\u001e\u0003\u0015A\u000b'/Y7fi\u0016\u00148/\u0001\nd_6l\u0017M\u001c3EKN\u001c'/\u001b9uS>t\u0017%A#\u0002y\u0015C\bo\u001c:uA\u0019,\u0017\r^;sKN\u0004cM]8nA\u0005\u0004s)Z8NKN\f\u0007\u0005Z1uC\u0002\u001aHo\u001c:fA%t\u0007%\u0019\u0011cS:\f'/\u001f\u0011g_Jl\u0017\r\u001e")
public class HBaseBinExportParams
implements BinExportCommand.BinExportParams {
    @Parameter(names={"--id-attribute"}, description="Name of the id attribute to export")
    private String idAttribute;
    @Parameter(names={"--geom-attribute"}, description="Name of the geometry attribute to export")
    private String geomAttribute;
    @Parameter(names={"--label-attribute"}, description="Name of the attribute to use as a bin file label")
    private String labelAttribute;
    @Parameter(names={"--dt-attribute"}, description="Name of the date attribute to export")
    private String dateAttribute;
    @Parameter(names={"--index"}, description="Specify a particular index to query", required=false)
    private String index;
    @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate", required=true)
    private String featureName;
    @Parameter(names={"-c", "--catalog"}, description="Catalog table for GeoMesa datastore", required=true)
    private String catalog;
    @Parameter(names={"-a", "--attributes"}, description="Attributes from feature to export (comma-separated)...Comma-separated expressions with each in the format attribute[=filter_function_expression]|derived-attribute=filter_function_expression|'id'. 'id' will export the feature ID, filter_function_expression is an expression of filter function applied to attributes, literals and filter functions, i.e. can be nested")
    private List<String> attributes;
    @Parameter(names={"-o", "--output"}, description="Output to a file instead of std out")
    private File file;
    @Parameter(names={"--gzip"}, description="Level of gzip compression to apply to output, from 1-9")
    private Integer gzip;
    @Parameter(names={"-F", "--output-format"}, description="File format of output files (csv|tsv|gml|json|shp|avro)")
    private String outputFormat;
    @Parameter(names={"--no-header"}, description="Export as a delimited text format (csv|tsv) without a type header", required=false)
    private boolean noHeader;
    @Parameter(names={"-m", "--max-features"}, description="Maximum number of features to return. default: Unlimited")
    private Integer maxFeatures;
    @Parameter(names={"--hints"}, description="Query hints to set, in the form key1=value1;key2=value2", required=false, converter=ParameterConverters.HintConverter.class)
    private Map<String, String> hints;
    @Parameter(names={"-q", "--cql"}, description="CQL predicate")
    private String cqlFilter;

    public String idAttribute() {
        return this.idAttribute;
    }

    public void idAttribute_$eq(String x$1) {
        this.idAttribute = x$1;
    }

    public String geomAttribute() {
        return this.geomAttribute;
    }

    public void geomAttribute_$eq(String x$1) {
        this.geomAttribute = x$1;
    }

    public String labelAttribute() {
        return this.labelAttribute;
    }

    public void labelAttribute_$eq(String x$1) {
        this.labelAttribute = x$1;
    }

    public String dateAttribute() {
        return this.dateAttribute;
    }

    public void dateAttribute_$eq(String x$1) {
        this.dateAttribute = x$1;
    }

    public String index() {
        return this.index;
    }

    public void index_$eq(String x$1) {
        this.index = x$1;
    }

    public Option<GeoMesaFeatureIndex<?, ?, ?>> loadIndex(GeoMesaDataStore<?, ?, ?> ds, IndexMode.IndexMode mode) throws ParameterException {
        return OptionalIndexParam.class.loadIndex((OptionalIndexParam)this, ds, (IndexMode.IndexMode)mode);
    }

    public String featureName() {
        return this.featureName;
    }

    public void featureName_$eq(String x$1) {
        this.featureName = x$1;
    }

    public String catalog() {
        return this.catalog;
    }

    public void catalog_$eq(String x$1) {
        this.catalog = x$1;
    }

    public List<String> attributes() {
        return this.attributes;
    }

    public void attributes_$eq(List<String> x$1) {
        this.attributes = x$1;
    }

    public File file() {
        return this.file;
    }

    public void file_$eq(File x$1) {
        this.file = x$1;
    }

    public Integer gzip() {
        return this.gzip;
    }

    public void gzip_$eq(Integer x$1) {
        this.gzip = x$1;
    }

    public String outputFormat() {
        return this.outputFormat;
    }

    public void outputFormat_$eq(String x$1) {
        this.outputFormat = x$1;
    }

    public boolean noHeader() {
        return this.noHeader;
    }

    public void noHeader_$eq(boolean x$1) {
        this.noHeader = x$1;
    }

    public Integer maxFeatures() {
        return this.maxFeatures;
    }

    public void maxFeatures_$eq(Integer x$1) {
        this.maxFeatures = x$1;
    }

    public Map<String, String> hints() {
        return this.hints;
    }

    public void hints_$eq(Map<String, String> x$1) {
        this.hints = x$1;
    }

    public String cqlFilter() {
        return this.cqlFilter;
    }

    public void cqlFilter_$eq(String x$1) {
        this.cqlFilter = x$1;
    }

    public HBaseBinExportParams() {
        OptionalCqlFilterParam.class.$init$((OptionalCqlFilterParam)this);
        FileExportParams.class.$init$((FileExportParams)this);
        ExportParams.class.$init$((ExportParams)this);
        CatalogParam.class.$init$((CatalogParam)this);
        RequiredTypeNameParam.class.$init$((RequiredTypeNameParam)this);
        OptionalIndexParam.class.$init$((OptionalIndexParam)this);
        BinExportCommand.BinExportParams.class.$init$((BinExportCommand.BinExportParams)this);
    }
}

