/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.grid;

import java.util.HashMap;
import java.util.logging.Logger;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.grid.GridFeatureBuilder;
import org.geotools.grid.Neighbor;
import org.geotools.grid.PolygonElement;

public abstract class PolygonBuilder {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.grid");
    protected final ReferencedEnvelope gridBounds;

    public PolygonBuilder(ReferencedEnvelope gridBounds) {
        this.gridBounds = gridBounds;
    }

    public boolean buildGrid(GridFeatureBuilder gridFeatureBuilder, double vertexSpacing, ListFeatureCollection fc) {
        PolygonElement el0;
        boolean result = true;
        boolean densify = this.isValidDenseVertexSpacing(vertexSpacing);
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(gridFeatureBuilder.getType());
        String geomPropName = gridFeatureBuilder.getType().getGeometryDescriptor().getLocalName();
        PolygonElement el = el0 = this.getFirstElement();
        while (el.getBounds().getMinY() <= this.gridBounds.getMaxY()) {
            while (el.getBounds().getMaxX() <= this.gridBounds.getMaxX()) {
                if (this.gridBounds.contains(el.getBounds()) && gridFeatureBuilder.getCreateFeature(el)) {
                    HashMap<String, Object> attrMap = new HashMap<String, Object>();
                    gridFeatureBuilder.setAttributes(el, attrMap);
                    if (densify) {
                        fb.set(geomPropName, (Object)el.toDenseGeometry(vertexSpacing));
                    } else {
                        fb.set(geomPropName, (Object)el.toGeometry());
                    }
                    for (String propName : attrMap.keySet()) {
                        fb.set(propName, attrMap.get(propName));
                    }
                    fc.add(fb.buildFeature(gridFeatureBuilder.getFeatureID(el)));
                }
                el = this.getNextXElement(el);
            }
            el = el0 = this.getNextYElement(el0);
        }
        return result;
    }

    public abstract boolean isValidNeighbor(Neighbor var1);

    public abstract PolygonElement createNeighbor(PolygonElement var1, Neighbor var2);

    public abstract PolygonElement getFirstElement();

    public abstract PolygonElement getNextXElement(PolygonElement var1);

    public abstract PolygonElement getNextYElement(PolygonElement var1);

    public abstract boolean isValidDenseVertexSpacing(double var1);
}

