/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.vectorbin;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import it.geosolutions.jaiext.vectorbin.AbstractLiteIterator;
import java.awt.geom.AffineTransform;

public final class PolygonIterator
extends AbstractLiteIterator {
    private AffineTransform at;
    private LineString[] rings;
    private int currentRing = 0;
    private int currentCoord = 0;
    private CoordinateSequence coords = null;
    private boolean done = false;

    public PolygonIterator(Polygon p, AffineTransform at) {
        int numInteriorRings = p.getNumInteriorRing();
        this.rings = new LineString[numInteriorRings + 1];
        this.rings[0] = p.getExteriorRing();
        for (int i = 0; i < numInteriorRings; ++i) {
            this.rings[i + 1] = p.getInteriorRingN(i);
        }
        if (at == null) {
            at = new AffineTransform();
        }
        this.at = at;
        this.coords = this.rings[0].getCoordinateSequence();
    }

    public int currentSegment(double[] coords) {
        if (this.currentCoord == this.coords.size()) {
            return 4;
        }
        if (this.currentCoord == 0) {
            coords[0] = this.coords.getX(0);
            coords[1] = this.coords.getY(0);
            this.transform(coords, 0, coords, 0, 1);
            return 0;
        }
        coords[0] = this.coords.getX(this.currentCoord);
        coords[1] = this.coords.getY(this.currentCoord);
        this.transform(coords, 0, coords, 0, 1);
        return 1;
    }

    protected void transform(double[] src, int index, double[] dest, int destIndex, int numPoints) {
        this.at.transform(src, index, dest, destIndex, numPoints);
    }

    public int getWindingRule() {
        return 0;
    }

    public boolean isDone() {
        return this.done;
    }

    public void next() {
        if (this.currentCoord == this.coords.size()) {
            if (this.currentRing < this.rings.length - 1) {
                this.currentCoord = 0;
                ++this.currentRing;
                this.coords = this.rings[this.currentRing].getCoordinateSequence();
            } else {
                this.done = true;
            }
        } else {
            ++this.currentCoord;
        }
    }
}

