/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ows;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.ows.DelegateHTTPClient;
import org.geotools.data.ows.DelegateHTTPResponse;
import org.geotools.data.ows.HTTPClient;
import org.geotools.data.ows.HTTPResponse;

public class LoggingHTTPClient
extends DelegateHTTPClient {
    private String charsetName;
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.ows.httpclient");

    public LoggingHTTPClient(HTTPClient delegate) {
        this(delegate, "UTF-8");
    }

    public LoggingHTTPClient(HTTPClient delegate, String charsetName) {
        super(delegate);
        this.charsetName = charsetName;
    }

    @Override
    public HTTPResponse post(URL url, InputStream postContent, String postContentType) throws IOException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            LoggingHTTPClient.copy(postContent, out);
            LOGGER.finest("POST Request URL: " + url);
            LOGGER.finest("POST Request Body: \n" + out.toString(this.charsetName));
            return new LoggingHTTPResponse(this.delegate.post(url, new ByteArrayInputStream(out.toByteArray()), postContentType), this.charsetName);
        }
        return this.delegate.post(url, postContent, postContentType);
    }

    @Override
    public HTTPResponse get(URL url) throws IOException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("GET Request URL: " + url);
            return new LoggingHTTPResponse(this.delegate.get(url), this.charsetName);
        }
        return this.delegate.get(url);
    }

    public static void copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
    }

    class LoggingHTTPResponse
    extends DelegateHTTPResponse {
        private InputStream input;

        public LoggingHTTPResponse(HTTPResponse delegate, String charsetName) throws IOException {
            super(delegate);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            LoggingHTTPClient.copy(delegate.getResponseStream(), output);
            LOGGER.finest("Response: \n" + output.toString(charsetName));
            this.input = new ByteArrayInputStream(output.toByteArray());
        }

        @Override
        public InputStream getResponseStream() throws IOException {
            return this.input;
        }
    }
}

