/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.metadata.AbstractMetadata;
import org.geotools.metadata.MetadataStandard;
import org.geotools.metadata.UnmodifiableMetadataException;
import org.geotools.resources.UnmodifiableArrayList;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.CheckedArrayList;
import org.geotools.util.CheckedHashSet;
import org.geotools.util.logging.Logging;

public abstract class ModifiableMetadata
extends AbstractMetadata
implements Cloneable {
    private static final ModifiableMetadata FREEZING = new Null();
    private transient ModifiableMetadata unmodifiable;

    protected ModifiableMetadata() {
    }

    protected ModifiableMetadata(Object source) throws ClassCastException, UnmodifiableMetadataException {
        super(source);
    }

    @Override
    public final boolean isModifiable() {
        return this.unmodifiable != this;
    }

    public synchronized AbstractMetadata unmodifiable() {
        if (this.unmodifiable == null) {
            ModifiableMetadata candidate;
            try {
                candidate = this.clone();
            }
            catch (CloneNotSupportedException exception) {
                Logging.unexpectedException(LOGGER, exception);
                return this;
            }
            candidate.freeze();
            this.unmodifiable = candidate;
        }
        assert (!this.unmodifiable.isModifiable());
        return this.unmodifiable;
    }

    /*
     * WARNING - void declaration
     */
    static Object unmodifiable(Object object) {
        if (object instanceof ModifiableMetadata) {
            return ((ModifiableMetadata)object).unmodifiable();
        }
        if (object instanceof Collection) {
            Collection<Object> collection = (UnmodifiableArrayList<Object>)object;
            if (collection.isEmpty()) {
                collection = collection instanceof List ? Collections.EMPTY_LIST : Collections.EMPTY_SET;
            } else {
                void var3_6;
                Object[] array = collection.toArray();
                boolean bl = false;
                while (var3_6 < array.length) {
                    array[var3_6] = ModifiableMetadata.unmodifiable(array[var3_6]);
                    ++var3_6;
                }
                collection = UnmodifiableArrayList.wrap(array);
                if (collection instanceof Set) {
                    collection = Collections.unmodifiableSet(new LinkedHashSet<Object>(collection));
                }
            }
            return collection;
        }
        if (object instanceof Map) {
            LinkedHashMap map = (LinkedHashMap)object;
            if (map.isEmpty()) {
                return Collections.EMPTY_MAP;
            }
            map = new LinkedHashMap(map);
            for (Map.Entry entry : map.entrySet()) {
                entry.setValue(ModifiableMetadata.unmodifiable(entry.getValue()));
            }
            return Collections.unmodifiableMap(map);
        }
        if (object instanceof org.opengis.util.Cloneable) {
            return ((org.opengis.util.Cloneable)object).clone();
        }
        return object;
    }

    public synchronized void freeze() {
        ModifiableMetadata success = null;
        try {
            this.unmodifiable = FREEZING;
            this.getStandard().freeze(this);
            success = this;
        }
        finally {
            this.unmodifiable = success;
        }
    }

    protected void checkWritePermission() throws UnmodifiableMetadataException {
        assert (Thread.holdsLock(this));
        if (!this.isModifiable()) {
            throw new UnmodifiableMetadataException(Errors.format(190));
        }
        this.invalidate();
    }

    @Override
    final void invalidate() {
        super.invalidate();
        this.unmodifiable = null;
    }

    private static boolean isModifiable(Collection collection) {
        if (!collection.isEmpty()) {
            try {
                collection.clear();
                return true;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return false;
    }

    protected final <E> List<E> copyList(Collection<? extends E> source, List<E> target, Class<E> elementType) throws UnmodifiableMetadataException {
        if (this.unmodifiable == FREEZING) {
            assert (!ModifiableMetadata.isModifiable(source));
            List unmodifiable = (List)source;
            return unmodifiable;
        }
        this.checkWritePermission();
        if (source != target) {
            if (source == null) {
                if (target != null) {
                    target.clear();
                }
            } else {
                if (target != null) {
                    target.clear();
                } else {
                    int capacity = source.size();
                    target = new MutableList<E>(elementType, capacity);
                }
                target.addAll(source);
            }
        }
        return target;
    }

    protected final <E> Collection<E> copyCollection(Collection<? extends E> source, Collection<E> target, Class<E> elementType) throws UnmodifiableMetadataException {
        if (this.unmodifiable == FREEZING) {
            assert (!ModifiableMetadata.isModifiable(source));
            Collection<E> unmodifiable = source;
            return unmodifiable;
        }
        this.checkWritePermission();
        if (source != target) {
            if (source == null) {
                if (target != null) {
                    target.clear();
                }
            } else {
                boolean isList = source instanceof List;
                if (target != null && target instanceof List == isList) {
                    target.clear();
                } else {
                    int capacity = source.size();
                    if (isList) {
                        target = new MutableList<E>(elementType, capacity);
                    } else {
                        capacity = Math.round((float)capacity / 0.75f) + 1;
                        target = new MutableSet<E>(elementType, capacity);
                    }
                }
                target.addAll(source);
            }
        }
        return target;
    }

    protected final <E> Collection<E> nonNullCollection(Collection<E> c, Class<E> elementType) {
        assert (Thread.holdsLock(this));
        if (c != null) {
            return c;
        }
        if (this.isModifiable()) {
            return new MutableSet<E>(elementType);
        }
        return Collections.emptySet();
    }

    protected final <E> Set<E> nonNullSet(Set<E> c, Class<E> elementType) {
        assert (Thread.holdsLock(this));
        if (c != null) {
            return c;
        }
        if (this.isModifiable()) {
            return new MutableSet<E>(elementType);
        }
        return Collections.emptySet();
    }

    protected final <E> List<E> nonNullList(List<E> c, Class<E> elementType) {
        assert (Thread.holdsLock(this));
        if (c != null) {
            return c;
        }
        if (this.isModifiable()) {
            return new MutableList<E>(elementType);
        }
        return Collections.emptyList();
    }

    protected ModifiableMetadata clone() throws CloneNotSupportedException {
        return (ModifiableMetadata)super.clone();
    }

    private final class MutableList<E>
    extends CheckedArrayList<E> {
        private static final long serialVersionUID = -5016778173550153002L;

        public MutableList(Class<E> type) {
            super(type);
        }

        public MutableList(Class<E> type, int capacity) {
            super(type, capacity);
        }

        @Override
        protected Object getLock() {
            return ModifiableMetadata.this;
        }

        @Override
        protected void checkWritePermission() throws UnsupportedOperationException {
            ModifiableMetadata.this.checkWritePermission();
        }
    }

    private final class MutableSet<E>
    extends CheckedHashSet<E> {
        private static final long serialVersionUID = 2337350768744454264L;

        public MutableSet(Class<E> type) {
            super(type);
        }

        public MutableSet(Class<E> type, int capacity) {
            super(type, capacity);
        }

        @Override
        protected Object getLock() {
            return ModifiableMetadata.this;
        }

        @Override
        protected void checkWritePermission() throws UnsupportedOperationException {
            ModifiableMetadata.this.checkWritePermission();
        }
    }

    private static final class Null
    extends ModifiableMetadata {
        private Null() {
        }

        @Override
        public MetadataStandard getStandard() {
            return null;
        }
    }
}

