/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid.io.imageio.geotiff;

import it.geosolutions.imageio.plugins.tiff.BaselineTIFFTagSet;
import it.geosolutions.imageio.plugins.tiff.GeoTIFFTagSet;
import it.geosolutions.imageio.plugins.tiff.TIFFTag;
import it.geosolutions.imageio.plugins.tiff.TIFFTagSet;
import java.awt.geom.AffineTransform;
import java.util.Map;
import org.geotools.coverage.grid.io.imageio.geotiff.GeoKeyEntry;
import org.geotools.coverage.grid.io.imageio.geotiff.GeoTiffConstants;
import org.geotools.coverage.grid.io.imageio.geotiff.PixelScale;
import org.geotools.coverage.grid.io.imageio.geotiff.TiePoint;
import org.geotools.util.KeySortedList;
import org.jdom.Content;
import org.jdom.Element;

public class GeoTiffIIOMetadataEncoder {
    public static final String ASCII_SEPARATOR = "|";
    private int numModelTiePoints;
    private TiePoint[] modelTiePoints;
    private PixelScale modelPixelScale;
    private double[] modelTransformation;
    private int numGeoTiffEntries;
    private KeySortedList<Integer, GeoKeyEntry> geoTiffEntries = new KeySortedList();
    private int numGeoTiffDoubleParams;
    private double[] geoTiffDoubleParams = new double[5];
    private int numGeoTiffAsciiParams;
    private StringBuilder geoTiffAsciiParams = new StringBuilder();
    private double noData;
    private boolean isNodataSet = false;
    private Map<String, String> tiffTagsMetadata;
    private boolean isMetadataSet;

    public GeoTiffIIOMetadataEncoder() {
        this(1, 1, 2);
    }

    public GeoTiffIIOMetadataEncoder(int geoTIFFVersion, int keyRevisionMajor, int keyRevisionMinor) {
        this.modelTiePoints = new TiePoint[5];
        this.modelPixelScale = new PixelScale();
        this.modelTransformation = new double[16];
        this.addGeoKeyEntry(geoTIFFVersion, keyRevisionMajor, 1, keyRevisionMinor);
    }

    public static boolean isTiffUShort(int value) {
        return value >= 0 && value <= 65535;
    }

    public int getGeoTIFFVersion() {
        return this.getGeoKeyEntryAt(0).getKeyID();
    }

    public void setGeoTIFFVersion(int version) {
        this.getGeoKeyEntryAt(0).setKeyID(version);
    }

    public int getKeyRevisionMajor() {
        return this.getGeoKeyEntryAt(0).getTiffTagLocation();
    }

    public int getKeyRevisionMinor() {
        return this.getGeoKeyEntryAt(0).getCount();
    }

    public void setKeyRevision(int major, int minor) {
        this.getGeoKeyEntryAt(0).setTiffTagLocation(major);
        this.getGeoKeyEntryAt(0).setCount(minor);
    }

    public double getModelPixelScaleX() {
        return this.modelPixelScale.getScaleX();
    }

    public double getModelPixelScaleY() {
        return this.modelPixelScale.getScaleY();
    }

    public double getModelPixelScaleZ() {
        return this.modelPixelScale.getScaleZ();
    }

    public void setModelPixelScale(double x, double y) {
        this.setModelPixelScale(x, y, 0.0);
    }

    public void setModelPixelScale(double x, double y, double z) {
        if (this.isModelTransformationSet()) {
            throw new IllegalStateException("ModelTransformationTag already set. It is not possible to set the ModelPixelScale.");
        }
        this.modelPixelScale.setScaleX(x);
        this.modelPixelScale.setScaleY(y);
        this.modelPixelScale.setScaleZ(z);
    }

    public int getNumModelTiePoints() {
        return this.numModelTiePoints;
    }

    public TiePoint getModelTiePoint() {
        return this.getModelTiePointAt(0);
    }

    public TiePoint getModelTiePointAt(int index) {
        return this.modelTiePoints[index];
    }

    public void setModelTiePoint(double i, double j, double x, double y) {
        this.setModelTiePoint(i, j, 0.0, x, y, 0.0);
    }

    public void setModelTiePoint(double i, double j, double k, double x, double y, double z) {
        if (this.isModelTransformationSet()) {
            throw new IllegalStateException("ModelTransformationTag already set. It is not possible to set the ModelTiePoint.");
        }
        if (this.getNumModelTiePoints() > 0) {
            this.getModelTiePointAt(0).set(i, j, k, x, y, z);
        } else {
            this.addModelTiePoint(i, j, k, x, y, z);
        }
    }

    public void addModelTiePoint(double i, double j, double x, double y) {
        this.addModelTiePoint(i, j, 0.0, x, y, 0.0);
    }

    public void addModelTiePoint(double i, double j, double k, double x, double y, double z) {
        int numTiePoints = this.numModelTiePoints;
        if (numTiePoints >= this.modelTiePoints.length - 1) {
            TiePoint[] tiePoints = new TiePoint[numTiePoints + 5];
            System.arraycopy(this.modelTiePoints, 0, tiePoints, 0, numTiePoints);
            this.modelTiePoints = tiePoints;
        }
        this.modelTiePoints[numTiePoints] = new TiePoint(i, j, k, x, y, z);
        ++this.numModelTiePoints;
    }

    public int getNumGeoKeyEntries() {
        return this.numGeoTiffEntries;
    }

    public GeoKeyEntry getGeoKeyEntryAt(int index) {
        Object it = this.geoTiffEntries.get(index);
        if (it != null) {
            return (GeoKeyEntry)it;
        }
        return null;
    }

    public GeoKeyEntry getGeoKeyEntry(int keyID) {
        GeoKeyEntry retVal = null;
        if (this.geoTiffEntries.count((Comparable)Integer.valueOf(keyID)) <= 0) {
            return null;
        }
        Object o = this.geoTiffEntries.first((Comparable)Integer.valueOf(keyID));
        if (o != null) {
            retVal = (GeoKeyEntry)o;
        }
        return retVal;
    }

    public boolean hasGeoKeyEntry(int keyID) {
        return this.getGeoKeyEntry(keyID) != null;
    }

    public int getGeoShortParam(int keyID) {
        GeoKeyEntry entry = this.getNonNullGeoKeyEntry(keyID);
        int tag = entry.getTiffTagLocation();
        int value = entry.getValueOffset();
        this.checkParamTag(tag, 0);
        return value;
    }

    public double getGeoDoubleParam(int keyID) {
        GeoKeyEntry entry = this.getNonNullGeoKeyEntry(keyID);
        int tag = entry.getTiffTagLocation();
        int offset = entry.getValueOffset();
        this.checkParamTag(tag, GeoTiffIIOMetadataEncoder.getGeoDoubleParamsTag().getNumber());
        return this.geoTiffDoubleParams[offset];
    }

    public double[] getGeoDoubleParams(int keyID) {
        return this.getGeoDoubleParams(keyID, null);
    }

    public double[] getGeoDoubleParams(int keyID, double[] values) {
        GeoKeyEntry entry = this.getNonNullGeoKeyEntry(keyID);
        int tag = entry.getTiffTagLocation();
        int count = entry.getCount();
        int offset = entry.getValueOffset();
        this.checkParamTag(tag, GeoTiffIIOMetadataEncoder.getGeoDoubleParamsTag().getNumber());
        if (values == null) {
            values = new double[count];
        }
        System.arraycopy(this.geoTiffDoubleParams, offset, values, 0, count);
        return values;
    }

    public String getGeoAsciiParam(int keyID) {
        GeoKeyEntry entry = this.getGeoKeyEntry(keyID);
        if (entry == null) {
            return null;
        }
        int tag = entry.getTiffTagLocation();
        int count = entry.getCount();
        int offset = entry.getValueOffset();
        this.checkParamTag(tag, GeoTiffIIOMetadataEncoder.getGeoAsciiParamsTag().getNumber());
        return this.geoTiffAsciiParams.substring(offset, offset + count);
    }

    public GeoKeyEntry addGeoShortParam(int keyID, int value) {
        return this.addGeoKeyEntry(keyID, 0, 1, value);
    }

    public void addGeoDoubleParam(int keyID, double value) {
        this.addGeoDoubleParamsRef(keyID, 1);
        this.addDoubleParam(value);
    }

    public void addGeoDoubleParams(int keyID, double[] values) {
        this.addGeoDoubleParamsRef(keyID, values.length);
        for (int i = 0; i < values.length; ++i) {
            this.addDoubleParam(values[i]);
        }
    }

    public void addGeoAscii(int keyID, String value) {
        GeoKeyEntry currentEntry = this.getGeoKeyEntry(keyID);
        if (currentEntry != null) {
            String currentGeoAscii = this.getGeoAsciiParam(keyID);
            assert (currentGeoAscii != null);
            int currentLength = currentGeoAscii.length();
            assert (currentEntry.getCount() == currentLength);
            StringBuilder newValue = new StringBuilder(currentGeoAscii);
            if (!currentGeoAscii.endsWith(ASCII_SEPARATOR)) {
                newValue.append(ASCII_SEPARATOR);
            }
            newValue.append(value).append(ASCII_SEPARATOR);
            GeoKeyEntry newEntry = this.updateGeoAsciiParamsRef(keyID, newValue.length(), currentEntry.getValueOffset());
            this.replaceAsciiParam(newValue.toString(), currentEntry.getValueOffset(), currentEntry.getValueOffset() + currentLength);
        } else {
            this.addGeoAsciiParamsRef(keyID, value.length() + 1);
            this.appendAsciiParam(value);
        }
    }

    private GeoKeyEntry updateGeoKeyEntry(int keyID, int tag, int count, int offset) {
        if (!GeoTiffIIOMetadataEncoder.isTiffUShort(keyID)) {
            throw new IllegalArgumentException("keyID is not a TIFF USHORT");
        }
        if (!GeoTiffIIOMetadataEncoder.isTiffUShort(tag)) {
            throw new IllegalArgumentException("tag is not a TIFF USHORT");
        }
        if (!GeoTiffIIOMetadataEncoder.isTiffUShort(count)) {
            throw new IllegalArgumentException("count is not a TIFF USHORT");
        }
        if (!GeoTiffIIOMetadataEncoder.isTiffUShort(offset)) {
            throw new IllegalArgumentException("offset is not a TIFF USHORT");
        }
        GeoKeyEntry element = new GeoKeyEntry(keyID, tag, count, offset);
        int valuesRemoved = this.geoTiffEntries.removeAll((Comparable)Integer.valueOf(keyID));
        assert (valuesRemoved == 1);
        this.geoTiffEntries.add((Comparable)Integer.valueOf(keyID), (Object)element);
        return element;
    }

    private GeoKeyEntry addGeoKeyEntry(int keyID, int tag, int count, int offset) {
        if (!GeoTiffIIOMetadataEncoder.isTiffUShort(keyID)) {
            throw new IllegalArgumentException("keyID is not a TIFF USHORT");
        }
        if (!GeoTiffIIOMetadataEncoder.isTiffUShort(tag)) {
            throw new IllegalArgumentException("tag is not a TIFF USHORT");
        }
        if (!GeoTiffIIOMetadataEncoder.isTiffUShort(count)) {
            throw new IllegalArgumentException("count is not a TIFF USHORT");
        }
        if (!GeoTiffIIOMetadataEncoder.isTiffUShort(offset)) {
            throw new IllegalArgumentException("offset is not a TIFF USHORT");
        }
        int numKeyEntries = this.numGeoTiffEntries++;
        GeoKeyEntry element = new GeoKeyEntry(keyID, tag, count, offset);
        this.geoTiffEntries.add((Comparable)Integer.valueOf(keyID), (Object)element);
        this.getGeoKeyEntryAt(0).setCount(numKeyEntries);
        return element;
    }

    public void assignTo(Element element) {
        if (!element.getName().equals("it_geosolutions_imageioimpl_plugins_tiff_image_1.0")) {
            throw new IllegalArgumentException("root not found: it_geosolutions_imageioimpl_plugins_tiff_image_1.0");
        }
        Element ifd1 = element.getChild("TIFFIFD");
        if (ifd1 == null) {
            throw new IllegalArgumentException("Unable to find child TIFFIFD");
        }
        Element ifd2 = this.createIFD();
        ifd1.setAttribute("tagSets", ifd2.getAttributeValue("tagSets"));
        Element[] childElems = ifd2.getChildren().toArray(new Element[0]);
        for (int i = 0; i < childElems.length; ++i) {
            Element child = childElems[i];
            ifd2.removeContent((Content)child);
            ifd1.addContent((Content)child);
        }
    }

    public Element createRootTree() {
        Element rootElement = new Element("it_geosolutions_imageioimpl_plugins_tiff_image_1.0");
        rootElement.addContent((Content)this.createIFD());
        return rootElement;
    }

    protected static TIFFTag getGeoKeyDirectoryTag() {
        return GeoTIFFTagSet.getInstance().getTag(34735);
    }

    protected static TIFFTag getGeoDoubleParamsTag() {
        return GeoTIFFTagSet.getInstance().getTag(34736);
    }

    protected static TIFFTag getGeoAsciiParamsTag() {
        return GeoTIFFTagSet.getInstance().getTag(34737);
    }

    protected static TIFFTag getModelPixelScaleTag() {
        return GeoTIFFTagSet.getInstance().getTag(33550);
    }

    protected static TIFFTag getModelTiePointTag() {
        return GeoTIFFTagSet.getInstance().getTag(33922);
    }

    protected static TIFFTag getModelTransformationTag() {
        return GeoTIFFTagSet.getInstance().getTag(34264);
    }

    protected static TIFFTag getAsciiTag(String set, int tagID) {
        if (set != null && set.length() > 0) {
            try {
                TagSet tagSet = TagSet.valueOf(set);
                if (tagSet != null) {
                    return tagSet.getTagSet().getTag(tagID);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected static TIFFTag getNoDataTag() {
        return GeoTiffConstants.NODATA_TAG;
    }

    private GeoKeyEntry getNonNullGeoKeyEntry(int keyID) {
        GeoKeyEntry entry = this.getGeoKeyEntry(keyID);
        if (entry == null) {
            throw new IllegalArgumentException("Unable to find an entry for the provided geo key " + keyID);
        }
        return entry;
    }

    private void checkParamTag(int tag, int expectedTag) {
        if (tag != expectedTag) {
            if (expectedTag == 0) {
                throw new IllegalArgumentException("invalid key access, not a GeoTIFF SHORT parameter");
            }
            if (expectedTag == GeoTiffIIOMetadataEncoder.getGeoDoubleParamsTag().getNumber()) {
                throw new IllegalArgumentException("invalid key access, not a GeoTIFF DOUBLE parameter");
            }
            if (expectedTag == GeoTiffIIOMetadataEncoder.getGeoAsciiParamsTag().getNumber()) {
                throw new IllegalArgumentException("invalid key access, not a GeoTIFF ASCII parameter");
            }
            throw new IllegalStateException();
        }
    }

    private void addDoubleParam(double param) {
        int numDoubleParams = this.numGeoTiffDoubleParams;
        if (numDoubleParams >= this.geoTiffDoubleParams.length - 1) {
            double[] doubleParams = new double[numDoubleParams + 5];
            System.arraycopy(this.geoTiffDoubleParams, 0, doubleParams, 0, numDoubleParams);
            this.geoTiffDoubleParams = doubleParams;
        }
        this.geoTiffDoubleParams[numDoubleParams] = param;
        ++this.numGeoTiffDoubleParams;
    }

    private void replaceAsciiParam(String str, int start, int end) {
        this.geoTiffAsciiParams.replace(start, end, str);
    }

    private void appendAsciiParam(String param) {
        this.geoTiffAsciiParams.append(param);
        this.geoTiffAsciiParams.append('|');
        ++this.numGeoTiffAsciiParams;
    }

    private GeoKeyEntry addGeoDoubleParamsRef(int keyID, int count) {
        return this.addGeoKeyEntry(keyID, GeoTiffIIOMetadataEncoder.getGeoDoubleParamsTag().getNumber(), count, this.getCurrentGeoDoublesOffset());
    }

    private GeoKeyEntry addGeoAsciiParamsRef(int keyID, int length) {
        return this.addGeoKeyEntry(keyID, GeoTiffIIOMetadataEncoder.getGeoAsciiParamsTag().getNumber(), length, this.getCurrentGeoAsciisOffset());
    }

    private GeoKeyEntry updateGeoAsciiParamsRef(int keyID, int length, int offset) {
        return this.updateGeoKeyEntry(keyID, GeoTiffIIOMetadataEncoder.getGeoAsciiParamsTag().getNumber(), length, offset);
    }

    private int getCurrentGeoDoublesOffset() {
        return this.numGeoTiffDoubleParams;
    }

    private int getCurrentGeoAsciisOffset() {
        return this.geoTiffAsciiParams.length();
    }

    private Element createIFD() {
        Element ifd = new Element("TIFFIFD");
        ifd.setAttribute("tagSets", BaselineTIFFTagSet.class.getName() + "," + GeoTIFFTagSet.class.getName());
        if (this.modelPixelScale.isSet()) {
            ifd.addContent((Content)this.createModelPixelScaleElement());
        }
        if (this.isModelTiePointsSet()) {
            ifd.addContent((Content)this.createModelTiePointsElement());
        } else if (this.isModelTransformationSet()) {
            ifd.addContent((Content)this.createModelTransformationElement());
        }
        if (this.getNumGeoKeyEntries() > 1) {
            ifd.addContent((Content)this.createGeoKeyDirectoryElement());
        }
        if (this.numGeoTiffDoubleParams > 0) {
            ifd.addContent((Content)this.createGeoDoubleParamsElement());
        }
        if (this.numGeoTiffAsciiParams > 0) {
            ifd.addContent((Content)this.createGeoAsciiParamsElement());
        }
        if (this.isNodataSet) {
            ifd.addContent((Content)this.createNoDataElement());
        }
        if (this.isMetadataSet) {
            this.createMetadataElement(ifd);
        }
        return ifd;
    }

    private boolean isModelTiePointsSet() {
        return this.numModelTiePoints > 0;
    }

    private boolean isModelTransformationSet() {
        for (int i = 0; i < this.modelTransformation.length; ++i) {
            if (this.modelTransformation[i] == 0.0) continue;
            return true;
        }
        return false;
    }

    public void setModelTransformation(AffineTransform rasterToModel) {
        if (this.modelPixelScale != null && this.modelPixelScale.isSet()) {
            throw new IllegalStateException("ModelPixelScaleTag already set. It is not possible to set the ModelTransformation.");
        }
        if (this.isModelTiePointsSet()) {
            throw new IllegalStateException("ModelTiePointsTag already set. It is not possible to set the ModelTransformation.");
        }
        this.modelTransformation[0] = rasterToModel.getScaleX();
        this.modelTransformation[1] = rasterToModel.getShearX();
        this.modelTransformation[2] = 0.0;
        this.modelTransformation[3] = rasterToModel.getTranslateX();
        this.modelTransformation[4] = rasterToModel.getShearY();
        this.modelTransformation[5] = rasterToModel.getScaleY();
        this.modelTransformation[6] = 0.0;
        this.modelTransformation[7] = rasterToModel.getTranslateY();
        this.modelTransformation[8] = 0.0;
        this.modelTransformation[9] = 0.0;
        this.modelTransformation[10] = 0.0;
        this.modelTransformation[11] = 0.0;
        this.modelTransformation[12] = 0.0;
        this.modelTransformation[13] = 0.0;
        this.modelTransformation[14] = 0.0;
        this.modelTransformation[15] = 1.0;
    }

    private Element createGeoKeyDirectoryElement() {
        Element field = this.createFieldElement(GeoTiffIIOMetadataEncoder.getGeoKeyDirectoryTag());
        Element data = new Element("TIFFShorts");
        field.addContent((Content)data);
        int[] values = this.getGeoKeyEntryAt(0).getValues();
        data.addContent((Content)this.createShortElement(values[0]));
        data.addContent((Content)this.createShortElement(values[1]));
        data.addContent((Content)this.createShortElement(values[3]));
        data.addContent((Content)this.createShortElement(values[2]));
        for (int i = 1; i < this.numGeoTiffEntries; ++i) {
            values = this.getGeoKeyEntryAt(i).getValues();
            int lenght = values.length;
            for (int j = 0; j < lenght; ++j) {
                Element GeoKeyRecord = this.createShortElement(values[j]);
                data.addContent((Content)GeoKeyRecord);
            }
        }
        return field;
    }

    private Element createGeoDoubleParamsElement() {
        Element field = this.createFieldElement(GeoTiffIIOMetadataEncoder.getGeoDoubleParamsTag());
        Element data = new Element("TIFFDoubles");
        field.addContent((Content)data);
        for (int i = 0; i < this.numGeoTiffDoubleParams; ++i) {
            Element param = this.createDoubleElement(this.geoTiffDoubleParams[i]);
            data.addContent((Content)param);
        }
        return field;
    }

    private Element createGeoAsciiParamsElement() {
        Element field = this.createFieldElement(GeoTiffIIOMetadataEncoder.getGeoAsciiParamsTag());
        Element data = new Element("TIFFAsciis");
        field.addContent((Content)data);
        data.addContent((Content)this.createAsciiElement(this.geoTiffAsciiParams.toString()));
        return field;
    }

    private Element createModelPixelScaleElement() {
        Element field = this.createFieldElement(GeoTiffIIOMetadataEncoder.getModelPixelScaleTag());
        Element data = new Element("TIFFDoubles");
        field.addContent((Content)data);
        this.addDoubleElements(data, this.modelPixelScale.getValues());
        return field;
    }

    private Element createModelTransformationElement() {
        Element field = this.createFieldElement(GeoTiffIIOMetadataEncoder.getModelTransformationTag());
        Element data = new Element("TIFFDoubles");
        field.addContent((Content)data);
        this.addDoubleElements(data, this.modelTransformation);
        return field;
    }

    private Element createModelTiePointsElement() {
        Element field = this.createFieldElement(GeoTiffIIOMetadataEncoder.getModelTiePointTag());
        Element data = new Element("TIFFDoubles");
        field.addContent((Content)data);
        for (int i = 0; i < this.numModelTiePoints; ++i) {
            this.addDoubleElements(data, this.modelTiePoints[i].getData());
        }
        return field;
    }

    private Element createNoDataElement() {
        Element field = this.createFieldElement(GeoTiffIIOMetadataEncoder.getNoDataTag());
        Element data = new Element("TIFFAsciis");
        field.addContent((Content)data);
        data.addContent((Content)this.createAsciiElement(Double.toString(this.noData)));
        return field;
    }

    private void createMetadataElement(Element ifd) {
        if (ifd != null && this.tiffTagsMetadata != null && !this.tiffTagsMetadata.isEmpty()) {
            for (String key : this.tiffTagsMetadata.keySet()) {
                String keyName;
                String[] setIdPair = key.split(":");
                String set = TagSet.BASELINE.toString();
                if (setIdPair.length > 1) {
                    set = setIdPair[0].toUpperCase();
                }
                if (!GeoTiffConstants.isNumeric(keyName = setIdPair[setIdPair.length - 1])) continue;
                String value = this.tiffTagsMetadata.get(key);
                TIFFTag tag = GeoTiffIIOMetadataEncoder.getAsciiTag(set, Integer.valueOf(keyName));
                if (tag == null) continue;
                Element field = this.createFieldElement(tag);
                Element data = new Element("TIFFAsciis");
                field.addContent((Content)data);
                data.addContent((Content)this.createAsciiElement(value));
                ifd.addContent((Content)field);
            }
        }
    }

    private Element createFieldElement(TIFFTag tag) {
        Element field = new Element("TIFFField");
        field.setAttribute("number", String.valueOf(tag.getNumber()));
        field.setAttribute("name", tag.getName());
        return field;
    }

    private Element createShortElement(int value) {
        Element GeoKeyRecord = new Element("TIFFShort");
        GeoKeyRecord.setAttribute("value", String.valueOf(value));
        return GeoKeyRecord;
    }

    private Element createDoubleElement(double value) {
        Element param = new Element("TIFFDouble");
        param.setAttribute("value", String.valueOf(value));
        return param;
    }

    private Element createAsciiElement(String value) {
        Element param = new Element("TIFFAscii");
        param.setAttribute("value", String.valueOf(value));
        return param;
    }

    private void addDoubleElements(Element data, double[] values) {
        int length = values.length;
        for (int j = 0; j < length; ++j) {
            Element GeoKeyRecord = this.createDoubleElement(values[j]);
            data.addContent((Content)GeoKeyRecord);
        }
    }

    public double getNoData() {
        return this.noData;
    }

    public void setNoData(double noData) {
        this.noData = noData;
        this.isNodataSet = true;
    }

    public void setTiffTagsMetadata(Map<String, String> metadata) {
        this.tiffTagsMetadata = metadata;
        this.isMetadataSet = true;
    }

    public static enum TagSet {
        BASELINE{

            @Override
            TIFFTagSet getTagSet() {
                return BaselineTIFFTagSet.getInstance();
            }
        }
        ,
        GEOTIFF{

            @Override
            TIFFTagSet getTagSet() {
                return GeoTIFFTagSet.getInstance();
            }
        };


        abstract TIFFTagSet getTagSet();

        public static TIFFTagSet getDefault() {
            return BASELINE.getTagSet();
        }
    }
}

