/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm.distance;

import com.vividsolutions.jts.algorithm.distance.PointPairDistance;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;

public class DistanceToPoint {
    private static LineSegment tempSegment = new LineSegment();

    public static void computeDistance(Geometry geom, Coordinate pt, PointPairDistance ptDist) {
        if (geom instanceof LineString) {
            DistanceToPoint.computeDistance((LineString)geom, pt, ptDist);
        } else if (geom instanceof Polygon) {
            DistanceToPoint.computeDistance((Polygon)geom, pt, ptDist);
        } else if (geom instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)geom;
            for (int i = 0; i < gc.getNumGeometries(); ++i) {
                Geometry g = gc.getGeometryN(i);
                DistanceToPoint.computeDistance(g, pt, ptDist);
            }
        } else {
            ptDist.setMinimum(geom.getCoordinate(), pt);
        }
    }

    public static void computeDistance(LineString line, Coordinate pt, PointPairDistance ptDist) {
        Coordinate[] coords = line.getCoordinates();
        for (int i = 0; i < coords.length - 1; ++i) {
            tempSegment.setCoordinates(coords[i], coords[i + 1]);
            Coordinate closestPt = tempSegment.closestPoint(pt);
            ptDist.setMinimum(closestPt, pt);
        }
    }

    public static void computeDistance(LineSegment segment, Coordinate pt, PointPairDistance ptDist) {
        Coordinate closestPt = segment.closestPoint(pt);
        ptDist.setMinimum(closestPt, pt);
    }

    public static void computeDistance(Polygon poly, Coordinate pt, PointPairDistance ptDist) {
        DistanceToPoint.computeDistance(poly.getExteriorRing(), pt, ptDist);
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            DistanceToPoint.computeDistance(poly.getInteriorRingN(i), pt, ptDist);
        }
    }
}

