/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.planargraph;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.planargraph.DirectedEdge;
import com.vividsolutions.jts.planargraph.DirectedEdgeStar;
import com.vividsolutions.jts.planargraph.Edge;
import com.vividsolutions.jts.planargraph.GraphComponent;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class Node
extends GraphComponent {
    protected Coordinate pt;
    protected DirectedEdgeStar deStar;

    public static Collection getEdgesBetween(Node node0, Node node1) {
        List edges0 = DirectedEdge.toEdges(node0.getOutEdges().getEdges());
        HashSet commonEdges = new HashSet(edges0);
        List edges1 = DirectedEdge.toEdges(node1.getOutEdges().getEdges());
        commonEdges.retainAll(edges1);
        return commonEdges;
    }

    public Node(Coordinate pt) {
        this(pt, new DirectedEdgeStar());
    }

    public Node(Coordinate pt, DirectedEdgeStar deStar) {
        this.pt = pt;
        this.deStar = deStar;
    }

    public Coordinate getCoordinate() {
        return this.pt;
    }

    public void addOutEdge(DirectedEdge de) {
        this.deStar.add(de);
    }

    public DirectedEdgeStar getOutEdges() {
        return this.deStar;
    }

    public int getDegree() {
        return this.deStar.getDegree();
    }

    public int getIndex(Edge edge) {
        return this.deStar.getIndex(edge);
    }

    public void remove(DirectedEdge de) {
        this.deStar.remove(de);
    }

    void remove() {
        this.pt = null;
    }

    public boolean isRemoved() {
        return this.pt == null;
    }
}

