/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.classpath;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2Utils;
import org.apache.commons.compress.compressors.gzip.GzipUtils;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZUtils;
import org.locationtech.geomesa.utils.classpath.PathUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.io.BufferedSource;
import scala.io.Source$;
import scala.util.Try$;

public final class PathUtils$ {
    public static final PathUtils$ MODULE$;
    private final Pattern uriRegex;
    private final boolean hadoopAvailable;

    static {
        new PathUtils$();
    }

    private Pattern uriRegex() {
        return this.uriRegex;
    }

    private boolean hadoopAvailable() {
        return this.hadoopAvailable;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<File> interpretPath(String path) {
        Tuple2 tuple22;
        List list;
        int firstWildcard = path.indexOf(42);
        if (firstWildcard == -1) {
            list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{new File(path)}));
            return list;
        }
        int lastSep = path.length() - 1 - ((String)new StringOps(Predef$.MODULE$.augmentString(path)).reverse()).indexOf(47, path.length() - firstWildcard - 1);
        Tuple2 tuple2 = lastSep == path.length() ? new Tuple2((Object)new File(".").toPath(), (Object)path) : new Tuple2((Object)new File(path.substring(0, lastSep)).toPath(), (Object)path.substring(lastSep + 1));
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Path basepath = (Path)tuple2._1();
        String glob = (String)tuple2._2();
        Tuple2 tuple24 = tuple22 = new Tuple2((Object)basepath, (Object)glob);
        Path basepath2 = (Path)tuple24._1();
        String glob2 = (String)tuple24._2();
        if (glob2.indexOf(47) == -1 && !glob2.contains("**")) {
            DirectoryStream<Path> stream = Files.newDirectoryStream(basepath2, glob2);
            try {
                list = ((TraversableOnce)JavaConversions$.MODULE$.iterableAsScalaIterable(stream).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final File apply(Path x$2) {
                        return x$2.toFile();
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toList();
            }
            catch (Throwable throwable) {
                void var11_11;
                var11_11.close();
                throw throwable;
            }
            stream.close();
            return list;
        }
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher(new StringBuilder().append((Object)"glob:").append((Object)glob2).toString());
        ArrayBuffer result = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(matcher, result){
            private final PathMatcher matcher$1;
            private final ArrayBuffer result$1;

            public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                if (this.matcher$1.matches(file) && attributes.isRegularFile() && !attributes.isDirectory()) {
                    this.result$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{file.toFile()}));
                }
                return FileVisitResult.CONTINUE;
            }
            {
                this.matcher$1 = matcher$1;
                this.result$1 = result$1;
            }
        };
        Files.walkFileTree(basepath2, (FileVisitor<? super Path>)visitor);
        list = result.toList();
        return list;
    }

    public InputStream getInputStream(String path) {
        return this.uriRegex().matcher(path).matches() && this.hadoopAvailable() ? new PathUtils.HadoopDelegate().getInputStream(path) : this.getInputStream(new File(path));
    }

    public InputStream getInputStream(File f) {
        return this.handleCompression(new FileInputStream(f), f.getPath());
    }

    public InputStream handleCompression(InputStream is, String filename) {
        return GzipUtils.isCompressedFilename((String)filename) ? new GZIPInputStream(new BufferedInputStream(is)) : (BZip2Utils.isCompressedFilename((String)filename) ? new BZip2CompressorInputStream((InputStream)new BufferedInputStream(is)) : (XZUtils.isCompressedFilename((String)filename) ? new XZCompressorInputStream((InputStream)new BufferedInputStream(is)) : new BufferedInputStream(is)));
    }

    public BufferedSource getSource(File f) {
        return Source$.MODULE$.fromInputStream(this.getInputStream(f), StandardCharsets.UTF_8.displayName());
    }

    public void deleteRecursively(Path f) {
        Files.walkFileTree(f, new PathUtils.DeleteFileVisitor());
    }

    private PathUtils$() {
        MODULE$ = this;
        this.uriRegex = Pattern.compile("\\w+://.*");
        this.hadoopAvailable = Try$.MODULE$.apply((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Class<Object> apply() {
                return Class.forName("org.apache.hadoop.conf.Configuration");
            }
        }).isSuccess();
    }
}

