/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geotools;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.FeatureUtils$;
import org.locationtech.geomesa.utils.geotools.GeneralShapefileIngest$;
import org.locationtech.geomesa.utils.io.WithClose$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.LongRef;
import scala.runtime.Null$;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class GeneralShapefileIngest$
implements LazyLogging {
    public static final GeneralShapefileIngest$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new GeneralShapefileIngest$();
    }

    private Logger logger$lzycompute() {
        GeneralShapefileIngest$ generalShapefileIngest$ = this;
        synchronized (generalShapefileIngest$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public FileDataStore getShapefileDatastore(String shapefilePath) {
        return shapefilePath.matches("\\w{3,5}:\\/\\/.*$") ? (FileDataStore)DataStoreFinder.getDataStore((java.util.Map)JavaConversions$.MODULE$.mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"url"), (Object)shapefilePath)})))) : FileDataStoreFinder.getDataStore((File)new File(shapefilePath));
    }

    public Tuple2<Object, Object> ingestToDataStore(String shapefilePath, DataStore ds, Option<String> typeName) {
        FileDataStore shapefile = this.getShapefileDatastore(shapefilePath);
        try {
            return this.ingestToDataStore(shapefile.getFeatureSource().getFeatures(), ds, typeName);
        }
        finally {
            if (shapefile != null) {
                shapefile.dispose();
            }
        }
    }

    public Tuple2<Object, Object> ingestToDataStore(SimpleFeatureCollection features, DataStore ds, Option<String> typeName) {
        SimpleFeatureType featureType;
        SimpleFeatureType simpleFeatureType;
        SimpleFeatureType fromCollection = (SimpleFeatureType)typeName.map((Function1)new Serializable(features){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureCollection features$1;

            public final SimpleFeatureType apply(String name2) {
                SimpleFeatureTypeBuilder sftBuilder = new SimpleFeatureTypeBuilder();
                sftBuilder.init((SimpleFeatureType)this.features$1.getSchema());
                sftBuilder.setName(name2);
                return sftBuilder.buildFeatureType();
            }
            {
                this.features$1 = features$1;
            }
        }).getOrElse((Function0)new Serializable(features){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureCollection features$1;

            public final SimpleFeatureType apply() {
                return (SimpleFeatureType)this.features$1.getSchema();
            }
            {
                this.features$1 = features$1;
            }
        });
        SimpleFeatureType existing = (SimpleFeatureType)Try$.MODULE$.apply((Function0)new Serializable(ds, fromCollection){
            public static final long serialVersionUID = 0L;
            private final DataStore ds$1;
            private final SimpleFeatureType fromCollection$1;

            public final SimpleFeatureType apply() {
                return this.ds$1.getSchema(this.fromCollection$1.getTypeName());
            }
            {
                this.ds$1 = ds$1;
                this.fromCollection$1 = fromCollection$1;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        });
        if (existing == null) {
            ds.createSchema((FeatureType)fromCollection);
            simpleFeatureType = ds.getSchema(fromCollection.getTypeName());
        } else {
            simpleFeatureType = existing;
        }
        SimpleFeatureType simpleFeatureType2 = featureType = simpleFeatureType;
        FeatureType featureType2 = features.getSchema();
        Object retype = !(simpleFeatureType2 != null ? !simpleFeatureType2.equals(featureType2) : featureType2 != null) ? new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SimpleFeature apply(SimpleFeature f) {
                return f;
            }
        } : new Serializable(featureType){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType featureType$1;

            /*
             * WARNING - void declaration
             */
            public final SimpleFeature apply(SimpleFeature f) {
                void var2_2;
                SimpleFeature newFeature = DataUtilities.reType((SimpleFeatureType)this.featureType$1, (SimpleFeature)f);
                newFeature.setDefaultGeometry(f.getDefaultGeometry());
                newFeature.getUserData().putAll(f.getUserData());
                return var2_2;
            }
            {
                this.featureType$1 = featureType$1;
            }
        };
        LongRef count2 = LongRef.create((long)0L);
        LongRef failed = LongRef.create((long)0L);
        WithClose$.MODULE$.apply(ds.getFeatureWriterAppend(featureType.getTypeName(), Transaction.AUTO_COMMIT), new Serializable(features, (Function1)retype, count2, failed){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureCollection features$1;
            public final Function1 retype$1;
            public final LongRef count$1;
            public final LongRef failed$1;

            public final void apply(FeatureWriter<SimpleFeatureType, SimpleFeature> writer2) {
                SelfClosingIterator$.MODULE$.apply(this.features$1.features()).foreach((Function1)new Serializable(this, writer2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.ingestToDataStore.1 $outer;
                    private final FeatureWriter writer$1;

                    public final void apply(SimpleFeature feature) {
                        try {
                            FeatureUtils$.MODULE$.copyToWriter((FeatureWriter<SimpleFeatureType, SimpleFeature>)this.writer$1, (SimpleFeature)this.$outer.retype$1.apply((Object)feature), FeatureUtils$.MODULE$.copyToWriter$default$3());
                            this.writer$1.write();
                            ++this.$outer.count$1.elem;
                        }
                        catch (Throwable throwable) {
                            BoxedUnit boxedUnit;
                            Throwable throwable2 = throwable;
                            Option option = NonFatal$.MODULE$.unapply(throwable2);
                            if (option.isEmpty()) {
                                throw throwable;
                            }
                            Throwable e = (Throwable)option.get();
                            if (GeneralShapefileIngest$.MODULE$.logger().underlying().isWarnEnabled()) {
                                GeneralShapefileIngest$.MODULE$.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error writing feature: ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{feature, e})), e);
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            ++this.$outer.failed$1.elem;
                            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.writer$1 = writer$1;
                    }
                });
            }
            {
                this.features$1 = features$1;
                this.retype$1 = retype$1;
                this.count$1 = count$1;
                this.failed$1 = failed$1;
            }
        });
        return new Tuple2.mcJJ.sp(count2.elem, failed.elem);
    }

    private GeneralShapefileIngest$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

