/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geotools;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import scala.Function1;
import scala.MatchError;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.DoubleRef;

@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001B\u0001\u0003\u00015\u0011\u0001b\u0012:jINs\u0017\r\u001d\u0006\u0003\u0007\u0011\t\u0001bZ3pi>|Gn\u001d\u0006\u0003\u000b\u0019\tQ!\u001e;jYNT!a\u0002\u0005\u0002\u000f\u001d,w.\\3tC*\u0011\u0011BC\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\t\u0011U\u0001!\u0011!Q\u0001\nY\t1!\u001a8w!\t9\u0002%D\u0001\u0019\u0015\tI\"$\u0001\u0003hK>l'BA\u000e\u001d\u0003\rQGo\u001d\u0006\u0003;y\taB^5wS\u0012\u001cx\u000e\\;uS>t7OC\u0001 \u0003\r\u0019w.\\\u0005\u0003Ca\u0011\u0001\"\u00128wK2|\u0007/\u001a\u0005\tG\u0001\u0011\t\u0011)A\u0005I\u0005)\u0001pU5{KB\u0011q\"J\u0005\u0003MA\u00111!\u00138u\u0011!A\u0003A!A!\u0002\u0013!\u0013!B=TSj,\u0007\"\u0002\u0016\u0001\t\u0003Y\u0013A\u0002\u001fj]&$h\b\u0006\u0003-]=\u0002\u0004CA\u0017\u0001\u001b\u0005\u0011\u0001\"B\u000b*\u0001\u00041\u0002\"B\u0012*\u0001\u0004!\u0003\"\u0002\u0015*\u0001\u0004!\u0003\u0002\u0003\u001a\u0001\u0011\u000b\u0007I\u0011A\u001a\u0002\u0011\u0015tg/\u001a7pa\u0016,\u0012\u0001\u000e\t\u0003/UJ!A\u000e\r\u0003\u0011\u001d+w.\\3uefD\u0001\u0002\u000f\u0001\t\u0002\u0003\u0006K\u0001N\u0001\nK:4X\r\\8qK\u0002BqA\u000f\u0001C\u0002\u0013%1(\u0001\u0003y\u001b&tW#\u0001\u001f\u0011\u0005=i\u0014B\u0001 \u0011\u0005\u0019!u.\u001e2mK\"1\u0001\t\u0001Q\u0001\nq\nQ\u0001_'j]\u0002BqA\u0011\u0001C\u0002\u0013%1(\u0001\u0003y\u001b\u0006D\bB\u0002#\u0001A\u0003%A(A\u0003y\u001b\u0006D\b\u0005C\u0004G\u0001\t\u0007I\u0011B\u001e\u0002\tel\u0015N\u001c\u0005\u0007\u0011\u0002\u0001\u000b\u0011\u0002\u001f\u0002\u000bel\u0015N\u001c\u0011\t\u000f)\u0003!\u0019!C\u0005w\u0005!\u00110T1y\u0011\u0019a\u0005\u0001)A\u0005y\u0005)\u00110T1yA!9a\n\u0001b\u0001\n\u0013Y\u0014A\u00013y\u0011\u0019\u0001\u0006\u0001)A\u0005y\u0005\u0019A\r\u001f\u0011\t\u000fI\u0003!\u0019!C\u0005w\u0005\u0011A-\u001f\u0005\u0007)\u0002\u0001\u000b\u0011\u0002\u001f\u0002\u0007\u0011L\b\u0005C\u0004W\u0001\t\u0007I\u0011B\u001e\u0002\u000fa|eMZ:fi\"1\u0001\f\u0001Q\u0001\nq\n\u0001\u0002_(gMN,G\u000f\t\u0005\b5\u0002\u0011\r\u0011\"\u0003<\u0003\u001dIxJ\u001a4tKRDa\u0001\u0018\u0001!\u0002\u0013a\u0014\u0001C=PM\u001a\u001cX\r\u001e\u0011\t\u000by\u0003A\u0011A0\u0002\u0003a$\"\u0001\u00101\t\u000b\u0005l\u0006\u0019\u0001\u0013\u0002\u0003%DQa\u0019\u0001\u0005\u0002\u0011\f\u0011!\u001f\u000b\u0003y\u0015DQA\u001a2A\u0002\u0011\n\u0011A\u001b\u0005\u0006C\u0002!\t\u0001\u001b\u000b\u0003I%DQAX4A\u0002qBQA\u001a\u0001\u0005\u0002-$\"\u0001\n7\t\u000b\rT\u0007\u0019\u0001\u001f\t\u000b9\u0004A\u0011A8\u0002\tMt\u0017\r\u001d\u000b\u0004aN$\b\u0003B\bryqJ!A\u001d\t\u0003\rQ+\b\u000f\\33\u0011\u0015qV\u000e1\u0001=\u0011\u0015\u0019W\u000e1\u0001=\u0011\u00151\b\u0001\"\u0001x\u00035\u0011'/Z:f]\"\fW\u000eT5oKRI\u00010a\u0003\u0002\u0010\u0005M\u0011q\u0003\t\u0006s\u0006\r\u0011\u0011\u0002\b\u0003u~t!a\u001f@\u000e\u0003qT!! \u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0012bAA\u0001!\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0003\u0003\u000f\u0011\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0004\u0003\u0003\u0001\u0002\u0003B\brI\u0011Ba!!\u0004v\u0001\u0004!\u0013A\u0001=1\u0011\u0019\t\t\"\u001ea\u0001I\u0005\u0011\u0011\u0010\r\u0005\u0007\u0003+)\b\u0019\u0001\u0013\u0002\u0005a\f\u0004BBA\rk\u0002\u0007A%\u0001\u0002zc\u0001")
public class GridSnap {
    private final Envelope env;
    private final int xSize;
    private final int ySize;
    private Geometry envelope;
    private final double xMin;
    private final double xMax;
    private final double yMin;
    private final double yMax;
    private final double dx;
    private final double dy;
    private final double xOffset;
    private final double yOffset;
    private volatile boolean bitmap$0;

    private Geometry envelope$lzycompute() {
        GridSnap gridSnap = this;
        synchronized (gridSnap) {
            if (!this.bitmap$0) {
                this.envelope = GeometryUtils$.MODULE$.geoFactory().toGeometry(this.env);
                this.bitmap$0 = true;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl8 : MonitorExitStatement: MONITOREXIT : var1_1
            this.env = null;
            return this.envelope;
        }
    }

    public Geometry envelope() {
        return this.bitmap$0 ? this.envelope : this.envelope$lzycompute();
    }

    private double xMin() {
        return this.xMin;
    }

    private double xMax() {
        return this.xMax;
    }

    private double yMin() {
        return this.yMin;
    }

    private double yMax() {
        return this.yMax;
    }

    private double dx() {
        return this.dx;
    }

    private double dy() {
        return this.dy;
    }

    private double xOffset() {
        return this.xOffset;
    }

    private double yOffset() {
        return this.yOffset;
    }

    public double x(int i) {
        return this.xOffset() + this.dx() * (double)i;
    }

    public double y(int j) {
        return this.yOffset() + this.dy() * (double)j;
    }

    public int i(double x) {
        int i;
        return x < this.xMin() || x > this.xMax() ? -1 : ((i = (int)package$.MODULE$.floor((x - this.xMin()) / this.dx())) < 0 || i > this.xSize ? -1 : (i == this.xSize ? this.xSize - 1 : i));
    }

    public int j(double y) {
        int i;
        return y < this.yMin() || y > this.yMax() ? -1 : ((i = (int)package$.MODULE$.floor((y - this.yMin()) / this.dy())) < 0 || i > this.ySize ? -1 : (i == this.ySize ? this.ySize - 1 : i));
    }

    public Tuple2<Object, Object> snap(double x, double y) {
        return new Tuple2.mcDD.sp(this.x(this.i(x)), this.y(this.j(y)));
    }

    public Iterator<Tuple2<Object, Object>> bresenhamLine(int x0, int y0, int x1, int y1) {
        Iterator iterator2;
        int deltaX = package$.MODULE$.abs(x1 - x0);
        int deltaY = package$.MODULE$.abs(y1 - y0);
        if (deltaX == 0 && deltaY == 0) {
            iterator2 = scala.package$.MODULE$.Iterator().single((Object)new Tuple2.mcII.sp(x0, y0));
        } else {
            int stepY;
            int stepX = x0 < x1 ? 1 : -1;
            int n = stepY = y0 < y1 ? 1 : -1;
            if (deltaX > deltaY) {
                double deltaError = (double)deltaY / (double)deltaX;
                DoubleRef error = DoubleRef.create((double)0.0);
                iterator2 = scala.package$.MODULE$.Iterator().iterate((Object)new Tuple2.mcII.sp(x0, y0), (Function1)new Serializable(this, stepX, stepY, deltaError, error){
                    public static final long serialVersionUID = 0L;
                    private final int stepX$1;
                    private final int stepY$1;
                    private final double deltaError$1;
                    private final DoubleRef error$1;

                    public final Tuple2<Object, Object> apply(Tuple2<Object, Object> x0$1) {
                        Tuple2<Object, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            Tuple2.mcII.sp sp2;
                            int x = tuple2._1$mcI$sp();
                            int y = tuple2._2$mcI$sp();
                            this.error$1.elem += this.deltaError$1;
                            if (this.error$1.elem >= 0.5) {
                                this.error$1.elem -= 1.0;
                                sp2 = new Tuple2.mcII.sp(x + this.stepX$1, y + this.stepY$1);
                            } else {
                                sp2 = new Tuple2.mcII.sp(x + this.stepX$1, y);
                            }
                            Tuple2.mcII.sp sp3 = sp2;
                            return sp3;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.stepX$1 = stepX$1;
                        this.stepY$1 = stepY$1;
                        this.deltaError$1 = deltaError$1;
                        this.error$1 = error$1;
                    }
                }).take(deltaX);
            } else {
                double deltaError = (double)deltaX / (double)deltaY;
                DoubleRef error = DoubleRef.create((double)0.0);
                iterator2 = scala.package$.MODULE$.Iterator().iterate((Object)new Tuple2.mcII.sp(x0, y0), (Function1)new Serializable(this, stepX, stepY, deltaError, error){
                    public static final long serialVersionUID = 0L;
                    private final int stepX$1;
                    private final int stepY$1;
                    private final double deltaError$2;
                    private final DoubleRef error$2;

                    public final Tuple2<Object, Object> apply(Tuple2<Object, Object> x0$2) {
                        Tuple2<Object, Object> tuple2 = x0$2;
                        if (tuple2 != null) {
                            Tuple2.mcII.sp sp2;
                            int x = tuple2._1$mcI$sp();
                            int y = tuple2._2$mcI$sp();
                            this.error$2.elem += this.deltaError$2;
                            if (this.error$2.elem >= 0.5) {
                                this.error$2.elem -= 1.0;
                                sp2 = new Tuple2.mcII.sp(x + this.stepX$1, y + this.stepY$1);
                            } else {
                                sp2 = new Tuple2.mcII.sp(x, y + this.stepY$1);
                            }
                            Tuple2.mcII.sp sp3 = sp2;
                            return sp3;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.stepX$1 = stepX$1;
                        this.stepY$1 = stepY$1;
                        this.deltaError$2 = deltaError$2;
                        this.error$2 = error$2;
                    }
                }).take(deltaY);
            }
        }
        return iterator2;
    }

    public GridSnap(Envelope env, int xSize, int ySize) {
        this.env = env;
        this.xSize = xSize;
        this.ySize = ySize;
        this.xMin = env.getMinX();
        this.xMax = env.getMaxX();
        this.yMin = env.getMinY();
        this.yMax = env.getMaxY();
        this.dx = (this.xMax() - this.xMin()) / (double)xSize;
        this.dy = (this.yMax() - this.yMin()) / (double)ySize;
        this.xOffset = this.xMin() + this.dx() / (double)2;
        this.yOffset = this.yMin() + this.dy() / (double)2;
    }
}

