/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geotools;

import org.locationtech.geomesa.utils.geotools.AttributeSpec;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureSpec;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureSpecParser;
import org.parboiled.errors.ErrorUtils;
import org.parboiled.errors.InvalidInputError;
import org.parboiled.errors.ParseError;
import org.parboiled.errors.ParsingException;
import org.parboiled.scala.ParsingResult$;
import org.parboiled.scala.package$;
import org.parboiled.scala.parserunners.BasicParseRunner$;
import org.parboiled.scala.parserunners.ReportingParseRunner;
import org.parboiled.scala.parserunners.ReportingParseRunner$;
import org.parboiled.scala.rules.Rule;
import org.parboiled.scala.rules.Rule1;
import org.parboiled.support.MatcherPath;
import org.parboiled.support.ParsingResult;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

public final class SimpleFeatureSpecParser$ {
    public static final SimpleFeatureSpecParser$ MODULE$;
    private final SimpleFeatureSpecParser Parser;
    private final Map<String, String> ReportableParserMessages;

    static {
        new SimpleFeatureSpecParser$();
    }

    private SimpleFeatureSpecParser Parser() {
        return this.Parser;
    }

    public SimpleFeatureSpec parse(String spec2, boolean report) throws ParsingException {
        return this.parse(spec2, this.Parser().spec(), report);
    }

    public AttributeSpec parseAttribute(String spec2, boolean report) throws ParsingException {
        return this.parse(spec2, this.Parser().attribute(), report);
    }

    private <T> T parse(String spec2, Rule1<T> rule, boolean report) {
        if (spec2 == null) {
            throw new IllegalArgumentException("Invalid spec string: null");
        }
        ReportingParseRunner runner = report ? ReportingParseRunner$.MODULE$.apply(rule) : BasicParseRunner$.MODULE$.apply(rule);
        org.parboiled.scala.ParsingResult parsing = runner.run(package$.MODULE$.string2Input(new StringOps(Predef$.MODULE$.augmentString(spec2)).stripMargin('|').replaceAll("\\s*", "")));
        return (T)parsing.result().getOrElse((Function0)new Serializable(report, parsing){
            public static final long serialVersionUID = 0L;
            private final boolean report$1;
            private final org.parboiled.scala.ParsingResult parsing$1;

            public final Nothing$ apply() {
                throw new ParsingException(SimpleFeatureSpecParser$.MODULE$.org$locationtech$geomesa$utils$geotools$SimpleFeatureSpecParser$$constructErrorMessage(this.parsing$1, this.report$1));
            }
            {
                this.report$1 = report$1;
                this.parsing$1 = parsing$1;
            }
        });
    }

    public boolean parse$default$2() {
        return true;
    }

    public boolean parseAttribute$default$2() {
        return true;
    }

    public <T> String org$locationtech$geomesa$utils$geotools$SimpleFeatureSpecParser$$constructErrorMessage(org.parboiled.scala.ParsingResult<T> result, boolean report) {
        ObjectRef fallback$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        return report ? (String)result.parseErrors().collectFirst((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends ParseError, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof InvalidInputError) {
                    String string2;
                    InvalidInputError invalidInputError = (InvalidInputError)A1;
                    Buffer matchers = (Buffer)((SeqLike)JavaConversions$.MODULE$.asScalaBuffer(invalidInputError.getFailedMatchers()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(MatcherPath path) {
                            return SimpleFeatureSpecParser$.MODULE$.org$locationtech$geomesa$utils$geotools$SimpleFeatureSpecParser$$getFailedMatcher(path);
                        }
                    }, Buffer$.MODULE$.canBuildFrom())).distinct();
                    if (matchers.isEmpty()) {
                        string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid spec string at index ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)invalidInputError.getStartIndex())}));
                    } else {
                        String expected = matchers.length() > 1 ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"one of: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{matchers.mkString(", ")})) : (String)matchers.head();
                        string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid spec string at index ", ". Expected ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)invalidInputError.getStartIndex()), expected}));
                    }
                    object = string2;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(ParseError x1) {
                ParseError parseError = x1;
                boolean bl = parseError instanceof InvalidInputError;
                return bl;
            }
        }).getOrElse((Function0)new Serializable(result, fallback$lzy, bitmap$0){
            public static final long serialVersionUID = 0L;
            private final org.parboiled.scala.ParsingResult result$1;
            private final ObjectRef fallback$lzy$1;
            private final VolatileByteRef bitmap$0$1;

            public final String apply() {
                return SimpleFeatureSpecParser$.MODULE$.org$locationtech$geomesa$utils$geotools$SimpleFeatureSpecParser$$fallback$1(this.result$1, this.fallback$lzy$1, this.bitmap$0$1);
            }
            {
                this.result$1 = result$1;
                this.fallback$lzy$1 = fallback$lzy$1;
                this.bitmap$0$1 = bitmap$0$1;
            }
        }) : this.org$locationtech$geomesa$utils$geotools$SimpleFeatureSpecParser$$fallback$1(result, fallback$lzy, bitmap$0);
    }

    public String org$locationtech$geomesa$utils$geotools$SimpleFeatureSpecParser$$getFailedMatcher(MatcherPath path) {
        Option option;
        while (true) {
            if ((option = this.ReportableParserMessages().get((Object)path.element.matcher.getLabel())) instanceof Some) {
                String m;
                Some some = (Some)option;
                String string2 = m = (String)some.x();
                return string2;
            }
            if (!None$.MODULE$.equals(option)) break;
            path = path.parent;
        }
        throw new MatchError((Object)option);
    }

    private Map<String, String> ReportableParserMessages() {
        return this.ReportableParserMessages;
    }

    private final String fallback$lzycompute$1(org.parboiled.scala.ParsingResult result$1, ObjectRef fallback$lzy$1, VolatileByteRef bitmap$0$1) {
        SimpleFeatureSpecParser$ simpleFeatureSpecParser$ = this;
        synchronized (simpleFeatureSpecParser$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                fallback$lzy$1.elem = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid spec string: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ErrorUtils.printParseErrors((ParsingResult)ParsingResult$.MODULE$.unwrap(result$1))}));
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (String)fallback$lzy$1.elem;
        }
    }

    public final String org$locationtech$geomesa$utils$geotools$SimpleFeatureSpecParser$$fallback$1(org.parboiled.scala.ParsingResult result$1, ObjectRef fallback$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.fallback$lzycompute$1(result$1, fallback$lzy$1, bitmap$0$1) : (String)fallback$lzy$1.elem;
    }

    private SimpleFeatureSpecParser$() {
        MODULE$ = this;
        this.Parser = new SimpleFeatureSpecParser();
        this.ReportableParserMessages = (Map)((TraversableLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.Parser().spec()), (Object)"specification"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.Parser().attribute()), (Object)"attribute"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.Parser().org$locationtech$geomesa$utils$geotools$SimpleFeatureSpecParser$$name()), (Object)"attribute name"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.Parser().org$locationtech$geomesa$utils$geotools$SimpleFeatureSpecParser$$mapType()), (Object)"attribute type binding"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.Parser().org$locationtech$geomesa$utils$geotools$SimpleFeatureSpecParser$$listType()), (Object)"attribute type binding"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.Parser().org$locationtech$geomesa$utils$geotools$SimpleFeatureSpecParser$$simpleType()), (Object)"attribute type binding"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.Parser().org$locationtech$geomesa$utils$geotools$SimpleFeatureSpecParser$$geometryType()), (Object)"geometry type binding"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.Parser().org$locationtech$geomesa$utils$geotools$SimpleFeatureSpecParser$$sftOption()), (Object)"feature type option"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.Parser().org$locationtech$geomesa$utils$geotools$SimpleFeatureSpecParser$$attributeOption()), (Object)"attribute option"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.Parser().org$locationtech$geomesa$utils$geotools$SimpleFeatureSpecParser$$default()), (Object)"'*'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.EOI()), (Object)"end of spec")}))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(Tuple2<Rule, String> x0$1) {
                Tuple2<Rule, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    Rule k = (Rule)tuple2._1();
                    String v = (String)tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k.matcher().getLabel()), (Object)v);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom());
    }
}

