/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.stats;

import org.locationtech.geomesa.utils.stats.BinnedStringArray$;
import org.locationtech.geomesa.utils.stats.WholeNumberBinnedArray;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenSeqLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055a\u0001B\u0001\u0003\u00015\u0011\u0011CQ5o]\u0016$7\u000b\u001e:j]\u001e\f%O]1z\u0015\t\u0019A!A\u0003ti\u0006$8O\u0003\u0002\u0006\r\u0005)Q\u000f^5mg*\u0011q\u0001C\u0001\bO\u0016|W.Z:b\u0015\tI!\"\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\f\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0002E\u0002\u0010!Ii\u0011AA\u0005\u0003#\t\u0011ac\u00165pY\u0016tU/\u001c2fe\nKgN\\3e\u0003J\u0014\u0018-\u001f\t\u0003'eq!\u0001F\f\u000e\u0003UQ\u0011AF\u0001\u0006g\u000e\fG.Y\u0005\u00031U\ta\u0001\u0015:fI\u00164\u0017B\u0001\u000e\u001c\u0005\u0019\u0019FO]5oO*\u0011\u0001$\u0006\u0005\n;\u0001\u0011\t\u0011)A\u0005=\u0005\na\u0001\\3oORD\u0007C\u0001\u000b \u0013\t\u0001SCA\u0002J]RL!!\b\u0012\n\u0005\r\u0012!a\u0003\"j]:,G-\u0011:sCfD\u0001\"\n\u0001\u0003\u0002\u0003\u0006IAJ\u0001\ne\u0006<(i\\;oIN\u0004B\u0001F\u0014\u0013%%\u0011\u0001&\u0006\u0002\u0007)V\u0004H.\u001a\u001a\t\u000b)\u0002A\u0011A\u0016\u0002\rqJg.\u001b;?)\raSF\f\t\u0003\u001f\u0001AQ!H\u0015A\u0002yAQ!J\u0015A\u0002\u0019B!\u0002\r\u0001\u0011\u0002#\u001d\r\u0015\"\u00032\u0003\rAHEM\u000b\u0002M!A1\u0007\u0001E\u0001B\u0003&a%\u0001\u0003yII\u0002\u0003\u0002C\u001b\u0001\u0011\u000b\u0007I\u0011\u0002\u001c\u0002\u000bM$\u0018M\u001d;\u0016\u0003IA\u0001\u0002\u000f\u0001\t\u0002\u0003\u0006KAE\u0001\u0007gR\f'\u000f\u001e\u0011\t\u0011i\u0002\u0001R1A\u0005\nY\n1!\u001a8e\u0011!a\u0004\u0001#A!B\u0013\u0011\u0012\u0001B3oI\u0002B\u0001B\u0010\u0001\t\u0006\u0004%IaP\u0001\u0011]>\u0014X.\u00197ju\u0016$G*\u001a8hi\",\u0012A\b\u0005\t\u0003\u0002A\t\u0011)Q\u0005=\u0005\tbn\u001c:nC2L'0\u001a3MK:<G\u000f\u001b\u0011\t\u0011\r\u0003\u0001R1A\u0005\n}\nA\u0002\u001d:fM&DH*\u001a8hi\"D\u0001\"\u0012\u0001\t\u0002\u0003\u0006KAH\u0001\u000eaJ,g-\u001b=MK:<G\u000f\u001b\u0011\t\u0011\u001d\u0003\u0001R1A\u0005\n!\u000ba\u0001\u001d:fM&DX#A%\u0011\u0005){U\"A&\u000b\u00051k\u0015\u0001\u00027b]\u001eT\u0011AT\u0001\u0005U\u00064\u0018-\u0003\u0002\u001b\u0017\"A\u0011\u000b\u0001E\u0001B\u0003&\u0011*A\u0004qe\u00164\u0017\u000e\u001f\u0011\t\u000bM\u0003A\u0011\u000b+\u0002\u001b\r|gN^3siR{Gj\u001c8h)\t)\u0006\f\u0005\u0002\u0015-&\u0011q+\u0006\u0002\u0005\u0019>tw\rC\u0003Z%\u0002\u0007!#A\u0003wC2,X\rC\u0003\\\u0001\u0011EC,A\bd_:4XM\u001d;Ge>lGj\u001c8h)\t\u0011R\fC\u0003Z5\u0002\u0007QkB\u0003`\u0005!\u0005\u0001-A\tCS:tW\rZ*ue&tw-\u0011:sCf\u0004\"aD1\u0007\u000b\u0005\u0011\u0001\u0012\u00012\u0014\u0005\u0005\u001c\u0007C\u0001\u000be\u0013\t)WC\u0001\u0004B]f\u0014VM\u001a\u0005\u0006U\u0005$\ta\u001a\u000b\u0002A\"9\u0011.\u0019b\u0001\n\u0013Q\u0017a\u0003\"bg\u0016\u001cdg\u00115beN,\u0012a\u001b\t\u0004)1t\u0017BA7\u0016\u0005\u0015\t%O]1z!\t!r.\u0003\u0002q+\t!1\t[1s\u0011\u0019\u0011\u0018\r)A\u0005W\u0006a!)Y:fgY\u001a\u0005.\u0019:tA!9A/\u0019b\u0001\n\u0003)\u0018\u0001\u0004\"bg\u0016\u001cd\u0007T8xKN$X#\u00018\t\r]\f\u0007\u0015!\u0003o\u00035\u0011\u0015m]34m1{w/Z:uA!9\u00110\u0019b\u0001\n\u0003)\u0018!\u0004\"bg\u0016\u001cd\u0007S5hQ\u0016\u001cH\u000f\u0003\u0004|C\u0002\u0006IA\\\u0001\u000f\u0005\u0006\u001cXm\r\u001cIS\u001eDWm\u001d;!\u0011\u0015i\u0018\r\"\u0001\u007f\u0003%qwN]7bY&TX\r\u0006\u0002\u0013\u007f\"1\u0011\u0011\u0001?A\u0002I\t\u0011a\u001d\u0005\b\u0003\u000b\tG\u0011AA\u0004\u0003=qwN]7bY&TXMQ8v]\u0012\u001cHc\u0001\u0014\u0002\n!9\u00111BA\u0002\u0001\u00041\u0013A\u00022pk:$7\u000f")
public class BinnedStringArray
extends WholeNumberBinnedArray<String> {
    private Tuple2<String, String> x$2;
    private String start;
    private String end;
    private int normalizedLength;
    private int prefixLength;
    private String prefix;
    private volatile byte bitmap$0;

    public static Tuple2<String, String> normalizeBounds(Tuple2<String, String> tuple2) {
        return BinnedStringArray$.MODULE$.normalizeBounds(tuple2);
    }

    public static String normalize(String string2) {
        return BinnedStringArray$.MODULE$.normalize(string2);
    }

    public static char Base36Highest() {
        return BinnedStringArray$.MODULE$.Base36Highest();
    }

    public static char Base36Lowest() {
        return BinnedStringArray$.MODULE$.Base36Lowest();
    }

    private Tuple2 x$2$lzycompute() {
        BinnedStringArray binnedStringArray = this;
        synchronized (binnedStringArray) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Tuple2 tuple2 = this.bounds();
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    String start = (String)tuple2._1();
                    String end = (String)tuple2._2();
                    this.x$2 = tuple22 = new Tuple2((Object)start, (Object)end);
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                } else {
                    throw new MatchError(tuple2);
                }
            }
            return this.x$2;
        }
    }

    private String start$lzycompute() {
        BinnedStringArray binnedStringArray = this;
        synchronized (binnedStringArray) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.start = (String)this.x$2()._1();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.start;
        }
    }

    private String end$lzycompute() {
        BinnedStringArray binnedStringArray = this;
        synchronized (binnedStringArray) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.end = (String)this.x$2()._2();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.end;
        }
    }

    private int normalizedLength$lzycompute() {
        BinnedStringArray binnedStringArray = this;
        synchronized (binnedStringArray) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.normalizedLength = this.start().length();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.normalizedLength;
        }
    }

    private int prefixLength$lzycompute() {
        BinnedStringArray binnedStringArray = this;
        synchronized (binnedStringArray) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.prefixLength = ((GenSeqLike)new StringOps(Predef$.MODULE$.augmentString(this.start())).zip((GenIterable)Predef$.MODULE$.wrapString(this.end()), Predef$.MODULE$.fallbackStringCanBuildFrom())).indexWhere((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Object, Object> x0$1) {
                        Tuple2<Object, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            char r;
                            char l = tuple2._1$mcC$sp();
                            boolean bl = l != (r = tuple2._2$mcC$sp());
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
            return this.prefixLength;
        }
    }

    private String prefix$lzycompute() {
        BinnedStringArray binnedStringArray = this;
        synchronized (binnedStringArray) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.prefix = this.start().substring(0, this.prefixLength());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
            return this.prefix;
        }
    }

    private /* synthetic */ Tuple2 x$2() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.x$2$lzycompute() : this.x$2;
    }

    private String start() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.start$lzycompute() : this.start;
    }

    private String end() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.end$lzycompute() : this.end;
    }

    private int normalizedLength() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.normalizedLength$lzycompute() : this.normalizedLength;
    }

    private int prefixLength() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.prefixLength$lzycompute() : this.prefixLength;
    }

    private String prefix() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.prefix$lzycompute() : this.prefix;
    }

    @Override
    public long convertToLong(String value2) {
        long l;
        String normalized = (String)new StringOps(Predef$.MODULE$.augmentString(BinnedStringArray$.MODULE$.normalize(value2))).padTo(this.normalizedLength(), (Object)BoxesRunTime.boxToCharacter((char)'0'), Predef$.MODULE$.StringCanBuildFrom());
        if (new StringOps(Predef$.MODULE$.augmentString(normalized)).$less((Object)this.start())) {
            l = 0L;
        } else if (new StringOps(Predef$.MODULE$.augmentString(normalized)).$greater((Object)this.end())) {
            l = Long.MAX_VALUE;
        } else {
            String sigDigits = ((String)new StringOps(Predef$.MODULE$.augmentString(normalized.substring(this.prefixLength()))).padTo(12, (Object)BoxesRunTime.boxToCharacter((char)BinnedStringArray$.MODULE$.Base36Lowest()), Predef$.MODULE$.StringCanBuildFrom())).substring(0, 12);
            l = Long.parseLong(sigDigits, 36);
        }
        return l;
    }

    @Override
    public String convertFromLong(long value2) {
        return new StringBuilder().append((Object)this.prefix()).append((Object)((String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(Long.toString(value2, 36))).reverse())).padTo(12, (Object)BoxesRunTime.boxToCharacter((char)BinnedStringArray$.MODULE$.Base36Lowest()), Predef$.MODULE$.StringCanBuildFrom()))).reverse()).replaceFirst("0+$", "")).toString();
    }

    public BinnedStringArray(int length, Tuple2<String, String> rawBounds) {
        super(length, BinnedStringArray$.MODULE$.normalizeBounds(rawBounds));
    }
}

