/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.stats;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.util.Date;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.locationtech.geomesa.utils.geotools.Conversions$RichGeometry$;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.stats.BinnedArray;
import org.locationtech.geomesa.utils.stats.BinnedArray$;
import org.locationtech.geomesa.utils.stats.BinnedStringArray$;
import org.locationtech.geomesa.utils.stats.MinMax;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;

public final class Histogram$ {
    public static final Histogram$ MODULE$;

    static {
        new Histogram$();
    }

    /*
     * WARNING - void declaration
     */
    public <T> Tuple2<T, T> buffer(T value2) {
        T t;
        block9: {
            void var2_14;
            Tuple2.mcII.sp sp2;
            block3: {
                block8: {
                    block7: {
                        block6: {
                            block5: {
                                block4: {
                                    block2: {
                                        t = value2;
                                        if (!(t instanceof Integer)) break block2;
                                        int n = BoxesRunTime.unboxToInt(t);
                                        sp2 = new Tuple2.mcII.sp(n - 100, n + 100);
                                        break block3;
                                    }
                                    if (!(t instanceof Long)) break block4;
                                    long l = BoxesRunTime.unboxToLong(t);
                                    sp2 = new Tuple2.mcJJ.sp(l - 100L, l + 100L);
                                    break block3;
                                }
                                if (!(t instanceof Float)) break block5;
                                float f = BoxesRunTime.unboxToFloat(t);
                                sp2 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)(f - (float)100)), (Object)BoxesRunTime.boxToFloat((float)(f + (float)100)));
                                break block3;
                            }
                            if (!(t instanceof Double)) break block6;
                            double d = BoxesRunTime.unboxToDouble(t);
                            sp2 = new Tuple2.mcDD.sp(d - (double)100, d + (double)100);
                            break block3;
                        }
                        if (!(t instanceof String)) break block7;
                        String string2 = (String)t;
                        sp2 = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string2, BoxesRunTime.boxToCharacter((char)BinnedStringArray$.MODULE$.Base36Lowest())})), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string2, BoxesRunTime.boxToCharacter((char)BinnedStringArray$.MODULE$.Base36Highest())})));
                        break block3;
                    }
                    if (!(t instanceof Date)) break block8;
                    Date date = (Date)t;
                    sp2 = new Tuple2((Object)new Date(date.getTime() - 60000L), (Object)new Date(date.getTime() + 60000L));
                    break block3;
                }
                if (!(t instanceof Geometry)) break block9;
                Geometry geometry = (Geometry)t;
                Envelope env = Conversions$RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry(geometry)).buffer(10.0).getEnvelopeInternal();
                Point min = GeometryUtils$.MODULE$.geoFactory().createPoint(new Coordinate(env.getMinX(), env.getMinY()));
                Point max = GeometryUtils$.MODULE$.geoFactory().createPoint(new Coordinate(env.getMaxX(), env.getMaxY()));
                sp2 = new Tuple2((Object)min, (Object)max);
            }
            Tuple2.mcII.sp buf = sp2;
            return var2_14;
        }
        throw new MatchError(t);
    }

    public <T> BinnedArray<T> expandBins(T value2, BinnedArray<T> old, MinMax.MinMaxDefaults<T> defaults, ClassTag<T> ct) {
        Object min = defaults.min(value2, old.bounds()._1());
        Object max = defaults.max(value2, old.bounds()._2());
        BinnedArray<T> bins = BinnedArray$.MODULE$.apply(old.length(), new Tuple2(min, max), ct);
        this.copyInto(bins, old);
        return bins;
    }

    public <T> Tuple2<T, T> checkEndpoints(BinnedArray<T> left, BinnedArray<T> right, MinMax.MinMaxDefaults<T> defaults) {
        Tuple2<T, T> tuple2 = this.getActualBounds(left);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Object lMin = tuple2._1();
            Object lMax = tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2(lMin, lMax);
            Object lMin2 = tuple23._1();
            Object lMax2 = tuple23._2();
            Tuple2<T, T> tuple24 = this.getActualBounds(right);
            if (tuple24 != null) {
                Tuple2 tuple25;
                Object rMin = tuple24._1();
                Object rMax = tuple24._2();
                Tuple2 tuple26 = tuple25 = new Tuple2(rMin, rMax);
                Object rMin2 = tuple26._1();
                Object rMax2 = tuple26._2();
                return new Tuple2(defaults.min(lMin2, rMin2), defaults.max(lMax2, rMax2));
            }
            throw new MatchError(tuple24);
        }
        throw new MatchError(tuple2);
    }

    private <T> Tuple2<T, T> getActualBounds(BinnedArray<T> bins) {
        int minIndex = Predef$.MODULE$.longArrayOps(bins.counts()).indexWhere((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(long x$5) {
                return this.apply$mcZJ$sp(x$5);
            }

            public boolean apply$mcZJ$sp(long x$5) {
                return x$5 != 0L;
            }
        });
        int maxIndex = bins.counts().length - Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.longArrayOps(bins.counts()).reverse()).indexWhere((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(long x$6) {
                return this.apply$mcZJ$sp(x$6);
            }

            public boolean apply$mcZJ$sp(long x$6) {
                return x$6 != 0L;
            }
        }) - 1;
        Object min = minIndex <= 0 ? bins.bounds()._1() : bins.bounds(minIndex)._1();
        Object max = maxIndex >= bins.counts().length - 1 ? bins.bounds()._2() : bins.bounds(maxIndex)._2();
        return new Tuple2(min, max);
    }

    public <T> void copyInto(BinnedArray<T> to, BinnedArray<T> from) {
        for (int i = 0; i < from.length(); ++i) {
            long count2 = from.counts()[i];
            if (count2 <= 0L) continue;
            Tuple2<T, T> tuple2 = from.bounds(i);
            if (tuple2 != null) {
                int hi;
                Tuple2 tuple22;
                Object min = tuple2._1();
                Object max = tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2(min, max);
                Object min2 = tuple23._1();
                Object max2 = tuple23._2();
                int lo = this.toIndex$1(min2, to);
                if (lo == (hi = this.toIndex$1(max2, to))) {
                    to.counts()[lo] = to.counts()[lo] + count2;
                    continue;
                }
                int size2 = hi - lo + 1;
                Predef$.MODULE$.require(size2 > 0, (Function0)new Serializable(to, from, min2){
                    public static final long serialVersionUID = 0L;
                    private final BinnedArray to$1;
                    private final BinnedArray from$1;
                    private final Object min$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error calculating bounds for ", " from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.min$1.getClass().getSimpleName(), this.from$1.bounds(), this.to$1.bounds()}));
                    }
                    {
                        this.to$1 = to$1;
                        this.from$1 = from$1;
                        this.min$1 = min$1;
                    }
                });
                long avgCount = count2 / (long)size2;
                long remainingCount = count2 % (long)size2;
                int mid = lo + size2 / 2;
                int j = lo;
                while (j <= hi) {
                    int n = j++;
                    to.counts()[n] = to.counts()[n] + avgCount;
                }
                to.counts()[mid] = to.counts()[mid] + remainingCount;
                continue;
            }
            throw new MatchError(tuple2);
        }
    }

    private final int toIndex$1(Object value2, BinnedArray to$1) {
        int i = to$1.indexOf(value2);
        return i != -1 ? i : (to$1.isBelow(value2) ? 0 : to$1.length() - 1);
    }

    private Histogram$() {
        MODULE$ = this;
    }
}

