/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.stats;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.Arrays;
import org.locationtech.geomesa.utils.stats.BinnedArray;
import org.locationtech.geomesa.utils.stats.BinnedArray$;
import org.locationtech.geomesa.utils.stats.Histogram$;
import org.locationtech.geomesa.utils.stats.MinMax;
import org.locationtech.geomesa.utils.stats.Stat;
import org.locationtech.geomesa.utils.stats.Stat$class;
import org.opengis.feature.simple.SimpleFeature;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.ListMap$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t\u0005b\u0001B\u0001\u0003\u00015\u0011\u0011\u0002S5ti><'/Y7\u000b\u0005\r!\u0011!B:uCR\u001c(BA\u0003\u0007\u0003\u0015)H/\u001b7t\u0015\t9\u0001\"A\u0004hK>lWm]1\u000b\u0005%Q\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0016\u00059!4\u0003\u0002\u0001\u0010+e\u0001\"\u0001E\n\u000e\u0003EQ\u0011AE\u0001\u0006g\u000e\fG.Y\u0005\u0003)E\u0011a!\u00118z%\u00164\u0007C\u0001\f\u0018\u001b\u0005\u0011\u0011B\u0001\r\u0003\u0005\u0011\u0019F/\u0019;\u0011\u0005i\tS\"A\u000e\u000b\u0005qi\u0012\u0001D:dC2\fGn\\4hS:<'B\u0001\u0010 \u0003!!\u0018\u0010]3tC\u001a,'\"\u0001\u0011\u0002\u0007\r|W.\u0003\u0002#7\tYA*\u0019>z\u0019><w-\u001b8h\u0011!!\u0003A!b\u0001\n\u0003)\u0013!C1uiJL'-\u001e;f+\u00051\u0003C\u0001\t(\u0013\tA\u0013CA\u0002J]RD\u0001B\u000b\u0001\u0003\u0002\u0003\u0006IAJ\u0001\u000bCR$(/\u001b2vi\u0016\u0004\u0003\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0014\u0002\u0017%t\u0017\u000e^5bY\nKgn\u001d\u0005\t]\u0001\u0011\t\u0011)A\u0005_\u0005\u0001\u0012N\\5uS\u0006dWI\u001c3q_&tGo\u001d\t\u0005!A\u0012$'\u0003\u00022#\t1A+\u001e9mKJ\u0002\"a\r\u001b\r\u0001\u0011)Q\u0007\u0001b\u0001m\t\tA+\u0005\u00028uA\u0011\u0001\u0003O\u0005\u0003sE\u0011qAT8uQ&tw\r\u0005\u0002\u0011w%\u0011A(\u0005\u0002\u0004\u0003:L\b\u0002\u0003 \u0001\u0005\u000b\u0007I1A \u0002\u0011\u0011,g-Y;miN,\u0012\u0001\u0011\t\u0004\u0003\u0012\u0013dB\u0001\fC\u0013\t\u0019%!\u0001\u0004NS:l\u0015\r_\u0005\u0003\u000b\u001a\u0013a\"T5o\u001b\u0006DH)\u001a4bk2$8O\u0003\u0002D\u0005!A\u0001\n\u0001B\u0001B\u0003%\u0001)A\u0005eK\u001a\fW\u000f\u001c;tA!A!\n\u0001B\u0001B\u0003-1*\u0001\u0002diB\u0019Aj\u0014\u001a\u000e\u00035S!AT\t\u0002\u000fI,g\r\\3di&\u0011\u0001+\u0014\u0002\t\u00072\f7o\u001d+bO\")!\u000b\u0001C\u0001'\u00061A(\u001b8jiz\"B\u0001\u0016-Z5R\u0019QKV,\u0011\u0007Y\u0001!\u0007C\u0003?#\u0002\u000f\u0001\tC\u0003K#\u0002\u000f1\nC\u0003%#\u0002\u0007a\u0005C\u0003-#\u0002\u0007a\u0005C\u0003/#\u0002\u0007q&\u0002\u0003]\u0001\u0001*&!A*\t\u0011y\u0003\u0001\u0019!C\u0001\u0005}\u000bAAY5ogV\t\u0001\rE\u0002\u0017CJJ!A\u0019\u0002\u0003\u0017\tKgN\\3e\u0003J\u0014\u0018-\u001f\u0005\tI\u0002\u0001\r\u0011\"\u0001\u0003K\u0006A!-\u001b8t?\u0012*\u0017\u000f\u0006\u0002gSB\u0011\u0001cZ\u0005\u0003QF\u0011A!\u00168ji\"9!nYA\u0001\u0002\u0004\u0001\u0017a\u0001=%c!1A\u000e\u0001Q!\n\u0001\fQAY5og\u0002BQA\u001c\u0001\u0005\u0002\u0015\na\u0001\\3oORD\u0007\"\u00029\u0001\t\u0003\t\u0018a\u00033je\u0016\u001cG/\u00138eKb$\"A\n:\t\u000bM|\u0007\u0019\u0001;\u0002\u000bY\fG.^3\u0011\u0005A)\u0018B\u0001<\u0012\u0005\u0011auN\\4\t\u000ba\u0004A\u0011A=\u0002\u000f%tG-\u001a=PMR\u0011aE\u001f\u0005\u0006g^\u0004\rA\r\u0005\u0006y\u0002!\t!`\u0001\u0006G>,h\u000e\u001e\u000b\u0003izDQa`>A\u0002\u0019\n\u0011!\u001b\u0005\b\u0003\u0007\u0001A\u0011AA\u0003\u0003\ri\u0017N\\\u000b\u0002e!9\u0011\u0011\u0002\u0001\u0005\u0002\u0005\u0015\u0011aA7bq\"9\u0011Q\u0002\u0001\u0005\u0002\u0005=\u0011A\u00022pk:$7/F\u00010\u0011\u001d\ti\u0001\u0001C\u0001\u0003'!2aLA\u000b\u0011\u0019y\u0018\u0011\u0003a\u0001M!9\u0011\u0011\u0004\u0001\u0005\u0002\u0005m\u0011aC7fI&\fgNV1mk\u0016$2AMA\u000f\u0011\u0019y\u0018q\u0003a\u0001M!9\u0011\u0011\u0005\u0001\u0005\u0002\u0005\r\u0012!D1eI\u000e{WO\u001c;t\rJ|W\u000eF\u0002g\u0003KAq!a\n\u0002 \u0001\u0007Q+A\u0003pi\",'\u000fC\u0004\u0002,\u0001!\t%!\f\u0002\u000f=\u00147/\u001a:wKR\u0019a-a\f\t\u0011\u0005E\u0012\u0011\u0006a\u0001\u0003g\t!a\u001d4\u0011\t\u0005U\u00121I\u0007\u0003\u0003oQA!!\u000f\u0002<\u000511/[7qY\u0016TA!!\u0010\u0002@\u00059a-Z1ukJ,'bAA!\u0015\u00059q\u000e]3oO&\u001c\u0018\u0002BA#\u0003o\u0011QbU5na2,g)Z1ukJ,\u0007bBA%\u0001\u0011\u0005\u00131J\u0001\nk:|'m]3sm\u0016$2AZA'\u0011!\t\t$a\u0012A\u0002\u0005M\u0002bBA)\u0001\u0011\u0005\u00131K\u0001\u0006IAdWo\u001d\u000b\u0004+\u0006U\u0003bBA\u0014\u0003\u001f\u0002\r!\u0016\u0005\b\u00033\u0002A\u0011IA.\u0003!!\u0003\u000f\\;tI\u0015\fHc\u00014\u0002^!9\u0011qEA,\u0001\u0004)\u0006bBA1\u0001\u0011\u0005\u00131M\u0001\ri>T5o\u001c8PE*,7\r^\u000b\u0003\u0003K\u0002r!a\u001a\u0002r\u0005U$(\u0004\u0002\u0002j)!\u00111NA7\u0003%IW.\\;uC\ndWMC\u0002\u0002pE\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019(!\u001b\u0003\u000f1K7\u000f^'baB!\u0011qOAA\u001b\t\tIH\u0003\u0003\u0002|\u0005u\u0014\u0001\u00027b]\u001eT!!a \u0002\t)\fg/Y\u0005\u0005\u0003\u0007\u000bIH\u0001\u0004TiJLgn\u001a\u0005\b\u0003\u000f\u0003A\u0011IAE\u0003\u001dI7/R7qif,\"!a#\u0011\u0007A\ti)C\u0002\u0002\u0010F\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002\u0014\u0002!\t%!&\u0002\u000b\rdW-\u0019:\u0015\u0003\u0019Dq!!'\u0001\t\u0003\nY*\u0001\u0007jg\u0016\u000bX/\u001b<bY\u0016tG\u000f\u0006\u0003\u0002\f\u0006u\u0005bBA\u0014\u0003/\u0003\r!F\u0004\b\u0003C\u0013\u0001\u0012AAR\u0003%A\u0015n\u001d;pOJ\fW\u000eE\u0002\u0017\u0003K3a!\u0001\u0002\t\u0002\u0005\u001d6cAAS\u001f!9!+!*\u0005\u0002\u0005-FCAAR\u0011!\ty+!*\u0005\u0002\u0005E\u0016A\u00022vM\u001a,'/\u0006\u0003\u00024\u0006eF\u0003BA[\u0003w\u0003b\u0001\u0005\u0019\u00028\u0006]\u0006cA\u001a\u0002:\u00121Q'!,C\u0002YBqa]AW\u0001\u0004\t9\f\u0003\u0005\u0002@\u0006\u0015F\u0011AAa\u0003))\u0007\u0010]1oI\nKgn]\u000b\u0005\u0003\u0007\fY\r\u0006\u0004\u0002F\u0006U\u0017q\u001b\u000b\u0007\u0003\u000f\fi-!5\u0011\tY\t\u0017\u0011\u001a\t\u0004g\u0005-GAB\u001b\u0002>\n\u0007a\u0007C\u0004?\u0003{\u0003\u001d!a4\u0011\t\u0005#\u0015\u0011\u001a\u0005\b\u0015\u0006u\u00069AAj!\u0011au*!3\t\u000fM\fi\f1\u0001\u0002J\"A\u0011\u0011\\A_\u0001\u0004\t9-A\u0002pY\u0012D\u0001\"!8\u0002&\u0012\u0005\u0011q\\\u0001\u000fG\",7m[#oIB|\u0017N\u001c;t+\u0011\t\t/!;\u0015\r\u0005\r\u0018q^A{)\u0011\t)/a;\u0011\rA\u0001\u0014q]At!\r\u0019\u0014\u0011\u001e\u0003\u0007k\u0005m'\u0019\u0001\u001c\t\u000fy\nY\u000eq\u0001\u0002nB!\u0011\tRAt\u0011!\t\t0a7A\u0002\u0005M\u0018\u0001\u00027fMR\u0004BAF1\u0002h\"A\u0011q_An\u0001\u0004\t\u00190A\u0003sS\u001eDG\u000f\u0003\u0005\u0002|\u0006\u0015F\u0011BA\u007f\u0003=9W\r^!diV\fGNQ8v]\u0012\u001cX\u0003BA\u0000\u0005\u000b!BA!\u0001\u0003\bA1\u0001\u0003\rB\u0002\u0005\u0007\u00012a\rB\u0003\t\u0019)\u0014\u0011 b\u0001m!9a,!?A\u0002\t%\u0001\u0003\u0002\fb\u0005\u0007A\u0001B!\u0004\u0002&\u0012\u0005!qB\u0001\tG>\u0004\u00180\u00138u_V!!\u0011\u0003B\u000e)\u00151'1\u0003B\u000f\u0011!\u0011)Ba\u0003A\u0002\t]\u0011A\u0001;p!\u00111\u0012M!\u0007\u0011\u0007M\u0012Y\u0002\u0002\u00046\u0005\u0017\u0011\rA\u000e\u0005\t\u0005?\u0011Y\u00011\u0001\u0003\u0018\u0005!aM]8n\u0001")
public class Histogram<T>
implements Stat,
LazyLogging {
    private final int attribute;
    private final MinMax.MinMaxDefaults<T> defaults;
    private final ClassTag<T> ct;
    private BinnedArray<T> bins;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static <T> void copyInto(BinnedArray<T> binnedArray, BinnedArray<T> binnedArray2) {
        Histogram$.MODULE$.copyInto(binnedArray, binnedArray2);
    }

    public static <T> Tuple2<T, T> checkEndpoints(BinnedArray<T> binnedArray, BinnedArray<T> binnedArray2, MinMax.MinMaxDefaults<T> minMaxDefaults) {
        return Histogram$.MODULE$.checkEndpoints(binnedArray, binnedArray2, minMaxDefaults);
    }

    public static <T> BinnedArray<T> expandBins(T t, BinnedArray<T> binnedArray, MinMax.MinMaxDefaults<T> minMaxDefaults, ClassTag<T> classTag) {
        return Histogram$.MODULE$.expandBins(t, binnedArray, minMaxDefaults, classTag);
    }

    public static <T> Tuple2<T, T> buffer(T t) {
        return Histogram$.MODULE$.buffer(t);
    }

    private Logger logger$lzycompute() {
        Histogram histogram2 = this;
        synchronized (histogram2) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public void $plus$eq(Stat other, Predef.DummyImplicit d) {
        Stat$class.$plus$eq(this, other, d);
    }

    @Override
    public Stat $plus(Stat other, Predef.DummyImplicit d) {
        return Stat$class.$plus(this, other, d);
    }

    @Override
    public String toJson() {
        return Stat$class.toJson(this);
    }

    public int attribute() {
        return this.attribute;
    }

    public MinMax.MinMaxDefaults<T> defaults() {
        return this.defaults;
    }

    public BinnedArray<T> bins() {
        return this.bins;
    }

    public void bins_$eq(BinnedArray<T> x$1) {
        this.bins = x$1;
    }

    public int length() {
        return this.bins().length();
    }

    public int directIndex(long value2) {
        return this.bins().directIndex(value2);
    }

    public int indexOf(T value2) {
        return this.bins().indexOf(value2);
    }

    public long count(int i) {
        return this.bins().counts()[i];
    }

    public T min() {
        return (T)this.bins().bounds()._1();
    }

    public T max() {
        return (T)this.bins().bounds()._2();
    }

    public Tuple2<T, T> bounds() {
        return this.bins().bounds();
    }

    public Tuple2<T, T> bounds(int i) {
        return this.bins().bounds(i);
    }

    public T medianValue(int i) {
        return this.bins().medianValue(i);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addCountsFrom(Histogram<T> other) {
        if (this.length() == other.length()) {
            Tuple2<T, T> tuple2 = this.bounds();
            Tuple2<T, T> tuple22 = other.bounds();
            if (!(tuple2 != null ? !tuple2.equals(tuple22) : tuple22 != null)) {
                this.$plus$eq(other);
                return;
            }
        }
        Histogram$.MODULE$.copyInto(this.bins(), other.bins());
    }

    @Override
    public void observe(SimpleFeature sf) {
        Object value2 = sf.getAttribute(this.attribute());
        if (value2 != null) {
            try {
                int i = this.bins().indexOf(value2);
                if (i == -1) {
                    this.bins_$eq(Histogram$.MODULE$.expandBins(value2, this.bins(), this.defaults(), this.ct));
                    BinnedArray<Object> qual$1 = this.bins();
                    Object x$8 = value2;
                    long x$9 = qual$1.add$default$2();
                    qual$1.add(x$8, x$9);
                } else {
                    long[] lArray = this.bins().counts();
                    lArray[i] = lArray[i] + 1L;
                }
            }
            catch (Exception exception) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error observing value '", "': ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value2, exception.toString()})));
                    boxedUnit = BoxedUnit.UNIT;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    @Override
    public void unobserve(SimpleFeature sf) {
        Object value2 = sf.getAttribute(this.attribute());
        if (value2 != null) {
            try {
                int i = this.bins().indexOf(value2);
                if (i == -1) {
                    this.bins_$eq(Histogram$.MODULE$.expandBins(value2, this.bins(), this.defaults(), this.ct));
                    this.bins().add(value2, -1L);
                } else {
                    long[] lArray = this.bins().counts();
                    lArray[i] = lArray[i] - 1L;
                }
            }
            catch (Exception exception) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error un-observing value '", "': ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value2, exception.toString()})));
                    boxedUnit = BoxedUnit.UNIT;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public Histogram<T> $plus(Histogram<T> other) {
        void var2_2;
        Histogram<T> plus2 = new Histogram<T>(this.attribute(), this.length(), this.bounds(), this.defaults(), this.ct);
        plus2.$plus$eq(this);
        plus2.$plus$eq(other);
        return var2_2;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public void $plus$eq(Histogram<T> other) {
        if (this.length() == other.length()) {
            Tuple2<T, T> tuple2 = this.bounds();
            Tuple2<T, T> tuple22 = other.bounds();
            if (!(tuple2 != null ? !tuple2.equals(tuple22) : tuple22 != null)) {
                int i = 0;
                while (i < this.bins().length()) {
                    long[] lArray = this.bins().counts();
                    int n = i;
                    lArray[n] = lArray[n] + other.bins().counts()[i];
                    ++i;
                }
                return;
            }
        }
        if (other.isEmpty()) return;
        if (this.isEmpty()) {
            this.bins_$eq(BinnedArray$.MODULE$.apply(other.length(), other.bounds(), this.ct));
            int i = 0;
            while (i < this.bins().length()) {
                this.bins().counts()[i] = other.bins().counts()[i];
                ++i;
            }
            return;
        }
        Tuple2<T, T> newEndpoints = Histogram$.MODULE$.checkEndpoints(this.bins(), other.bins(), this.defaults());
        int newLength = package$.MODULE$.max(this.length(), other.length());
        Tuple2<T, T> tuple2 = newEndpoints;
        Tuple2<T, T> tuple23 = this.bounds();
        if ((tuple2 != null ? !tuple2.equals(tuple23) : tuple23 != null) || newLength != this.length()) {
            BinnedArray<T> newBins = BinnedArray$.MODULE$.apply(newLength, newEndpoints, this.ct);
            Histogram$.MODULE$.copyInto(newBins, this.bins());
            this.bins_$eq(newBins);
        }
        Histogram$.MODULE$.copyInto(this.bins(), other.bins());
    }

    public ListMap<String, Object> toJsonObject() {
        Tuple2[] tuple2Array = new Tuple2[3];
        tuple2Array[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lower-bound"), this.bounds()._1());
        tuple2Array[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"upper-bound"), this.bounds()._2());
        ListMap listMap = (ListMap)ListMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"index"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lower-bound"), this.bounds(0)._1()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"upper-bound"), this.bounds(0)._2()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"count"), (Object)BoxesRunTime.boxToLong((long)this.bins().counts()[0]))}));
        tuple2Array[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bins"), ((SeqLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), this.bins().length()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Histogram $outer;

            public final ListMap<String, Object> apply(int i) {
                return (ListMap)ListMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"index"), (Object)BoxesRunTime.boxToInteger((int)i)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"upper-bound"), this.$outer.bounds(i)._2()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"count"), (Object)BoxesRunTime.boxToLong((long)this.$outer.bins().counts()[i]))}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).$plus$colon((Object)listMap, IndexedSeq$.MODULE$.canBuildFrom()));
        return (ListMap)ListMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
    }

    @Override
    public boolean isEmpty() {
        return Predef$.MODULE$.longArrayOps(this.bins().counts()).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(long x$2) {
                return this.apply$mcZJ$sp(x$2);
            }

            public boolean apply$mcZJ$sp(long x$2) {
                return x$2 == 0L;
            }
        });
    }

    @Override
    public void clear() {
        this.bins().clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isEquivalent(Stat other) {
        Stat stat2 = other;
        if (!(stat2 instanceof Histogram)) return false;
        Histogram histogram2 = (Histogram)stat2;
        if (this.attribute() != histogram2.attribute()) return false;
        Tuple2<T, T> tuple2 = this.bounds();
        Tuple2<T, T> tuple22 = histogram2.bounds();
        if (tuple2 == null) {
            if (tuple22 != null) {
                return false;
            }
        } else if (!tuple2.equals(tuple22)) return false;
        if (!Arrays.equals(this.bins().counts(), histogram2.bins().counts())) return false;
        return true;
    }

    public Histogram(int attribute2, int initialBins, Tuple2<T, T> initialEndpoints, MinMax.MinMaxDefaults<T> defaults, ClassTag<T> ct) {
        this.attribute = attribute2;
        this.defaults = defaults;
        this.ct = ct;
        Stat$class.$init$(this);
        LazyLogging.class.$init$((LazyLogging)this);
        this.bins = BinnedArray$.MODULE$.apply(initialBins, initialEndpoints, ct);
    }
}

