/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.stats;

import org.geotools.data.DataUtilities;
import org.locationtech.geomesa.utils.stats.Stat;
import org.locationtech.geomesa.utils.stats.StatParser;
import org.opengis.feature.simple.SimpleFeatureType;
import org.parboiled.errors.ErrorUtils;
import org.parboiled.errors.ParsingException;
import org.parboiled.scala.ParsingResult;
import org.parboiled.scala.ParsingResult$;
import org.parboiled.scala.package$;
import org.parboiled.scala.parserunners.ReportingParseRunner;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.Nothing$;

public final class StatParser$ {
    public static final StatParser$ MODULE$;
    private final StatParser Parser;
    private final ThreadLocal<SimpleFeatureType> sfts;

    static {
        new StatParser$();
    }

    private StatParser Parser() {
        return this.Parser;
    }

    private ThreadLocal<SimpleFeatureType> sfts() {
        return this.sfts;
    }

    public Stat parse(SimpleFeatureType sft, String stat2, boolean report) throws ParsingException {
        if (stat2 == null) {
            throw new IllegalArgumentException("Stat must not be null");
        }
        ReportingParseRunner runner = report ? package$.MODULE$.ReportingParseRunner().apply(this.Parser().stat()) : package$.MODULE$.BasicParseRunner().apply(this.Parser().stat());
        this.sfts().set(sft);
        try {
            ParsingResult parsing = runner.run(package$.MODULE$.string2Input(stat2));
            return (Stat)parsing.result().getOrElse((Function0)new Serializable(parsing){
                public static final long serialVersionUID = 0L;
                private final ParsingResult parsing$1;

                public final Nothing$ apply() {
                    throw new ParsingException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid stat string: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ErrorUtils.printParseErrors((org.parboiled.support.ParsingResult)ParsingResult$.MODULE$.unwrap(this.parsing$1))})));
                }
                {
                    this.parsing$1 = parsing$1;
                }
            });
        }
        finally {
            this.sfts().remove();
        }
    }

    public boolean parse$default$3() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public int org$locationtech$geomesa$utils$stats$StatParser$$getIndex(String attribute2) {
        void var2_2;
        int i = this.org$locationtech$geomesa$utils$stats$StatParser$$sft().indexOf(attribute2);
        Predef$.MODULE$.require(i != -1, (Function0)new Serializable(attribute2){
            public static final long serialVersionUID = 0L;
            private final String attribute$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attribute '", "' does not exist in sft ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.attribute$1, DataUtilities.encodeType((SimpleFeatureType)StatParser$.MODULE$.org$locationtech$geomesa$utils$stats$StatParser$$sft())}));
            }
            {
                this.attribute$1 = attribute$1;
            }
        });
        return (int)var2_2;
    }

    public SimpleFeatureType org$locationtech$geomesa$utils$stats$StatParser$$sft() {
        return this.sfts().get();
    }

    private StatParser$() {
        MODULE$ = this;
        this.Parser = new StatParser();
        this.sfts = new ThreadLocal();
    }
}

