/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geotools.xml.FlowHandler;
import org.geotools.xml.XMLElementHandler;
import org.geotools.xml.gml.FCBuffer;
import org.geotools.xml.handlers.ComplexElementHandler;
import org.geotools.xml.handlers.DocumentHandler;
import org.geotools.xml.handlers.ElementHandlerFactory;
import org.geotools.xml.handlers.IgnoreHandler;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLSAXHandler
extends DefaultHandler {
    protected static final Logger logger = Logging.getLogger((String)"net.refractions.xml.sax");
    protected static Level level = Level.FINE;
    private Stack handlers = new Stack();
    private StringBuffer characters = new StringBuffer();
    private Map hints;
    private ElementHandlerFactory ehf = new ElementHandlerFactory(logger);
    private Map schemaProxy = new HashMap();
    private DocumentHandler document = null;
    private Locator locator;
    private URI instanceDocument;

    @Override
    public InputSource resolveEntity(String pubId, String sysId) throws SAXException {
        if (sysId != null && sysId.endsWith("dtd")) {
            return new InputSource(new StringReader(""));
        }
        try {
            return super.resolveEntity(pubId, sysId);
        }
        catch (IOException e) {
            SAXException se = new SAXException(e.getLocalizedMessage());
            se.initCause(e);
            throw se;
        }
    }

    public XMLSAXHandler(URI intendedDocument, Map hints) {
        this.instanceDocument = intendedDocument;
        this.hints = hints;
        logger.setLevel(level);
    }

    public XMLSAXHandler(Map hints) {
        this.hints = hints;
        logger.setLevel(level);
    }

    @Override
    public void endDocument() {
        this.document = (DocumentHandler)this.handlers.pop();
    }

    @Override
    public void startDocument() {
        try {
            this.document = new DocumentHandler(this.ehf);
            this.handlers.push(this.document);
        }
        catch (RuntimeException e) {
            logger.warning(e.toString());
            throw e;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.characters.append(ch, start, length);
    }

    private void handleCharacters() throws SAXException {
        if (this.characters.length() == 0) {
            return;
        }
        try {
            this.checkStatus();
            String text = this.characters.toString();
            this.characters.setLength(0);
            if (text != null && !"".equals(text)) {
                ((XMLElementHandler)this.handlers.peek()).characters(text);
            }
        }
        catch (SAXException e) {
            logger.warning(e.toString());
            throw e;
        }
    }

    private void checkStatus() throws FCBuffer.StopException {
        FlowHandler handler;
        if (this.hints != null && this.hints.get("FLOW_HANDLER_HINT") != null && (handler = (FlowHandler)this.hints.get("FLOW_HANDLER_HINT")).shouldStop(this.hints)) {
            throw new FCBuffer.StopException();
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new FCBuffer.StopException();
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.handleCharacters();
        logger.fine("END: " + qName);
        XMLElementHandler handler = null;
        try {
            handler = (XMLElementHandler)this.handlers.peek();
            URI uri = new URI(namespaceURI);
            handler.endElement(uri, localName, this.hints);
        }
        catch (Exception e) {
            this.processException(e);
            logger.warning(e.getMessage());
            logger.warning("Line " + this.locator.getLineNumber() + " Col " + this.locator.getColumnNumber());
            SAXException exception = new SAXException(e.getMessage() + " at Line " + this.locator.getLineNumber() + " Col " + this.locator.getColumnNumber() + " tag is: \n" + qName, e);
            exception.initCause(e);
            throw exception;
        }
        finally {
            ComplexElementHandler complexParent;
            String typename;
            XMLElementHandler parent;
            this.handlers.pop();
            if (handler != null && !this.handlers.isEmpty() && (parent = (XMLElementHandler)this.handlers.peek()) instanceof ComplexElementHandler && (typename = (complexParent = (ComplexElementHandler)parent).getType().getClass().getName()).equals("org.geotools.xml.wfs.WFSBasicComplexTypes$FeatureCollectionType")) {
                complexParent.removeElement(handler);
            }
        }
    }

    private void processException(Exception e) {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        StringBuffer msg = new StringBuffer(e.getLocalizedMessage());
        StackTraceElement[] trace = e.getStackTrace();
        for (int i = 0; i < trace.length; ++i) {
            StackTraceElement element = trace[i];
            msg.append("    ");
            msg.append(element.toString());
            msg.append("\n");
        }
        logger.log(Level.SEVERE, msg.toString());
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.characters.setLength(0);
        this.checkStatus();
        if (this.schemaProxy.size() != 0) {
            String[] targ2uri;
            logger.fine("ADDING NAMESPACES: " + this.schemaProxy.size());
            String t = atts.getValue("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
            if (t == null || "".equals(t)) {
                t = atts.getValue("", "schemaLocation");
            }
            if (t != null && !"".equals(t) && (targ2uri = t.split("\\s+")) != null) {
                if (targ2uri.length != 0 && targ2uri.length % 2 != 0) {
                    throw new SAXException("Bad Schema location attribute: you must have an even number of terms");
                }
                for (int i = 0; i < targ2uri.length / 2; ++i) {
                    Map schemas;
                    String uri = targ2uri[i * 2 + 1];
                    String targ = targ2uri[i * 2];
                    String prefix = (String)this.schemaProxy.get(targ);
                    URI targUri = null;
                    boolean set = false;
                    if (this.hints != null && this.hints.containsKey("NAMESPACE_MAPPING") && (schemas = (Map)this.hints.get("NAMESPACE_MAPPING")).containsKey(targ)) {
                        this.ehf.startPrefixMapping(prefix, targ, (URI)schemas.get(targ));
                        set = true;
                        break;
                    }
                    if (!set) {
                        try {
                            targUri = this.instanceDocument == null ? new URI(uri) : this.instanceDocument.resolve(uri);
                        }
                        catch (URISyntaxException e1) {
                            logger.warning(e1.toString());
                        }
                        this.ehf.startPrefixMapping(prefix, targ, targUri);
                    }
                    this.schemaProxy.remove(targ);
                }
            }
            if (this.schemaProxy.size() != 0) {
                Iterator it = this.schemaProxy.keySet().iterator();
                while (it.hasNext()) {
                    String targ = (String)it.next();
                    String prefix = (String)this.schemaProxy.get(targ);
                    this.ehf.startPrefixMapping(prefix, targ);
                    it.remove();
                }
            }
        }
        logger.finest("Moving on to finding the element handler");
        try {
            XMLElementHandler parent = (XMLElementHandler)this.handlers.peek();
            logger.finest("Parent Node = " + parent.getClass().getName() + "  '" + parent.getName() + "'");
            logger.finest("This Node = " + localName + " :: " + namespaceURI);
            URI uri = new URI(namespaceURI);
            XMLElementHandler eh = parent.getHandler(uri, localName, this.hints);
            if (eh == null) {
                eh = new IgnoreHandler();
            }
            logger.finest("This Node = " + eh.getClass().getName());
            this.handlers.push(eh);
            eh.startElement(new URI(namespaceURI), localName, atts);
        }
        catch (Exception e) {
            this.processException(e);
            logger.warning(e.toString());
            logger.warning("Line " + this.locator.getLineNumber() + " Col " + this.locator.getColumnNumber());
            SAXException exception = new SAXException(e.getMessage() + " at Line " + this.locator.getLineNumber() + " Col " + this.locator.getColumnNumber() + " tag is: \n" + qName, e);
            exception.initCause(e);
            throw exception;
        }
    }

    public static void setLogLevel(Level l) {
        level = l;
        logger.setLevel(l);
        XMLElementHandler.setLogLevel(l);
    }

    public Object getDocument() throws SAXException {
        return this.document.getValue();
    }

    @Override
    public void error(SAXParseException exception) {
        logger.severe("ERROR " + exception.getMessage());
        logger.severe("col " + this.locator.getColumnNumber() + ", line " + this.locator.getLineNumber());
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        logger.severe("FATAL " + exception.getMessage());
        if (this.locator != null) {
            logger.severe("col " + this.locator.getColumnNumber() + ", line " + this.locator.getLineNumber());
        }
        throw exception;
    }

    @Override
    public void warning(SAXParseException exception) {
        logger.warning("WARN " + exception.getMessage());
        logger.severe("col " + this.locator.getColumnNumber() + ", line " + this.locator.getLineNumber());
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this.locator = locator;
    }

    @Override
    public void endPrefixMapping(String prefix) {
        if (prefix.equals("gml") || prefix.equals("wfs")) {
            return;
        }
        this.ehf.endPrefixMapping(prefix);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        if ("http://www.w3.org/2001/XMLSchema-instance".equals(uri)) {
            return;
        }
        this.schemaProxy.put(uri, prefix);
    }
}

