/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.handlers.xsi;

import java.net.URI;
import java.net.URISyntaxException;
import org.geotools.xml.XSIElementHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ImportHandler
extends XSIElementHandler {
    public static final String LOCALNAME = "import";
    private static int offset = 0;
    private URI namespace;
    private URI schemaLocation;
    private int hashCodeOffset = ImportHandler.getOffset();

    private static int getOffset() {
        return offset++;
    }

    @Override
    public int hashCode() {
        return LOCALNAME.hashCode() * (this.schemaLocation == null ? 1 : this.schemaLocation.hashCode()) + this.hashCodeOffset;
    }

    @Override
    public XSIElementHandler getHandler(String namespaceURI, String localName) {
        return null;
    }

    @Override
    public void startElement(String namespaceURI, String localName, Attributes atts) throws SAXException {
        String sl = atts.getValue("", "schemaLocation");
        if (sl == null) {
            sl = atts.getValue(namespaceURI, "schemaLocation");
        }
        try {
            this.schemaLocation = sl != null ? new URI(sl) : null;
        }
        catch (URISyntaxException e) {
            logger.warning(e.toString());
            throw new SAXException(e);
        }
        String namespace1 = atts.getValue("", "namespace");
        if (namespace1 == null) {
            namespace1 = atts.getValue(namespaceURI, "namespace");
        }
        try {
            this.namespace = new URI(namespace1);
        }
        catch (URISyntaxException e) {
            logger.warning(e.toString());
            throw new SAXException(e);
        }
        if (namespaceURI.equalsIgnoreCase(namespace1)) {
            throw new SAXException("You may not import a namespace with the same name as the current namespace");
        }
    }

    @Override
    public String getLocalName() {
        return LOCALNAME;
    }

    public URI getNamespace() {
        return this.namespace;
    }

    public URI getSchemaLocation() {
        return this.schemaLocation;
    }

    @Override
    public int getHandlerType() {
        return 0;
    }

    @Override
    public void endElement(String namespaceURI, String localName) {
    }
}

