/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.criteria.domain.criteria;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.calrissian.mango.criteria.domain.criteria.ComparableKeyValueLeafCriteria;
import org.calrissian.mango.criteria.domain.criteria.Criteria;
import org.calrissian.mango.criteria.domain.criteria.ParentCriteria;
import org.calrissian.mango.domain.Tuple;
import org.calrissian.mango.domain.TupleStore;

public class RangeCriteria
extends ComparableKeyValueLeafCriteria {
    protected Object end;
    protected String encodedEnd;

    public RangeCriteria(String key, Object start, Object end, Comparator comparator, ParentCriteria parentCriteria) {
        super(key, start, comparator, parentCriteria);
        this.end = end;
    }

    @Override
    public Criteria clone(ParentCriteria parentCriteria) {
        return new RangeCriteria(this.key, this.value, this.end, this.comparator, parentCriteria);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RangeCriteria that = (RangeCriteria)o;
        if (this.encodedEnd != null ? !this.encodedEnd.equals(that.encodedEnd) : that.encodedEnd != null) {
            return false;
        }
        return !(this.end != null ? !this.end.equals(that.end) : that.end != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.end != null ? this.end.hashCode() : 0);
        result = 31 * result + (this.encodedEnd != null ? this.encodedEnd.hashCode() : 0);
        return result;
    }

    @Override
    public boolean apply(TupleStore obj) {
        Iterator<Tuple> i$;
        Collection<Tuple> tuples = obj.getAll(this.key);
        if (tuples != null && (i$ = tuples.iterator()).hasNext()) {
            Tuple tuple = i$.next();
            int startCompare = this.comparator.compare(tuple.getValue(), this.value);
            int endCompare = this.comparator.compare(tuple.getValue(), this.end);
            return startCompare >= 0 && endCompare <= 0;
        }
        return false;
    }
}

