/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.vector;

import com.vividsolutions.jts.geom.Geometry;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.vector.AggregateProcess;
import org.geotools.process.vector.VectorProcess;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.Within;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@DescribeProcess(title="Vector Zonal Statistics", description="Computes statistics for the distribution of a given attribute in a set of polygonal zones.  Input must be points.")
public class VectorZonalStatistics
implements VectorProcess {
    @DescribeResult(name="statistics", description="A feature collection with the attributes of the zone layer (prefixed by 'z_') and the statistics fields count,min,max,sum,avg,stddev")
    public SimpleFeatureCollection execute(@DescribeParameter(name="data", description="Input collection of point features") SimpleFeatureCollection data, @DescribeParameter(name="dataAttribute", description="Attribute to use for computing statistics") String dataAttribute, @DescribeParameter(name="zones", description="Zone polygon features for which to compute statistics") SimpleFeatureCollection zones) {
        AttributeDescriptor dataDescriptor = ((SimpleFeatureType)data.getSchema()).getDescriptor(dataAttribute);
        if (dataDescriptor == null) {
            throw new IllegalArgumentException("Attribute " + dataAttribute + " not found in " + data.getSchema());
        }
        return new ZonalStatisticsCollection(data, dataAttribute, zones);
    }

    static class ZonalStatisticsIterator
    implements SimpleFeatureIterator {
        Set<AggregateProcess.AggregationFunction> FUNCTIONS = new HashSet<AggregateProcess.AggregationFunction>(){
            {
                this.add(AggregateProcess.AggregationFunction.Count);
                this.add(AggregateProcess.AggregationFunction.Max);
                this.add(AggregateProcess.AggregationFunction.Min);
                this.add(AggregateProcess.AggregationFunction.Sum);
                this.add(AggregateProcess.AggregationFunction.Average);
                this.add(AggregateProcess.AggregationFunction.StdDev);
            }
        };
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        SimpleFeatureIterator zones;
        String dataAttribute;
        SimpleFeatureCollection data;
        SimpleFeatureBuilder builder;
        String dataGeomName;

        public ZonalStatisticsIterator(SimpleFeatureIterator zones, String dataAttribute, SimpleFeatureCollection data, SimpleFeatureType targetSchema) {
            this.zones = zones;
            this.dataAttribute = dataAttribute;
            this.data = data;
            this.builder = new SimpleFeatureBuilder(targetSchema);
            this.dataGeomName = ((SimpleFeatureType)data.getSchema()).getGeometryDescriptor().getLocalName();
        }

        @Override
        public void close() {
            this.zones.close();
        }

        @Override
        public boolean hasNext() {
            return this.zones.hasNext();
        }

        @Override
        public SimpleFeature next() throws NoSuchElementException {
            SimpleFeature zone = (SimpleFeature)this.zones.next();
            try {
                Geometry zoneGeom = (Geometry)zone.getDefaultGeometry();
                CoordinateReferenceSystem dataCrs = ((SimpleFeatureType)this.data.getSchema()).getCoordinateReferenceSystem();
                CoordinateReferenceSystem zonesCrs = this.builder.getFeatureType().getGeometryDescriptor().getCoordinateReferenceSystem();
                if (!CRS.equalsIgnoreMetadata((Object)zonesCrs, (Object)dataCrs)) {
                    zoneGeom = JTS.transform(zoneGeom, CRS.findMathTransform((CoordinateReferenceSystem)zonesCrs, (CoordinateReferenceSystem)dataCrs, (boolean)true));
                }
                Within areaFilter = this.ff.within((Expression)this.ff.property(this.dataGeomName), (Expression)this.ff.literal((Object)zoneGeom));
                SimpleFeatureCollection zoneCollection = this.data.subCollection((Filter)areaFilter);
                AggregateProcess.Results stats = new AggregateProcess().execute(zoneCollection, this.dataAttribute, this.FUNCTIONS, true, null);
                this.builder.addAll(zone.getAttributes());
                if (stats != null) {
                    this.builder.add((Object)stats.getCount());
                    this.builder.add((Object)stats.getMin());
                    this.builder.add((Object)stats.getMax());
                    this.builder.add((Object)stats.getSum());
                    this.builder.add((Object)stats.getAverage());
                    this.builder.add((Object)stats.getStandardDeviation());
                }
                return this.builder.buildFeature(zone.getID());
            }
            catch (Exception e) {
                throw new ProcessException("Failed to compute statistics on feature " + zone, e);
            }
        }
    }

    static class ZonalStatisticsCollection
    extends DecoratingSimpleFeatureCollection {
        SimpleFeatureCollection data;
        String dataAttribute;
        SimpleFeatureType targetSchema;

        public ZonalStatisticsCollection(SimpleFeatureCollection data, String dataAttribute, SimpleFeatureCollection zones) {
            super(zones);
            this.dataAttribute = dataAttribute;
            this.data = data;
            SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
            for (AttributeDescriptor att : ((SimpleFeatureType)zones.getSchema()).getAttributeDescriptors()) {
                tb.minOccurs(att.getMinOccurs());
                tb.maxOccurs(att.getMaxOccurs());
                tb.restrictions(att.getType().getRestrictions());
                if (att instanceof GeometryDescriptor) {
                    GeometryDescriptor gatt = (GeometryDescriptor)att;
                    tb.crs(gatt.getCoordinateReferenceSystem());
                }
                tb.add("z_" + att.getLocalName(), att.getType().getBinding());
            }
            AttributeDescriptor dataDescriptor = ((SimpleFeatureType)data.getSchema()).getDescriptor(dataAttribute);
            tb.add("count", Long.class);
            tb.add("min", Double.class);
            tb.add("max", Double.class);
            tb.add("sum", Double.class);
            tb.add("avg", Double.class);
            tb.add("stddev", Double.class);
            tb.setName(((SimpleFeatureType)zones.getSchema()).getName());
            this.targetSchema = tb.buildFeatureType();
        }

        public SimpleFeatureType getSchema() {
            return this.targetSchema;
        }

        public SimpleFeatureIterator features() {
            return new ZonalStatisticsIterator(this.delegate.features(), this.dataAttribute, this.data, this.targetSchema);
        }
    }
}

