/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.iterators;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.geotools.factory.Hints;
import org.locationtech.geomesa.arrow.io.SimpleFeatureArrowFileWriter;
import org.locationtech.geomesa.arrow.io.SimpleFeatureArrowIO$;
import org.locationtech.geomesa.arrow.package;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary$;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector;
import org.locationtech.geomesa.features.ScalaSimpleFeature;
import org.locationtech.geomesa.features.ScalaSimpleFeature$;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.iterators.AggregatingScan$;
import org.locationtech.geomesa.index.iterators.ArrowBatchAggregate;
import org.locationtech.geomesa.index.iterators.ArrowBatchScan$;
import org.locationtech.geomesa.index.iterators.ArrowBatchScan$Configuration$;
import org.locationtech.geomesa.index.stats.GeoMesaStats;
import org.locationtech.geomesa.utils.cache.SoftThreadLocalCache;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.io.WithClose$;
import org.locationtech.geomesa.utils.stats.EnumerationStat;
import org.locationtech.geomesa.utils.stats.Stat$;
import org.locationtech.geomesa.utils.stats.TopK;
import org.locationtech.geomesa.utils.text.StringSerialization$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

public final class ArrowBatchScan$ {
    public static final ArrowBatchScan$ MODULE$;
    private final SoftThreadLocalCache<String, ArrowBatchAggregate> org$locationtech$geomesa$index$iterators$ArrowBatchScan$$aggregateCache;

    static {
        new ArrowBatchScan$();
    }

    public SoftThreadLocalCache<String, ArrowBatchAggregate> org$locationtech$geomesa$index$iterators$ArrowBatchScan$$aggregateCache() {
        return this.org$locationtech$geomesa$index$iterators$ArrowBatchScan$$aggregateCache;
    }

    public Map<String, String> configure(SimpleFeatureType sft, GeoMesaFeatureIndex<?, ?, ?> index, Option<Filter> filter2, Map<String, ArrowDictionary> dictionaries, Hints hints) {
        String batchSize = (String)QueryHints$.MODULE$.RichHints(hints).getArrowBatchSize().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(int x$3) {
                return ((Object)BoxesRunTime.boxToInteger((int)x$3)).toString();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return package.ArrowProperties$.MODULE$.BatchSize().get();
            }
        });
        Map<String, String> base = AggregatingScan$.MODULE$.configure(sft, index, filter2, QueryHints$.MODULE$.RichHints(hints).getTransform(), QueryHints$.MODULE$.RichHints(hints).getSampling());
        return base.$plus$plus(AggregatingScan$.MODULE$.optionalMap((Seq<Tuple2<String, Either<String, Option<String>>>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ArrowBatchScan$Configuration$.MODULE$.BatchSizeKey()), AggregatingScan$.MODULE$.StringToConfig(batchSize)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ArrowBatchScan$Configuration$.MODULE$.DictionaryKey()), AggregatingScan$.MODULE$.StringToConfig(this.encodeDictionaries(dictionaries))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ArrowBatchScan$Configuration$.MODULE$.IncludeFidsKey()), AggregatingScan$.MODULE$.StringToConfig(((Object)BoxesRunTime.boxToBoolean((boolean)QueryHints$.MODULE$.RichHints(hints).isArrowIncludeFid())).toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ArrowBatchScan$Configuration$.MODULE$.SortKey()), AggregatingScan$.MODULE$.OptionToConfig((Option<String>)QueryHints$.MODULE$.RichHints(hints).getArrowSort().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Object> x$4) {
                return (String)x$4._1();
            }
        }))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ArrowBatchScan$Configuration$.MODULE$.SortReverseKey()), AggregatingScan$.MODULE$.OptionToConfig((Option<String>)QueryHints$.MODULE$.RichHints(hints).getArrowSort().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Object> x$5) {
                return ((Object)BoxesRunTime.boxToBoolean((boolean)x$5._2$mcZ$sp())).toString();
            }
        })))})));
    }

    public Map<String, ArrowDictionary> createDictionaries(GeoMesaStats stats, SimpleFeatureType sft, Option<Filter> filter2, Seq<String> attributes, Map<String, Seq<Object>> provided, boolean useCached) {
        Map map;
        if (attributes.isEmpty()) {
            map = Predef$.MODULE$.Map().empty();
        } else {
            Map map2;
            Map providedDictionaries = (Map)provided.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, ArrowDictionary> apply(Tuple2<String, Seq<Object>> x0$1) {
                    Tuple2<String, Seq<Object>> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        Seq v = (Seq)tuple2._2();
                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)ArrowDictionary$.MODULE$.create(ArrowBatchScan$.MODULE$.org$locationtech$geomesa$index$iterators$ArrowBatchScan$$sort((Seq<Object>)v)));
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
            }, Map$.MODULE$.canBuildFrom());
            Seq toLookup = (Seq)attributes.filterNot((Function1)new Serializable(provided){
                public static final long serialVersionUID = 0L;
                private final Map provided$1;

                public final boolean apply(String key) {
                    return this.provided$1.contains((Object)key);
                }
                {
                    this.provided$1 = provided$1;
                }
            });
            if (toLookup.isEmpty()) {
                map2 = Predef$.MODULE$.Map().empty();
            } else {
                Map cached;
                Map map3 = cached = useCached ? ((TraversableOnce)stats.getStats(sft, (Seq<String>)toLookup, stats.getStats$default$3(), ClassTag$.MODULE$.apply(TopK.class)).map((Function1)new Serializable(sft){
                    public static final long serialVersionUID = 0L;
                    private final SimpleFeatureType sft$1;

                    public final Tuple2<String, TopK<Object>> apply(TopK<Object> k) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ArrowBatchScan$.MODULE$.org$locationtech$geomesa$index$iterators$ArrowBatchScan$$name$1(k.attribute(), this.sft$1)), k);
                    }
                    {
                        this.sft$1 = sft$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()) : Predef$.MODULE$.Map().empty();
                if (toLookup.forall((Function1)new Serializable(cached){
                    public static final long serialVersionUID = 0L;
                    private final Map cached$1;

                    public final boolean apply(String key) {
                        return this.cached$1.contains((Object)key);
                    }
                    {
                        this.cached$1 = cached$1;
                    }
                })) {
                    map2 = (Map)cached.map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<String, ArrowDictionary> apply(Tuple2<String, TopK<Object>> x0$2) {
                            Tuple2<String, TopK<Object>> tuple2 = x0$2;
                            if (tuple2 != null) {
                                String name = (String)tuple2._1();
                                TopK k = (TopK)tuple2._2();
                                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)ArrowDictionary$.MODULE$.create(ArrowBatchScan$.MODULE$.org$locationtech$geomesa$index$iterators$ArrowBatchScan$$sort((Seq<Object>)k.topK(1000).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Object apply(Tuple2<Object, Object> x$6) {
                                        return x$6._1();
                                    }
                                }).toSeq())));
                                return tuple22;
                            }
                            throw new MatchError(tuple2);
                        }
                    }, Map$.MODULE$.canBuildFrom());
                } else {
                    String query = Stat$.MODULE$.SeqStat((Seq)toLookup.map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String attribute) {
                            return Stat$.MODULE$.Enumeration(attribute);
                        }
                    }, Seq$.MODULE$.canBuildFrom()));
                    Seq enumerations = stats.runStats(sft, query, (Filter)filter2.getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final IncludeFilter apply() {
                            return Filter.INCLUDE;
                        }
                    }));
                    Iterator nameIter = toLookup.iterator();
                    map2 = ((TraversableOnce)enumerations.map((Function1)new Serializable(nameIter){
                        public static final long serialVersionUID = 0L;
                        private final Iterator nameIter$1;

                        public final Tuple2<String, ArrowDictionary> apply(EnumerationStat<String> e) {
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.nameIter$1.next()), (Object)ArrowDictionary$.MODULE$.create(ArrowBatchScan$.MODULE$.org$locationtech$geomesa$index$iterators$ArrowBatchScan$$sort((Seq<Object>)e.values().toSeq())));
                        }
                        {
                            this.nameIter$1 = nameIter$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                }
            }
            Map queriedDictionaries = map2;
            map = providedDictionaries.$plus$plus((GenTraversableOnce)queriedDictionaries);
        }
        return map;
    }

    public Seq<Object> org$locationtech$geomesa$index$iterators$ArrowBatchScan$$sort(Seq<Object> values) {
        Seq seq;
        if (!values.isEmpty() && Comparable.class.isAssignableFrom(values.head().getClass())) {
            Ordering<Object> ordering = new Ordering<Object>(){

                public Some<Object> tryCompare(Object x, Object y) {
                    return Ordering.class.tryCompare((Ordering)this, (Object)x, (Object)y);
                }

                public boolean lteq(Object x, Object y) {
                    return Ordering.class.lteq((Ordering)this, (Object)x, (Object)y);
                }

                public boolean gteq(Object x, Object y) {
                    return Ordering.class.gteq((Ordering)this, (Object)x, (Object)y);
                }

                public boolean lt(Object x, Object y) {
                    return Ordering.class.lt((Ordering)this, (Object)x, (Object)y);
                }

                public boolean gt(Object x, Object y) {
                    return Ordering.class.gt((Ordering)this, (Object)x, (Object)y);
                }

                public boolean equiv(Object x, Object y) {
                    return Ordering.class.equiv((Ordering)this, (Object)x, (Object)y);
                }

                public Object max(Object x, Object y) {
                    return Ordering.class.max((Ordering)this, (Object)x, (Object)y);
                }

                public Object min(Object x, Object y) {
                    return Ordering.class.min((Ordering)this, (Object)x, (Object)y);
                }

                public Ordering<Object> reverse() {
                    return Ordering.class.reverse((Ordering)this);
                }

                public <U> Ordering<U> on(Function1<U, Object> f) {
                    return Ordering.class.on((Ordering)this, f);
                }

                public Ordering.Ops mkOrderingOps(Object lhs) {
                    return Ordering.class.mkOrderingOps((Ordering)this, (Object)lhs);
                }

                public int compare(Object left, Object right) {
                    return ((Comparable)left).compareTo(right);
                }
                {
                    PartialOrdering.class.$init$((PartialOrdering)this);
                    Ordering.class.$init$((Ordering)this);
                }
            };
            seq = (Seq)values.sorted((Ordering)ordering);
        } else {
            seq = values;
        }
        return seq;
    }

    public Function1<CloseableIterator<SimpleFeature>, CloseableIterator<SimpleFeature>> reduceFeatures(SimpleFeatureType sft, Hints hints, Map<String, ArrowDictionary> dictionaries) {
        Option<Tuple2<String, Object>> option;
        block4: {
            Object object;
            ScalaSimpleFeature footer;
            ScalaSimpleFeature header;
            block3: {
                Some some;
                Tuple2 tuple2;
                SimpleFeatureVector.SimpleFeatureEncoding encoding;
                block2: {
                    encoding = SimpleFeatureVector.SimpleFeatureEncoding$.MODULE$.min(QueryHints$.MODULE$.RichHints(hints).isArrowIncludeFid());
                    Option<Tuple2<String, Object>> sortField = QueryHints$.MODULE$.RichHints(hints).getArrowSort();
                    header = new ScalaSimpleFeature(org.locationtech.geomesa.arrow.package$.MODULE$.ArrowEncodedSft(), "", new Object[]{this.fileMetadata(sft, dictionaries, encoding, sortField), GeometryUtils$.MODULE$.zeroPoint()}, ScalaSimpleFeature$.MODULE$.$lessinit$greater$default$4());
                    footer = new ScalaSimpleFeature(org.locationtech.geomesa.arrow.package$.MODULE$.ArrowEncodedSft(), "", new Object[]{Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, 0, 0, 0}), ClassTag$.MODULE$.Byte()), GeometryUtils$.MODULE$.zeroPoint()}, ScalaSimpleFeature$.MODULE$.$lessinit$greater$default$4());
                    option = sortField;
                    if (!None$.MODULE$.equals(option)) break block2;
                    object = new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final CloseableIterator<SimpleFeature> apply(CloseableIterator<SimpleFeature> iter) {
                            return iter;
                        }
                    };
                    break block3;
                }
                if (!(option instanceof Some) || (tuple2 = (Tuple2)(some = (Some)option).x()) == null) break block4;
                String attribute = (String)tuple2._1();
                boolean reverse = tuple2._2$mcZ$sp();
                int batchSize = BoxesRunTime.unboxToInt((Object)QueryHints$.MODULE$.RichHints(hints).getArrowBatchSize().getOrElse((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return new StringOps(Predef$.MODULE$.augmentString(package.ArrowProperties$.MODULE$.BatchSize().get())).toInt();
                    }
                }));
                object = new Serializable(sft, dictionaries, encoding, attribute, reverse, batchSize){
                    public static final long serialVersionUID = 0L;
                    private final SimpleFeatureType sft$2;
                    private final Map dictionaries$2;
                    private final SimpleFeatureVector.SimpleFeatureEncoding encoding$2;
                    private final String attribute$1;
                    private final boolean reverse$1;
                    private final int batchSize$1;

                    public final CloseableIterator<ScalaSimpleFeature> apply(CloseableIterator<SimpleFeature> iter) {
                        ScalaSimpleFeature sf = new ScalaSimpleFeature(org.locationtech.geomesa.arrow.package$.MODULE$.ArrowEncodedSft(), "", new Object[]{null, GeometryUtils$.MODULE$.zeroPoint()}, ScalaSimpleFeature$.MODULE$.$lessinit$greater$default$4());
                        CloseableIterator bytes = iter.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final byte[] apply(SimpleFeature x$7) {
                                return (byte[])x$7.getAttribute(0);
                            }
                        });
                        CloseableIterator sorted = SimpleFeatureArrowIO$.MODULE$.sortBatches(this.sft$2, this.dictionaries$2, this.encoding$2, this.attribute$1, this.reverse$1, this.batchSize$1, bytes);
                        return sorted.map((Function1)new Serializable(this, sf){
                            public static final long serialVersionUID = 0L;
                            private final ScalaSimpleFeature sf$1;

                            public final ScalaSimpleFeature apply(byte[] bytes) {
                                this.sf$1.setAttribute(0, (Object)bytes);
                                return this.sf$1;
                            }
                            {
                                this.sf$1 = sf$1;
                            }
                        });
                    }
                    {
                        this.sft$2 = sft$2;
                        this.dictionaries$2 = dictionaries$2;
                        this.encoding$2 = encoding$2;
                        this.attribute$1 = attribute$1;
                        this.reverse$1 = reverse$1;
                        this.batchSize$1 = batchSize$1;
                    }
                };
            }
            Serializable sort = object;
            return new Serializable(header, footer, (Function1)sort){
                public static final long serialVersionUID = 0L;
                private final ScalaSimpleFeature header$1;
                public final ScalaSimpleFeature footer$1;
                public final Function1 sort$1;

                public final CloseableIterator<SimpleFeature> apply(CloseableIterator<SimpleFeature> iter) {
                    return CloseableIterator$.MODULE$.apply(package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ScalaSimpleFeature[]{this.header$1})), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            CloseableIterator$.MODULE$.apply$default$2();
                        }
                    }).$plus$plus((Function0)new Serializable(this, iter){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.reduceFeatures.1 $outer;
                        private final CloseableIterator iter$1;

                        public final CloseableIterator<SimpleFeature> apply() {
                            return (CloseableIterator)this.$outer.sort$1.apply((Object)this.iter$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.iter$1 = iter$1;
                        }
                    }).$plus$plus((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.reduceFeatures.1 $outer;

                        public final CloseableIterator<ScalaSimpleFeature> apply() {
                            return CloseableIterator$.MODULE$.apply(package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ScalaSimpleFeature[]{this.$outer.footer$1})), (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final void apply() {
                                    this.apply$mcV$sp();
                                }

                                public void apply$mcV$sp() {
                                    CloseableIterator$.MODULE$.apply$default$2();
                                }
                            });
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.header$1 = header$1;
                    this.footer$1 = footer$1;
                    this.sort$1 = sort$1;
                }
            };
        }
        throw new MatchError(option);
    }

    private byte[] fileMetadata(SimpleFeatureType sft, Map<String, ArrowDictionary> dictionaries, SimpleFeatureVector.SimpleFeatureEncoding encoding, Option<Tuple2<String, Object>> sort) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        return (byte[])WithClose$.MODULE$.apply((Object)new SimpleFeatureArrowFileWriter(sft, (OutputStream)out, dictionaries, encoding, sort, org.locationtech.geomesa.arrow.package$.MODULE$.allocator()), (Function1)new Serializable(out){
            public static final long serialVersionUID = 0L;
            private final ByteArrayOutputStream out$1;

            public final byte[] apply(SimpleFeatureArrowFileWriter writer2) {
                writer2.start();
                return this.out$1.toByteArray();
            }
            {
                this.out$1 = out$1;
            }
        });
    }

    private String encodeDictionaries(Map<String, ArrowDictionary> dictionaries) {
        return StringSerialization$.MODULE$.encodeSeqMap((Map)dictionaries.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Seq<Object>> apply(Tuple2<String, ArrowDictionary> x0$3) {
                Tuple2<String, ArrowDictionary> tuple2 = x0$3;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    ArrowDictionary v = (ArrowDictionary)tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.values());
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom()));
    }

    public Map<String, ArrowDictionary> org$locationtech$geomesa$index$iterators$ArrowBatchScan$$decodeDictionaries(SimpleFeatureType sft, String encoded) {
        return (Map)StringSerialization$.MODULE$.decodeSeqMap(sft, encoded).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, ArrowDictionary> apply(Tuple2<String, Seq<Object>> x0$4) {
                Tuple2<String, Seq<Object>> tuple2 = x0$4;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    Seq v = (Seq)tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)ArrowDictionary$.MODULE$.create(v));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom());
    }

    public final String org$locationtech$geomesa$index$iterators$ArrowBatchScan$$name$1(int i, SimpleFeatureType sft$1) {
        return sft$1.getDescriptor(i).getLocalName();
    }

    private ArrowBatchScan$() {
        MODULE$ = this;
        this.org$locationtech$geomesa$index$iterators$ArrowBatchScan$$aggregateCache = new SoftThreadLocalCache();
    }
}

