/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.utils;

import com.google.common.util.concurrent.MoreExecutors;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureReader;
import org.locationtech.geomesa.index.utils.ThreadManagement;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class ThreadManagement$
implements LazyLogging {
    public static final ThreadManagement$ MODULE$;
    private final long interval;
    private final Object ordering;
    private final PriorityBlockingQueue<ThreadManagement.ReaderAndTime> org$locationtech$geomesa$index$utils$ThreadManagement$$openReaders;
    private final Runnable reaper;
    private final ScheduledExecutorService org$locationtech$geomesa$index$utils$ThreadManagement$$executor;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new ThreadManagement$();
    }

    private Logger logger$lzycompute() {
        ThreadManagement$ threadManagement$ = this;
        synchronized (threadManagement$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    private long interval() {
        return this.interval;
    }

    private Object ordering() {
        return this.ordering;
    }

    public PriorityBlockingQueue<ThreadManagement.ReaderAndTime> org$locationtech$geomesa$index$utils$ThreadManagement$$openReaders() {
        return this.org$locationtech$geomesa$index$utils$ThreadManagement$$openReaders;
    }

    private Runnable reaper() {
        return this.reaper;
    }

    public ScheduledExecutorService org$locationtech$geomesa$index$utils$ThreadManagement$$executor() {
        return this.org$locationtech$geomesa$index$utils$ThreadManagement$$executor;
    }

    public void register(GeoMesaFeatureReader reader, long start, long timeout) {
        this.org$locationtech$geomesa$index$utils$ThreadManagement$$openReaders().offer(new ThreadManagement.ReaderAndTime(reader, start + timeout, timeout));
    }

    public void unregister(GeoMesaFeatureReader reader, long start, long timeout) {
        this.org$locationtech$geomesa$index$utils$ThreadManagement$$openReaders().remove(new ThreadManagement.ReaderAndTime(reader, start + timeout, timeout));
    }

    private ThreadManagement$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.interval = 5000L;
        this.ordering = new Ordering<ThreadManagement.ReaderAndTime>(){

            public Some tryCompare(Object x, Object y) {
                return Ordering.class.tryCompare((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lteq(Object x, Object y) {
                return Ordering.class.lteq((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gteq(Object x, Object y) {
                return Ordering.class.gteq((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lt(Object x, Object y) {
                return Ordering.class.lt((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gt(Object x, Object y) {
                return Ordering.class.gt((Ordering)this, (Object)x, (Object)y);
            }

            public boolean equiv(Object x, Object y) {
                return Ordering.class.equiv((Ordering)this, (Object)x, (Object)y);
            }

            public Object max(Object x, Object y) {
                return Ordering.class.max((Ordering)this, (Object)x, (Object)y);
            }

            public Object min(Object x, Object y) {
                return Ordering.class.min((Ordering)this, (Object)x, (Object)y);
            }

            public Ordering<ThreadManagement.ReaderAndTime> reverse() {
                return Ordering.class.reverse((Ordering)this);
            }

            public <U> Ordering<U> on(Function1<U, ThreadManagement.ReaderAndTime> f) {
                return Ordering.class.on((Ordering)this, f);
            }

            public Ordering.Ops mkOrderingOps(Object lhs) {
                return Ordering.class.mkOrderingOps((Ordering)this, (Object)lhs);
            }

            public int compare(ThreadManagement.ReaderAndTime x, ThreadManagement.ReaderAndTime y) {
                return Predef$.MODULE$.long2Long(x.killAt()).compareTo(Predef$.MODULE$.long2Long(y.killAt()));
            }
            {
                PartialOrdering.class.$init$((PartialOrdering)this);
                Ordering.class.$init$((Ordering)this);
            }
        };
        this.org$locationtech$geomesa$index$utils$ThreadManagement$$openReaders = new PriorityBlockingQueue(11, this.ordering());
        this.reaper = new Runnable(){

            public void run() {
                BoxedUnit boxedUnit;
                long time = System.currentTimeMillis();
                boolean loop = true;
                int numClosed = 0;
                while (loop) {
                    ThreadManagement.ReaderAndTime holder = ThreadManagement$.MODULE$.org$locationtech$geomesa$index$utils$ThreadManagement$$openReaders().poll();
                    if (holder == null) {
                        loop = false;
                        continue;
                    }
                    if (holder.killAt() < time) {
                        BoxedUnit boxedUnit2;
                        if (holder.reader().isClosed()) continue;
                        if (ThreadManagement$.MODULE$.logger().underlying().isWarnEnabled()) {
                            ThreadManagement$.MODULE$.logger().underlying().warn(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Stopping query on schema '", "' with filter "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{holder.reader().query().getTypeName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' based on timeout of ", "ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{org.locationtech.geomesa.filter.package$.MODULE$.filterToString(holder.reader().query().getFilter()), BoxesRunTime.boxToLong((long)holder.timeout())}))).toString());
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                        holder.reader().close();
                        ++numClosed;
                        continue;
                    }
                    Object object = holder.reader().isClosed() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)ThreadManagement$.MODULE$.org$locationtech$geomesa$index$utils$ThreadManagement$$openReaders().offer(holder));
                    loop = false;
                }
                if (ThreadManagement$.MODULE$.logger().underlying().isTraceEnabled()) {
                    ThreadManagement$.MODULE$.logger().underlying().trace(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Force closed ", " queries with ", " queries still running."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numClosed), BoxesRunTime.boxToInteger((int)ThreadManagement$.MODULE$.org$locationtech$geomesa$index$utils$ThreadManagement$$openReaders().size())})));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
        };
        this.org$locationtech$geomesa$index$utils$ThreadManagement$$executor = MoreExecutors.getExitingScheduledExecutorService((ScheduledThreadPoolExecutor)new ScheduledThreadPoolExecutor(1));
        this.org$locationtech$geomesa$index$utils$ThreadManagement$$executor().scheduleWithFixedDelay(this.reaper(), this.interval(), this.interval(), TimeUnit.MILLISECONDS);
        package$.MODULE$.addShutdownHook((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ThreadManagement$.MODULE$.org$locationtech$geomesa$index$utils$ThreadManagement$$executor().shutdownNow();
            }
        });
    }
}

