/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.locationtech.geomesa.convert.EvaluationContext;
import org.locationtech.geomesa.convert.TransformerFn;
import org.locationtech.geomesa.convert.TransformerFn$;
import org.locationtech.geomesa.convert.TransformerFn$class;
import org.locationtech.geomesa.convert.TransformerFunctionFactory;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\u0001\u0003\u0001-\u0011\u0011#\u00133Gk:\u001cG/[8o\r\u0006\u001cGo\u001c:z\u0015\t\u0019A!A\u0004d_:4XM\u001d;\u000b\u0005\u00151\u0011aB4f_6,7/\u0019\u0006\u0003\u000f!\tA\u0002\\8dCRLwN\u001c;fG\"T\u0011!C\u0001\u0004_J<7\u0001A\n\u0004\u00011\u0011\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0005\u0002\u0014)5\t!!\u0003\u0002\u0016\u0005\tQBK]1og\u001a|'/\\3s\rVt7\r^5p]\u001a\u000b7\r^8ss\")q\u0003\u0001C\u00011\u00051A(\u001b8jiz\"\u0012!\u0007\t\u0003'\u0001AQa\u0007\u0001\u0005Bq\t\u0011BZ;oGRLwN\\:\u0016\u0003u\u00012AH\u0011$\u001b\u0005y\"B\u0001\u0011\u000f\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003E}\u00111aU3r%\r!#F\r\u0004\u0005K\u0001\u00011E\u0001\u0007=e\u00164\u0017N\\3nK:$h(\u0003\u0002(Q\u0005)\u0011\r\u001d9ms*\u0011\u0011FA\u0001\u000e)J\fgn\u001d4pe6,'O\u00128\u0011\u0005-\u0002T\"\u0001\u0017\u000b\u00055r\u0013\u0001\u00027b]\u001eT\u0011aL\u0001\u0005U\u00064\u0018-\u0003\u00022Y\t1qJ\u00196fGR\u0004\"aE\u001a\n\u0005Q\u0012!!\u0004+sC:\u001chm\u001c:nKJ4e\u000eC\u00047\u0001\t\u0007I\u0011A\u001c\u0002\u0019M$(/\u001b8he\tKH/Z:\u0016\u0003a\u00122!\u000f\u00163\r\u0011)\u0003\u0001\u0001\u001d\t\rm\u0002\u0001\u0015!\u00039\u00035\u0019HO]5oOJ\u0012\u0015\u0010^3tA!9Q\b\u0001b\u0001\n\u0003q\u0014AB;vS\u00124e.F\u0001@%\r\u0001EB\r\u0004\u0005K\u0001\u0001q\b\u0003\u0004C\u0001\u0001\u0006IaP\u0001\bkVLGM\u00128!\u0011\u001d!\u0005A1A\u0005\u0002y\naAY1tKZ\"\u0004B\u0002$\u0001A\u0003%q(A\u0004cCN,g\u0007\u000e\u0011\t\u000f!\u0003!\u0019!C\u0001\u0013\u0006\u0019Q\u000eZ\u001b\u0016\u0003)\u0003\"a\u0013'\u000e\u0003\u00011A!\u0014\u0001\u0001\u001d\n\u0019Q\nR\u001b\u0014\u00071c!\u0007C\u0003\u0018\u0019\u0012\u0005\u0001\u000bF\u0001K\u0011\u001d\u0011FJ1A\u0005BM\u000bQA\\1nKN,\u0012\u0001\u0016\t\u0004=\u0005*\u0006CA\u0016W\u0013\t9FF\u0001\u0004TiJLgn\u001a\u0005\u000732\u0003\u000b\u0011\u0002+\u0002\r9\fW.Z:!\u0011\u0015YF\n\"\u0011J\u0003-9W\r^%ogR\fgnY3\t\u000fuc%\u0019!C\u0005=\u00061\u0001.Y:iKJ,\u0012a\u0018\t\u0003A&l\u0011!\u0019\u0006\u0003E\u000e\fA\u0001[1tQ*\u0011A-Z\u0001\u0007G>lWn\u001c8\u000b\u0005\u0019<\u0017AB4p_\u001edWMC\u0001i\u0003\r\u0019w.\\\u0005\u0003U\u0006\u0014A\u0002S1tQ\u001a+hn\u0019;j_:Da\u0001\u001c'!\u0002\u0013y\u0016a\u00025bg\",'\u000f\t\u0005\u0006]2#\te\\\u0001\u0005KZ\fG\u000e\u0006\u0002qsR\u0011\u0011\u000f\u001e\t\u0003\u001bIL!a\u001d\b\u0003\u0007\u0005s\u0017\u0010C\u0003v[\u0002\u000fa/A\u0002dib\u0004\"aE<\n\u0005a\u0014!!E#wC2,\u0018\r^5p]\u000e{g\u000e^3yi\")!0\u001ca\u0001w\u0006!\u0011M]4t!\riA0]\u0005\u0003{:\u0011Q!\u0011:sCfDaa \u0001!\u0002\u0013Q\u0015\u0001B7ek\u00012a!a\u0001\u0001\u0001\u0005\u0015!AC've6,(oM04eM!\u0011\u0011\u0001\u00073\u0011\u001d9\u0012\u0011\u0001C\u0001\u0003\u0013!\"!a\u0003\u0011\u0007-\u000b\t\u0001\u0003\u0005^\u0003\u0003\u0011\r\u0011\"\u0003_\u0011\u001da\u0017\u0011\u0001Q\u0001\n}C\u0011BUA\u0001\u0005\u0004%\t%a\u0005\u0016\u0005\u0005U\u0001CBA\f\u0003O\tYC\u0004\u0003\u0002\u001a\u0005\rb\u0002BA\u000e\u0003Ci!!!\b\u000b\u0007\u0005}!\"\u0001\u0004=e>|GOP\u0005\u0002\u001f%\u0019\u0011Q\u0005\b\u0002\u000fA\f7m[1hK&\u0019!%!\u000b\u000b\u0007\u0005\u0015b\u0002\u0005\u0003\u0002.\u0005MbbA\u0007\u00020%\u0019\u0011\u0011\u0007\b\u0002\rA\u0013X\rZ3g\u0013\r9\u0016Q\u0007\u0006\u0004\u0003cq\u0001\u0002C-\u0002\u0002\u0001\u0006I!!\u0006\t\u000f9\f\t\u0001\"\u0011\u0002<Q!\u0011QHA!)\r\t\u0018q\b\u0005\u0007k\u0006e\u00029\u0001<\t\ri\fI\u00041\u0001|\u0011%\t)\u0005\u0001b\u0001\n\u0003\t9%\u0001\u0006nkJlWO]\u001a`gI*\"!a\u0003\t\u0011\u0005-\u0003\u0001)A\u0005\u0003\u0017\t1\"\\;s[V\u00148gX\u001a3A\u00191\u0011q\n\u0001\u0001\u0003#\u0012!\"T;s[V\u00148g\u0018\u001c5'\u0011\ti\u0005\u0004\u001a\t\u000f]\ti\u0005\"\u0001\u0002VQ\u0011\u0011q\u000b\t\u0004\u0017\u00065\u0003\u0002C/\u0002N\t\u0007I\u0011\u00020\t\u000f1\fi\u0005)A\u0005?\"I!+!\u0014C\u0002\u0013\u0005\u00131\u0003\u0005\t3\u00065\u0003\u0015!\u0003\u0002\u0016!9a.!\u0014\u0005B\u0005\rD\u0003BA3\u0003S\"2!]A4\u0011\u0019)\u0018\u0011\ra\u0002m\"1!0!\u0019A\u0002mD\u0011\"!\u001c\u0001\u0005\u0004%\t!a\u001c\u0002\u00155,(/\\;sg}3D'\u0006\u0002\u0002X!A\u00111\u000f\u0001!\u0002\u0013\t9&A\u0006nkJlWO]\u001a`mQ\u0002\u0003")
public class IdFunctionFactory
implements TransformerFunctionFactory {
    private final TransformerFn string2Bytes = TransformerFn$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"string2bytes", "stringToBytes"}), (Function1)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final byte[] apply(Object[] args) {
            return ((String)args[0]).getBytes(StandardCharsets.UTF_8);
        }
    });
    private final TransformerFn uuidFn = TransformerFn$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"uuid"}), (Function1)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final String apply(Object[] args) {
            return UUID.randomUUID().toString();
        }
    });
    private final TransformerFn base64 = TransformerFn$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"base64"}), (Function1)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final String apply(Object[] args) {
            return Base64.encodeBase64URLSafeString((byte[])((byte[])args[0]));
        }
    });
    private final MD5 md5 = new MD5();
    private final Murmur3_32 murmur3_32 = new Murmur3_32();
    private final Murmur3_64 murmur3_64 = new Murmur3_64();

    public Seq<Object> functions() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TransformerFn[]{this.string2Bytes(), this.md5(), this.uuidFn(), this.base64(), this.murmur3_32(), this.murmur3_64()}));
    }

    public TransformerFn string2Bytes() {
        return this.string2Bytes;
    }

    public TransformerFn uuidFn() {
        return this.uuidFn;
    }

    public TransformerFn base64() {
        return this.base64;
    }

    public MD5 md5() {
        return this.md5;
    }

    public Murmur3_32 murmur3_32() {
        return this.murmur3_32;
    }

    public Murmur3_64 murmur3_64() {
        return this.murmur3_64;
    }

    public class MD5
    implements TransformerFn {
        private final Seq<String> names;
        private final HashFunction hasher;

        @Override
        public Seq<String> names() {
            return this.names;
        }

        @Override
        public MD5 getInstance() {
            return this.org$locationtech$geomesa$convert$IdFunctionFactory$MD5$$$outer().new MD5();
        }

        private HashFunction hasher() {
            return this.hasher;
        }

        @Override
        public Object eval(Object[] args, EvaluationContext ctx) {
            return this.hasher().hashBytes((byte[])args[0]).toString();
        }

        public /* synthetic */ IdFunctionFactory org$locationtech$geomesa$convert$IdFunctionFactory$MD5$$$outer() {
            return IdFunctionFactory.this;
        }

        public MD5() {
            if (IdFunctionFactory.this == null) {
                throw null;
            }
            TransformerFn$class.$init$(this);
            this.names = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"md5"}));
            this.hasher = Hashing.md5();
        }
    }

    public class Murmur3_32
    implements TransformerFn {
        private final HashFunction hasher;
        private final Seq<String> names;

        @Override
        public TransformerFn getInstance() {
            return TransformerFn$class.getInstance(this);
        }

        private HashFunction hasher() {
            return this.hasher;
        }

        @Override
        public Seq<String> names() {
            return this.names;
        }

        @Override
        public Object eval(Object[] args, EvaluationContext ctx) {
            return this.hasher().hashString((CharSequence)args[0].toString(), StandardCharsets.UTF_8);
        }

        public /* synthetic */ IdFunctionFactory org$locationtech$geomesa$convert$IdFunctionFactory$Murmur3_32$$$outer() {
            return IdFunctionFactory.this;
        }

        public Murmur3_32() {
            if (IdFunctionFactory.this == null) {
                throw null;
            }
            TransformerFn$class.$init$(this);
            this.hasher = Hashing.murmur3_32();
            this.names = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"murmur3_32"}));
        }
    }

    public class Murmur3_64
    implements TransformerFn {
        private final HashFunction hasher;
        private final Seq<String> names;

        @Override
        public TransformerFn getInstance() {
            return TransformerFn$class.getInstance(this);
        }

        private HashFunction hasher() {
            return this.hasher;
        }

        @Override
        public Seq<String> names() {
            return this.names;
        }

        @Override
        public Object eval(Object[] args, EvaluationContext ctx) {
            return BoxesRunTime.boxToLong((long)this.hasher().hashString((CharSequence)args[0].toString(), StandardCharsets.UTF_8).asLong());
        }

        public /* synthetic */ IdFunctionFactory org$locationtech$geomesa$convert$IdFunctionFactory$Murmur3_64$$$outer() {
            return IdFunctionFactory.this;
        }

        public Murmur3_64() {
            if (IdFunctionFactory.this == null) {
                throw null;
            }
            TransformerFn$class.$init$(this);
            this.hasher = Hashing.murmur3_128();
            this.names = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"murmur3_64"}));
        }
    }
}

