/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.structure.opt;

import java.util.ArrayList;
import java.util.Iterator;
import org.geotools.graph.structure.Edge;
import org.geotools.graph.structure.Node;
import org.geotools.graph.structure.opt.OptGraphable;
import org.geotools.graph.structure.opt.OptNode;

public class OptEdge
extends OptGraphable
implements Edge {
    private OptNode m_nodeA;
    private OptNode m_nodeB;

    public OptEdge(OptNode nodeA, OptNode nodeB) {
        this.m_nodeA = nodeA;
        this.m_nodeB = nodeB;
    }

    @Override
    public Node getNodeA() {
        return this.m_nodeA;
    }

    @Override
    public Node getNodeB() {
        return this.m_nodeB;
    }

    @Override
    public Node getOtherNode(Node node) {
        return this.m_nodeA.equals(node) ? this.m_nodeB : (this.m_nodeB.equals(node) ? this.m_nodeA : null);
    }

    @Override
    public void reverse() {
        OptNode tmp = this.m_nodeA;
        this.m_nodeA = this.m_nodeB;
        this.m_nodeB = tmp;
    }

    @Override
    public int compareNodes(Edge other) {
        if (this.m_nodeA.equals(other.getNodeA()) && this.m_nodeB.equals(other.getNodeB())) {
            return 0;
        }
        if (this.m_nodeB.equals(other.getNodeA()) && this.m_nodeA.equals(other.getNodeB())) {
            return -1;
        }
        return 1;
    }

    @Override
    public Iterator getRelated() {
        return new RelatedIterator(this);
    }

    public class RelatedIterator
    implements Iterator {
        private Iterator m_itr;

        public RelatedIterator(OptEdge edge) {
            Edge e;
            int i;
            ArrayList<Edge> edges = new ArrayList<Edge>(OptEdge.this.m_nodeA.getDegree() + OptEdge.this.m_nodeB.getDegree() - 2 - OptEdge.this.m_nodeA.getEdges(OptEdge.this.m_nodeB).size());
            for (i = 0; i < OptEdge.this.m_nodeA.getEdgeArray().length; ++i) {
                e = OptEdge.this.m_nodeA.getEdgeArray()[i];
                if (e.equals(edge)) continue;
                edges.add(OptEdge.this.m_nodeA.getEdgeArray()[i]);
            }
            for (i = 0; i < OptEdge.this.m_nodeB.getEdgeArray().length; ++i) {
                e = OptEdge.this.m_nodeB.getEdgeArray()[i];
                if (e.getOtherNode(OptEdge.this.m_nodeB).equals(OptEdge.this.m_nodeA)) continue;
                edges.add(e);
            }
            this.m_itr = edges.iterator();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(this.getClass().getName() + "#remove() not supported.");
        }

        @Override
        public boolean hasNext() {
            return this.m_itr.hasNext();
        }

        public Object next() {
            return this.m_itr.next();
        }
    }
}

