/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.util.graph;

import org.geotools.graph.structure.Graph;
import org.geotools.graph.structure.Graphable;
import org.geotools.graph.traverse.GraphIterator;
import org.geotools.graph.traverse.GraphTraversal;
import org.geotools.graph.traverse.GraphWalker;
import org.geotools.graph.traverse.basic.BasicGraphTraversal;
import org.geotools.graph.traverse.standard.BreadthFirstTopologicalIterator;

public class CycleDetector
implements GraphWalker {
    private Graph m_graph;
    private int m_nvisited;
    private GraphIterator m_iterator;

    public CycleDetector(Graph graph) {
        this.m_graph = graph;
        this.m_nvisited = 0;
        this.m_iterator = this.createIterator();
    }

    public boolean containsCycle() {
        this.m_nvisited = 0;
        BasicGraphTraversal traversal = new BasicGraphTraversal(this.m_graph, this, this.m_iterator);
        traversal.init();
        traversal.traverse();
        return this.m_graph.getNodes().size() != this.m_nvisited;
    }

    @Override
    public int visit(Graphable element, GraphTraversal traversal) {
        ++this.m_nvisited;
        return 0;
    }

    @Override
    public void finish() {
    }

    protected GraphIterator createIterator() {
        return new BreadthFirstTopologicalIterator();
    }
}

