/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.crs;

import java.util.Collections;
import java.util.Date;
import java.util.Map;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Duration;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotools.referencing.crs.AbstractSingleCRS;
import org.geotools.referencing.cs.DefaultTimeCS;
import org.geotools.referencing.datum.DefaultTemporalDatum;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.TemporalDatum;

public class DefaultTemporalCRS
extends AbstractSingleCRS
implements TemporalCRS {
    private static final long serialVersionUID = 3000119849197222007L;
    public static final DefaultTemporalCRS JULIAN = new DefaultTemporalCRS(DefaultTemporalDatum.JULIAN, DefaultTimeCS.DAYS);
    public static final DefaultTemporalCRS MODIFIED_JULIAN = new DefaultTemporalCRS(DefaultTemporalDatum.MODIFIED_JULIAN, DefaultTimeCS.DAYS);
    public static final DefaultTemporalCRS TRUNCATED_JULIAN = new DefaultTemporalCRS(DefaultTemporalDatum.TRUNCATED_JULIAN, DefaultTimeCS.DAYS);
    public static final DefaultTemporalCRS DUBLIN_JULIAN = new DefaultTemporalCRS(DefaultTemporalDatum.DUBLIN_JULIAN, DefaultTimeCS.DAYS);
    public static final DefaultTemporalCRS UNIX = new DefaultTemporalCRS(DefaultTemporalDatum.UNIX, DefaultTimeCS.SECONDS);
    public static final DefaultTemporalCRS JAVA = new DefaultTemporalCRS(DefaultTemporalDatum.UNIX, DefaultTimeCS.MILLISECONDS);
    public static Unit<Duration> MILLISECOND = SI.MILLI((Unit)SI.SECOND);
    private transient UnitConverter toMillis;
    private transient long origin;

    public DefaultTemporalCRS(TemporalCRS crs) {
        super((SingleCRS)crs);
    }

    public DefaultTemporalCRS(TemporalDatum datum, TimeCS cs) {
        this(DefaultTemporalCRS.getProperties((IdentifiedObject)datum), datum, cs);
    }

    public DefaultTemporalCRS(String name, TemporalDatum datum, TimeCS cs) {
        this(Collections.singletonMap("name", name), datum, cs);
    }

    public DefaultTemporalCRS(Map<String, ?> properties, TemporalDatum datum, TimeCS cs) {
        super(properties, (Datum)datum, (CoordinateSystem)cs);
    }

    public static DefaultTemporalCRS wrap(TemporalCRS crs) {
        if (crs == null || crs instanceof DefaultTemporalCRS) {
            return (DefaultTemporalCRS)crs;
        }
        return new DefaultTemporalCRS(crs);
    }

    private void initializeConverter() {
        this.origin = ((TemporalDatum)this.datum).getOrigin().getTime();
        this.toMillis = this.coordinateSystem.getAxis(0).getUnit().getConverterTo(MILLISECOND);
    }

    public TimeCS getCoordinateSystem() {
        return (TimeCS)super.getCoordinateSystem();
    }

    public TemporalDatum getDatum() {
        return (TemporalDatum)super.getDatum();
    }

    public Date toDate(double value) {
        if (this.toMillis == null) {
            this.initializeConverter();
        }
        return new Date(Math.round(this.toMillis.convert(value)) + this.origin);
    }

    public double toValue(Date time) {
        if (this.toMillis == null) {
            this.initializeConverter();
        }
        return this.toMillis.inverse().convert((double)(time.getTime() - this.origin));
    }

    @Override
    public int hashCode() {
        return 0x86FFB877 ^ super.hashCode();
    }
}

