/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.filter.index;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import org.geotools.data.FeatureReader;
import org.geotools.data.simple.DelegateSimpleFeatureReader;
import org.geotools.data.simple.FilteringSimpleFeatureReader;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureReader;
import org.geotools.feature.collection.DelegateSimpleFeatureIterator;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.filter.index.SpatialIndexSupport;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Or;
import org.opengis.filter.spatial.BinarySpatialOperator;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;

public abstract class SpatialIndexSupport$class {
    public static SimpleFeatureReader getReaderForFilter(SpatialIndexSupport $this, Filter filter) {
        SimpleFeatureReader simpleFeatureReader;
        Filter filter2 = filter;
        if (filter2 instanceof IncludeFilter) {
            simpleFeatureReader = $this.include();
        } else if (filter2 instanceof BinarySpatialOperator) {
            BinarySpatialOperator binarySpatialOperator = (BinarySpatialOperator)filter2;
            simpleFeatureReader = $this.spatial(binarySpatialOperator);
        } else if (filter2 instanceof And) {
            And and2 = (And)filter2;
            simpleFeatureReader = $this.and(and2);
        } else if (filter2 instanceof Or) {
            Or or = (Or)filter2;
            simpleFeatureReader = $this.or(or);
        } else {
            simpleFeatureReader = $this.unoptimized(filter2);
        }
        return simpleFeatureReader;
    }

    public static SimpleFeatureReader include(SpatialIndexSupport $this) {
        return $this.reader($this.allFeatures());
    }

    public static SimpleFeatureReader spatial(SpatialIndexSupport $this, BinarySpatialOperator f) {
        SimpleFeatureReader simpleFeatureReader;
        FilterValues<Geometry> geometries = FilterHelper$.MODULE$.extractGeometries((Filter)f, RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType($this.sft())), false);
        if (geometries.isEmpty()) {
            simpleFeatureReader = $this.unoptimized((Filter)f);
        } else {
            Envelope envelope = ((Geometry)geometries.values().head()).getEnvelopeInternal();
            ((IterableLike)geometries.values().tail()).foreach((Function1)new Serializable($this, envelope){
                public static final long serialVersionUID = 0L;
                private final Envelope envelope$1;

                public final void apply(Geometry g) {
                    this.envelope$1.expandToInclude(g.getEnvelopeInternal());
                }
                {
                    this.envelope$1 = envelope$1;
                }
            });
            simpleFeatureReader = $this.reader((Iterator<SimpleFeature>)$this.spatialIndex().query(envelope, (Function1)new Serializable($this, f){
                public static final long serialVersionUID = 0L;
                private final BinarySpatialOperator f$1;

                public final boolean apply(Object x$1) {
                    return this.f$1.evaluate(x$1);
                }
                {
                    this.f$1 = f$1;
                }
            }));
        }
        return simpleFeatureReader;
    }

    public static SimpleFeatureReader and(SpatialIndexSupport $this, And a) {
        SimpleFeatureReader simpleFeatureReader;
        FilterValues<Geometry> geometries = FilterHelper$.MODULE$.extractGeometries((Filter)a, $this.sft().getGeometryDescriptor().getLocalName(), false);
        if (geometries.isEmpty()) {
            simpleFeatureReader = $this.unoptimized((Filter)a);
        } else {
            Envelope envelope = ((Geometry)geometries.values().head()).getEnvelopeInternal();
            ((IterableLike)geometries.values().tail()).foreach((Function1)new Serializable($this, envelope){
                public static final long serialVersionUID = 0L;
                private final Envelope envelope$2;

                public final void apply(Geometry g) {
                    this.envelope$2.expandToInclude(g.getEnvelopeInternal());
                }
                {
                    this.envelope$2 = envelope$2;
                }
            });
            simpleFeatureReader = $this.reader((Iterator<SimpleFeature>)$this.spatialIndex().query(envelope, (Function1)new Serializable($this, a){
                public static final long serialVersionUID = 0L;
                private final And a$1;

                public final boolean apply(Object x$1) {
                    return this.a$1.evaluate(x$1);
                }
                {
                    this.a$1 = a$1;
                }
            }));
        }
        return simpleFeatureReader;
    }

    public static SimpleFeatureReader or(SpatialIndexSupport $this, Or o) {
        Buffer readers = (Buffer)((TraversableLike)JavaConversions$.MODULE$.asScalaBuffer(o.getChildren()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SpatialIndexSupport $outer;

            public final SimpleFeatureReader apply(Filter filter) {
                return this.$outer.getReaderForFilter(filter);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Buffer$.MODULE$.canBuildFrom())).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final SelfClosingIterator<SimpleFeature> apply(SimpleFeatureReader x$1) {
                return SelfClosingIterator$.MODULE$.apply((FeatureReader)x$1);
            }
        }, Buffer$.MODULE$.canBuildFrom());
        CloseableIterator composed = (CloseableIterator)readers.foldLeft((Object)CloseableIterator$.MODULE$.empty(), (Function2)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final CloseableIterator<SimpleFeature> apply(CloseableIterator<SimpleFeature> x$2, SelfClosingIterator<SimpleFeature> x$3) {
                return x$2.$plus$plus((Function0)new Serializable(this, x$3){
                    public static final long serialVersionUID = 0L;
                    private final SelfClosingIterator x$3$1;

                    public final SelfClosingIterator<SimpleFeature> apply() {
                        return this.x$3$1;
                    }
                    {
                        this.x$3$1 = x$3$1;
                    }
                });
            }
        });
        return $this.reader((Iterator<SimpleFeature>)composed);
    }

    public static SimpleFeatureReader unoptimized(SpatialIndexSupport $this, Filter f) {
        return new FilteringSimpleFeatureReader($this.include(), f);
    }

    public static SimpleFeatureReader reader(SpatialIndexSupport $this, Iterator iter) {
        return new DelegateSimpleFeatureReader($this.sft(), (SimpleFeatureIterator)new DelegateSimpleFeatureIterator(JavaConversions$.MODULE$.asJavaIterator(iter)));
    }

    public static void $init$(SpatialIndexSupport $this) {
    }
}

