/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.data;

import com.beust.jcommander.ParameterException;
import java.io.IOException;
import java.util.regex.Pattern;
import org.geotools.data.DataStore;
import org.locationtech.geomesa.tools.Command$;
import org.locationtech.geomesa.tools.data.RemoveSchemaCommand;
import org.locationtech.geomesa.tools.utils.Prompt$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;

public abstract class RemoveSchemaCommand$class {
    public static void execute(RemoveSchemaCommand $this) {
        Tuple2 tuple2;
        block9: {
            block8: {
                block7: {
                    tuple2 = new Tuple2((Object)Option$.MODULE$.apply((Object)$this.params().pattern()), (Object)Option$.MODULE$.apply((Object)$this.params().featureName()));
                    if (tuple2 != null) {
                        Option option = (Option)tuple2._1();
                        Option option2 = (Option)tuple2._2();
                        if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
                            throw new ParameterException("Please provide either featureName or pattern");
                        }
                    }
                    if (tuple2 != null) {
                        Option option = (Option)tuple2._1();
                        Option option3 = (Option)tuple2._2();
                        if (option instanceof Some && option3 instanceof Some) {
                            throw new ParameterException("Cannot specify both featureName and pattern");
                        }
                    }
                    if (tuple2 == null) break block7;
                    Option option = (Option)tuple2._1();
                    Option option4 = (Option)tuple2._2();
                    if (!(option instanceof Some)) break block7;
                    Some some = (Some)option;
                    Pattern pattern = (Pattern)some.x();
                    if (!None$.MODULE$.equals(option4)) break block7;
                    BoxedUnit boxedUnit = (BoxedUnit)$this.withDataStore(new Serializable($this, pattern){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ RemoveSchemaCommand $outer;
                        private final Pattern pattern$1;

                        public final void apply(DS x$1) {
                            this.$outer.remove(x$1, this.pattern$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.pattern$1 = pattern$1;
                        }
                    });
                    break block8;
                }
                if (tuple2 == null) break block9;
                Option option = (Option)tuple2._1();
                Option option5 = (Option)tuple2._2();
                if (!None$.MODULE$.equals(option) || !(option5 instanceof Some)) break block9;
                Some some = (Some)option5;
                String typeName = (String)some.x();
                BoxedUnit boxedUnit = (BoxedUnit)$this.withDataStore(new Serializable($this, typeName){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ RemoveSchemaCommand $outer;
                    private final String typeName$1;

                    public final void apply(DS x$2) {
                        this.$outer.remove(x$2, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.typeName$1}))));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.typeName$1 = typeName$1;
                    }
                });
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static void remove(RemoveSchemaCommand $this, DataStore ds, Pattern pattern) {
        String[] typeNames = (String[])Predef$.MODULE$.refArrayOps((Object[])ds.getTypeNames()).filter((Function1)new Serializable($this, pattern){
            public static final long serialVersionUID = 0L;
            private final Pattern pattern$2;

            public final boolean apply(String x$3) {
                return this.pattern$2.matcher(x$3).matches();
            }
            {
                this.pattern$2 = pattern$2;
            }
        });
        if (Predef$.MODULE$.refArrayOps((Object[])typeNames).isEmpty()) {
            Command$.MODULE$.user().warn("No schemas matched the provided pattern");
        } else {
            $this.remove(ds, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])typeNames));
        }
    }

    public static void remove(RemoveSchemaCommand $this, DataStore ds, Seq typeNames) {
        if ($this.params().force() || $this.promptConfirm((Seq<String>)typeNames)) {
            typeNames.foreach((Function1)new Serializable($this, ds){
                public static final long serialVersionUID = 0L;
                private final DataStore ds$1;

                public final void apply(String typeName) {
                    boolean bl;
                    try {
                        bl = this.ds$1.getSchema(typeName) == null;
                    }
                    catch (IOException iOException) {
                        bl = true;
                    }
                    if (bl) {
                        Command$.MODULE$.user().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Schema '", "' doesn't exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeName})));
                    } else {
                        boolean bl2;
                        Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removing '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeName})));
                        this.ds$1.removeSchema(typeName);
                        try {
                            bl2 = this.ds$1.getSchema(typeName) != null;
                        }
                        catch (IOException iOException) {
                            bl2 = false;
                        }
                        if (bl2) {
                            Command$.MODULE$.user().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error removing feature type '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeName})));
                        }
                    }
                }
                {
                    this.ds$1 = ds$1;
                }
            });
        } else {
            Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cancelled schema removal"})).s((Seq)Nil$.MODULE$));
        }
    }

    public static boolean promptConfirm(RemoveSchemaCommand $this, Seq featureNames) {
        return Prompt$.MODULE$.confirm(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Remove schema(s) ", "? (yes/no): "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{featureNames.mkString(", ")})), Prompt$.MODULE$.confirm$default$2());
    }

    public static void $init$(RemoveSchemaCommand $this) {
        $this.org$locationtech$geomesa$tools$data$RemoveSchemaCommand$_setter_$name_$eq("remove-schema");
    }
}

