/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.export.formats;

import java.io.OutputStream;
import org.geotools.GML;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.store.ReTypingFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.geomesa.tools.export.formats.FeatureExporter;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.None$;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00193A!\u0001\u0002\u0001\u001f\tYq)\u001c7FqB|'\u000f^3s\u0015\t\u0019A!A\u0004g_Jl\u0017\r^:\u000b\u0005\u00151\u0011AB3ya>\u0014HO\u0003\u0002\b\u0011\u0005)Ao\\8mg*\u0011\u0011BC\u0001\bO\u0016|W.Z:b\u0015\tYA\"\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\r\u0001\u0001\u0003\u0007\t\u0003#Yi\u0011A\u0005\u0006\u0003'Q\tA\u0001\\1oO*\tQ#\u0001\u0003kCZ\f\u0017BA\f\u0013\u0005\u0019y%M[3diB\u0011\u0011DG\u0007\u0002\u0005%\u00111D\u0001\u0002\u0010\r\u0016\fG/\u001e:f\u000bb\u0004xN\u001d;fe\"AQ\u0004\u0001B\u0001B\u0003%a$\u0001\u0002pgB\u0011qDI\u0007\u0002A)\u0011\u0011\u0005F\u0001\u0003S>L!a\t\u0011\u0003\u0019=+H\u000f];u'R\u0014X-Y7\t\u000b\u0015\u0002A\u0011\u0001\u0014\u0002\rqJg.\u001b;?)\t9\u0003\u0006\u0005\u0002\u001a\u0001!)Q\u0004\na\u0001=!)Q\u0001\u0001C!UQ\u00111\u0006\u000e\t\u0004Y=\nT\"A\u0017\u000b\u00039\nQa]2bY\u0006L!\u0001M\u0017\u0003\r=\u0003H/[8o!\ta#'\u0003\u00024[\t!Aj\u001c8h\u0011\u0015)\u0014\u00061\u00017\u0003!1W-\u0019;ve\u0016\u001c\bCA\u001c?\u001b\u0005A$BA\u001d;\u0003\u0019\u0019\u0018.\u001c9mK*\u00111\bP\u0001\u0005I\u0006$\u0018M\u0003\u0002>\u0019\u0005Aq-Z8u_>d7/\u0003\u0002@q\t92+[7qY\u00164U-\u0019;ve\u0016\u001cu\u000e\u001c7fGRLwN\u001c\u0005\u0006\u0003\u0002!\tEQ\u0001\u0006G2|7/\u001a\u000b\u0002\u0007B\u0011A\u0006R\u0005\u0003\u000b6\u0012A!\u00168ji\u0002")
public class GmlExporter
implements FeatureExporter {
    private final OutputStream os;

    @Override
    public Option<Object> export(SimpleFeatureCollection features) {
        SimpleFeatureCollection simpleFeatureCollection;
        GML encode = new GML(GML.Version.WFS1_0);
        encode.setNamespace("geomesa", "http://geomesa.org");
        if (features.getSchema().getName().getNamespaceURI() == null) {
            SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
            builder.init((SimpleFeatureType)features.getSchema());
            builder.setNamespaceURI("http://geomesa.org");
            SimpleFeatureType namespacedSFT = builder.buildFeatureType();
            simpleFeatureCollection = new ReTypingFeatureCollection(features, namespacedSFT);
        } else {
            simpleFeatureCollection = features;
        }
        SimpleFeatureCollection fcToWrite = simpleFeatureCollection;
        encode.encode(this.os, fcToWrite);
        return None$.MODULE$;
    }

    @Override
    public void close() {
        this.os.flush();
        this.os.close();
    }

    public GmlExporter(OutputStream os) {
        this.os = os;
    }
}

