/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.ingest;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.IOUtils;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.factory.Hints;
import org.geotools.filter.identity.FeatureIdImpl;
import org.joda.time.format.PeriodFormatter;
import org.locationtech.geomesa.tools.Command$;
import org.locationtech.geomesa.tools.ingest.AbstractIngest;
import org.locationtech.geomesa.tools.ingest.AbstractIngest$;
import org.locationtech.geomesa.tools.ingest.LocalIngestConverter;
import org.locationtech.geomesa.utils.classpath.PathUtils$;
import org.locationtech.geomesa.utils.stats.CountingInputStream;
import org.locationtech.geomesa.utils.text.TextTools$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tEb!B\u0001\u0003\u0003\u0003i!AD!cgR\u0014\u0018m\u0019;J]\u001e,7\u000f\u001e\u0006\u0003\u0007\u0011\ta!\u001b8hKN$(BA\u0003\u0007\u0003\u0015!xn\u001c7t\u0015\t9\u0001\"A\u0004hK>lWm]1\u000b\u0005%Q\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001qa#\u0007\t\u0003\u001fQi\u0011\u0001\u0005\u0006\u0003#I\tA\u0001\\1oO*\t1#\u0001\u0003kCZ\f\u0017BA\u000b\u0011\u0005\u0019y%M[3diB\u0011qbF\u0005\u00031A\u0011\u0001BU;o]\u0006\u0014G.\u001a\t\u00035\u0005j\u0011a\u0007\u0006\u00039u\tAb]2bY\u0006dwnZ4j]\u001eT!AH\u0010\u0002\u0011QL\b/Z:bM\u0016T\u0011\u0001I\u0001\u0004G>l\u0017B\u0001\u0012\u001c\u0005-a\u0015M_=M_\u001e<\u0017N\\4\t\u0011\u0011\u0002!Q1A\u0005\u0002\u0015\n\u0001\u0002Z:QCJ\fWn]\u000b\u0002MA!q%\f\u00191\u001d\tA3&D\u0001*\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0003\u0019\u0001&/\u001a3fM&\u0011af\f\u0002\u0004\u001b\u0006\u0004(B\u0001\u0017*!\t9\u0013'\u0003\u00023_\t11\u000b\u001e:j]\u001eD\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006IAJ\u0001\nIN\u0004\u0016M]1ng\u0002B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006I\u0001M\u0001\tif\u0004XMT1nK\"A\u0001\b\u0001B\u0001B\u0003%\u0011(\u0001\u0004j]B,Ho\u001d\t\u0004u\t\u0003dBA\u001eA\u001d\tat(D\u0001>\u0015\tqD\"\u0001\u0004=e>|GOP\u0005\u0002U%\u0011\u0011)K\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0019EIA\u0002TKFT!!Q\u0015\t\u0011\u0019\u0003!\u0011!Q\u0001\nA\n1\u0002\\5cU\u0006\u00148OR5mK\"A\u0001\n\u0001B\u0001B\u0003%\u0011*\u0001\u0007mS\nT\u0017M]:QCRD7\u000fE\u0002;\u00152K!a\u0013#\u0003\u0011%#XM]1u_J\u00042\u0001K'P\u0013\tq\u0015FA\u0005Gk:\u001cG/[8oaA\u0019!H\u0011)\u0011\u0005E#V\"\u0001*\u000b\u0005M\u0013\u0012AA5p\u0013\t)&K\u0001\u0003GS2,\u0007\u0002C,\u0001\u0005\u0003\u0005\u000b\u0011\u0002-\u0002\u001f9,X\u000eT8dC2$\u0006N]3bIN\u0004\"\u0001K-\n\u0005iK#aA%oi\")A\f\u0001C\u0001;\u00061A(\u001b8jiz\"rA\u00181bE\u000e$W\r\u0005\u0002`\u00015\t!\u0001C\u0003%7\u0002\u0007a\u0005C\u000377\u0002\u0007\u0001\u0007C\u000397\u0002\u0007\u0011\bC\u0003G7\u0002\u0007\u0001\u0007C\u0003I7\u0002\u0007\u0011\nC\u0003X7\u0002\u0007\u0001\fC\u0003h\u0001\u0019\u0005\u0001.\u0001\bcK\u001a|'/\u001a*v]R\u000b7o[:\u0015\u0003%\u0004\"\u0001\u000b6\n\u0005-L#\u0001B+oSRDQ!\u001c\u0001\u0007\u00029\fAc\u0019:fCR,Gj\\2bY\u000e{gN^3si\u0016\u0014HcA8siB\u0011q\f]\u0005\u0003c\n\u0011A\u0003T8dC2LenZ3ti\u000e{gN^3si\u0016\u0014\b\"B:m\u0001\u0004\u0001\u0016\u0001\u00024jY\u0016DQ!\u001e7A\u0002Y\f\u0001BZ1jYV\u0014Xm\u001d\t\u0003ozl\u0011\u0001\u001f\u0006\u0003sj\fa!\u0019;p[&\u001c'BA>}\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003{J\tA!\u001e;jY&\u0011q\u0010\u001f\u0002\u000b\u0003R|W.[2M_:<\u0007bBA\u0002\u0001\u0019\u0005\u0011QA\u0001\u0012eVtG)[:ue&\u0014W\u000f^3e\u0015>\u0014G\u0003BA\u0004\u0003'\u0001r\u0001KA\u0005\u0003\u001b\ti!C\u0002\u0002\f%\u0012a\u0001V;qY\u0016\u0014\u0004c\u0001\u0015\u0002\u0010%\u0019\u0011\u0011C\u0015\u0003\t1{gn\u001a\u0005\t\u0003+\t\t\u00011\u0001\u0002\u0018\u0005q1\u000f^1ukN\u001c\u0015\r\u001c7cC\u000e\\\u0007\u0003BA\r\u0003Wr1aXA\u000e\u000f\u001d\tiB\u0001E\u0001\u0003?\ta\"\u00112tiJ\f7\r^%oO\u0016\u001cH\u000fE\u0002`\u0003C1a!\u0001\u0002\t\u0002\u0005\r2\u0003BA\u0011\u0003K\u00012\u0001KA\u0014\u0013\r\tI#\u000b\u0002\u0007\u0003:L(+\u001a4\t\u000fq\u000b\t\u0003\"\u0001\u0002.Q\u0011\u0011q\u0004\u0005\u000b\u0003c\t\tC1A\u0005\u0002\u0005M\u0012a\u0004)fe&|GMR8s[\u0006$H/\u001a:\u0016\u0005\u0005U\u0002\u0003BA\u001c\u0003\u000bj!!!\u000f\u000b\t\u0005m\u0012QH\u0001\u0007M>\u0014X.\u0019;\u000b\t\u0005}\u0012\u0011I\u0001\u0005i&lWMC\u0002\u0002D)\tAA[8eC&!\u0011qIA\u001d\u0005=\u0001VM]5pI\u001a{'/\\1ui\u0016\u0014\b\"CA&\u0003C\u0001\u000b\u0011BA\u001b\u0003A\u0001VM]5pI\u001a{'/\\1ui\u0016\u0014\b\u0005C\u0006\u0002P\u0005\u0005\u0002R1A\u0005\n\u0005E\u0013!\u0004;fe6Lg.\u00197XS\u0012$\b.\u0006\u0002\u0002TA!\u0001&TA+!\rA\u0013qK\u0005\u0004\u00033J#!\u0002$m_\u0006$\bbCA/\u0003CA\t\u0011)Q\u0005\u0003'\na\u0002^3s[&t\u0017\r\\,jIRD\u0007\u0005\u0003\u0005\u0002b\u0005\u0005B\u0011AA2\u0003-9W\r^*uCRLeNZ8\u0015\u000bA\n)'!\u001b\t\u0011\u0005\u001d\u0014q\fa\u0001\u0003\u001b\t\u0011b];dG\u0016\u001c8/Z:\t\u000fU\fy\u00061\u0001\u0002\u000e\u0019Q\u0011QNA\u0011!\u0003\r\n#a\u001c\u0003\u001dM#\u0018\r^;t\u0007\u0006dGNY1dWN!\u00111NA\u0013\u0011\u001d\t\u0019(a\u001b\u0007\u0002!\fQA]3tKRD\u0001\"a\u001e\u0002l\u0019\u0005\u0011\u0011P\u0001\u0006CB\u0004H.\u001f\u000b\nS\u0006m\u0014qPAB\u0003\u0017Cq!! \u0002v\u0001\u0007\u0001'\u0001\u0004qe\u00164\u0017\u000e\u001f\u0005\t\u0003\u0003\u000b)\b1\u0001\u0002V\u0005A\u0001O]8he\u0016\u001c8\u000f\u0003\u0005\u0002\u0006\u0006U\u0004\u0019AAD\u0003!\u0019w.\u001e8uKJ\u001c\b\u0003\u0002\u001eC\u0003\u0013\u0003b\u0001KA\u0005a\u00055\u0001\u0002CAG\u0003k\u0002\r!a$\u0002\t\u0011|g.\u001a\t\u0004Q\u0005E\u0015bAAJS\t9!i\\8mK\u0006t\u0017\u0006BA6\u0003/3q!!'\u0002\"\u0001\tYJA\u0007Qe&tG\u000f\u0015:pOJ,7o]\n\u0007\u0003/\u000b)#!(\u0011\t\u0005}\u00151N\u0007\u0003\u0003CA1\"a)\u0002\u0018\n\u0005\t\u0015!\u0003\u0002&\u0006\u0019q.\u001e;\u0011\u0007E\u000b9+C\u0002\u0002*J\u00131\u0002\u0015:j]R\u001cFO]3b[\"Q\u0011QVAL\u0005\u0003\u0005\u000b\u0011\u0002\u0019\u0002\u0011\u0015l\u0007\u000f^=CCJD1\"!-\u0002\u0018\n\u0005\t\u0015!\u0003\u00024\u0006Y!/\u001a9mC\u000e,W.\u001a8u!\rA\u0013QW\u0005\u0004\u0003oK#\u0001B\"iCJD1\"a/\u0002\u0018\n\u0005\t\u0015!\u0003\u00024\u0006I\u0011N\u001c3jG\u0006$xN\u001d\u0005\f\u0003\u007f\u000b9J!A!\u0002\u0013\t\u0019,\u0001\u0004u_\u001e<G.\u001a\u0005\b9\u0006]E\u0011AAb)1\t)-a2\u0002J\u0006-\u0017QZAh!\u0011\ty*a&\t\u0011\u0005\r\u0016\u0011\u0019a\u0001\u0003KCq!!,\u0002B\u0002\u0007\u0001\u0007\u0003\u0005\u00022\u0006\u0005\u0007\u0019AAZ\u0011!\tY,!1A\u0002\u0005M\u0006\u0002CA`\u0003\u0003\u0004\r!a-\t\u0015\u0005M\u0017q\u0013a\u0001\n\u0013\t).A\u0004u_\u001e<G.\u001a3\u0016\u0005\u0005=\u0005BCAm\u0003/\u0003\r\u0011\"\u0003\u0002\\\u0006YAo\\4hY\u0016$w\fJ3r)\rI\u0017Q\u001c\u0005\u000b\u0003?\f9.!AA\u0002\u0005=\u0015a\u0001=%c!I\u00111]ALA\u0003&\u0011qR\u0001\ti><w\r\\3eA!Q\u0011q]AL\u0001\u0004%I!!;\u0002\u000bM$\u0018M\u001d;\u0016\u0005\u00055\u0001BCAw\u0003/\u0003\r\u0011\"\u0003\u0002p\u0006I1\u000f^1si~#S-\u001d\u000b\u0004S\u0006E\bBCAp\u0003W\f\t\u00111\u0001\u0002\u000e!I\u0011Q_ALA\u0003&\u0011QB\u0001\u0007gR\f'\u000f\u001e\u0011\t\u000f\u0005M\u0014q\u0013C!Q\"A\u0011qOAL\t\u0003\nY\u0010F\u0005j\u0003{\fyP!\u0001\u0003\u0004!9\u0011QPA}\u0001\u0004\u0001\u0004\u0002CAA\u0003s\u0004\r!!\u0016\t\u0011\u0005\u0015\u0015\u0011 a\u0001\u0003\u000fC\u0001\"!$\u0002z\u0002\u0007\u0011q\u0012\u0005\n\u0005\u000f\u0001!\u0019!C\t\u0005\u0013\t!\u0001Z:\u0016\u0005\t-\u0001\u0003\u0002B\u0007\u0005/i!Aa\u0004\u000b\t\tE!1C\u0001\u0005I\u0006$\u0018MC\u0002\u0003\u0016)\t\u0001bZ3pi>|Gn]\u0005\u0005\u00053\u0011yAA\u0005ECR\f7\u000b^8sK\"A!Q\u0004\u0001!\u0002\u0013\u0011Y!A\u0002eg\u0002BaA!\t\u0001\t\u0003B\u0017a\u0001:v]\"1!Q\u0005\u0001\u0005\n!\f\u0001B];o\u0019>\u001c\u0017\r\u001c\u0005\u0007\u0005S\u0001A\u0011\u00025\u0002\u001dI,h\u000eR5tiJL'-\u001e;fI\"9!Q\u0006\u0001\u0005\n\t=\u0012AD2sK\u0006$XmQ1mY\n\f7m\u001b\u000b\u0003\u0003/\u0001")
public abstract class AbstractIngest
implements Runnable,
LazyLogging {
    private final scala.collection.immutable.Map<String, String> dsParams;
    public final String org$locationtech$geomesa$tools$ingest$AbstractIngest$$typeName;
    private final Seq<String> inputs;
    private final int numLocalThreads;
    private final DataStore ds;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static String getStatInfo(long l, long l2) {
        return AbstractIngest$.MODULE$.getStatInfo(l, l2);
    }

    public static PeriodFormatter PeriodFormatter() {
        return AbstractIngest$.MODULE$.PeriodFormatter();
    }

    private Logger logger$lzycompute() {
        AbstractIngest abstractIngest = this;
        synchronized (abstractIngest) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public scala.collection.immutable.Map<String, String> dsParams() {
        return this.dsParams;
    }

    public abstract void beforeRunTasks();

    public abstract LocalIngestConverter createLocalConverter(File var1, AtomicLong var2);

    public abstract Tuple2<Object, Object> runDistributedJob(StatusCallback var1);

    public DataStore ds() {
        return this.ds;
    }

    @Override
    public void run() {
        this.beforeRunTasks();
        Seq distPrefixes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hdfs://", "s3n://", "s3a://", "wasb://", "wasbs://"}));
        String string = ((String)this.inputs.head()).toLowerCase();
        if (distPrefixes.exists((Function1)new Serializable(this, string){
            public static final long serialVersionUID = 0L;
            private final String eta$0$1$1;

            public final boolean apply(String x$1) {
                return this.eta$0$1$1.startsWith(x$1);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        })) {
            Command$.MODULE$.user().info("Running ingestion in distributed mode");
            this.runDistributed();
        } else {
            Command$.MODULE$.user().info("Running ingestion in local mode");
            this.runLocal();
        }
        this.ds().dispose();
    }

    /*
     * WARNING - void declaration
     */
    private void runLocal() {
        Tuple2 tuple2 = new Tuple2((Object)new AtomicLong(0L), (Object)new AtomicLong(0L));
        if (tuple2 != null) {
            int n;
            Tuple2 tuple22;
            AtomicLong written = (AtomicLong)tuple2._1();
            AtomicLong failed2 = (AtomicLong)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)written, (Object)failed2);
            AtomicLong written2 = (AtomicLong)tuple23._1();
            AtomicLong failed3 = (AtomicLong)tuple23._2();
            AtomicLong bytesRead = new AtomicLong(0L);
            Seq files = (Seq)this.inputs.flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final List<File> apply(String path) {
                    return PathUtils$.MODULE$.interpretPath(path);
                }
            }, Seq$.MODULE$.canBuildFrom());
            int numFiles = files.length();
            float totalLength = BoxesRunTime.unboxToLong((Object)((TraversableOnce)files.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply(File x$3) {
                    return x$3.length();
                }
            }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            if (this.numLocalThreads <= numFiles) {
                n = this.numLocalThreads;
            } else {
                Command$.MODULE$.user().warn("Can't use more threads than there are input files - reducing thread count");
                n = numFiles;
            }
            int threads = n;
            Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ingesting ", " with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TextTools$.MODULE$.getPlural((long)numFiles, "file"), TextTools$.MODULE$.getPlural((long)threads, "thread")})));
            long start = System.currentTimeMillis();
            StatusCallback statusCallback = this.createCallback();
            ExecutorService es = Executors.newFixedThreadPool(threads);
            Seq futures = (Seq)files.map((Function1)new Serializable(this, written2, failed3, bytesRead, es){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AbstractIngest $outer;
                private final AtomicLong written$1;
                private final AtomicLong failed$1;
                private final AtomicLong bytesRead$1;
                private final ExecutorService es$1;

                public final Future<?> apply(File f) {
                    public class Org_locationtech_geomesa_tools_ingest_AbstractIngest$LocalIngestWorker$1
                    implements Runnable {
                        private final File file;
                        public final /* synthetic */ AbstractIngest $outer;
                        public final AtomicLong written$1;
                        public final AtomicLong failed$1;
                        public final AtomicLong bytesRead$1;

                        /*
                         * WARNING - void declaration
                         */
                        public void run() {
                            block11: {
                                try {
                                    Tuple2<SimpleFeatureType, Iterator<SimpleFeature>> tuple2;
                                    block10: {
                                        ObjectRef fw = ObjectRef.create(null);
                                        LocalIngestConverter converter = this.org$locationtech$geomesa$tools$ingest$AbstractIngest$LocalIngestWorker$$$outer().createLocalConverter(this.file, this.failed$1);
                                        CountingInputStream countingStream = new CountingInputStream((InputStream)new FileInputStream(this.file));
                                        InputStream is = PathUtils$.MODULE$.handleCompression((InputStream)countingStream, this.file.getPath());
                                        try {
                                            Tuple2 tuple22;
                                            tuple2 = converter.convert(is);
                                            if (tuple2 == null) break block10;
                                            SimpleFeatureType sft = (SimpleFeatureType)tuple2._1();
                                            Iterator features = (Iterator)tuple2._2();
                                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)sft, (Object)features);
                                            SimpleFeatureType sft2 = (SimpleFeatureType)tuple23._1();
                                            Iterator features2 = (Iterator)tuple23._2();
                                            if (features2.hasNext()) {
                                                this.org$locationtech$geomesa$tools$ingest$AbstractIngest$LocalIngestWorker$$$outer().ds().createSchema((FeatureType)sft2);
                                                fw.elem = this.org$locationtech$geomesa$tools$ingest$AbstractIngest$LocalIngestWorker$$$outer().ds().getFeatureWriterAppend(this.org$locationtech$geomesa$tools$ingest$AbstractIngest$LocalIngestWorker$$$outer().org$locationtech$geomesa$tools$ingest$AbstractIngest$$typeName, Transaction.AUTO_COMMIT);
                                            }
                                            features2.foreach((Function1)new Serializable(this, fw, countingStream){
                                                public static final long serialVersionUID = 0L;
                                                private final /* synthetic */ Org_locationtech_geomesa_tools_ingest_AbstractIngest$LocalIngestWorker$1 $outer;
                                                private final ObjectRef fw$1;
                                                private final CountingInputStream countingStream$1;

                                                public final void apply(SimpleFeature sf) {
                                                    long l;
                                                    SimpleFeature toWrite = (SimpleFeature)((FeatureWriter)this.fw$1.elem).next();
                                                    toWrite.setAttributes(sf.getAttributes());
                                                    ((FeatureIdImpl)toWrite.getIdentifier()).setID(sf.getID());
                                                    toWrite.getUserData().putAll(sf.getUserData());
                                                    toWrite.getUserData().put(Hints.USE_PROVIDED_FID, Boolean.TRUE);
                                                    try {
                                                        ((FeatureWriter)this.fw$1.elem).write();
                                                        l = this.$outer.written$1.incrementAndGet();
                                                    }
                                                    catch (Throwable throwable) {
                                                        long l2;
                                                        BoxedUnit boxedUnit;
                                                        Throwable throwable2 = throwable;
                                                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                                                        if (option.isEmpty()) {
                                                            throw throwable;
                                                        }
                                                        Throwable e = (Throwable)option.get();
                                                        if (this.$outer.org$locationtech$geomesa$tools$ingest$AbstractIngest$LocalIngestWorker$$$outer().logger().underlying().isErrorEnabled()) {
                                                            this.$outer.org$locationtech$geomesa$tools$ingest$AbstractIngest$LocalIngestWorker$$$outer().logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to write '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DataUtilities.encodeFeature((SimpleFeature)toWrite)})), e);
                                                            boxedUnit = BoxedUnit.UNIT;
                                                        } else {
                                                            boxedUnit = BoxedUnit.UNIT;
                                                        }
                                                        l = l2 = this.$outer.failed$1.incrementAndGet();
                                                    }
                                                    this.$outer.bytesRead$1.addAndGet(this.countingStream$1.getCount());
                                                    this.countingStream$1.resetCount();
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw null;
                                                    }
                                                    this.$outer = $outer;
                                                    this.fw$1 = fw$1;
                                                    this.countingStream$1 = countingStream$1;
                                                }
                                            });
                                        }
                                        catch (Throwable throwable) {
                                            void var8_1;
                                            void var11_4;
                                            void var9_2;
                                            IOUtils.closeQuietly((Closeable)var9_2);
                                            IOUtils.closeQuietly((InputStream)var11_4);
                                            IOUtils.closeQuietly((Closeable)((FeatureWriter)var8_1.elem));
                                            throw throwable;
                                        }
                                        IOUtils.closeQuietly((Closeable)converter);
                                        IOUtils.closeQuietly((InputStream)is);
                                        IOUtils.closeQuietly((Closeable)((FeatureWriter)fw.elem));
                                        break block11;
                                    }
                                    throw new MatchError(tuple2);
                                }
                                catch (Throwable throwable) {
                                    BoxedUnit boxedUnit;
                                    Throwable throwable2 = throwable;
                                    boolean bl = throwable2 instanceof ClassNotFoundException ? true : throwable2 instanceof NoClassDefFoundError;
                                    if (bl) {
                                        throw throwable2;
                                    }
                                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                                    if (option.isEmpty()) {
                                        throw throwable;
                                    }
                                    Throwable e = (Throwable)option.get();
                                    String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fatal error running local ingest worker on file ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file.getPath()}));
                                    Command$.MODULE$.user().error(msg);
                                    if (this.org$locationtech$geomesa$tools$ingest$AbstractIngest$LocalIngestWorker$$$outer().logger().underlying().isErrorEnabled()) {
                                        this.org$locationtech$geomesa$tools$ingest$AbstractIngest$LocalIngestWorker$$$outer().logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fatal error running local ingest worker on file ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file.getPath()})), e);
                                        boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                    BoxedUnit boxedUnit2 = boxedUnit;
                                }
                            }
                        }

                        public /* synthetic */ AbstractIngest org$locationtech$geomesa$tools$ingest$AbstractIngest$LocalIngestWorker$$$outer() {
                            return this.$outer;
                        }

                        public Org_locationtech_geomesa_tools_ingest_AbstractIngest$LocalIngestWorker$1(AbstractIngest $outer, File file, AtomicLong written$1, AtomicLong failed$1, AtomicLong bytesRead$1) {
                            this.file = file;
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.written$1 = written$1;
                            this.failed$1 = failed$1;
                            this.bytesRead$1 = bytesRead$1;
                        }
                    }
                    return this.es$1.submit(new Org_locationtech_geomesa_tools_ingest_AbstractIngest$LocalIngestWorker$1(this.$outer, f, this.written$1, this.failed$1, this.bytesRead$1));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.written$1 = written$1;
                    this.failed$1 = failed$1;
                    this.bytesRead$1 = bytesRead$1;
                    this.es$1 = es$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
            es.shutdown();
            while (true) {
                void var7_7;
                void var6_6;
                void var11_11;
                void var8_8;
                void var15_14;
                if (es.isTerminated()) {
                    statusCallback.apply("", this.progress$1(bytesRead, totalLength), (Seq<Tuple2<String, Object>>)this.counters$1(written2, failed3), true);
                    futures.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Object apply(Future<?> x$4) {
                            return x$4.get();
                        }
                    });
                    Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Local ingestion complete in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TextTools$.MODULE$.getTime(start)})));
                    Command$.MODULE$.user().info(AbstractIngest$.MODULE$.getStatInfo(written2.get(), failed3.get()));
                    return;
                }
                Thread.sleep(1000L);
                var15_14.apply("", this.progress$1((AtomicLong)var8_8, (float)var11_11), (Seq<Tuple2<String, Object>>)this.counters$1((AtomicLong)var6_6, (AtomicLong)var7_7), false);
            }
        }
        throw new MatchError((Object)tuple2);
    }

    private void runDistributed() {
        long start = System.currentTimeMillis();
        StatusCallback statusCallback = this.createCallback();
        Tuple2<Object, Object> tuple2 = this.runDistributedJob(statusCallback);
        if (tuple2 != null) {
            Tuple2.mcJJ.sp sp2;
            long success = tuple2._1$mcJ$sp();
            long failed2 = tuple2._2$mcJ$sp();
            Tuple2.mcJJ.sp sp3 = sp2 = new Tuple2.mcJJ.sp(success, failed2);
            long success2 = sp3._1$mcJ$sp();
            long failed3 = sp3._2$mcJ$sp();
            Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Distributed ingestion complete in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TextTools$.MODULE$.getTime(start)})));
            Command$.MODULE$.user().info(AbstractIngest$.MODULE$.getStatInfo(success2, failed3));
            return;
        }
        throw new MatchError(tuple2);
    }

    private StatusCallback createCallback() {
        return this.dsParams().get((Object)"useMock").exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$6) {
                return new StringOps(Predef$.MODULE$.augmentString(x$6)).toBoolean();
            }
        }) ? new PrintProgress(System.err, TextTools$.MODULE$.buildString('\u26ac', 60), ' ', '\u15e7', '\u2b58') : new PrintProgress(System.err, TextTools$.MODULE$.buildString(' ', 60), '=', '>', '>');
    }

    private final float progress$1(AtomicLong bytesRead$1, float totalLength$1) {
        return (float)((double)bytesRead$1.get() / (double)totalLength$1);
    }

    private final Seq counters$1(AtomicLong written$1, AtomicLong failed$1) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"ingested", (Object)BoxesRunTime.boxToLong((long)written$1.get())), new Tuple2((Object)"failed", (Object)BoxesRunTime.boxToLong((long)failed$1.get()))}));
    }

    public AbstractIngest(scala.collection.immutable.Map<String, String> dsParams, String typeName, Seq<String> inputs, String libjarsFile, Iterator<Function0<Seq<File>>> libjarsPaths, int numLocalThreads) {
        this.dsParams = dsParams;
        this.org$locationtech$geomesa$tools$ingest$AbstractIngest$$typeName = typeName;
        this.inputs = inputs;
        this.numLocalThreads = numLocalThreads;
        LazyLogging.class.$init$((LazyLogging)this);
        this.ds = DataStoreFinder.getDataStore((Map)JavaConversions$.MODULE$.mapAsJavaMap(dsParams));
    }

    public static class PrintProgress
    implements StatusCallback {
        private final PrintStream out;
        private final String emptyBar;
        private final char replacement;
        private final char indicator;
        private final char toggle;
        private boolean toggled;
        private long start;

        private boolean toggled() {
            return this.toggled;
        }

        private void toggled_$eq(boolean x$1) {
            this.toggled = x$1;
        }

        private long start() {
            return this.start;
        }

        private void start_$eq(long x$1) {
            this.start = x$1;
        }

        @Override
        public void reset() {
            this.start_$eq(System.currentTimeMillis());
        }

        @Override
        public void apply(String prefix, float progress, Seq<Tuple2<String, Object>> counters, boolean done) {
            String string;
            int arg$macro$1 = (int)(progress * (float)100);
            String percent = new StringOps("%3d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$1)}));
            String counterString = counters.isEmpty() ? "" : ((TraversableOnce)counters.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<String, Object> x0$1) {
                    Tuple2<String, Object> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String label = (String)tuple2._1();
                        long count = tuple2._2$mcJ$sp();
                        String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)count), label}));
                        return string;
                    }
                    throw new MatchError(tuple2);
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString(" ", " ", "");
            String info = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", "% complete", " in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{percent, counterString, TextTools$.MODULE$.getTime(this.start())}));
            float tWidth = AbstractIngest$.MODULE$.org$locationtech$geomesa$tools$ingest$AbstractIngest$$terminalWidth().apply$mcF$sp();
            float scaleFactor = tWidth > (float)(info.length() + 3) && tWidth < (float)(this.emptyBar.length() + info.length() + 2 + prefix.length()) ? (tWidth - (float)info.length() - (float)2 - (float)prefix.length()) / (float)this.emptyBar.length() : 1.0f;
            int scaledLen = (int)((float)this.emptyBar.length() * scaleFactor);
            int numDone = (int)((float)scaledLen * progress);
            if (numDone < 1) {
                string = this.emptyBar.substring(this.emptyBar.length() - scaledLen);
            } else if (numDone >= scaledLen) {
                string = TextTools$.MODULE$.buildString(this.replacement, scaledLen);
            } else {
                String doneStr = TextTools$.MODULE$.buildString(this.replacement, numDone - 1);
                String doStr = this.emptyBar.substring(this.emptyBar.length() - (scaledLen - numDone));
                char i = this.toggled() ? this.toggle : this.indicator;
                this.toggled_$eq(!this.toggled());
                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{doneStr, BoxesRunTime.boxToCharacter((char)i), doStr}));
            }
            String bar = string;
            this.out.print(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\r", "[", "]", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prefix, bar, info})));
            if (done) {
                this.out.println();
            }
        }

        public PrintProgress(PrintStream out, String emptyBar, char replacement, char indicator, char toggle) {
            this.out = out;
            this.emptyBar = emptyBar;
            this.replacement = replacement;
            this.indicator = indicator;
            this.toggle = toggle;
            this.toggled = false;
            this.start = System.currentTimeMillis();
        }
    }

    public static interface StatusCallback {
        public void reset();

        public void apply(String var1, float var2, Seq<Tuple2<String, Object>> var3, boolean var4);
    }
}

