/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.convert.scripting;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.locationtech.geomesa.convert.scripting.ScriptingFunctionFactory$;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class ScriptingFunctionFactory$
implements LazyLogging {
    public static final ScriptingFunctionFactory$ MODULE$;
    private final String ConvertScriptsPathProperty;
    private final String ConvertScriptsClassPath;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new ScriptingFunctionFactory$();
    }

    private Logger logger$lzycompute() {
        ScriptingFunctionFactory$ scriptingFunctionFactory$ = this;
        synchronized (scriptingFunctionFactory$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public final String ConvertScriptsPathProperty() {
        return "geomesa.convert.scripts.path";
    }

    public final String ConvertScriptsClassPath() {
        return "geomesa-convert-scripts";
    }

    public Seq<URI> loadScriptsFromEnvironment() {
        String v = new GeoMesaSystemProperties.SystemProperty("geomesa.convert.scripts.path", GeoMesaSystemProperties.SystemProperty$.MODULE$.apply$default$2()).get();
        return v == null ? (Seq)Seq$.MODULE$.empty() : (Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])v.split(":")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final File apply(String d) {
                return new File(d);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)))).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File f) {
                return f.exists() && f.canRead() && (f.isDirectory() ? f.canExecute() : true);
            }
        })).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<URI> apply(File f) {
                return f.isDirectory() ? (Iterable)JavaConversions$.MODULE$.collectionAsScalaIterable(FileUtils.listFiles((File)f, (IOFileFilter)TrueFileFilter.TRUE, (IOFileFilter)TrueFileFilter.TRUE)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final URI apply(File x$2) {
                        return x$2.toURI();
                    }
                }, Iterable$.MODULE$.canBuildFrom()) : (Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new URI[]{f.toURI()}));
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public Seq<URI> loadScripts(ClassLoader loader) {
        return (Seq)((TraversableLike)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(loader.getResources("geomesa-convert-scripts/"))).toSeq().flatten((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterator<URL> apply(Enumeration<URL> i) {
                return JavaConversions$.MODULE$.enumerationAsScalaIterator(i);
            }
        })).flatMap((Function1)new Serializable(loader){
            public static final long serialVersionUID = 0L;
            public final ClassLoader loader$1;

            public final Seq<URI> apply(URL url) {
                String string;
                block7: {
                    Seq seq;
                    block6: {
                        block5: {
                            BoxedUnit boxedUnit;
                            URI uri = url.toURI();
                            string = uri.getScheme();
                            if (!"jar".equals(string)) break block5;
                            FileSystem fs = FileSystems.newFileSystem(uri, Collections.<K, V>emptyMap(), this.loader$1);
                            Path p = fs.getPath("geomesa-convert-scripts/", new String[0]);
                            Seq uris = JavaConversions$.MODULE$.asScalaIterator(Files.walk(p, new FileVisitOption[0]).iterator()).toSeq();
                            Seq files = (Seq)((TraversableLike)uris.filterNot((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(Path x$3) {
                                    return Files.isDirectory(x$3, new LinkOption[0]);
                                }
                            })).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final URI apply(Path x$4) {
                                    return x$4.toUri();
                                }
                            }, Seq$.MODULE$.canBuildFrom());
                            if (ScriptingFunctionFactory$.MODULE$.logger().underlying().isDebugEnabled()) {
                                ScriptingFunctionFactory$.MODULE$.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loaded scripts ", " from jar ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{files.mkString(","), uri.toString()})));
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            seq = files;
                            break block6;
                        }
                        if (!"file".equals(string)) break block7;
                        seq = (Seq)JavaConversions$.MODULE$.asScalaBuffer(IOUtils.readLines((InputStream)url.openStream(), (String)"UTF-8")).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.loadScripts.2 $outer;

                            public final URI apply(String s) {
                                return this.$outer.loader$1.getResource(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"geomesa-convert-scripts", s}))).toURI();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, Buffer$.MODULE$.canBuildFrom());
                    }
                    return seq;
                }
                throw new MatchError((Object)string);
            }
            {
                this.loader$1 = loader$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private ScriptingFunctionFactory$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

