/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.index;

import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Query;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.geotools.factory.Hints;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary;
import org.locationtech.geomesa.hbase.coprocessor.aggregators.ArrowBatchAggregator$;
import org.locationtech.geomesa.hbase.coprocessor.aggregators.ArrowFileAggregator$;
import org.locationtech.geomesa.hbase.coprocessor.aggregators.HBaseBinAggregator$;
import org.locationtech.geomesa.hbase.coprocessor.aggregators.HBaseDensityAggregator$;
import org.locationtech.geomesa.hbase.coprocessor.aggregators.HBaseStatsAggregator$;
import org.locationtech.geomesa.hbase.coprocessor.utils.CoprocessorConfig;
import org.locationtech.geomesa.hbase.coprocessor.utils.CoprocessorConfig$;
import org.locationtech.geomesa.hbase.data.EmptyPlan;
import org.locationtech.geomesa.hbase.data.HBaseDataStore;
import org.locationtech.geomesa.hbase.data.HBaseFeature;
import org.locationtech.geomesa.hbase.data.HBaseQueryPlan;
import org.locationtech.geomesa.hbase.filters.JSimpleFeatureFilter;
import org.locationtech.geomesa.hbase.index.HBaseFeatureIndex;
import org.locationtech.geomesa.hbase.index.HBaseFeatureIndex$;
import org.locationtech.geomesa.hbase.index.HBaseIndexAdapter;
import org.locationtech.geomesa.index.api.FilterStrategy;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.api.QueryPlan;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.index.ClientSideFiltering;
import org.locationtech.geomesa.index.iterators.ArrowBatchScan$;
import org.locationtech.geomesa.index.utils.KryoLazyStatsUtils$;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;

public abstract class HBaseIndexAdapter$class {
    public static ClientSideFiltering.RowAndValue rowAndValue(HBaseIndexAdapter $this, Result result) {
        Cell cell = result.rawCells()[0];
        return new ClientSideFiltering.RowAndValue(cell.getRowArray(), cell.getRowOffset(), (int)cell.getRowLength(), cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
    }

    /*
     * WARNING - void declaration
     */
    public static Mutation createInsert(HBaseIndexAdapter $this, byte[] row, HBaseFeature feature) {
        void var3_3;
        Put put = new Put(row).addImmutable(feature.fullValue().cf(), feature.fullValue().cq(), feature.fullValue().value());
        feature.fullValue().vis().foreach((Function1)new Serializable($this, put){
            public static final long serialVersionUID = 0L;
            private final Put put$1;

            public final Put apply(CellVisibility x$1) {
                return this.put$1.setCellVisibility(x$1);
            }
            {
                this.put$1 = put$1;
            }
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static Mutation createDelete(HBaseIndexAdapter $this, byte[] row, HBaseFeature feature) {
        void var3_3;
        Delete del = new Delete(row).addFamily(feature.fullValue().cf());
        feature.fullValue().vis().foreach((Function1)new Serializable($this, del){
            public static final long serialVersionUID = 0L;
            private final Delete del$1;

            public final Delete apply(CellVisibility x$1) {
                return this.del$1.setCellVisibility(x$1);
            }
            {
                this.del$1 = del$1;
            }
        });
        return var3_3;
    }

    public static Query range(HBaseIndexAdapter $this, byte[] start, byte[] end) {
        return new Scan(start, end).addColumn(HBaseFeatureIndex$.MODULE$.DataColumnFamily(), HBaseFeatureIndex$.MODULE$.DataColumnQualifier());
    }

    public static Query rangeExact(HBaseIndexAdapter $this, byte[] row) {
        return new Get(row).addColumn(HBaseFeatureIndex$.MODULE$.DataColumnFamily(), HBaseFeatureIndex$.MODULE$.DataColumnQualifier());
    }

    public static QueryPlan scanPlan(HBaseIndexAdapter $this, SimpleFeatureType sft, HBaseDataStore ds, FilterStrategy filter, Option indexValues, Seq ranges, Option ecql, Hints hints) {
        HBaseFeatureIndex.ScanConfig scanConfig;
        block4: {
            HBaseQueryPlan hBaseQueryPlan;
            block3: {
                Tuple3 tuple3;
                block2: {
                    if (!ranges.isEmpty()) break block2;
                    hBaseQueryPlan = new EmptyPlan((FilterStrategy<HBaseDataStore, HBaseFeature, Mutation>)filter);
                    break block3;
                }
                TableName table = TableName.valueOf((String)$this.getTableName(sft.getTypeName(), ds));
                boolean dedupe = $this.hasDuplicates(sft, (Option<Filter>)filter.primary());
                scanConfig = $this.scanConfig(ds, sft, (FilterStrategy<HBaseDataStore, HBaseFeature, Mutation>)filter, indexValues, (Option<Filter>)ecql, hints, dedupe);
                if (scanConfig == null) break block4;
                Seq<Tuple2<Object, org.apache.hadoop.hbase.filter.Filter>> hbaseFilters = scanConfig.filters();
                Option<CoprocessorConfig> coprocessor = scanConfig.coprocessor();
                Function1<Iterator<Result>, Iterator<SimpleFeature>> toFeatures = scanConfig.entriesToFeatures();
                Tuple3 tuple32 = tuple3 = new Tuple3(hbaseFilters, coprocessor, toFeatures);
                Seq hbaseFilters2 = (Seq)tuple32._1();
                Option coprocessor2 = (Option)tuple32._2();
                Function1 toFeatures2 = (Function1)tuple32._3();
                hBaseQueryPlan = $this.buildPlatformScanPlan(ds, sft, (FilterStrategy<HBaseDataStore, HBaseFeature, Mutation>)filter, hints, (Seq<Query>)ranges, table, (Seq<Tuple2<Object, org.apache.hadoop.hbase.filter.Filter>>)hbaseFilters2, (Option<CoprocessorConfig>)coprocessor2, (Function1<Iterator<Result>, Iterator<SimpleFeature>>)toFeatures2);
            }
            return hBaseQueryPlan;
        }
        throw new MatchError((Object)scanConfig);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HBaseFeatureIndex.ScanConfig scanConfig(HBaseIndexAdapter $this, HBaseDataStore ds, SimpleFeatureType sft, FilterStrategy filter, Option indexValues, Option ecql, Hints hints, boolean dedupe) {
        HBaseFeatureIndex.ScanConfig scanConfig;
        Option transform = QueryHints$.MODULE$.RichHints(hints).getTransform();
        if (ds.config().remoteFilter()) {
            Seq seq;
            Some coprocessorConfig;
            Some some;
            Tuple2 tuple2;
            Tuple2 tuple22 = (Tuple2)transform.getOrElse((Function0)new Serializable($this, sft){
                public static final long serialVersionUID = 0L;
                private final SimpleFeatureType sft$1;

                public final Tuple2<String, SimpleFeatureType> apply() {
                    return new Tuple2((Object)"", (Object)this.sft$1);
                }
                {
                    this.sft$1 = sft$1;
                }
            });
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            String remoteTdefArg = (String)tuple22._1();
            SimpleFeatureType returnSchema = (SimpleFeatureType)tuple22._2();
            Tuple2 tuple23 = tuple2 = new Tuple2((Object)remoteTdefArg, (Object)returnSchema);
            String remoteTdefArg2 = (String)tuple23._1();
            SimpleFeatureType returnSchema2 = (SimpleFeatureType)tuple23._2();
            Seq<Tuple2<Object, org.apache.hadoop.hbase.filter.Filter>> additionalFilters = $this.createPushDownFilters(ds, sft, (FilterStrategy<HBaseDataStore, HBaseFeature, Mutation>)filter, indexValues, (Option<Tuple2<String, SimpleFeatureType>>)transform);
            Function1 toFeatures = $this.resultsToFeatures(returnSchema2, (Option)None$.MODULE$, (Option)None$.MODULE$);
            if (QueryHints$.MODULE$.RichHints(hints).isDensityQuery()) {
                Map<String, String> options = HBaseDensityAggregator$.MODULE$.configure(sft, $this, (Option<Filter>)ecql, hints);
                some = new Some((Object)new CoprocessorConfig(options, (Function1<byte[], SimpleFeature>)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final SimpleFeature apply(byte[] bytes) {
                        return HBaseDensityAggregator$.MODULE$.bytesToFeatures(bytes);
                    }
                }, CoprocessorConfig$.MODULE$.apply$default$3()));
            } else if (QueryHints$.MODULE$.RichHints(hints).isArrowQuery()) {
                Seq dictionaryFields = QueryHints$.MODULE$.RichHints(hints).getArrowDictionaryFields();
                Map providedDictionaries = QueryHints$.MODULE$.RichHints(hints).getArrowDictionaryEncodedValues(sft);
                if (QueryHints$.MODULE$.RichHints(hints).getArrowSort().isDefined() || QueryHints$.MODULE$.RichHints(hints).isArrowComputeDictionaries() || dictionaryFields.forall((Function1)new Serializable($this, providedDictionaries){
                    public static final long serialVersionUID = 0L;
                    private final Map providedDictionaries$1;

                    public final boolean apply(String key) {
                        return this.providedDictionaries$1.contains((Object)key);
                    }
                    {
                        this.providedDictionaries$1 = providedDictionaries$1;
                    }
                })) {
                    Map dictionaries = ArrowBatchScan$.MODULE$.createDictionaries(ds.stats(), sft, filter.filter(), dictionaryFields, providedDictionaries, QueryHints$.MODULE$.RichHints(hints).isArrowCachedDictionaries());
                    Map<String, String> options = ArrowBatchAggregator$.MODULE$.configure(sft, $this, (Option<Filter>)ecql, (Map<String, ArrowDictionary>)dictionaries, hints);
                    Function1 reduce = ArrowBatchScan$.MODULE$.reduceFeatures((SimpleFeatureType)QueryHints$.MODULE$.RichHints(hints).getTransformSchema().getOrElse((Function0)new Serializable($this, sft){
                        public static final long serialVersionUID = 0L;
                        private final SimpleFeatureType sft$1;

                        public final SimpleFeatureType apply() {
                            return this.sft$1;
                        }
                        {
                            this.sft$1 = sft$1;
                        }
                    }), hints, dictionaries);
                    some = new Some((Object)new CoprocessorConfig(options, (Function1<byte[], SimpleFeature>)new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        public final SimpleFeature apply(byte[] bytes) {
                            return ArrowBatchAggregator$.MODULE$.bytesToFeatures(bytes);
                        }
                    }, (Function1<CloseableIterator<SimpleFeature>, CloseableIterator<SimpleFeature>>)reduce));
                } else {
                    Map<String, String> options = ArrowFileAggregator$.MODULE$.configure(sft, $this, (Option<Filter>)ecql, (Seq<String>)dictionaryFields, hints);
                    some = new Some((Object)new CoprocessorConfig(options, (Function1<byte[], SimpleFeature>)new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        public final SimpleFeature apply(byte[] bytes) {
                            return ArrowFileAggregator$.MODULE$.bytesToFeatures(bytes);
                        }
                    }, CoprocessorConfig$.MODULE$.apply$default$3()));
                }
            } else if (QueryHints$.MODULE$.RichHints(hints).isStatsQuery()) {
                Map<String, String> statsOptions = HBaseStatsAggregator$.MODULE$.configure(sft, (GeoMesaFeatureIndex<HBaseDataStore, HBaseFeature, Mutation>)filter.index(), (Option<Filter>)ecql, hints);
                some = new Some((Object)new CoprocessorConfig(statsOptions, (Function1<byte[], SimpleFeature>)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final SimpleFeature apply(byte[] bytes) {
                        return HBaseStatsAggregator$.MODULE$.bytesToFeatures(bytes);
                    }
                }, (Function1<CloseableIterator<SimpleFeature>, CloseableIterator<SimpleFeature>>)new Serializable($this, returnSchema2, hints){
                    public static final long serialVersionUID = 0L;
                    private final SimpleFeatureType returnSchema$1;
                    private final Hints hints$1;

                    public final CloseableIterator<SimpleFeature> apply(CloseableIterator<SimpleFeature> features) {
                        return KryoLazyStatsUtils$.MODULE$.reduceFeatures(this.returnSchema$1, this.hints$1, features);
                    }
                    {
                        void var3_3;
                        this.returnSchema$1 = returnSchema$1;
                        this.hints$1 = var3_3;
                    }
                }));
            } else if (QueryHints$.MODULE$.RichHints(hints).isBinQuery()) {
                Map<String, String> options = HBaseBinAggregator$.MODULE$.configure(sft, (GeoMesaFeatureIndex<HBaseDataStore, HBaseFeature, Mutation>)filter.index(), (Option<Filter>)ecql, hints);
                some = new Some((Object)new CoprocessorConfig(options, (Function1<byte[], SimpleFeature>)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final SimpleFeature apply(byte[] bytes) {
                        return HBaseBinAggregator$.MODULE$.bytesToFeatures(bytes);
                    }
                }, CoprocessorConfig$.MODULE$.apply$default$3()));
            } else {
                some = coprocessorConfig = None$.MODULE$;
            }
            if (coprocessorConfig.isDefined() || ecql.isEmpty() && transform.isEmpty()) {
                seq = (Seq)Seq$.MODULE$.empty();
            } else {
                Filter remoteCQLFilter = (Filter)ecql.getOrElse((Function0)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final IncludeFilter apply() {
                        return Filter.INCLUDE;
                    }
                });
                String encodedSft = SimpleFeatureTypes$.MODULE$.encodeType(returnSchema2, SimpleFeatureTypes$.MODULE$.encodeType$default$2());
                JSimpleFeatureFilter filter2 = new JSimpleFeatureFilter(sft, remoteCQLFilter, remoteTdefArg2, encodedSft);
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)JSimpleFeatureFilter.Priority), (Object)filter2)}));
            }
            Seq filters = seq;
            scanConfig = new HBaseFeatureIndex.ScanConfig((Seq<Tuple2<Object, org.apache.hadoop.hbase.filter.Filter>>)((Seq)filters.$plus$plus(additionalFilters, Seq$.MODULE$.canBuildFrom())), (Option<CoprocessorConfig>)coprocessorConfig, (Function1<Iterator<Result>, Iterator<SimpleFeature>>)toFeatures);
            return scanConfig;
        } else {
            scanConfig = new HBaseFeatureIndex.ScanConfig((Seq<Tuple2<Object, org.apache.hadoop.hbase.filter.Filter>>)((Seq)Seq$.MODULE$.empty()), (Option<CoprocessorConfig>)None$.MODULE$, (Function1<Iterator<Result>, Iterator<SimpleFeature>>)$this.resultsToFeatures(sft, ecql, transform));
        }
        return scanConfig;
    }

    public static boolean hasDuplicates(HBaseIndexAdapter $this, SimpleFeatureType sft, Option filter) {
        return false;
    }

    public static Seq createPushDownFilters(HBaseIndexAdapter $this, HBaseDataStore ds, SimpleFeatureType sft, FilterStrategy filter, Option indexValues, Option transform) {
        return (Seq)Seq$.MODULE$.empty();
    }

    public static void $init$(HBaseIndexAdapter $this) {
    }
}

