/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.index;

import org.apache.hadoop.hbase.filter.Filter;
import org.locationtech.geomesa.curve.Z3SFC;
import org.locationtech.geomesa.hbase.data.HBaseDataStore;
import org.locationtech.geomesa.hbase.filters.Z3HBaseFilter;
import org.locationtech.geomesa.hbase.filters.Z3HBaseFilter$;
import org.locationtech.geomesa.hbase.index.HBaseZ3PushDown;
import org.locationtech.geomesa.hbase.index.HBaseZ3PushDown$;
import org.locationtech.geomesa.index.api.FilterStrategy;
import org.locationtech.geomesa.index.filters.Z3Filter;
import org.locationtech.geomesa.index.index.Z3IndexValues;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.ShortRef;

public abstract class HBaseZ3PushDown$class {
    public static Seq createPushDownFilters(HBaseZ3PushDown $this, HBaseDataStore ds, SimpleFeatureType sft, FilterStrategy filter, Option indexValues, Option transform) {
        Option z3Filter = indexValues.map((Function1)new Serializable($this, sft){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseZ3PushDown $outer;
            private final SimpleFeatureType sft$1;

            public final Tuple2<Object, Filter> apply(Z3IndexValues x0$1) {
                Z3IndexValues z3IndexValues = x0$1;
                if (z3IndexValues != null) {
                    Z3SFC sfc = z3IndexValues.sfc();
                    Seq xy = z3IndexValues.spatialBounds();
                    Map times = z3IndexValues.temporalBounds();
                    int offset = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isTableSharing$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.sft$1)) ? 2 : 1;
                    Tuple2 tuple2 = HBaseZ3PushDown$class.org$locationtech$geomesa$hbase$index$HBaseZ3PushDown$$configureZ3PushDown(this.$outer, sfc, xy, times, offset);
                    return tuple2;
                }
                throw new MatchError((Object)z3IndexValues);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sft$1 = sft$1;
            }
        });
        return (Seq)$this.org$locationtech$geomesa$hbase$index$HBaseZ3PushDown$$super$createPushDownFilters(ds, sft, filter, indexValues, transform).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(z3Filter).toSeq(), Seq$.MODULE$.canBuildFrom());
    }

    public static Tuple2 org$locationtech$geomesa$hbase$index$HBaseZ3PushDown$$configureZ3PushDown(HBaseZ3PushDown $this, Z3SFC sfc, Seq xy, Map timeMap, int offset) {
        ShortRef minEpoch = ShortRef.create((short)Short.MAX_VALUE);
        ShortRef maxEpoch = ShortRef.create((short)Short.MIN_VALUE);
        Seq wholePeriod = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJJ.sp((long)sfc.time().min(), (long)sfc.time().max())}));
        Map filteredTimes = (Map)timeMap.filter((Function1)new Serializable($this, wholePeriod){
            public static final long serialVersionUID = 0L;
            private final Seq wholePeriod$1;

            public final boolean apply(Tuple2<Object, Seq<Tuple2<Object, Object>>> x$1) {
                Object object = x$1._2();
                Seq seq = this.wholePeriod$1;
                return object != null ? !object.equals(seq) : seq != null;
            }
            {
                this.wholePeriod$1 = wholePeriod$1;
            }
        });
        Seq epochsAndTimes = (Seq)((TraversableLike)filteredTimes.toSeq().sortBy((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final short apply(Tuple2<Object, Seq<Tuple2<Object, Object>>> x$2) {
                return BoxesRunTime.unboxToShort((Object)x$2._1());
            }
        }, (Ordering)Ordering.Short$.MODULE$)).map((Function1)new Serializable($this, sfc, minEpoch, maxEpoch){
            public static final long serialVersionUID = 0L;
            public final Z3SFC sfc$1;
            private final ShortRef minEpoch$1;
            private final ShortRef maxEpoch$1;

            public final Tuple2<Object, int[][]> apply(Tuple2<Object, Seq<Tuple2<Object, Object>>> x0$2) {
                Tuple2<Object, Seq<Tuple2<Object, Object>>> tuple2 = x0$2;
                if (tuple2 != null) {
                    short epoch = BoxesRunTime.unboxToShort((Object)tuple2._1());
                    Seq times = (Seq)tuple2._2();
                    if (epoch < this.minEpoch$1.elem) {
                        this.minEpoch$1.elem = epoch;
                    }
                    if (epoch > this.maxEpoch$1.elem) {
                        this.maxEpoch$1.elem = epoch;
                    }
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToShort((short)epoch), ((TraversableOnce)times.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ HBaseZ3PushDown$.anonfun.4 $outer;

                        public final int[] apply(Tuple2<Object, Object> x0$3) {
                            Tuple2<Object, Object> tuple2 = x0$3;
                            if (tuple2 != null) {
                                long t1 = tuple2._1$mcJ$sp();
                                long t2 = tuple2._2$mcJ$sp();
                                int[] nArray = new int[]{this.$outer.sfc$1.time().normalize((double)t1), this.$outer.sfc$1.time().normalize((double)t2)};
                                return nArray;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                this.sfc$1 = sfc$1;
                this.minEpoch$1 = minEpoch$1;
                this.maxEpoch$1 = maxEpoch$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        int[][][] tvals = minEpoch.elem == Short.MAX_VALUE && maxEpoch.elem == Short.MIN_VALUE ? (int[][][])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)))) : (int[][][])Array$.MODULE$.ofDim(maxEpoch.elem - minEpoch.elem + 1, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))));
        epochsAndTimes.foreach((Function1)new Serializable($this, minEpoch, tvals){
            public static final long serialVersionUID = 0L;
            private final ShortRef minEpoch$1;
            private final int[][][] tvals$1;

            public final void apply(Tuple2<Object, int[][]> x0$4) {
                Tuple2<Object, int[][]> tuple2 = x0$4;
                if (tuple2 != null) {
                    short w = BoxesRunTime.unboxToShort((Object)tuple2._1());
                    int[][] times = (int[][])tuple2._2();
                    this.tvals$1[w - this.minEpoch$1.elem] = times;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.minEpoch$1 = minEpoch$1;
                this.tvals$1 = tvals$1;
            }
        });
        int[][] normalizedXY = (int[][])((TraversableOnce)xy.map((Function1)new Serializable($this, sfc){
            public static final long serialVersionUID = 0L;
            private final Z3SFC sfc$1;

            public final int[] apply(Tuple4<Object, Object, Object, Object> x0$5) {
                Tuple4<Object, Object, Object, Object> tuple4 = x0$5;
                if (tuple4 != null) {
                    double xmin = BoxesRunTime.unboxToDouble((Object)tuple4._1());
                    double ymin = BoxesRunTime.unboxToDouble((Object)tuple4._2());
                    double xmax = BoxesRunTime.unboxToDouble((Object)tuple4._3());
                    double ymax = BoxesRunTime.unboxToDouble((Object)tuple4._4());
                    int[] nArray = new int[]{this.sfc$1.lon().normalize(xmin), this.sfc$1.lat().normalize(ymin), this.sfc$1.lon().normalize(xmax), this.sfc$1.lat().normalize(ymax)};
                    return nArray;
                }
                throw new MatchError(tuple4);
            }
            {
                this.sfc$1 = sfc$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)));
        Z3HBaseFilter filter = new Z3HBaseFilter(new Z3Filter(normalizedXY, tvals, minEpoch.elem, maxEpoch.elem, 8), offset);
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)Z3HBaseFilter$.MODULE$.Priority()), (Object)filter);
    }

    public static void $init$(HBaseZ3PushDown $this) {
    }
}

