/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.arrow.vector;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.NullableFloat8Vector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.AbstractContainerVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.types.pojo.Field;
import org.locationtech.geomesa.arrow.vector.GeometryFields;
import org.locationtech.geomesa.arrow.vector.impl.AbstractMultiPointVector;

public class MultiPointVector
extends AbstractMultiPointVector {
    public static final List<Field> fields = GeometryFields.XY_DOUBLE_LIST;

    public MultiPointVector(String name, BufferAllocator allocator, @Nullable Map<String, String> metadata) {
        super(name, allocator, metadata);
    }

    public MultiPointVector(String name, AbstractContainerVector container, @Nullable Map<String, String> metadata) {
        super(name, container, metadata);
    }

    public MultiPointVector(ListVector vector) {
        super(vector);
    }

    @Override
    protected List<Field> getFields() {
        return fields;
    }

    @Override
    protected AbstractMultiPointVector.MultiPointWriter createWriter(ListVector vector) {
        return new MultiPointDoubleWriter(vector);
    }

    @Override
    protected AbstractMultiPointVector.MultiPointReader createReader(ListVector vector) {
        return new MultiPointDoubleReader(vector);
    }

    public static class MultiPointDoubleReader
    extends AbstractMultiPointVector.MultiPointReader {
        private NullableFloat8Vector.Accessor accessor;

        public MultiPointDoubleReader(ListVector vector) {
            super(vector);
        }

        @Override
        protected void setOrdinalAccessor(ValueVector.Accessor accessor) {
            this.accessor = (NullableFloat8Vector.Accessor)accessor;
        }

        @Override
        protected double readOrdinal(int index) {
            return this.accessor.get(index);
        }
    }

    public static class MultiPointDoubleWriter
    extends AbstractMultiPointVector.MultiPointWriter {
        private NullableFloat8Vector.Mutator mutator;

        public MultiPointDoubleWriter(ListVector vector) {
            super(vector);
        }

        @Override
        protected void setOrdinalMutator(ValueVector.Mutator mutator) {
            this.mutator = (NullableFloat8Vector.Mutator)mutator;
        }

        @Override
        protected void writeOrdinal(int index, double ordinal) {
            this.mutator.setSafe(index, ordinal);
        }
    }
}

