/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.arrow.vector;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.NullableFloat8Vector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.AbstractContainerVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.types.pojo.Field;
import org.locationtech.geomesa.arrow.vector.GeometryFields;
import org.locationtech.geomesa.arrow.vector.impl.AbstractMultiPolygonVector;

public class MultiPolygonVector
extends AbstractMultiPolygonVector {
    public static final List<Field> fields = GeometryFields.XY_DOUBLE_LIST_3;

    public MultiPolygonVector(String name, BufferAllocator allocator, @Nullable Map<String, String> metadata) {
        super(name, allocator, metadata);
    }

    public MultiPolygonVector(String name, AbstractContainerVector container, @Nullable Map<String, String> metadata) {
        super(name, container, metadata);
    }

    public MultiPolygonVector(ListVector vector) {
        super(vector);
    }

    @Override
    protected List<Field> getFields() {
        return fields;
    }

    @Override
    protected AbstractMultiPolygonVector.MultiPolygonWriter createWriter(ListVector vector) {
        return new MultiPolygonDoubleWriter(vector);
    }

    @Override
    protected AbstractMultiPolygonVector.MultiPolygonReader createReader(ListVector vector) {
        return new MultiPolygonDoubleReader(vector);
    }

    public static class MultiPolygonDoubleReader
    extends AbstractMultiPolygonVector.MultiPolygonReader {
        private NullableFloat8Vector.Accessor accessor;

        public MultiPolygonDoubleReader(ListVector vector) {
            super(vector);
        }

        @Override
        protected void setOrdinalAccessor(ValueVector.Accessor accessor) {
            this.accessor = (NullableFloat8Vector.Accessor)accessor;
        }

        @Override
        protected double readOrdinal(int index) {
            return this.accessor.get(index);
        }
    }

    public static class MultiPolygonDoubleWriter
    extends AbstractMultiPolygonVector.MultiPolygonWriter {
        private NullableFloat8Vector.Mutator mutator;

        public MultiPolygonDoubleWriter(ListVector vector) {
            super(vector);
        }

        @Override
        protected void setOrdinalMutator(ValueVector.Mutator mutator) {
            this.mutator = (NullableFloat8Vector.Mutator)mutator;
        }

        @Override
        protected void writeOrdinal(int index, double ordinal) {
            this.mutator.setSafe(index, ordinal);
        }
    }
}

