/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.arrow.vector.impl;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import java.util.List;
import java.util.Map;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.vector.complex.AbstractContainerVector;
import org.apache.arrow.vector.complex.BaseRepeatedValueVector;
import org.apache.arrow.vector.complex.FixedSizeListVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.locationtech.geomesa.arrow.vector.GeometryVector;
import org.locationtech.geomesa.arrow.vector.impl.AbstractGeometryReader;
import org.locationtech.geomesa.arrow.vector.impl.AbstractGeometryWriter;

public abstract class AbstractMultiPointVector
implements GeometryVector<MultiPoint, ListVector> {
    private final ListVector vector;
    private final MultiPointWriter writer;
    private final MultiPointReader reader;

    private static FieldType createFieldType(Map<String, String> metadata) {
        return new FieldType(true, (ArrowType)ArrowType.List.INSTANCE, null, metadata);
    }

    protected AbstractMultiPointVector(String name, BufferAllocator allocator, Map<String, String> metadata) {
        this(new ListVector(name, allocator, AbstractMultiPointVector.createFieldType(metadata), null));
    }

    protected AbstractMultiPointVector(String name, AbstractContainerVector container, Map<String, String> metadata) {
        this((ListVector)container.addOrGet(name, AbstractMultiPointVector.createFieldType(metadata), ListVector.class));
    }

    protected AbstractMultiPointVector(ListVector vector) {
        if (vector.getDataVector().equals(BaseRepeatedValueVector.DEFAULT_DATA_VECTOR)) {
            vector.initializeChildrenFromFields(this.getFields());
            vector.allocateNew();
        }
        this.vector = vector;
        this.writer = this.createWriter(vector);
        this.reader = this.createReader(vector);
    }

    protected abstract List<Field> getFields();

    protected abstract MultiPointWriter createWriter(ListVector var1);

    protected abstract MultiPointReader createReader(ListVector var1);

    public MultiPointWriter getWriter() {
        return this.writer;
    }

    public MultiPointReader getReader() {
        return this.reader;
    }

    @Override
    public ListVector getVector() {
        return this.vector;
    }

    @Override
    public void close() throws Exception {
        this.vector.close();
    }

    public static abstract class MultiPointReader
    extends AbstractGeometryReader<MultiPoint> {
        private final ListVector.Accessor accessor;
        private final UInt4Vector.Accessor offsets;

        public MultiPointReader(ListVector vector) {
            this.accessor = vector.getAccessor();
            this.offsets = ((UInt4Vector)vector.getFieldInnerVectors().get(1)).getAccessor();
            this.setOrdinalAccessor(((FieldVector)((FieldVector)vector.getChildrenFromFields().get(0)).getChildrenFromFields().get(0)).getAccessor());
        }

        @Override
        public MultiPoint get(int index) {
            if (this.accessor.isNull(index)) {
                return null;
            }
            int offsetStart = this.offsets.get(index);
            int offsetEnd = this.offsets.get(index + 1);
            Coordinate[] coordinates = new Coordinate[offsetEnd - offsetStart];
            for (int i = 0; i < coordinates.length; ++i) {
                double y = this.readOrdinal((offsetStart + i) * 2);
                double x = this.readOrdinal((offsetStart + i) * 2 + 1);
                coordinates[i] = new Coordinate(x, y);
            }
            return GeometryVector.factory.createMultiPoint(coordinates);
        }

        @Override
        public int getValueCount() {
            return this.accessor.getValueCount();
        }

        @Override
        public int getNullCount() {
            return this.accessor.getNullCount();
        }
    }

    public static abstract class MultiPointWriter
    extends AbstractGeometryWriter<MultiPoint> {
        private final BitVector.Mutator nullSet;
        private final ListVector.Mutator mutator;
        private final FixedSizeListVector.Mutator tupleMutator;

        protected MultiPointWriter(ListVector vector) {
            this.nullSet = ((BitVector)vector.getFieldInnerVectors().get(0)).getMutator();
            this.mutator = vector.getMutator();
            FixedSizeListVector tuples = (FixedSizeListVector)vector.getChildrenFromFields().get(0);
            this.tupleMutator = tuples.getMutator();
            this.setOrdinalMutator(((FieldVector)tuples.getChildrenFromFields().get(0)).getMutator());
        }

        @Override
        public void set(int index, MultiPoint geom) {
            if (geom == null) {
                this.nullSet.setSafe(index, 0);
            } else {
                int position = this.mutator.startNewValue(index);
                for (int i = 0; i < geom.getNumPoints(); ++i) {
                    Point p = (Point)geom.getGeometryN(i);
                    this.tupleMutator.setNotNull(position + i);
                    this.writeOrdinal((position + i) * 2, p.getY());
                    this.writeOrdinal((position + i) * 2 + 1, p.getX());
                }
                this.mutator.endValue(index, geom.getNumPoints());
            }
        }

        @Override
        public void setValueCount(int count) {
            this.mutator.setValueCount(count);
        }
    }
}

