/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings.ext;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.geometry.jts.CurvedGeometryFactory;
import org.geotools.gml3.ArcParameters;
import org.geotools.gml3.GML;
import org.geotools.gml3.bindings.GML3ParsingUtils;
import org.geotools.gml3.bindings.LineStringTypeBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;

public class CompositeCurveTypeBinding
extends LineStringTypeBinding {
    private final GeometryFactory gFactory;
    private ArcParameters arcParameters;

    public CompositeCurveTypeBinding(GeometryFactory gFactory, CoordinateSequenceFactory csFactory) {
        super(gFactory, csFactory);
        this.gFactory = gFactory;
    }

    public void setArcParameters(ArcParameters arcParameters) {
        this.arcParameters = arcParameters;
    }

    @Override
    public QName getTarget() {
        return GML.CompositeCurveType;
    }

    @Override
    public Class getType() {
        return LineString.class;
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        List children = node.getChildren("curveMember");
        ArrayList<LineString> components = new ArrayList<LineString>();
        for (Node child : children) {
            if (!(child.getValue() instanceof LineString)) continue;
            LineString ls = (LineString)child.getValue();
            components.add(ls);
        }
        if (components.isEmpty()) {
            return this.gFactory.createLineString(new Coordinate[0]);
        }
        CoordinateSequence cs = ((LineString)components.get(0)).getCoordinateSequence();
        CurvedGeometryFactory factory = GML3ParsingUtils.getCurvedGeometryFactory(this.arcParameters, this.gFactory, cs);
        return factory.createCurvedGeometry(components);
    }

    public static CoordinateList extractCurveMemberCoordinates(Node node) {
        List curveMembers = node.getChildren("curveMember");
        CoordinateList clist = new CoordinateList();
        for (int i = 0; i < curveMembers.size(); ++i) {
            List curves = ((Node)curveMembers.get(i)).getChildren(MultiLineString.class);
            for (int j = 0; j < curves.size(); ++j) {
                MultiLineString mls = (MultiLineString)((Node)curves.get(j)).getValue();
                clist.add(mls.getCoordinates(), false);
            }
        }
        return clist;
    }
}

