/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.wfs.v2_0.bindings;

import java.util.Enumeration;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class CopyingHandler
extends DefaultHandler {
    protected StringBuffer buffer;
    protected NamespaceSupport namespaceContext;

    public CopyingHandler() {
        this(null);
    }

    public CopyingHandler(NamespaceSupport namespaceContext) {
        this.namespaceContext = namespaceContext;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        boolean root = false;
        if (this.buffer == null) {
            this.buffer = new StringBuffer();
            root = true;
        }
        this.buffer.append("<").append(qName);
        if (attributes.getLength() > 0) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.buffer.append(" ").append(attributes.getQName(i)).append("=\"").append(attributes.getValue(i)).append("\"");
            }
        }
        if (root && this.namespaceContext != null) {
            Enumeration<String> e = this.namespaceContext.getPrefixes();
            while (e.hasMoreElements()) {
                String prefix = e.nextElement();
                if ("".equals(prefix)) {
                    this.buffer.append(" xmlns");
                } else {
                    this.buffer.append(" xmlns:").append(prefix);
                }
                this.buffer.append("='").append(this.namespaceContext.getURI(prefix)).append("'");
            }
        }
        this.buffer.append(">");
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.buffer == null) {
            this.buffer = new StringBuffer();
        }
        this.buffer.append(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.buffer != null) {
            this.buffer.append("</").append(qName).append(">");
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.buffer = null;
    }
}

